/*
 * Decompiled with CFR 0.152.
 */
package net.felis.cbc_ballistics.screen;

import java.util.ArrayList;
import java.util.Set;
import net.felis.cbc_ballistics.block.entity.ArtilleryCoordinatorBlockEntity;
import net.felis.cbc_ballistics.block.entity.CalculatorBlockEntity;
import net.felis.cbc_ballistics.util.ParticleHelper;
import net.felis.cbc_ballistics.util.Utils;
import net.felis.cbc_ballistics.util.artilleryNetwork.Director;
import net.felis.cbc_ballistics.util.calculator.FiringSolutions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class Artillery_CoordinatorInterface {
    public static Artillery_CoordinatorInterface CLIENT_DATA;
    private CompoundTag tags;

    public Artillery_CoordinatorInterface(ArtilleryCoordinatorBlockEntity be) {
        this.tags = new CompoundTag();
        this.tags.m_128359_("network_id", be.getNetwork_id());
        this.tags.m_128359_("target", be.getPersistentData().m_128461_("targetPos"));
        ArtilleryCoordinatorBlockEntity superior = be.getSuperior();
        if (superior != null) {
            this.tags.m_128359_("superior", superior.getNetwork_id());
        }
        this.tags.m_128385_("pos", Utils.blockPosToArray(be.m_58899_()));
        this.tags.m_128344_("mode", be.getMode().NUM);
        this.tags.m_128344_("guns", (byte)be.getAllCannons().size());
        this.tags.m_128344_("ready", (byte)be.numReadyLayers());
        this.tags.m_128344_("subnet", (byte)be.getSuboridinates().size());
        ArrayList<Director> directors = be.getAllDirectors();
        this.tags.m_128344_("dir", (byte)directors.size());
        for (int i = 0; i < directors.size(); ++i) {
            CalculatorBlockEntity ce;
            FiringSolutions.Solution results;
            Director director = directors.get(i);
            if (!(director instanceof CalculatorBlockEntity) || (results = (ce = (CalculatorBlockEntity)director).getResult()) == null) continue;
            this.tags.m_128365_("solution" + i, (Tag)results.toTagSingle());
        }
    }

    public Artillery_CoordinatorInterface(CompoundTag tags) {
        this.tags = tags;
    }

    public void allowIdChange(boolean val) {
        this.tags.m_128379_("allow_id_change", val);
    }

    public CompoundTag getTags() {
        return this.tags.m_6426_();
    }

    public ArtilleryCoordinatorBlockEntity.Mode getMode() {
        return ArtilleryCoordinatorBlockEntity.Mode.fromByte(this.tags.m_128445_("mode"));
    }

    public void setMode(ArtilleryCoordinatorBlockEntity.Mode mode) {
        this.tags.m_128344_("mode", mode.NUM);
    }

    public String getNetworkId() {
        return this.tags.m_128461_("network_id");
    }

    public String getSuperiorId() {
        return this.tags.m_128461_("superior");
    }

    public byte getNumReadyCannons() {
        return this.tags.m_128445_("ready");
    }

    public String getTargetPos() {
        return this.tags.m_128461_("target");
    }

    public void setTargetPos(String targetPos) {
        this.tags.m_128359_("target", targetPos);
    }

    public boolean allSet() {
        return this.getNumCannons() == this.getNumReadyCannons();
    }

    public byte getNumSubnets() {
        return this.tags.m_128445_("subnet");
    }

    public boolean allowIdChange() {
        return this.tags.m_128471_("allow_id_change");
    }

    public byte getNumCannons() {
        return this.tags.m_128445_("guns");
    }

    public byte getNumDirector() {
        return this.tags.m_128445_("dir");
    }

    public void renderSolutions(Level level) {
        for (FiringSolutions.Solution solution : this.getSolutions()) {
            float impactYaw = (solution.YAW + 180.0f) % 360.0f;
            Vec3 thing = solution.HIT_POS.m_82549_(new Vec3(Utils.vecToVel(solution.ANGLE_OF_ATTACK, solution.YAW, -10.0f)));
            ParticleHelper.line(level, solution.HIT_POS, thing, ParticleHelper.Colour.RED, 1.0f);
            ParticleHelper.Circle(level, solution.HIT_POS, ParticleHelper.Colour.RED, solution.DISPERSION, impactYaw, solution.ANGLE_OF_ATTACK, 1.0f);
        }
    }

    public float[] getMedianSet() {
        ArrayList<FiringSolutions.Solution> solutions = this.getSolutions();
        float[] pres = new float[solutions.size()];
        float[] disp = new float[solutions.size()];
        float[] tTT = new float[solutions.size()];
        for (int i = 0; i < solutions.size(); ++i) {
            FiringSolutions.Solution s = solutions.get(i);
            pres[i] = s.PRECISION;
            disp[i] = s.DISPERSION;
            tTT[i] = s.AIR_TIME;
        }
        return new float[]{Utils.median(pres), Utils.median(disp), Utils.median(tTT)};
    }

    public ArrayList<FiringSolutions.Solution> getSolutions() {
        ArrayList<FiringSolutions.Solution> solutions = new ArrayList<FiringSolutions.Solution>();
        Set keys = this.tags.m_128431_();
        for (String key : keys) {
            if (!key.startsWith("solution")) continue;
            solutions.add(FiringSolutions.solution(this.tags.m_128469_(key)));
        }
        return solutions;
    }

    public boolean update(CompoundTag tags) {
        if (tags.m_128461_("network_id").equals(this.tags.m_128461_("network_id"))) {
            this.tags.m_128391_(tags);
            if (this.tags.m_128441_("new_network_id")) {
                this.tags.m_128359_("network_id", tags.m_128461_("new_network_id"));
                this.tags.m_128473_("new_network_id");
            }
            return true;
        }
        return false;
    }
}

