/*
 * Decompiled with CFR 0.152.
 */
package net.felis.cbc_ballistics.screen.custom;

import net.felis.cbc_ballistics.networking.ModMessages;
import net.felis.cbc_ballistics.networking.packet.artilleryCoordinator.SendArtilleryNetworkInstructionC2SPacket;
import net.felis.cbc_ballistics.screen.Artillery_CoordinatorInterface;
import net.felis.cbc_ballistics.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.TextAndImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class Artillery_CoordinatorScreen
extends Screen {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("cbc_ballistics", "textures/gui/artillery_network/artillery_network_screen.png");
    private static final Font FONT = Minecraft.m_91087_().f_91062_;
    private static final Component ID = Component.m_237115_((String)"block.cbc_ballistics.artillery_network.id");
    private static final Component NUM_DIR = Component.m_237115_((String)"block.cbc_ballistics.artillery_coordinator.num_dir");
    private static final Component NUM_CAN = Component.m_237115_((String)"block.cbc_ballistics.artillery_coordinator.num_can");
    private static final Component READY_CAN = Component.m_237115_((String)"block.cbc_ballistics.artillery_network.ready_can");
    private static final Component SEND = Component.m_237115_((String)"block.cbc_ballistics.artillery_network.send");
    private static final Component SET = Component.m_237115_((String)"block.cbc_ballistics.artillery_network.set");
    private static final Component FIRE = Component.m_237115_((String)"block.cbc_ballistics.artillery_network.fire");
    private static final Component TARGET_POS = Component.m_237115_((String)"block.cbc_ballistics.ballistic_calculator.targetPos");
    private static final Component MEDIAN = Component.m_237115_((String)"block.cbc_ballistics.artillery_network.median");
    private static final Component PRES = Component.m_237115_((String)"block.cbc_ballistics.ballistic_calculator.precision");
    private static final Component TTT = Component.m_237115_((String)"block.cbc_ballistics.ballistic_calculator.travelTime");
    private static final Component DISP = Component.m_237115_((String)"block.cbc_ballistics.ballistic_calculator.dispersion");
    private static final Component BLOCKS = Component.m_237115_((String)"block.cbc_ballistics.ballistic_calculator.blocks");
    private static final Component SECONDS = Component.m_237115_((String)"block.cbc_ballistics.ballistic_calculator.seconds");
    private static final Component SUPER = Component.m_237115_((String)"unit.cbc_ballistics.artillery_network.super_short");
    private static final Component SUB = Component.m_237115_((String)"unit.cbc_ballistics.artillery_network.sub_short");
    private int ticks;
    private int leftBound;
    private int topBound;
    private final int imageHeight;
    private final int imageWidth;
    private Artillery_CoordinatorInterface data;
    private final BlockPos pos;
    private EditBox netId;
    private EditBox targetPos;
    private boolean targetError;
    private boolean changedTarget;
    private int changeCooldown;
    private TextAndImageButton sendButton;
    private int sendCooldown;
    private TextAndImageButton setButton;
    private int setCooldown;
    private TextAndImageButton modeButton;
    private int modeCooldown;
    private TextAndImageButton fireButton;
    private int fireCooldown;
    private double medianPres;
    private double medianDisp;
    private double medianTTT;

    public Artillery_CoordinatorScreen(BlockPos pos, Artillery_CoordinatorInterface data) {
        super((Component)Component.m_237113_((String)"Screen"));
        this.imageWidth = 192;
        this.imageHeight = 108;
        this.data = data;
        this.pos = pos;
        this.medianDisp = 0.0;
        this.medianTTT = 0.0;
        this.medianPres = 0.0;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftBound = (this.f_96543_ - this.imageWidth) / 2;
        this.topBound = (this.f_96544_ - this.imageHeight) / 2;
        this.ticks = 0;
        int x = this.imageWidth / 2;
        int y = (int)((double)this.imageHeight * 0.75);
        this.targetPos = (EditBox)this.m_142416_((GuiEventListener)new EditBox(FONT, this.leftBound + 8, this.topBound + 14, 176, 8, TARGET_POS));
        this.targetPos.m_94199_(Integer.MAX_VALUE);
        this.targetPos.m_94167_("_");
        this.targetPos.m_94182_(false);
        this.targetPos.m_94144_(this.data.getTargetPos());
        if (this.data.allowIdChange()) {
            this.netId = (EditBox)this.m_142416_((GuiEventListener)new EditBox(FONT, this.leftBound + 32, this.topBound + 66, 176, 8, TARGET_POS));
            this.netId.m_94199_(5);
            this.netId.m_94167_("_");
            this.netId.m_94182_(false);
            this.netId.m_94144_(this.data.getNetworkId());
        }
        this.sendButton = (TextAndImageButton)this.m_142416_((GuiEventListener)TextAndImageButton.m_267772_((Component)SEND, (ResourceLocation)this.getButton(this.sendCooldown), this::send).m_267775_());
        this.sendButton.m_264152_(this.leftBound + 8, this.topBound + 26);
        this.sendButton.setHeight(16);
        this.sendButton.m_93674_(56);
        this.setButton = (TextAndImageButton)this.m_142416_((GuiEventListener)TextAndImageButton.m_267772_((Component)SET, (ResourceLocation)this.getButton(this.setCooldown), this::set).m_267775_());
        this.setButton.m_264152_(this.leftBound + 68, this.topBound + 26);
        this.setButton.setHeight(16);
        this.setButton.m_93674_(56);
        this.modeButton = (TextAndImageButton)this.m_142416_((GuiEventListener)TextAndImageButton.m_267772_((Component)this.getMode(), (ResourceLocation)this.getButton(this.modeCooldown), this::mode).m_267775_());
        this.modeButton.m_264152_(this.leftBound + 128, this.topBound + 26);
        this.modeButton.setHeight(16);
        this.modeButton.m_93674_(56);
        this.fireButton = (TextAndImageButton)this.m_142416_((GuiEventListener)TextAndImageButton.m_267772_((Component)FIRE, (ResourceLocation)this.getButton(this.fireCooldown), this::fire).m_267775_());
        this.fireButton.m_264152_(this.leftBound + 128, this.topBound + 66);
        this.fireButton.setHeight(16);
        this.fireButton.m_93674_(56);
        this.check();
    }

    public void m_88315_(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(pGuiGraphics);
        pGuiGraphics.m_280163_(BACKGROUND, this.leftBound, this.topBound, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        if (this.targetError) {
            pGuiGraphics.m_280614_(FONT, TARGET_POS, this.leftBound + 8, this.topBound + 6, 16007990, false);
        } else {
            pGuiGraphics.m_280614_(FONT, TARGET_POS, this.leftBound + 8, this.topBound + 6, 0xFFFFFF, false);
        }
        if (this.targetPos.m_94155_().equals(this.data.getTargetPos())) {
            this.sendButton.m_280139_(pGuiGraphics, FONT, 0xFFFFFF);
        } else {
            this.sendButton.m_280139_(pGuiGraphics, FONT, 16007990);
        }
        this.sendButton.m_280322_(pGuiGraphics, this.getButton(this.sendCooldown), this.leftBound + 8, this.topBound + 26, 0, 0, 0, 56, 16, 56, 16);
        if (!this.changedTarget) {
            this.setButton.m_280139_(pGuiGraphics, FONT, 0xFFFFFF);
        } else {
            this.setButton.m_280139_(pGuiGraphics, FONT, 16007990);
        }
        this.setButton.m_280322_(pGuiGraphics, this.getButton(this.setCooldown), this.leftBound + 68, this.topBound + 26, 0, 0, 0, 56, 16, 56, 16);
        this.modeButton.m_93666_(this.getMode());
        this.modeButton.m_280139_(pGuiGraphics, FONT, 0xFFFFFF);
        this.modeButton.m_280322_(pGuiGraphics, this.getButton(this.modeCooldown), this.leftBound + 128, this.topBound + 26, 0, 0, 0, 56, 16, 56, 16);
        this.fireButton.m_280322_(pGuiGraphics, this.getButton(this.fireCooldown), this.leftBound + 128, this.topBound + 66, 0, 0, 0, 56, 16, 56, 16);
        if (this.data.allowIdChange()) {
            pGuiGraphics.m_280056_(FONT, ID.getString(), this.leftBound + 8, this.topBound + 66, 0xFFFFFF, false);
        } else {
            pGuiGraphics.m_280056_(FONT, ID.getString() + this.data.getNetworkId(), this.leftBound + 8, this.topBound + 66, 0xFFFFFF, false);
        }
        pGuiGraphics.m_280056_(FONT, NUM_CAN.getString() + this.data.getNumCannons(), this.leftBound + 68, this.topBound + 66, 0xFFFFFF, false);
        pGuiGraphics.m_280056_(FONT, NUM_DIR.getString() + this.data.getNumDirector(), this.leftBound + 8, this.topBound + 74, 0xFFFFFF, false);
        pGuiGraphics.m_280056_(FONT, READY_CAN.getString() + this.data.getNumReadyCannons(), this.leftBound + 68, this.topBound + 74, 0xFFFFFF, false);
        float[] medianSet = this.data.getMedianSet();
        pGuiGraphics.m_280614_(FONT, MEDIAN, this.leftBound + 8, this.topBound + 46, 0xFFFFFF, false);
        double pres = (double)Math.round(medianSet[0] * 1000.0f) / 1000.0;
        pGuiGraphics.m_280056_(FONT, PRES.getString() + pres + BLOCKS.getString(), this.leftBound + 8, this.topBound + 54, 0xFFFFFF, false);
        double disp = (double)Math.round(medianSet[1] * 1000.0f) / 1000.0;
        pGuiGraphics.m_280056_(FONT, DISP.getString() + disp + BLOCKS.getString(), this.leftBound + 98, this.topBound + 46, 0xFFFFFF, false);
        double tTT = (double)Math.round(medianSet[2] / 20.0f * 1000.0f) / 1000.0;
        pGuiGraphics.m_280056_(FONT, TTT.getString() + tTT + SECONDS.getString(), this.leftBound + 98, this.topBound + 54, 0xFFFFFF, false);
        pGuiGraphics.m_280614_(FONT, SUPER, this.leftBound + 8, this.topBound + 86, 0xFFFFFF, false);
        pGuiGraphics.m_280056_(FONT, this.data.getSuperiorId(), this.leftBound + 8, this.topBound + 94, 0xFFFFFF, false);
        pGuiGraphics.m_280614_(FONT, SUB, this.leftBound + 98, this.topBound + 86, 0xFFFFFF, false);
        pGuiGraphics.m_280056_(FONT, "" + this.data.getNumSubnets(), this.leftBound + 98, this.topBound + 94, 0xFFFFFF, false);
    }

    private void check() {
        this.changeCooldown = 5;
        this.targetError = this.targetPos.m_94155_().isEmpty() ? false : !Utils.posFromString(this.targetPos.m_94155_(), new int[3]);
    }

    public void m_86600_() {
        ++this.ticks;
        this.setCooldown = Math.max(0, this.setCooldown - 1);
        this.sendCooldown = Math.max(0, this.sendCooldown - 1);
        this.modeCooldown = Math.max(0, this.modeCooldown - 1);
        this.fireCooldown = Math.max(0, this.fireCooldown - 1);
        if (this.ticks == 20) {
            this.ticks = 0;
            this.check();
        }
        if (this.data.allowIdChange()) {
            String value = this.netId.m_94155_();
            if (!this.data.getNetworkId().equals(value)) {
                if (value.length() == 5) {
                    this.netId.m_94202_(0xFFFFFF);
                    CompoundTag tag = new CompoundTag();
                    tag.m_128359_("network_id", this.data.getNetworkId());
                    tag.m_128359_("new_network_id", value);
                    this.data.update(tag);
                    this.setNetId();
                } else {
                    this.netId.m_94202_(16007990);
                }
            }
        }
        super.m_86600_();
    }

    public boolean m_7043_() {
        return false;
    }

    private Component getMode() {
        return this.data.getMode().getComponent();
    }

    public void send(Button button) {
        if (this.sendCooldown <= 0 && !this.targetError) {
            this.changedTarget = true;
            this.sendCooldown = 5;
            this.data.setTargetPos(this.targetPos.m_94155_());
            ModMessages.sendToServer(new SendArtilleryNetworkInstructionC2SPacket(this.pos, 0, this.targetPos.m_94155_()));
        }
    }

    public void set(Button button) {
        if (this.setCooldown <= 0 && !this.targetError) {
            this.changedTarget = false;
            this.setCooldown = 5;
            ModMessages.sendToServer(new SendArtilleryNetworkInstructionC2SPacket(this.pos, 1, "nothing"));
        }
    }

    public void mode(Button button) {
        if (this.modeCooldown <= 0 && !this.targetError) {
            this.modeCooldown = 5;
            ModMessages.sendToServer(new SendArtilleryNetworkInstructionC2SPacket(this.pos, 2, "" + this.data.getMode().next().NUM));
            this.send(null);
        }
    }

    public void fire(Button button) {
        if (this.fireCooldown <= 0 && !this.targetError) {
            this.fireCooldown = 5;
            ModMessages.sendToServer(new SendArtilleryNetworkInstructionC2SPacket(this.pos, 3, "nothing"));
        }
    }

    public void setNetId() {
        ModMessages.sendToServer(new SendArtilleryNetworkInstructionC2SPacket(this.pos, 4, this.netId.m_94155_()));
    }

    private ResourceLocation getButton(int ticks) {
        if (ticks <= 0) {
            return new ResourceLocation("cbc_ballistics", "textures/gui/artillery_network/28x8button_up.png");
        }
        return new ResourceLocation("cbc_ballistics", "textures/gui/artillery_network/28x8button_down.png");
    }
}

