/*
 * Decompiled with CFR 0.152.
 */
package net.felis.cbc_ballistics.screen.custom;

import net.felis.cbc_ballistics.block.entity.CalculatorBlockEntity;
import net.felis.cbc_ballistics.util.calculator.FiringSolutions;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.TextAndImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class Ballistic_CalculatorScreen
extends Screen {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("cbc_ballistics", "textures/gui/calculator/calculator_interface.png");
    private static final Component CANNON_POS = Component.m_237115_((String)"block.cbc_ballistics.ballistic_calculator.cannonPos");
    private static final Component TARGET_POS = Component.m_237115_((String)"block.cbc_ballistics.ballistic_calculator.targetPos");
    private static final Component MIN_PITCH = Component.m_237115_((String)"block.cbc_ballistics.ballistic_calculator.minPitch");
    private static final Component MAX_PITCH = Component.m_237115_((String)"block.cbc_ballistics.ballistic_calculator.maxPitch");
    private static final Component LENGTH = Component.m_237115_((String)"block.cbc_ballistics.ballistic_calculator.length");
    private static final Component GRAV = Component.m_237115_((String)"block.cbc_ballistics.ballistic_calculator.grav");
    private static final Component DRAG = Component.m_237115_((String)"block.cbc_ballistics.ballistic_calculator.drag");
    private static final Component CHARGES = Component.m_237115_((String)"block.cbc_ballistics.ballistic_calculator.charge");
    private static final Component MIN_CHARGE = Component.m_237115_((String)"block.cbc_ballistics.ballistic_calculator.minCharge");
    private static final Component MAX_CHARGE = Component.m_237115_((String)"block.cbc_ballistics.ballistic_calculator.maxCharge");
    private static final Component CALCULATE = Component.m_237115_((String)"block.cbc_ballistics.ballistic_calculator.calculate");
    private static final Component OUT_OF_RANGE = Component.m_237115_((String)"block.cbc_ballistics.ballistic_calculator.outOfRange");
    private static final Component PITCH = Component.m_237115_((String)"block.cbc_ballistics.ballistic_calculator.pitch");
    private static final Component PRECISION = Component.m_237115_((String)"block.cbc_ballistics.ballistic_calculator.precision");
    private static final Component DISPERSION = Component.m_237115_((String)"block.cbc_ballistics.ballistic_calculator.dispersion");
    private static final Component YAW = Component.m_237115_((String)"block.cbc_ballistics.ballistic_calculator.yaw");
    private static final Component TRAVEL_TIME = Component.m_237115_((String)"block.cbc_ballistics.ballistic_calculator.travelTime");
    private static final Component BLOCKS = Component.m_237115_((String)"block.cbc_ballistics.ballistic_calculator.blocks");
    private static final Component SECONDS = Component.m_237115_((String)"block.cbc_ballistics.ballistic_calculator.seconds");
    private static final Font FONT = Minecraft.m_91087_().f_91062_;
    private int ticks;
    private int leftBound;
    private int topBound;
    private final int imageHeight;
    private final int imageWidth;
    private CalculatorBlockEntity block;
    private final BlockPos pos;
    private EditBox cannonPos;
    private boolean cannonError;
    private EditBox targetPos;
    private boolean targetError;
    private EditBox minPitch;
    private boolean minPitchError;
    private EditBox maxPitch;
    private boolean maxPitchError;
    private EditBox length;
    private boolean lengthError;
    private EditBox maxCharge;
    private boolean maxChargeError;
    private EditBox minCharge;
    private boolean minChargeError;
    private EditBox grav;
    private boolean gravError;
    private EditBox drag;
    private boolean dragError;
    private TextAndImageButton material;
    private int materialCooldown;
    private TextAndImageButton modeButton;
    private int modeCooldown;
    private TextAndImageButton calculateButton;
    private int calculateCooldown;
    private boolean allowPress;

    public Ballistic_CalculatorScreen(BlockPos pos) {
        super((Component)Component.m_237113_((String)"Screen"));
        this.imageWidth = 192;
        this.imageHeight = 128;
        this.pos = pos;
        this.modeCooldown = 0;
        this.allowPress = true;
        this.calculateCooldown = 0;
        this.materialCooldown = 0;
    }

    protected void m_7856_() {
        BlockEntity block;
        super.m_7856_();
        this.leftBound = (this.f_96543_ - this.imageWidth) / 2;
        this.topBound = (this.f_96544_ - this.imageHeight) / 2;
        this.ticks = 0;
        if (this.f_96541_ != null && this.f_96541_.f_91073_ != null && (block = this.f_96541_.f_91073_.m_7702_(this.pos)) instanceof CalculatorBlockEntity) {
            this.block = (CalculatorBlockEntity)block;
        }
        int x = this.imageWidth / 2;
        int y = (int)((double)this.imageHeight * 0.75);
        CompoundTag tag = this.block.getPersistentData();
        this.cannonPos = (EditBox)this.m_142416_((GuiEventListener)new EditBox(FONT, this.leftBound + 8, this.topBound + 14, 176, 8, CANNON_POS));
        this.cannonPos.m_94199_(Integer.MAX_VALUE);
        this.cannonPos.m_94167_("_");
        this.cannonPos.m_94182_(false);
        this.cannonPos.m_94144_(tag.m_128461_("cannonPos"));
        this.targetPos = (EditBox)this.m_142416_((GuiEventListener)new EditBox(FONT, this.leftBound + 8, this.topBound + 54, 176, 8, TARGET_POS));
        this.targetPos.m_94199_(Integer.MAX_VALUE);
        this.targetPos.m_94167_("_");
        this.targetPos.m_94182_(false);
        this.targetPos.m_94144_(tag.m_128461_("targetPos"));
        this.minPitch = (EditBox)this.m_142416_((GuiEventListener)new EditBox(FONT, this.leftBound + 8, this.topBound + 34, 30, 8, MIN_PITCH));
        this.minPitch.m_94199_(4);
        this.minPitch.m_94167_("\u00b0");
        this.minPitch.m_94182_(false);
        this.minPitch.m_94144_(tag.m_128461_("minPitch"));
        this.maxPitch = (EditBox)this.m_142416_((GuiEventListener)new EditBox(FONT, this.leftBound + 42, this.topBound + 34, 30, 8, MAX_PITCH));
        this.maxPitch.m_94199_(4);
        this.maxPitch.m_94167_("\u00b0");
        this.maxPitch.m_94182_(false);
        this.maxPitch.m_94144_(tag.m_128461_("maxPitch"));
        this.length = (EditBox)this.m_142416_((GuiEventListener)new EditBox(FONT, this.leftBound + 76, this.topBound + 34, 30, 8, LENGTH));
        this.length.m_94199_(5);
        this.length.m_94167_("_");
        this.length.m_94182_(false);
        this.length.m_94144_(tag.m_128461_("length"));
        this.grav = (EditBox)this.m_142416_((GuiEventListener)new EditBox(FONT, this.leftBound + 76, this.topBound + 74, 30, 8, GRAV));
        this.grav.m_94199_(5);
        this.grav.m_94167_("_");
        this.grav.m_94182_(false);
        this.grav.m_94144_(tag.m_128461_("gravity"));
        this.drag = (EditBox)this.m_142416_((GuiEventListener)new EditBox(FONT, this.leftBound + 110, this.topBound + 74, 30, 8, DRAG));
        this.drag.m_94199_(5);
        this.drag.m_94167_("_");
        this.drag.m_94182_(false);
        this.drag.m_94144_(tag.m_128461_("drag"));
        this.minCharge = (EditBox)this.m_142416_((GuiEventListener)new EditBox(FONT, this.leftBound + 130, this.topBound + 34, 20, 8, MIN_CHARGE));
        this.minCharge.m_94199_(2);
        this.minCharge.m_94167_("_");
        this.minCharge.m_94182_(false);
        this.minCharge.m_94144_(tag.m_128461_("minCharge"));
        this.maxCharge = (EditBox)this.m_142416_((GuiEventListener)new EditBox(FONT, this.leftBound + 170, this.topBound + 34, 16, 8, MAX_CHARGE));
        this.maxCharge.m_94199_(2);
        this.maxCharge.m_94167_("_");
        this.maxCharge.m_94182_(false);
        this.maxCharge.m_94144_(tag.m_128461_("maxCharge"));
        this.material = (TextAndImageButton)this.m_142416_((GuiEventListener)TextAndImageButton.m_267772_((Component)this.block.getMaterial(), (ResourceLocation)this.getMaterialButton(), this::cycleMaterial).m_267775_());
        this.material.m_264152_(this.leftBound + 144, this.topBound + 66);
        this.material.setHeight(16);
        this.material.m_93674_(40);
        this.modeButton = (TextAndImageButton)this.m_142416_((GuiEventListener)TextAndImageButton.m_267772_((Component)this.block.getMode(), (ResourceLocation)this.getModeButton(), this::mode).m_267775_());
        this.modeButton.m_264152_(this.leftBound + 8, this.topBound + 86);
        this.modeButton.setHeight(16);
        this.modeButton.m_93674_(64);
        this.calculateButton = (TextAndImageButton)this.m_142416_((GuiEventListener)TextAndImageButton.m_267772_((Component)CALCULATE, (ResourceLocation)this.getCalculatebutton(), this::calculate).m_267775_());
        this.calculateButton.m_264152_(this.leftBound + 8, this.topBound + 66);
        this.calculateButton.setHeight(16);
        this.calculateButton.m_93674_(64);
        this.calculateButton.m_93666_(CALCULATE);
        this.check();
    }

    public void m_88315_(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(pGuiGraphics);
        pGuiGraphics.m_280163_(BACKGROUND, this.leftBound, this.topBound, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        boolean error = false;
        if (this.cannonError) {
            error = true;
            pGuiGraphics.m_280614_(FONT, CANNON_POS, this.leftBound + 8, this.topBound + 6, 16007990, false);
        } else {
            pGuiGraphics.m_280614_(FONT, CANNON_POS, this.leftBound + 8, this.topBound + 6, 0xFFFFFF, false);
        }
        if (this.targetError) {
            error = true;
            pGuiGraphics.m_280614_(FONT, TARGET_POS, this.leftBound + 8, this.topBound + 46, 16007990, false);
        } else {
            pGuiGraphics.m_280614_(FONT, TARGET_POS, this.leftBound + 8, this.topBound + 46, 0xFFFFFF, false);
        }
        if (this.minPitchError) {
            error = true;
            pGuiGraphics.m_280614_(FONT, MIN_PITCH, this.leftBound + 8, this.topBound + 26, 16007990, false);
        } else {
            pGuiGraphics.m_280614_(FONT, MIN_PITCH, this.leftBound + 8, this.topBound + 26, 0xFFFFFF, false);
        }
        if (this.maxPitchError) {
            error = true;
            pGuiGraphics.m_280614_(FONT, MAX_PITCH, this.leftBound + 42, this.topBound + 26, 16007990, false);
        } else {
            pGuiGraphics.m_280614_(FONT, MAX_PITCH, this.leftBound + 42, this.topBound + 26, 0xFFFFFF, false);
        }
        if (this.lengthError) {
            error = true;
            pGuiGraphics.m_280614_(FONT, LENGTH, this.leftBound + 76, this.topBound + 26, 16007990, false);
        } else {
            pGuiGraphics.m_280614_(FONT, LENGTH, this.leftBound + 76, this.topBound + 26, 0xFFFFFF, false);
        }
        if (this.gravError) {
            error = true;
            pGuiGraphics.m_280614_(FONT, GRAV, this.leftBound + 76, this.topBound + 66, 16007990, false);
        } else {
            pGuiGraphics.m_280614_(FONT, GRAV, this.leftBound + 76, this.topBound + 66, 0xFFFFFF, false);
        }
        if (this.dragError) {
            error = true;
            pGuiGraphics.m_280614_(FONT, DRAG, this.leftBound + 110, this.topBound + 66, 16007990, false);
        } else {
            pGuiGraphics.m_280614_(FONT, DRAG, this.leftBound + 110, this.topBound + 66, 0xFFFFFF, false);
        }
        pGuiGraphics.m_280614_(FONT, CHARGES, this.leftBound + 114, this.topBound + 26, 0xFFFFFF, false);
        if (this.minChargeError) {
            error = true;
            pGuiGraphics.m_280614_(FONT, MIN_CHARGE, this.leftBound + 114, this.topBound + 34, 16007990, false);
        } else {
            pGuiGraphics.m_280614_(FONT, MIN_CHARGE, this.leftBound + 114, this.topBound + 34, 0xFFFFFF, false);
        }
        if (this.maxChargeError) {
            error = true;
            pGuiGraphics.m_280614_(FONT, MAX_CHARGE, this.leftBound + 150, this.topBound + 34, 16007990, false);
        } else {
            pGuiGraphics.m_280614_(FONT, MAX_CHARGE, this.leftBound + 150, this.topBound + 34, 0xFFFFFF, false);
        }
        this.material.m_93666_(this.block.getMaterial());
        this.material.m_280139_(pGuiGraphics, FONT, 0xFFFFFF);
        this.material.m_280322_(pGuiGraphics, this.getMaterialButton(), this.leftBound + 144, this.topBound + 66, 0, 0, 0, 40, 16, 40, 16);
        this.modeButton.m_93666_(this.block.getMode());
        this.modeButton.m_280139_(pGuiGraphics, FONT, 0xFFFFFF);
        this.modeButton.m_280322_(pGuiGraphics, this.getModeButton(), this.leftBound + 8, this.topBound + 86, 0, 0, 0, 64, 16, 64, 16);
        if (error) {
            this.allowPress = false;
            this.calculateButton.m_280139_(pGuiGraphics, FONT, 16007990);
        } else {
            this.allowPress = true;
            this.calculateButton.m_280139_(pGuiGraphics, FONT, 0xFFFFFF);
        }
        this.calculateButton.m_280322_(pGuiGraphics, this.getCalculatebutton(), this.leftBound + 8, this.topBound + 66, 0, 0, 0, 64, 16, 64, 16);
        if (this.block.isReady()) {
            if (this.block.isTooFar()) {
                pGuiGraphics.m_280430_(FONT, OUT_OF_RANGE, this.leftBound + 76, this.topBound + 86, 16007990);
            } else if (this.block.getResult() != null) {
                FiringSolutions.Solution solution = this.block.getResult();
                double pitch = (double)Math.round(solution.PITCH * 1000.0f) / 1000.0;
                pGuiGraphics.m_280056_(FONT, PITCH.getString() + pitch, this.leftBound + 76, this.topBound + 86, 0xFFFFFF, false);
                pGuiGraphics.m_280056_(FONT, CHARGES.getString() + ": " + solution.CHARGES, this.leftBound + 76, this.topBound + 94, 0xFFFFFF, false);
                double yaw = (double)Math.round(solution.YAW * 1000.0f) / 1000.0;
                pGuiGraphics.m_280488_(FONT, YAW.getString() + yaw, this.leftBound + 8, this.topBound + 106, 0xFFFFFF);
                double pres = (double)Math.round(solution.PRECISION * 1000.0f) / 1000.0;
                pGuiGraphics.m_280056_(FONT, PRECISION.getString() + pres + BLOCKS.getString(), this.leftBound + 8, this.topBound + 114, 0xFFFFFF, false);
                double disp = (double)Math.round(solution.DISPERSION * 1000.0f) / 1000.0;
                pGuiGraphics.m_280056_(FONT, DISPERSION.getString() + disp + BLOCKS.getString(), this.leftBound + 98, this.topBound + 106, 0xFFFFFF, false);
                double TTT = (double)Math.round(solution.AIR_TIME / 20.0f * 1000.0f) / 1000.0;
                pGuiGraphics.m_280056_(FONT, TRAVEL_TIME.getString() + TTT + SECONDS.getString(), this.leftBound + 98, this.topBound + 114, 0xFFFFFF, false);
            }
        }
    }

    public void m_86600_() {
        ++this.ticks;
        this.materialCooldown = Math.max(0, this.materialCooldown - 1);
        this.modeCooldown = Math.max(0, this.modeCooldown - 1);
        this.calculateCooldown = Math.max(0, this.calculateCooldown - 1);
        if (this.ticks == 20) {
            this.ticks = 0;
            this.check();
        }
        super.m_86600_();
    }

    private void check() {
        if (this.cannonPos.m_94155_().isEmpty()) {
            this.cannonError = false;
        } else {
            boolean bl = this.cannonError = !this.block.setCannonPos(this.cannonPos.m_94155_());
        }
        if (this.targetPos.m_94155_().isEmpty()) {
            this.targetError = false;
        } else {
            boolean bl = this.targetError = !this.block.setTargetPos(this.targetPos.m_94155_());
        }
        if (this.minPitch.m_94155_().isEmpty()) {
            this.minPitchError = false;
        } else {
            boolean bl = this.minPitchError = !this.block.setMinPitch(this.minPitch.m_94155_());
        }
        if (this.maxPitch.m_94155_().isEmpty()) {
            this.maxPitchError = false;
        } else {
            boolean bl = this.maxPitchError = !this.block.setMaxPitch(this.maxPitch.m_94155_());
        }
        if (this.length.m_94155_().isEmpty()) {
            this.lengthError = false;
        } else {
            boolean bl = this.lengthError = !this.block.setLength(this.length.m_94155_());
        }
        if (this.grav.m_94155_().isEmpty()) {
            this.gravError = false;
        } else {
            boolean bl = this.gravError = !this.block.setGravity(this.grav.m_94155_());
        }
        if (this.drag.m_94155_().isEmpty()) {
            this.dragError = false;
        } else {
            boolean bl = this.dragError = !this.block.setDrag(this.drag.m_94155_());
        }
        if (this.maxCharge.m_94155_().isEmpty()) {
            this.maxChargeError = false;
        } else {
            boolean bl = this.maxChargeError = !this.block.setMaxCharge(this.maxCharge.m_94155_());
        }
        this.minChargeError = this.minCharge.m_94155_().isEmpty() ? false : !this.block.setMinCharge(this.minCharge.m_94155_());
    }

    private ResourceLocation getMaterialButton() {
        if (this.materialCooldown <= 0) {
            return new ResourceLocation("cbc_ballistics", "textures/gui/calculator/20x8button_up.png");
        }
        return new ResourceLocation("cbc_ballistics", "textures/gui/calculator/20x8button_down.png");
    }

    private ResourceLocation getModeButton() {
        if (this.modeCooldown <= 0) {
            return new ResourceLocation("cbc_ballistics", "textures/gui/calculator/38x8button_up.png");
        }
        return new ResourceLocation("cbc_ballistics", "textures/gui/calculator/38x8button_down.png");
    }

    private ResourceLocation getCalculatebutton() {
        if (this.calculateCooldown <= 0) {
            return new ResourceLocation("cbc_ballistics", "textures/gui/calculator/38x8button_up.png");
        }
        return new ResourceLocation("cbc_ballistics", "textures/gui/calculator/38x8button_down.png");
    }

    private void cycleMaterial(Button button) {
        if (this.materialCooldown <= 0) {
            this.materialCooldown = 5;
            this.block.cycleMaterial();
        }
    }

    private void mode(Button button) {
        if (this.modeCooldown <= 0) {
            this.modeCooldown = 5;
            this.block.cycleMode();
        }
    }

    private void calculate(Button button) {
        if (this.calculateCooldown <= 0) {
            this.calculateCooldown = 5;
            this.block.sync(true);
        }
    }

    public void m_7379_() {
        this.block.setCannonPos(this.cannonPos.m_94155_());
        this.block.setTargetPos(this.targetPos.m_94155_());
        this.block.setMinCharge(this.minCharge.m_94155_());
        this.block.setMaxCharge(this.maxCharge.m_94155_());
        this.block.setLength(this.length.m_94155_());
        this.block.setGravity(this.grav.m_94155_());
        this.block.setDrag(this.drag.m_94155_());
        this.block.setMaxPitch(this.maxPitch.m_94155_());
        this.block.setMinPitch(this.minPitch.m_94155_());
        this.block.sync(false);
        super.m_7379_();
    }

    public boolean m_7043_() {
        return false;
    }
}

