/*
 * Decompiled with CFR 0.152.
 */
package net.felis.cbc_ballistics.util;

import net.felis.cbc_ballistics.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ParticleHelper {
    private static final float FREQ = 0.25f;

    public static void line(Level level, BlockPos from, BlockPos to, Colour colour, float size) {
        ParticleHelper.line(level, from.m_252807_(), to.m_252807_(), colour, size);
    }

    public static void line(Level level, Vec3 from, Vec3 to, Colour colour, float size) {
        double[] f = Utils.vec3ToArray(from);
        double[] t = Utils.vec3ToArray(to);
        double dist = Utils.distFrom(from, to);
        double freak = dist / 0.25;
        float xChange = (float)((t[0] - f[0]) / freak);
        float yChange = (float)((t[1] - f[1]) / freak);
        float zChange = (float)((t[2] - f[2]) / freak);
        DustParticleOptions dust = colour.toDust(size);
        float i = 0.0f;
        while ((double)i < dist) {
            level.m_6493_((ParticleOptions)dust, true, f[0], f[1], f[2], 0.0, 0.0, 0.0);
            f[0] = f[0] + (double)xChange;
            f[1] = f[1] + (double)yChange;
            f[2] = f[2] + (double)zChange;
            i += 0.25f;
        }
    }

    public static void dot(Level level, Vec3 pos, Colour colour, float size) {
        DustParticleOptions dust = colour.toDust(size);
        level.m_6493_((ParticleOptions)dust, true, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
    }

    public static void Circle(Level level, Vec3 pos, Colour colour, float radius, float yaw, float pitch, float size) {
        DustParticleOptions dust = colour.toDust(size);
        Vec3 nor = new Vec3(Utils.vecToVel(-pitch, yaw, 1.0f));
        Vec3 orth1 = Utils.orthog(nor);
        Vec3 orth2 = new Vec3(nor.m_252839_().cross((Vector3fc)orth1.m_252839_()));
        float i = 0.0f;
        while ((double)i < Math.PI * 2) {
            float x = (float)(pos.f_82479_ + (double)radius * Math.cos(i) * orth1.f_82479_ + (double)radius * Math.sin(i) * orth2.f_82479_);
            float y = (float)(pos.f_82480_ + (double)radius * Math.cos(i) * orth1.f_82480_ + (double)radius * Math.sin(i) * orth2.f_82480_);
            float z = (float)(pos.f_82481_ + (double)radius * Math.cos(i) * orth1.f_82481_ + (double)radius * Math.sin(i) * orth2.f_82481_);
            level.m_6493_((ParticleOptions)dust, true, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
            i += 0.25f / radius;
        }
    }

    public static enum Colour {
        YELLOW(1.0f, 1.0f, 0.333333f),
        BLACK(0.0f, 0.0f, 0.0f),
        WHITE(1.0f, 1.0f, 1.0f),
        BLUE(0.333333f, 0.333333f, 1.0f),
        GREEN(0.333333f, 1.0f, 0.333333f),
        RED(1.0f, 0.333333f, 0.333333f);

        private final float r;
        private final float g;
        private final float b;

        private Colour(float r, float g, float b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public float[] toArray() {
            return new float[]{this.r, this.g, this.b};
        }

        public float r() {
            return this.r;
        }

        public float g() {
            return this.g;
        }

        public float b() {
            return this.b;
        }

        public DustParticleOptions toDust(float size) {
            return new DustParticleOptions(new Vector3f(this.r, this.g, this.b), size);
        }
    }
}

