/*
 * Decompiled with CFR 0.152.
 */
package net.felis.cbc_ballistics.util;

import java.util.ArrayList;
import java.util.Arrays;
import net.felis.cbc_ballistics.block.entity.ArtilleryCoordinatorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.joml.Vector3f;

public class Utils {
    public static boolean posFromString(String string, int[] array) {
        for (int i = 0; i <= 2; ++i) {
            boolean pass = false;
            boolean found = false;
            int index = 0;
            for (int j = 0; j < string.length(); ++j) {
                try {
                    Integer.valueOf(string.substring(j, j + 1));
                    if (found) continue;
                    index = j;
                    found = true;
                    continue;
                }
                catch (NumberFormatException e) {
                    if (found) {
                        try {
                            array[i] = Integer.parseInt(string.substring(index, j));
                        }
                        catch (NumberFormatException e1) {
                            return false;
                        }
                        string = string.substring(j);
                        pass = true;
                        break;
                    }
                    if (string.charAt(j) != '-') continue;
                    index = j;
                    found = true;
                }
            }
            if (pass) continue;
            if (found) {
                try {
                    array[i] = Integer.parseInt(string.substring(index));
                    string = "";
                    continue;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            return false;
        }
        return string.isEmpty();
    }

    public static int stringToInt(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static String blockPosToString(BlockPos pos) {
        return "X = " + pos.m_123341_() + ", Y = " + pos.m_123342_() + ", Z = " + pos.m_123343_();
    }

    public static int[] blockPosToArray(BlockPos pos) {
        return new int[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()};
    }

    public static double[] vec3ToArray(Vec3 pos) {
        return new double[]{pos.f_82479_, pos.f_82480_, pos.f_82481_};
    }

    public static BlockPos arrayToBlockPos(int[] array) {
        return new BlockPos(array[0], array[1], array[2]);
    }

    public static double median(double[] array) {
        if (array.length > 0) {
            if (array.length > 1) {
                Arrays.sort((double[])array.clone());
                return array[(int)Math.round((double)array.length / 2.0)];
            }
            return array[0];
        }
        return 0.0;
    }

    public static float median(float[] array) {
        if (array.length > 0) {
            if (array.length > 1) {
                Arrays.sort((float[])array.clone());
                return array[(int)Math.round((double)array.length / 2.0)];
            }
            return array[0];
        }
        return 0.0f;
    }

    public static double[] toArray(ArrayList<Double> array) {
        double[] ret = new double[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            ret[i] = array.get(i);
        }
        return ret;
    }

    public static String formatPos(int[] array) {
        return "X = " + array[0] + ", Y = " + array[1] + ", Z = " + array[2];
    }

    public static String formatPos(BlockPos pos) {
        return "X = " + pos.m_123341_() + ", Y = " + pos.m_123342_() + ", Z = " + pos.m_123343_();
    }

    public static String formatPos(Vec3 pos) {
        return "X = " + Mth.m_14107_((double)pos.f_82479_) + ", Y = " + Mth.m_14107_((double)pos.f_82480_) + ", Z = " + Mth.m_14107_((double)pos.f_82481_);
    }

    public static PacketDistributor.TargetPoint targetPoint(BlockPos pos, int radius, ResourceKey<Level> dimension) {
        return new PacketDistributor.TargetPoint((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)radius, dimension);
    }

    public static Vector3f vecToVel(float xRot, float yRot, float magnitude) {
        float xVel = -Mth.m_14031_((float)(yRot * ((float)Math.PI / 180))) * Mth.m_14089_((float)(xRot * ((float)Math.PI / 180)));
        float yVel = -Mth.m_14031_((float)(xRot * ((float)Math.PI / 180)));
        float zVel = Mth.m_14089_((float)(yRot * ((float)Math.PI / 180))) * Mth.m_14089_((float)(xRot * ((float)Math.PI / 180)));
        return new Vector3f(xVel * magnitude, yVel * magnitude, zVel * magnitude);
    }

    public static double distFrom(BlockPos pos0, BlockPos pos1) {
        int x = pos0.m_123341_() - pos1.m_123341_();
        int y = pos0.m_123342_() - pos1.m_123342_();
        int z = pos0.m_123343_() - pos1.m_123343_();
        return Math.sqrt(x * x + y * y + z * z);
    }

    public static double distFrom(Vec3 pos0, Vec3 pos1) {
        double x = pos0.f_82479_ - pos1.f_82479_;
        double y = pos0.f_82480_ - pos1.f_82480_;
        double z = pos0.f_82481_ - pos1.f_82481_;
        return Math.sqrt(x * x + y * y + z * z);
    }

    public static double distFrom(BlockEntity be0, BlockEntity be1) {
        return Utils.distFrom(be0.m_58899_(), be1.m_58899_());
    }

    public static boolean arrayEquals(int[] a0, int[] a1) {
        if (a0 == null || a1 == null) {
            return false;
        }
        for (int i = 0; i < Math.min(a0.length, a1.length); ++i) {
            if (a0[i] == a1[i]) continue;
            return false;
        }
        return true;
    }

    public static CompoundTag tagOf(ArtilleryCoordinatorBlockEntity be) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("network_id", be.getNetwork_id());
        return tag;
    }

    public static int yawFromFacing(Direction d) {
        return switch (d) {
            case Direction.NORTH -> 0;
            case Direction.EAST -> 270;
            case Direction.SOUTH -> 180;
            case Direction.WEST -> 90;
            default -> 0;
        };
    }

    public static Vec3 orthog(Vec3 p) {
        if (p.f_82479_ > p.f_82481_ && p.f_82479_ > p.f_82480_) {
            Vec3 vec = new Vec3(0.0, -p.f_82481_, p.f_82480_);
            return vec.m_82490_(1.0 / vec.m_82553_());
        }
        if (p.f_82480_ > p.f_82481_) {
            Vec3 vec = new Vec3(-p.f_82481_, 0.0, p.f_82479_);
            return vec.m_82490_(1.0 / vec.m_82553_());
        }
        Vec3 vec = new Vec3(-p.f_82480_, p.f_82479_, 0.0);
        return vec.m_82490_(1.0 / vec.m_82553_());
    }
}

