/*
 * Decompiled with CFR 0.152.
 */
package net.felis.cbc_ballistics.util.calculator;

import java.util.ArrayList;
import net.felis.cbc_ballistics.util.calculator.FiringSolutions;
import net.felis.cbc_ballistics.util.calculator.Material;
import net.felis.cbc_ballistics.util.calculator.Projectile;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;

public class Cannon {
    private BlockPos cannonPos;
    private Level level;
    private int barrelLength;
    private float maxPitch;
    private float minPitch;
    private Material material;
    private int maxCharge;
    private int minCharge;
    private float gravity;
    private float drag;
    private BlockPos target;

    private Cannon(BlockPos cannonPos, int barrelLength, float minPitch, float maxPitch, Material material, Level level, int minCharge, int maxCharge, float gravity, float drag) {
        this.cannonPos = cannonPos;
        this.level = level;
        this.barrelLength = barrelLength;
        this.minPitch = minPitch;
        this.maxPitch = maxPitch;
        this.material = material;
        this.minCharge = minCharge;
        this.maxCharge = maxCharge;
        this.gravity = gravity;
        this.drag = drag;
    }

    public FiringSolutions interpolateTarget(BlockPos target) {
        int i;
        this.target = target;
        Projectile[] solutions = new Projectile[2];
        ArrayList<Projectile> lowerSolutions = new ArrayList<Projectile>();
        ArrayList<Projectile> upperSolutions = new ArrayList<Projectile>();
        for (i = this.minCharge; i <= this.maxCharge; ++i) {
            try {
                Projectile[] solutionI = this.calculate(i);
                lowerSolutions.add(this.calculate(solutionI[0]));
                upperSolutions.add(this.calculate(solutionI[1]));
                continue;
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        if (lowerSolutions.size() <= 0 || upperSolutions.size() <= 0) {
            throw new RuntimeException("Out of range");
        }
        solutions[0] = (Projectile)lowerSolutions.get(lowerSolutions.size() - 1);
        for (i = lowerSolutions.size() - 1; i >= 0; --i) {
            if (!(((Projectile)lowerSolutions.get(i)).getPrecisionEstimate() >= solutions[0].getPrecisionEstimate())) continue;
            solutions[0] = (Projectile)lowerSolutions.get(i);
        }
        solutions[1] = (Projectile)upperSolutions.get(0);
        for (i = 1; i < upperSolutions.size(); ++i) {
            if (!(((Projectile)upperSolutions.get(i)).getPrecisionEstimate() >= solutions[1].getPrecisionEstimate())) continue;
            solutions[1] = (Projectile)upperSolutions.get(i);
        }
        return new FiringSolutions(solutions, this.getYaw());
    }

    public BlockPos getCannonPos() {
        return this.cannonPos;
    }

    public Level getLevel() {
        return this.level;
    }

    public float getYaw() {
        double xDistance = this.cannonPos.m_123341_() - this.target.m_123341_();
        if (xDistance == 0.0) {
            return 0.0f;
        }
        float rawYaw = (float)(Math.atan((double)(this.cannonPos.m_123343_() - this.target.m_123343_()) / xDistance) * 57.29577951308232);
        if (xDistance >= 0.0) {
            rawYaw += 180.0f;
        }
        return (rawYaw + 270.0f) % 360.0f;
    }

    public BlockPos getTarget() {
        return this.target;
    }

    public double distToTarget() {
        return Math.sqrt(Math.pow(this.cannonPos.m_123341_() - this.target.m_123341_(), 2.0) + Math.pow(this.cannonPos.m_123343_() - this.target.m_123343_(), 2.0));
    }

    public int getBarrelLength() {
        return this.barrelLength;
    }

    public double getMinPitch() {
        return this.minPitch;
    }

    public double getMaxPitch() {
        return this.maxPitch;
    }

    public Material getMaterial() {
        return this.material;
    }

    public float getGravity() {
        return this.gravity;
    }

    public float getDrag() {
        return this.drag;
    }

    private Projectile[] calculate(int charges) {
        ArrayList<Projectile> angles = new ArrayList<Projectile>();
        for (int pitch = (int)Math.floor(this.minPitch); pitch <= (int)Math.ceil(this.maxPitch); ++pitch) {
            try {
                Projectile projectile = new Projectile(this, pitch, charges);
                angles.add(projectile);
                continue;
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        if (angles.size() <= 0) {
            throw new RuntimeException("Out of range");
        }
        return new Projectile[]{this.getUpperAngle(angles), this.getLowerAngle(angles)};
    }

    private Projectile calculate(Projectile projectile) {
        for (int i = 0; i <= 5; ++i) {
            int charges = projectile.getCharges();
            double lowerPitch = projectile.getPitch() - Math.pow(10.0, -i);
            double upperPitch = projectile.getPitch() + Math.pow(10.0, -i);
            double iter = (upperPitch - lowerPitch) / 21.0;
            ArrayList<Projectile> angles = new ArrayList<Projectile>();
            for (double pitch = lowerPitch; pitch <= upperPitch; pitch += iter) {
                try {
                    Projectile newProjectile = new Projectile(this, pitch, charges);
                    angles.add(newProjectile);
                    continue;
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
            }
            projectile = (Projectile)angles.get(0);
            for (int j = 1; j < angles.size(); ++j) {
                if (!(projectile.getDelta() > ((Projectile)angles.get(j)).getDelta())) continue;
                projectile = (Projectile)angles.get(j);
            }
        }
        return projectile;
    }

    private Projectile getUpperAngle(ArrayList<Projectile> array) {
        for (int i = 1; i < array.size(); ++i) {
            if (!(array.get(i - 1).getDelta() < array.get(i).getDelta())) continue;
            return array.get(i - 1);
        }
        return array.get(0);
    }

    private Projectile getLowerAngle(ArrayList<Projectile> array) {
        for (int i = array.size() - 2; i >= 0; --i) {
            if (!(array.get(i).getDelta() > array.get(i + 1).getDelta())) continue;
            return array.get(i + 1);
        }
        return array.get(array.size() - 1);
    }

    public static class Builder {
        private BlockPos cannonPos = new BlockPos(0, 0, 0);
        private Level level;
        private int barrelLength;
        private float maxPitch;
        private float minPitch;
        private Material material;
        private float gravity;
        private float drag;
        private int minCharge;
        private int maxCharge;

        public Builder(Level level) {
            this.level = level;
            this.barrelLength = 1;
            this.material = Material.STEEL;
            this.maxPitch = 60.0f;
            this.minPitch = -30.0f;
            this.minCharge = 1;
            this.maxCharge = 1;
            this.gravity = 0.05f;
            this.drag = 0.99f;
        }

        public Builder at(BlockPos pos) {
            this.cannonPos = pos;
            return this;
        }

        public Builder length(int barrelLength) {
            this.barrelLength = barrelLength;
            return this;
        }

        public Builder material(Material material) {
            this.material = material;
            return this;
        }

        public Builder maxPitch(float maxPitch) {
            this.maxPitch = maxPitch;
            return this;
        }

        public Builder minPitch(float minPitch) {
            this.minPitch = minPitch;
            return this;
        }

        public Builder maxCharge(int maxCharge) {
            this.maxCharge = maxCharge;
            return this;
        }

        public Builder minCharge(int minCharge) {
            this.minCharge = minCharge;
            return this;
        }

        public Builder drag(float drag) {
            this.drag = drag;
            return this;
        }

        public Builder grav(float grav) {
            this.gravity = grav;
            return this;
        }

        public Cannon build() {
            return new Cannon(this.cannonPos, this.barrelLength, this.minPitch, this.maxPitch, this.material, this.level, this.minCharge, this.maxCharge, this.gravity, this.drag);
        }
    }
}

