/*
 * Decompiled with CFR 0.152.
 */
package net.felis.cbc_ballistics.util.calculator;

import net.felis.cbc_ballistics.util.calculator.Projectile;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.phys.Vec3;

public class FiringSolutions {
    public final Solution INDIRECT;
    public final Solution DIRECT;
    public final float YAW;

    private FiringSolutions(float yaw) {
        this.YAW = yaw;
        this.DIRECT = new Solution();
        this.INDIRECT = new Solution();
    }

    public FiringSolutions() {
        this(0.0f);
    }

    public FiringSolutions(Projectile[] projectiles, float yaw) {
        this.YAW = yaw;
        this.DIRECT = projectiles[0] != null ? new Solution(projectiles[0]) : new Solution();
        this.INDIRECT = projectiles[1] != null ? new Solution(projectiles[1]) : new Solution();
    }

    public FiringSolutions(CompoundTag tag) {
        this.YAW = tag.m_128457_("yaw");
        this.INDIRECT = new Solution(tag.m_128469_("indirect"));
        this.DIRECT = new Solution(tag.m_128469_("direct"));
    }

    public CompoundTag toTags() {
        CompoundTag tag = new CompoundTag();
        tag.m_128350_("yaw", this.YAW);
        tag.m_128365_("direct", (Tag)this.DIRECT.toTag());
        tag.m_128365_("indirect", (Tag)this.INDIRECT.toTag());
        return tag;
    }

    public static Solution solution(CompoundTag tag) {
        return new FiringSolutions(tag.m_128457_("yaw")).new Solution(tag);
    }

    public class Solution {
        public final float PITCH;
        public final Vec3 HIT_POS;
        public final float ANGLE_OF_ATTACK;
        public final float DISPERSION;
        public final float PRECISION;
        public final float AIR_TIME;
        public final byte CHARGES;
        public final float YAW;
        public final Type TYPE;

        public Solution() {
            this.PITCH = 0.0f;
            this.DISPERSION = 0.0f;
            this.PRECISION = 0.0f;
            this.AIR_TIME = 0.0f;
            this.CHARGES = 0;
            this.HIT_POS = new Vec3(0.0, 0.0, 0.0);
            this.ANGLE_OF_ATTACK = 90.0f;
            this.TYPE = Type.OUT_OF_RANGE;
            this.YAW = FiringSolutions.this.YAW;
        }

        private Solution(Projectile projectile) {
            this.HIT_POS = projectile.simulate().m_82450_();
            this.PITCH = (float)projectile.getPitch();
            this.DISPERSION = (float)projectile.getDispersion();
            this.PRECISION = (float)projectile.getPrecision();
            this.AIR_TIME = (float)projectile.getAirtime();
            this.CHARGES = (byte)projectile.getCharges();
            this.ANGLE_OF_ATTACK = projectile.getAngleOfAttack();
            this.TYPE = Type.NORMAl;
            this.YAW = FiringSolutions.this.YAW;
        }

        public Solution(CompoundTag tag) {
            this.PITCH = tag.m_128457_("pitch");
            this.DISPERSION = tag.m_128457_("disp");
            this.PRECISION = tag.m_128457_("pres");
            this.AIR_TIME = tag.m_128457_("air_time");
            this.CHARGES = tag.m_128445_("charges");
            this.ANGLE_OF_ATTACK = tag.m_128457_("angle_of_attack");
            this.HIT_POS = new Vec3((double)tag.m_128457_("x"), (double)tag.m_128457_("y"), (double)tag.m_128457_("z"));
            this.TYPE = Type.of(tag.m_128471_("state"));
            this.YAW = FiringSolutions.this.YAW;
        }

        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.m_128350_("pitch", this.PITCH);
            tag.m_128350_("disp", this.DISPERSION);
            tag.m_128350_("pres", this.PRECISION);
            tag.m_128350_("air_time", this.AIR_TIME);
            tag.m_128344_("charges", this.CHARGES);
            tag.m_128379_("state", this.TYPE.BOOL);
            tag.m_128350_("angle_of_attack", this.ANGLE_OF_ATTACK);
            tag.m_128350_("x", (float)this.HIT_POS.f_82479_);
            tag.m_128350_("y", (float)this.HIT_POS.f_82480_);
            tag.m_128350_("z", (float)this.HIT_POS.f_82481_);
            return tag;
        }

        public CompoundTag toTagSingle() {
            CompoundTag tag = this.toTag();
            tag.m_128350_("yaw", this.YAW);
            return tag;
        }
    }

    public static enum Type {
        OUT_OF_RANGE(false),
        NORMAl(true);

        public final boolean BOOL;

        private Type(boolean bool) {
            this.BOOL = bool;
        }

        public static Type of(boolean bool) {
            if (bool) {
                return NORMAl;
            }
            return OUT_OF_RANGE;
        }
    }
}

