/*
 * Decompiled with CFR 0.152.
 */
package net.felis.cbc_ballistics.util.calculator;

import net.felis.cbc_ballistics.entity.custom.DetectingProjectile;
import net.felis.cbc_ballistics.util.Utils;
import net.felis.cbc_ballistics.util.calculator.Cannon;
import net.felis.cbc_ballistics.util.calculator.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class Projectile {
    private final Cannon cannon;
    private final double pitch;
    private final int power;
    private final double delta;
    private final double timeToTarget;
    private float angle_of_attack;
    private double[] pos = new double[2];
    private double[] vel = new double[2];
    private HitResult result;
    private double distanceTravelled;

    public Projectile(Cannon cannon, double pitch, int charges) {
        this.cannon = cannon;
        this.pitch = pitch;
        this.power = charges * 2;
        double pitchRadians = Math.toRadians(pitch);
        BlockPos cannonPos = cannon.getCannonPos();
        this.pos[0] = (double)cannon.getBarrelLength() * Math.cos(pitchRadians);
        this.pos[1] = (double)cannonPos.m_123342_() + Math.sin(pitchRadians) * (double)cannon.getBarrelLength();
        this.vel[0] = Math.cos(pitchRadians) * (double)this.power;
        this.vel[1] = Math.sin(pitchRadians) * (double)this.power;
        this.timeToTarget = Math.abs(Math.log(1.0 - (cannon.distToTarget() - this.pos[0]) / (100.0 * this.vel[0])) / Math.log(0.99));
        double[] airTimes = this.getAirTimes();
        double deltaA = Math.abs(this.timeToTarget - airTimes[0]);
        double deltaB = Math.abs(this.timeToTarget - airTimes[1]);
        this.delta = Math.min(deltaA, deltaB);
    }

    public Cannon getCannon() {
        return this.cannon;
    }

    public float getYaw() {
        return this.cannon.getYaw();
    }

    public double getPitch() {
        return this.pitch;
    }

    public int getCharges() {
        return this.power / 2;
    }

    public double getDelta() {
        return this.delta;
    }

    public double getTimeToTarget() {
        return this.timeToTarget;
    }

    public double getAirtime() {
        return this.timeToTarget + this.delta;
    }

    public double getPrecisionEstimate() {
        Double precisionEstimate = new Double(1.0 - this.delta / this.getAirtime());
        if (precisionEstimate.isNaN()) {
            return 0.0;
        }
        return precisionEstimate;
    }

    public double getDispersion() {
        Material material = this.cannon.getMaterial();
        double inaccuracy = Math.max((float)this.power - material.reduction * (float)this.cannon.getBarrelLength(), material.minDisp);
        return 0.0172275 * inaccuracy * this.distanceTravelled;
    }

    public HitResult simulate() {
        Vec3 cPos = this.cannon.getCannonPos().m_252807_();
        float yaw = this.cannon.getYaw();
        Vector3f tipPos = Utils.vecToVel(-((float)this.pitch), yaw, (float)this.cannon.getBarrelLength() + 0.5f);
        tipPos.add((float)cPos.f_82479_, (float)cPos.f_82480_, (float)cPos.f_82481_);
        DetectingProjectile d = new DetectingProjectile.Detect(this.cannon.getLevel(), new Vec3(tipPos)).grav(this.cannon.getGravity()).drag(this.cannon.getDrag()).allowHitEntity(false).range(1000000).simulate(-((float)this.pitch), yaw, this.power);
        this.result = d.getResults();
        this.angle_of_attack = d.getAngle_of_attack();
        this.distanceTravelled = d.getDistTravelled();
        return this.result;
    }

    public float getAngleOfAttack() {
        return this.angle_of_attack;
    }

    public double getDistanceTravelled() {
        return this.distanceTravelled;
    }

    public double getPrecision() {
        if (this.result != null) {
            BlockPos cPos = this.cannon.getTarget();
            return Utils.distFrom(this.result.m_82450_(), new Vec3((double)cPos.m_123341_(), (double)cPos.m_123342_(), (double)cPos.m_123343_()));
        }
        return Double.MAX_VALUE;
    }

    public String toString() {
        return "Pitch = " + this.getPitch() + ", precision = " + this.getPrecision() + ", Charges = " + this.getCharges() + ", traveltime = " + this.getAirtime() / 20.0 + ", dispersion = " + this.getDispersion();
    }

    private double[] getAirTimes() {
        double airTime0;
        BlockPos target = this.cannon.getTarget();
        double yCoordinate = this.pos[1];
        double yVelocity = this.vel[1];
        double airTime1 = 9.99999999E8;
        if (yCoordinate <= (double)target.m_123342_()) {
            for (airTime0 = 0.0; airTime0 < 100000.0; airTime0 += 1.0) {
                yCoordinate += yVelocity;
                yVelocity = (double)this.cannon.getDrag() * yVelocity - (double)this.cannon.getGravity();
                if (!(yCoordinate > (double)target.m_123342_())) continue;
                airTime1 = airTime0 - 1.0;
                break;
            }
        }
        while (airTime0 < 100000.0) {
            yCoordinate += yVelocity;
            yVelocity = (double)this.cannon.getDrag() * yVelocity - (double)this.cannon.getGravity();
            airTime0 += 1.0;
            if (!(yCoordinate <= (double)target.m_123342_())) continue;
            return new double[]{airTime0, airTime1};
        }
        throw new RuntimeException("Out of range");
    }
}

