/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.steamEngine;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.AllParticleTypes;
import com.simibubi.create.content.kinetics.steamEngine.SteamJetParticle;
import com.simibubi.create.foundation.particle.ICustomParticleDataWithSprite;
import java.util.Locale;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SteamJetParticleData
implements ParticleOptions,
ICustomParticleDataWithSprite<SteamJetParticleData> {
    public static final Codec<SteamJetParticleData> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.FLOAT.fieldOf("speed").forGetter(p -> Float.valueOf(p.speed))).apply((Applicative)i, SteamJetParticleData::new));
    public static final ParticleOptions.Deserializer<SteamJetParticleData> DESERIALIZER = new ParticleOptions.Deserializer<SteamJetParticleData>(){

        public SteamJetParticleData fromCommand(ParticleType<SteamJetParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float speed = reader.readFloat();
            return new SteamJetParticleData(speed);
        }

        public SteamJetParticleData fromNetwork(ParticleType<SteamJetParticleData> particleTypeIn, FriendlyByteBuf buffer) {
            return new SteamJetParticleData(buffer.readFloat());
        }
    };
    float speed;

    public SteamJetParticleData(float speed) {
        this.speed = speed;
    }

    public SteamJetParticleData() {
        this(0.0f);
    }

    public ParticleType<?> m_6012_() {
        return AllParticleTypes.STEAM_JET.get();
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.speed);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %f", AllParticleTypes.STEAM_JET.parameter(), Float.valueOf(this.speed));
    }

    @Override
    public ParticleOptions.Deserializer<SteamJetParticleData> getDeserializer() {
        return DESERIALIZER;
    }

    @Override
    public Codec<SteamJetParticleData> getCodec(ParticleType<SteamJetParticleData> type) {
        return CODEC;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ParticleEngine.SpriteParticleRegistration<SteamJetParticleData> getMetaFactory() {
        return SteamJetParticle.Factory::new;
    }
}

