/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.link;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.redstone.link.LinkBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.RaycastHelper;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class LinkHandler {
    @SubscribeEvent
    public static void onBlockActivated(PlayerInteractEvent.RightClickBlock event) {
        Level world = event.getLevel();
        BlockPos pos = event.getPos();
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        if (player.m_6144_() || player.m_5833_()) {
            return;
        }
        LinkBehaviour behaviour = BlockEntityBehaviour.get((BlockGetter)world, pos, LinkBehaviour.TYPE);
        if (behaviour == null) {
            return;
        }
        ItemStack heldItem = player.m_21120_(hand);
        BlockHitResult ray = RaycastHelper.rayTraceRange(world, player, 10.0);
        if (ray == null) {
            return;
        }
        if (AllItems.LINKED_CONTROLLER.isIn(heldItem)) {
            return;
        }
        if (AllItems.WRENCH.isIn(heldItem)) {
            return;
        }
        boolean fakePlayer = player instanceof FakePlayer;
        boolean fakePlayerChoice = false;
        if (fakePlayer) {
            BlockState blockState = world.m_8055_(pos);
            Vec3 localHit = ray.m_82450_().m_82546_(Vec3.m_82528_((Vec3i)pos)).m_82549_(Vec3.m_82528_((Vec3i)ray.m_82434_().m_122436_()).m_82490_(0.25));
            fakePlayerChoice = localHit.m_82557_(behaviour.firstSlot.getLocalOffset((LevelAccessor)world, pos, blockState)) > localHit.m_82557_(behaviour.secondSlot.getLocalOffset((LevelAccessor)world, pos, blockState));
        }
        for (boolean first : Arrays.asList(false, true)) {
            if (!behaviour.testHit(first, ray.m_82450_()) && (!fakePlayer || fakePlayerChoice != first)) continue;
            if (event.getSide() != LogicalSide.CLIENT) {
                behaviour.setFrequency(first, heldItem);
            }
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
            world.m_5594_(null, pos, SoundEvents.f_12013_, SoundSource.BLOCKS, 0.25f, 0.1f);
        }
    }
}

