/*
 * Decompiled with CFR 0.152.
 */
package net.toopa.createsecurity.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.toopa.createsecurity.CreateSecurityMod;
import net.toopa.createsecurity.procedures.ChangeCardTierProcedure;
import net.toopa.createsecurity.procedures.ClickValidateButtonProcedure;
import net.toopa.createsecurity.procedures.ToggleCardLockProcedure;
import net.toopa.createsecurity.procedures.UpCardTierProcedure;
import net.toopa.createsecurity.world.inventory.InscriberGUIMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class InscriberGUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public InscriberGUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public InscriberGUIButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(InscriberGUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(InscriberGUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            InscriberGUIButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = InscriberGUIMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            ClickValidateButtonProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            ToggleCardLockProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 2) {
            ChangeCardTierProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 3) {
            UpCardTierProcedure.execute((LevelAccessor)world, x, y, z);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CreateSecurityMod.addNetworkMessage(InscriberGUIButtonMessage.class, InscriberGUIButtonMessage::buffer, InscriberGUIButtonMessage::new, InscriberGUIButtonMessage::handler);
    }
}

