/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.connector.base;

import com.mrh0.createaddition.blocks.connector.base.AbstractConnectorBlockEntity;
import com.mrh0.createaddition.blocks.connector.base.ConnectorMode;
import com.mrh0.createaddition.blocks.connector.base.ConnectorVariant;
import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.energy.IWireNode;
import com.mrh0.createaddition.energy.NodeRotation;
import com.simibubi.create.api.contraption.transformable.TransformableBlock;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractConnectorBlock<BE extends AbstractConnectorBlockEntity>
extends Block
implements IBE<BE>,
IWrenchable,
TransformableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final EnumProperty<ConnectorMode> MODE = EnumProperty.m_61587_((String)"mode", ConnectorMode.class);
    public static final EnumProperty<ConnectorVariant> VARIANT = EnumProperty.m_61587_((String)"variant", ConnectorVariant.class);
    private static final VoxelShape boxwe = Block.m_49796_((double)0.0, (double)7.0, (double)7.0, (double)10.0, (double)9.0, (double)9.0);
    private static final VoxelShape boxsn = Block.m_49796_((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)10.0);

    public AbstractConnectorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(MODE, (Comparable)((Object)ConnectorMode.None))).m_61124_(NodeRotation.ROTATION, (Comparable)((Object)NodeRotation.NONE))).m_61124_(VARIANT, (Comparable)((Object)ConnectorVariant.Default)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, MODE, NodeRotation.ROTATION, VARIANT});
    }

    public BlockState m_5573_(BlockPlaceContext c) {
        Direction dir = c.m_43719_().m_122424_();
        ConnectorMode mode = ConnectorMode.test(c.m_43725_(), c.m_8083_().m_121945_(dir), c.m_43719_());
        ConnectorVariant variant = ConnectorVariant.test(c.m_43725_(), c.m_8083_().m_121945_(dir), c.m_43719_());
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)dir)).m_61124_(MODE, (Comparable)((Object)mode))).m_61124_(VARIANT, (Comparable)((Object)variant));
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        super.m_5707_(worldIn, pos, state, player);
        if (worldIn.m_5776_()) {
            return;
        }
        BlockEntity te = worldIn.m_7702_(pos);
        if (te == null) {
            return;
        }
        if (!(te instanceof IWireNode)) {
            return;
        }
        IWireNode cte = (IWireNode)te;
        cte.dropWires(worldIn, !player.m_7500_());
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext c) {
        if (c.m_43725_().m_5776_()) {
            c.m_43725_().m_7785_((double)c.m_8083_().m_123341_(), (double)c.m_8083_().m_123342_(), (double)c.m_8083_().m_123343_(), SoundEvents.f_11710_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
        c.m_43725_().m_46597_(c.m_8083_(), (BlockState)state.m_61124_(MODE, (Comparable)((Object)((ConnectorMode)((Object)state.m_61143_(MODE))).getNext())));
        return InteractionResult.SUCCESS;
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext c) {
        BlockEntity be = c.m_43725_().m_7702_(c.m_8083_());
        if (be == null) {
            return super.onSneakWrenched(state, c);
        }
        if (!(be instanceof IWireNode)) {
            return super.onSneakWrenched(state, c);
        }
        IWireNode cbe = (IWireNode)be;
        if (!c.m_43725_().m_5776_() && c.m_43723_() != null) {
            cbe.dropWires(c.m_43725_(), c.m_43723_(), !c.m_43723_().m_7500_());
        }
        return super.onSneakWrenched(state, c);
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity;
        BlockEntity blockEntity2 = blockEntity = state.m_155947_() ? worldIn.m_7702_(pos) : null;
        if (blockEntity != null && blockEntity instanceof AbstractConnectorBlockEntity) {
            ((AbstractConnectorBlockEntity)blockEntity).updateExternalEnergyStorage();
        }
        if (!state.m_60710_((LevelReader)worldIn, pos)) {
            AbstractConnectorBlock.m_49892_((BlockState)state, (LevelAccessor)worldIn, (BlockPos)pos, (BlockEntity)blockEntity);
            if (blockEntity instanceof IWireNode) {
                ((IWireNode)blockEntity).dropWires(worldIn, true);
            }
            worldIn.m_7471_(pos, false);
            for (Direction direction : Direction.values()) {
                worldIn.m_46672_(pos.m_121945_(direction), (Block)this);
            }
        }
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        return !Shapes.m_83157_((VoxelShape)world.m_8055_(pos.m_121945_(dir)).m_60816_((BlockGetter)world, pos.m_121945_(dir)).m_83263_(dir.m_122424_()), (VoxelShape)boxwe, (BooleanOp)BooleanOp.f_82683_) || !Shapes.m_83157_((VoxelShape)world.m_8055_(pos.m_121945_(dir)).m_60816_((BlockGetter)world, pos.m_121945_(dir)).m_83263_(dir.m_122424_()), (VoxelShape)boxsn, (BooleanOp)BooleanOp.f_82683_) || world.m_8055_(pos.m_121945_(dir)).m_60659_((BlockGetter)world, pos, dir.m_122424_(), SupportType.CENTER) || (Boolean)Config.CONNECTOR_IGNORE_FACE_CHECK.get() != false;
    }

    public BlockState m_6843_(BlockState state, Rotation direction) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)direction.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation direction) {
        return this.m_6843_(state, direction);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)mirror.m_54848_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState transform(BlockState state, StructureTransform transform) {
        NodeRotation rotation = NodeRotation.get(transform.rotationAxis, transform.rotation);
        if (transform.mirror != null) {
            state = this.m_6943_(state, transform.mirror);
        }
        state = (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.rotate((Direction)state.m_61143_((Property)FACING), false));
        return (BlockState)state.m_61124_(NodeRotation.ROTATION, (Comparable)((Object)rotation));
    }
}

