/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.block.FrameTrap;

import com.adonis.createfisheryindustry.config.CreateFisheryCommonConfig;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class FrameTrapContext {
    protected final ItemStack fishingRod;
    protected final FishingHook fishingHook;
    protected final RandomSource randomSource;
    protected final Set<BlockPos> visitedBlocks = new HashSet<BlockPos>();
    protected final int baseMinCatchTime = 800;
    protected final int baseMaxCatchTime = 1400;
    public int timeUntilCatch;

    public FrameTrapContext(ServerLevel level, ItemStack fishingRod) {
        this.fishingRod = fishingRod;
        this.fishingHook = new FishingHook(EntityType.f_20533_, (Level)level);
        this.randomSource = RandomSource.m_216327_();
        this.reset(level);
    }

    public void reset(ServerLevel level) {
        this.visitedBlocks.clear();
        double cooldownMultiplier = CreateFisheryCommonConfig.getFishingCooldownMultiplier();
        int adjustedMinTime = (int)(800.0 * cooldownMultiplier);
        int adjustedMaxTime = (int)(1400.0 * cooldownMultiplier);
        this.timeUntilCatch = Mth.m_216271_((RandomSource)this.randomSource, (int)adjustedMinTime, (int)adjustedMaxTime);
    }

    public boolean visitNewPosition(ServerLevel level, BlockPos pos) {
        boolean inWater = this.isWaterBlock(level, pos);
        if (!inWater) {
            return false;
        }
        this.visitedBlocks.add(pos);
        return true;
    }

    private boolean isWaterBlock(ServerLevel level, BlockPos pos) {
        FluidState fluidState = level.m_6425_(pos);
        return fluidState.m_205070_(FluidTags.f_13131_) && fluidState.m_76170_();
    }

    private boolean calculateOpenWater(ServerLevel level, BlockPos pos) {
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                for (int y = -1; y <= 2; ++y) {
                    BlockPos checkPos = pos.m_7918_(x, y, z);
                    if (!(y == -1 ? !this.isWaterBlock(level, checkPos) : !this.isWaterBlock(level, checkPos) && !level.m_8055_(checkPos).m_60795_())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public LootTable getLootTable(ServerLevel level) {
        return level.m_7654_().m_278653_().m_278676_(BuiltInLootTables.f_78720_);
    }

    public LootParams buildLootContext(MovementContext context, ServerLevel level, BlockPos pos) {
        this.fishingHook.m_6034_(context.position.f_82479_, context.position.f_82480_, context.position.f_82481_);
        boolean openWater = this.calculateOpenWater(level, pos);
        return new LootParams.Builder(level).m_287286_(LootContextParams.f_81460_, (Object)context.position).m_287286_(LootContextParams.f_81463_, (Object)this.fishingRod).m_287286_(LootContextParams.f_81455_, (Object)this.fishingHook).m_287239_((float)EnchantmentHelper.m_44904_((ItemStack)this.fishingRod)).m_287235_(LootContextParamSets.f_81414_);
    }

    public boolean canCatch() {
        double successRate = CreateFisheryCommonConfig.getFishingSuccessRate();
        return (double)this.randomSource.m_188501_() < successRate;
    }

    public void invalidate(ServerLevel level) {
        this.reset(level);
        this.fishingHook.m_146870_();
    }

    public FishingHook getFishingHook() {
        return this.fishingHook;
    }

    public ItemStack getFishingRod() {
        return this.fishingRod;
    }

    public RandomSource getRandomSource() {
        return this.randomSource;
    }
}

