/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block.blockentity;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import de.mrjulsen.crn.block.NavigatorLecternBlock;
import de.mrjulsen.crn.registry.ModItems;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class NavigatorLecternBlockEntity
extends SmartBlockEntity {
    private static final String NBT_NAVIGATOR = "Navigator";
    private CompoundTag navigatorNbt = new CompoundTag();

    public NavigatorLecternBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        if (this.navigatorNbt != null) {
            compound.m_128365_(NBT_NAVIGATOR, (Tag)this.navigatorNbt);
        }
    }

    public void writeSafe(CompoundTag compound) {
        super.writeSafe(compound);
        if (this.navigatorNbt != null) {
            compound.m_128365_(NBT_NAVIGATOR, (Tag)this.navigatorNbt);
        }
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.navigatorNbt = compound.m_128441_(NBT_NAVIGATOR) ? compound.m_128469_(NBT_NAVIGATOR) : new CompoundTag();
    }

    public void setNavigator(ItemStack newNavigator) {
        if (newNavigator != null) {
            this.navigatorNbt = newNavigator.m_41784_();
            this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_12013_, SoundSource.BLOCKS, 0.8f, 1.0f);
        }
    }

    public void swapControllers(ItemStack stack, Player player, InteractionHand hand, BlockState state) {
        ItemStack newController = stack.m_41777_();
        stack.m_41764_(0);
        if (player.m_21120_(hand).m_41619_()) {
            player.m_21008_(hand, this.createNavigator());
        } else {
            this.dropController(state);
        }
        this.setNavigator(newController);
    }

    public void dropController(BlockState state) {
        Direction dir = (Direction)state.m_61143_((Property)NavigatorLecternBlock.f_54465_);
        double x = (double)this.f_58858_.m_123341_() + 0.5 + 0.25 * (double)dir.m_122429_();
        double y = this.f_58858_.m_123342_() + 1;
        double z = (double)this.f_58858_.m_123343_() + 0.5 + 0.25 * (double)dir.m_122431_();
        ItemEntity itementity = new ItemEntity(this.f_58857_, x, y, z, this.createNavigator());
        itementity.m_32060_();
        this.f_58857_.m_7967_((Entity)itementity);
        this.navigatorNbt = new CompoundTag();
        this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_12016_, SoundSource.BLOCKS, 0.8f, 1.0f);
    }

    public static boolean playerInRange(Player player, Level world, BlockPos pos) {
        double reach = 5.0;
        return player.m_20238_(Vec3.m_82512_((Vec3i)pos)) < reach * reach;
    }

    private ItemStack createNavigator() {
        ItemStack stack = ModItems.NAVIGATOR.asStack();
        stack.m_41751_(this.navigatorNbt == null ? new CompoundTag() : this.navigatorNbt);
        return stack;
    }
}

