/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block.display;

import com.simibubi.create.api.behaviour.display.DisplayTarget;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.source.PercentOrProgressBarDisplaySource;
import com.simibubi.create.content.redstone.displayLink.source.SingleLineDisplaySource;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTargetStats;
import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.block.IBlockGetter;
import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.block.display.AdvancedDisplaySource;
import de.mrjulsen.crn.block.display.properties.SimpleStaticTextDisplaySettings;
import de.mrjulsen.crn.block.display.properties.StaticTextDisplaySettings;
import de.mrjulsen.crn.block.properties.EDisplayType;
import de.mrjulsen.crn.client.AdvancedDisplaysRegistry;
import de.mrjulsen.crn.config.ModCommonConfig;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.data.train.TrainStop;
import de.mrjulsen.crn.data.train.TrainUtils;
import de.mrjulsen.crn.data.train.portable.StationDisplayData;
import de.mrjulsen.crn.event.ModCommonEvents;
import de.mrjulsen.crn.registry.ModDisplayTypes;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;

public class AdvancedDisplayTarget
extends DisplayTarget {
    private static boolean running = false;
    private static boolean threadRunning = false;
    private static final Queue<Runnable> workerTasks = new ConcurrentLinkedQueue<Runnable>();

    public static void start() {
        if (running) {
            AdvancedDisplayTarget.stop();
        }
        while (running && threadRunning) {
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        workerTasks.clear();
        running = true;
        new Thread(() -> {
            threadRunning = true;
            CreateRailwaysNavigator.LOGGER.info("Advanced Display Data Manager has been started.");
            while (running) {
                while (!workerTasks.isEmpty()) {
                    try {
                        workerTasks.poll().run();
                    }
                    catch (Exception e) {
                        CreateRailwaysNavigator.LOGGER.info("Error while process Advanced Display Data. " + e.getMessage(), (Throwable)e);
                    }
                }
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            workerTasks.clear();
            CreateRailwaysNavigator.LOGGER.info("Advanced Display Data Manager has been stopped.");
            threadRunning = false;
        }, "Advanced Display Data Manager").start();
    }

    public static void stop() {
        CreateRailwaysNavigator.LOGGER.info("Stopping Advanced Display Data Manager...");
        running = false;
    }

    private static void queueAdvancedDisplayWorkerTask(Runnable task) {
        workerTasks.add(task);
    }

    public void acceptText(int line, List<MutableComponent> text, DisplayLinkContext context) {
        CompoundTag nbt = context.sourceConfig();
        BlockEntity blockEntity = context.getTargetBlockEntity();
        if (blockEntity instanceof AdvancedDisplayBlockEntity) {
            AdvancedDisplayBlockEntity blockEntity2 = (AdvancedDisplayBlockEntity)blockEntity;
            if (ModCommonEvents.hasServer()) {
                AdvancedDisplayBlockEntity controller = blockEntity2.getController(new IBlockGetter.WorldBlockGetter(blockEntity2.m_58904_()));
                if (controller == null) {
                    return;
                }
                long dayTime = context.getTargetBlockEntity().m_58904_().m_46468_();
                boolean advancedDisplaySource = context.blockEntity().activeSource instanceof AdvancedDisplaySource;
                AdvancedDisplayTarget.queueAdvancedDisplayWorkerTask(() -> {
                    if (advancedDisplaySource) {
                        String filter = context.sourceConfig().m_128461_("Filter");
                        if (controller.getDisplayType().category().getSource() != EDisplayType.EDisplayTypeDataSource.PLATFORM) {
                            if (!((Boolean)ModCommonConfig.AUTO_UPDATE_DISPLAY_TYPE.get()).booleanValue()) {
                                return;
                            }
                            if (controller.getDisplayType().category() != EDisplayType.PLATFORM) {
                                AdvancedDisplaysRegistry.DisplayTypeResourceKey displayType = filter.contains("*") ? ModDisplayTypes.DEPARTURE_BOARD_TABLE : (controller.getDisplayProperties().singleLined() ? ModDisplayTypes.PLATFORM_RUNNING_TEXT : ModDisplayTypes.PLATFORM_TABLE);
                                ModCommonEvents.getCurrentServer().ifPresent(server -> server.m_201446_(() -> controller.applyToAll(x -> {
                                    x.setDisplayType(displayType, null);
                                    x.notifyUpdate();
                                })));
                            }
                        }
                        List<StationDisplayData> preds = AdvancedDisplayTarget.prepare(filter, controller.getDisplayProperties().platformDisplayTrainsCount().apply(controller));
                        controller.setData(preds, filter, GlobalSettings.getInstance().getOrCreateStationTagFor(filter).getInfoForStation(filter), dayTime);
                        ModCommonEvents.getCurrentServer().ifPresent(x -> x.m_201446_(() -> ((AdvancedDisplayBlockEntity)controller).notifyUpdate()));
                    } else if (controller.getDisplayType().equals(ModDisplayTypes.SIMPLE_TEXT)) {
                        SimpleStaticTextDisplaySettings settings = controller.getSettingsAs(SimpleStaticTextDisplaySettings.class).orElse(new SimpleStaticTextDisplaySettings());
                        settings.setStaticText(Component.Serializer.m_130703_((Component)((Component)text.get(0))));
                        CreateRailwaysNavigator.LOGGER.debug(settings.getStaticText());
                        ModCommonEvents.getCurrentServer().ifPresent(x -> x.m_201446_(() -> controller.applyToAll(a -> {
                            a.setDisplayType(ModDisplayTypes.SIMPLE_TEXT, settings);
                            a.notifyUpdate();
                        }, new IBlockGetter.WorldBlockGetter(blockEntity2.m_58904_()))));
                    } else {
                        if (!controller.getDisplayType().equals(ModDisplayTypes.RICH_TEXT) && !((Boolean)ModCommonConfig.AUTO_UPDATE_DISPLAY_TYPE.get()).booleanValue()) {
                            return;
                        }
                        StaticTextDisplaySettings settings = controller.getSettingsAs(StaticTextDisplaySettings.class).orElse(new StaticTextDisplaySettings());
                        for (int i = 0; i < controller.getYSize() * 3 - line - 1; ++i) {
                            int componentIndex = i + line;
                            if (i == 0) {
                                AdvancedDisplayTarget.reserve((int)componentIndex, (BlockEntity)controller, (DisplayLinkContext)context);
                            }
                            if (i > 0 && this.isReserved(componentIndex, (BlockEntity)controller, context)) break;
                            while (componentIndex >= settings.getComponentsCount()) {
                                settings.addComponent(new StaticTextDisplaySettings.TextComponent("{\"text\":\"\"}"));
                            }
                            StaticTextDisplaySettings.TextComponent component = settings.getComponents().get(componentIndex);
                            if (i >= text.size()) {
                                if (context.blockEntity().activeSource instanceof SingleLineDisplaySource) break;
                                component.setStaticText("{\"text\":\"\"}");
                            } else {
                                component.setStaticText(Component.Serializer.m_130703_((Component)((Component)text.get(i))));
                            }
                            component.setTextAlignment(ETextAlignment.LEFT);
                            component.setXScale(0.4f);
                            component.setMinXScale(0.4f);
                            component.setYScale(0.4f);
                            component.setY((float)componentIndex * 5.5f);
                            settings.setComponent(componentIndex, component);
                        }
                        ModCommonEvents.getCurrentServer().ifPresent(x -> x.m_201446_(() -> controller.applyToAll(a -> {
                            a.setDisplayType(ModDisplayTypes.RICH_TEXT, settings);
                            a.notifyUpdate();
                        })));
                    }
                });
            }
        }
    }

    public static List<StationDisplayData> prepare(String filter, int maxLines) {
        ArrayList<StationDisplayData> result = new ArrayList<StationDisplayData>(maxLines);
        int i = 0;
        for (TrainStop stop : TrainUtils.getDeparturesAtStationName(filter, null, false)) {
            result.add(StationDisplayData.of(stop));
            if (++i < maxLines) continue;
            break;
        }
        return result;
    }

    public boolean isReserved(int line, BlockEntity target, DisplayLinkContext context) {
        if (target instanceof AdvancedDisplayBlockEntity) {
            AdvancedDisplayBlockEntity controller = (AdvancedDisplayBlockEntity)target;
            if (controller.getDisplayType().equals(ModDisplayTypes.SIMPLE_TEXT) || controller.getDisplayType().equals(ModDisplayTypes.RICH_TEXT)) {
                return super.isReserved(line, target, context);
            }
            return true;
        }
        return super.isReserved(line, target, context);
    }

    public DisplayTargetStats provideStats(DisplayLinkContext context) {
        AdvancedDisplayBlockEntity controller = this.getController(context);
        if (controller == null) {
            return new DisplayTargetStats(1, 1024, (DisplayTarget)this);
        }
        float textScale = 0.4f;
        int maxRows = 50;
        int maxColumns = 1024;
        if (controller.getDisplayType().equals(ModDisplayTypes.SIMPLE_TEXT)) {
            textScale = 0.75f;
            maxRows = 1;
        } else if (controller.getDisplayType().equals(ModDisplayTypes.RICH_TEXT)) {
            maxColumns = controller.getYSize() * 3 - 1;
        }
        if (context.blockEntity().activeSource instanceof PercentOrProgressBarDisplaySource) {
            maxColumns = (int)((float)(controller.getXSizeScaled() * 16 - 3) / 9.0f / textScale);
        }
        if (context.blockEntity().activeSource instanceof AdvancedDisplaySource) {
            maxRows = 1;
        }
        maxRows = Math.min(maxRows, 50);
        return new DisplayTargetStats(maxRows, maxColumns, (DisplayTarget)this);
    }

    public Component getLineOptionText(int line) {
        return TextUtils.translate((String)"createrailwaysnavigator.display_target.advanced_display.component", (Object[])new Object[]{line + 1});
    }

    private AdvancedDisplayBlockEntity getController(DisplayLinkContext context) {
        BlockEntity teIn = context.getTargetBlockEntity();
        if (!(teIn instanceof AdvancedDisplayBlockEntity)) {
            return null;
        }
        AdvancedDisplayBlockEntity be = (AdvancedDisplayBlockEntity)teIn;
        return be.getController(new IBlockGetter.WorldBlockGetter(be.m_58904_()));
    }

    public AABB getMultiblockBounds(LevelAccessor level, BlockPos pos) {
        AABB baseShape = super.getMultiblockBounds(level, pos);
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof AdvancedDisplayBlockEntity)) {
            return baseShape;
        }
        AdvancedDisplayBlockEntity fdbe = (AdvancedDisplayBlockEntity)be;
        AdvancedDisplayBlockEntity controller = fdbe.getController(new IBlockGetter.WorldBlockGetter(fdbe.m_58904_()));
        if (controller == null) {
            return baseShape;
        }
        Vec3i normal = controller.getDirection().m_122427_().m_122436_();
        return baseShape.m_82338_(controller.m_58899_().m_121996_((Vec3i)pos)).m_82363_((double)(normal.m_123341_() * (controller.getXSize() - 1)), (double)(1 - controller.getYSize()), (double)(normal.m_123343_() * (controller.getXSize() - 1)));
    }
}

