/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.trains.schedule.ScheduleScreen;
import com.simibubi.create.content.trains.schedule.condition.TimedWaitCondition;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.CreateLang;
import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.api.client.Screens;
import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.client.gui.NavigatorToast;
import de.mrjulsen.crn.client.gui.widgets.vanilla.ResizableButton;
import de.mrjulsen.crn.client.gui.windows.AdvancedDisplaySettingsWindow;
import de.mrjulsen.crn.client.gui.windows.PrioritizedDestinationInstructionSettingsWindow;
import de.mrjulsen.crn.client.gui.windows.TrainSectionSettingsWindow;
import de.mrjulsen.crn.client.gui.windows.TrainSeparationSettingsWindow;
import de.mrjulsen.crn.client.lang.CustomLanguage;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.schedule.condition.DynamicDelayCondition;
import de.mrjulsen.crn.data.schedule.condition.TrainSeparationCondition;
import de.mrjulsen.crn.data.schedule.instruction.PrioritizedDestinationInstruction;
import de.mrjulsen.crn.data.schedule.instruction.ResetTimingsInstruction;
import de.mrjulsen.crn.data.schedule.instruction.TravelSectionInstruction;
import de.mrjulsen.crn.mixin.ModularGuiLineBuilderAccessor;
import de.mrjulsen.crn.mixin.ScheduleScreenAccessor;
import de.mrjulsen.crn.network.packets.stc.ServerErrorPacketData;
import de.mrjulsen.crn.util.ETimeFormat;
import de.mrjulsen.crn.util.Owner;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindow;
import de.mrjulsen.mcdragonlib.client.util.DLGraphics;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.RenderUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.network.NetworkPacketContext;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.time.ConfiguredTimeSystem;
import de.mrjulsen.mcdragonlib.util.time.DLTime;
import de.mrjulsen.mcdragonlib.util.time.ITimeSystem;
import de.mrjulsen.mcdragonlib.util.time.TimeContext;
import java.util.List;
import java.util.Objects;
import net.createmod.catnip.data.Pair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.ClientLanguage;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;

public class ClientWrapper {
    public static final ModelResourceLocation NAVIGATOR_WORLD_MODEL = new ModelResourceLocation("createrailwaysnavigator", "navigator_world", "inventory");
    private static CustomLanguage currentLanguage;
    private static Language currentClientLanguage;

    public static void showNavigatorGui() {
        Screens.showNavigatorScreen(null, false);
    }

    public static Level getClientLevel() {
        return Minecraft.m_91087_().f_91073_;
    }

    public static void handleErrorMessagePacket(ServerErrorPacketData packet, NetworkPacketContext ctx) {
        Minecraft.m_91087_().m_91300_().m_94922_((Toast)new SystemToast(SystemToast.SystemToastIds.PERIODIC_NOTIFICATION, Constants.TEXT_SERVER_ERROR, (Component)TextUtils.text((String)packet.message)));
    }

    public static void showAdvancedDisplaySettingsScreen(AdvancedDisplayBlockEntity blockEntity, AbstractContraptionEntity contraption) {
        DLWindow.openWindow(mgr -> new AdvancedDisplaySettingsWindow(mgr, blockEntity, contraption));
    }

    public static void updateLanguage(CustomLanguage lang, boolean force) {
        LanguageInfo info;
        if (currentLanguage == lang && !force) {
            return;
        }
        LanguageInfo languageInfo = info = lang == CustomLanguage.DEFAULT ? null : Minecraft.m_91087_().m_91102_().m_118976_(lang.getCode());
        if (info == null) {
            info = Minecraft.m_91087_().m_91102_().m_118976_(Minecraft.m_91087_().m_91102_().m_264236_());
        }
        currentLanguage = lang;
        if (lang == CustomLanguage.DEFAULT || info == null) {
            currentClientLanguage = Language.m_128107_();
            CreateRailwaysNavigator.LOGGER.info("Updated custom language to: (Default)");
        } else {
            currentClientLanguage = ClientLanguage.m_264420_((ResourceManager)Minecraft.m_91087_().m_91098_(), List.of(lang == CustomLanguage.DEFAULT ? Minecraft.m_91087_().m_91102_().m_264236_() : lang.getCode()), (boolean)false);
            CreateRailwaysNavigator.LOGGER.info("Updated custom language to: " + (info == null ? null : info.f_118945_()));
        }
    }

    public static Language getCurrentClientLanguage() {
        return currentClientLanguage == null ? Language.m_128107_() : currentClientLanguage;
    }

    public static void sendCRNNotification(Component title, Component description) {
        if (((Boolean)ModClientConfig.ROUTE_NOTIFICATIONS.get()).booleanValue()) {
            Minecraft.m_91087_().m_91300_().m_94922_((Toast)NavigatorToast.multiline(title, description));
        }
    }

    public static int renderMultilineLabelSafe(DLGuiGraphics graphics, int x, int y, Font font, Component text, int maxWidth, DLColor color) {
        MultiLineLabel label = MultiLineLabel.m_94341_((Font)font, (FormattedText)text, (int)maxWidth);
        GuiGraphics guiGraphics = graphics.graphics();
        Objects.requireNonNull(font);
        label.m_6516_(guiGraphics, x, y, 9, color.getAsARGB());
        Objects.requireNonNull(font);
        return 9 * label.m_5770_();
    }

    public static int getTextBlockHeight(Font font, Component text, int maxWidth) {
        int lines = font.m_92923_((FormattedText)text, maxWidth).size();
        Objects.requireNonNull(font);
        return lines * 9;
    }

    public static void showTrainDebugScreen() {
        RenderSystem.recordRenderCall(() -> {});
    }

    public static void initPrioritizedDestinationInstruction(PrioritizedDestinationInstruction instruction, ModularGuiLineBuilder builder) {
        ModularGuiLineBuilderAccessor accessor = (ModularGuiLineBuilderAccessor)builder;
        ResizableButton btn = new ResizableButton(accessor.crn$getX(), accessor.crn$getY() - 4, 121, 16, (Component)TextUtils.translate((String)"createrailwaysnavigator.schedule.instruction.configure"), b -> {
            Screen patt0$temp = Minecraft.m_91087_().f_91080_;
            if (patt0$temp instanceof ScheduleScreen) {
                ScheduleScreen scheduleScreen = (ScheduleScreen)patt0$temp;
                ((ScheduleScreenAccessor)scheduleScreen).crn$getOnEditorClose().accept(true);
                builder.customArea(0, 0).speechBubble();
                DLWindow.openWindow(mgr -> new PrioritizedDestinationInstructionSettingsWindow(mgr, instruction, instruction.getData()));
            }
        }){};
        accessor.crn$getTarget().add(Pair.of((Object)((Object)btn), (Object)"config_btn"));
    }

    public static void initScheduleSectionInstruction(TravelSectionInstruction instruction, ModularGuiLineBuilder builder) {
        ModularGuiLineBuilderAccessor accessor = (ModularGuiLineBuilderAccessor)builder;
        ResizableButton btn = new ResizableButton(accessor.crn$getX(), accessor.crn$getY() - 4, 121, 16, (Component)TextUtils.translate((String)"createrailwaysnavigator.schedule.instruction.configure"), b -> {
            Screen patt0$temp = Minecraft.m_91087_().f_91080_;
            if (patt0$temp instanceof ScheduleScreen) {
                ScheduleScreen scheduleScreen = (ScheduleScreen)patt0$temp;
                ((ScheduleScreenAccessor)scheduleScreen).crn$getOnEditorClose().accept(true);
                builder.customArea(0, 0).speechBubble();
                DLWindow.openWindow(mgr -> new TrainSectionSettingsWindow(mgr, instruction.getData()));
            }
        });
        accessor.crn$getTarget().add(Pair.of((Object)((Object)btn), (Object)"config_btn"));
    }

    public static void initResetTimingsInstruction(ResetTimingsInstruction instruction, ModularGuiLineBuilder builder) {
    }

    public static void initDynamicDelayCondition(DynamicDelayCondition condition, ModularGuiLineBuilder builder) {
        builder.addScrollInput(0, 26, (i, l) -> {
            i.titled(TextUtils.translate((String)("createrailwaysnavigator.schedule.condition." + condition.getId().m_135815_() + ".min_duration"))).withShiftStep(15).withRange(0, 121);
            i.lockedTooltipX = -15;
            i.lockedTooltipY = 35;
        }, "Min");
        builder.addScrollInput(26, 26, (i, l) -> {
            i.titled(CreateLang.translateDirect((String)"generic.duration", (Object[])new Object[0])).withShiftStep(15).withRange(0, 121);
            i.lockedTooltipX = -15;
            i.lockedTooltipY = 35;
        }, "Value");
        builder.addSelectionScrollInput(52, 58, (i, l) -> i.forOptions(TimedWaitCondition.TimeUnit.translatedOptions()).titled(CreateLang.translateDirect((String)"generic.timeUnit", (Object[])new Object[0])), "TimeUnit");
        ModularGuiLineBuilderAccessor accessor = (ModularGuiLineBuilderAccessor)builder;
    }

    public static void initTimingAdjustmentGui(TrainSeparationCondition condition, ModularGuiLineBuilder builder) {
        ModularGuiLineBuilderAccessor accessor = (ModularGuiLineBuilderAccessor)builder;
        ResizableButton btn = new ResizableButton(accessor.crn$getX(), accessor.crn$getY() - 4, 121, 16, (Component)TextUtils.translate((String)"createrailwaysnavigator.schedule.instruction.configure"), b -> {
            Screen patt0$temp = Minecraft.m_91087_().f_91080_;
            if (patt0$temp instanceof ScheduleScreen) {
                ScheduleScreen scheduleScreen = (ScheduleScreen)patt0$temp;
                ((ScheduleScreenAccessor)scheduleScreen).crn$getOnEditorClose().accept(true);
                builder.customArea(0, 0).speechBubble();
                DLWindow.openWindow(mgr -> new TrainSeparationSettingsWindow(mgr, condition.getData()));
            }
        });
        accessor.crn$getTarget().add(Pair.of((Object)((Object)btn), (Object)"config_btn"));
    }

    public static void renderNavigatorItem(DLGraphics graphics, ItemStack itemStack, ItemDisplayContext context, boolean leftHand, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, BakedModel model) {
        if (context != ItemDisplayContext.FIRST_PERSON_LEFT_HAND && context != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND && context != ItemDisplayContext.FIXED) {
            return;
        }
        int backgroundId = itemStack.m_41784_().m_128451_("BackgroundId");
        DLTime time = DLTime.fromLevelTime((Level)Minecraft.m_91087_().f_91073_, (ITimeSystem)new ConfiguredTimeSystem());
        Font font = Minecraft.m_91087_().f_91062_;
        poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        poseStack.m_252880_(4.0f, 2.0f, -1.26f);
        RenderUtils.renderTexture((ResourceLocation)new ResourceLocation("createrailwaysnavigator", String.format("textures/item/navigator_backgrounds/%s.png", backgroundId)), (DLGraphics)graphics, (Vector3f)new Vector3f(0.0f), (float)8.0f, (float)12.0f, (float)0.0f, (float)0.0f, (float)0.6666667f, (float)1.0f, (Direction)Direction.UP, (DLColor)DLColor.WHITE, (int)0xF000F0, (boolean)false);
        poseStack.m_252880_(0.0f, 0.0f, -0.01f);
        poseStack.m_85836_();
        poseStack.m_252880_(4.0f, 0.8f, 0.0f);
        poseStack.m_85841_(0.075f, 0.075f, 0.075f);
        RenderUtils.drawString((DLGraphics)graphics, (Font)font, (float)0.0f, (float)0.0f, (Component)TextUtils.translate((String)"gui.createrailwaysnavigator.journey_info.date", (Object[])new Object[]{(long)time.toGameDays()}), (DLColor)DLColor.WHITE, (ETextAlignment)ETextAlignment.CENTER, (boolean)false, (int)0xF000F0);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_252880_(4.0f, 2.0f, 0.0f);
        poseStack.m_85841_(0.2f, 0.2f, 0.2f);
        RenderUtils.drawString((DLGraphics)graphics, (Font)font, (float)0.0f, (float)0.0f, (String)time.format(((ETimeFormat)((Object)ModClientConfig.TIME_FORMAT.get())).getFormat(), TimeContext.INGAME), (DLColor)DLColor.WHITE, (ETextAlignment)ETextAlignment.CENTER, (boolean)false, (int)0xF000F0);
        poseStack.m_85849_();
    }

    public static Owner getMe() {
        return new Owner((Player)Minecraft.m_91087_().f_91074_);
    }

    public static Player getClientPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }
}

