/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.ber.variants;

import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.block.display.properties.DepartureBoardDisplayTableSettings;
import de.mrjulsen.crn.block.properties.ETimeDisplay;
import de.mrjulsen.crn.client.ber.AdvancedDisplayRenderInstance;
import de.mrjulsen.crn.client.ber.variants.AbstractAdvancedDisplayRenderer;
import de.mrjulsen.crn.client.lang.CustomLanguage;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.train.TrainStatus;
import de.mrjulsen.crn.data.train.portable.StationDisplayData;
import de.mrjulsen.crn.util.ModUtils;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.ber.BERGraphics;
import de.mrjulsen.mcdragonlib.client.ber.BERLabel;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.PaddingF;
import de.mrjulsen.mcdragonlib.client.util.DLGraphics;
import de.mrjulsen.mcdragonlib.client.util.RenderUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.Pair;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Point;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.mcdragonlib.util.math.Size;
import de.mrjulsen.mcdragonlib.util.properties.NumberProperty;
import de.mrjulsen.mcdragonlib.util.time.ConfiguredTimeSystem;
import de.mrjulsen.mcdragonlib.util.time.DLTime;
import de.mrjulsen.mcdragonlib.util.time.ITimeSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.joml.Vector3f;

public class BERDepartureBoardTable
implements AbstractAdvancedDisplayRenderer<DepartureBoardDisplayTableSettings> {
    private final MutableComponent textTrainTerminates = CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.train_terminates");
    private static final String keyDeparture = "gui.createrailwaysnavigator.departure";
    private static final String keyTrain = "gui.createrailwaysnavigator.line";
    private static final String keyDestination = "gui.createrailwaysnavigator.destination";
    private static final String keyPlatform = "gui.createrailwaysnavigator.platform";
    private static final String keyVia = "gui.createrailwaysnavigator.via";
    private static final String keyTooSmall = "gui.createrailwaysnavigator.too_small";
    private static final int MIN_SIZE = 4;
    private static final float LINE_HEIGHT = 5.4f;
    private static final float Y_OFFSET = 5.4f;
    private static final float SPACING = 2.0f;
    private static final float TIME_LABEL_MAX_WIDTH = 12.0f;
    private static final float REAL_TIME_LABEL_MAX_WIDTH = 12.0f;
    private boolean showInfoLine = false;
    private MutableComponent infoLineText = TextUtils.empty();
    private int maxLines = 0;
    private final BERLabel statusLabel = new BERLabel();
    private final BERLabel tooSmallLabel = new BERLabel();
    private BERLabel[][] lines = new BERLabel[0][];
    private final BERLabel[] headlines;

    public BERDepartureBoardTable() {
        this.statusLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.4f), (Object)Float.valueOf(0.4f)));
        this.statusLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.4f), (Object)Float.valueOf(0.4f)));
        this.statusLabel.horizontalAlign.set((Object)ETextAlignment.CENTER);
        this.statusLabel.color.set((Object)DARK_FONT_COLOR);
        this.statusLabel.backgroundColor.set((Object)DLColor.WHITE);
        this.statusLabel.fullBackground.set((Object)true);
        this.statusLabel.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
        this.statusLabel.horizontalScrollingSpeed.set((Number)Float.valueOf(12.0f));
        this.statusLabel.backgroundPadding.set((Object)new PaddingF(0.5f));
        NumberProperty numberProperty = this.statusLabel.preferredHeight;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        numberProperty.set((Number)Float.valueOf(9.0f * ((Float)this.statusLabel.verticalMaxScale.get()).floatValue()));
        this.tooSmallLabel.text.set((Object)TextUtils.translate((String)keyTooSmall));
        this.tooSmallLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.4f), (Object)Float.valueOf(0.4f)));
        this.tooSmallLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.4f), (Object)Float.valueOf(0.4f)));
        this.tooSmallLabel.position.set((Object)Point.of((double)3.0, (double)3.0));
        this.headlines = new BERLabel[LineComponent.values().length];
        BERLabel bERLabel = new BERLabel();
        this.headlines[LineComponent.TIME.i()] = bERLabel;
        BERLabel timeLabel = bERLabel;
        timeLabel.text.set((Object)CustomLanguage.translate(keyDeparture).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.ITALIC));
        timeLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.2f), (Object)Float.valueOf(0.4f)));
        timeLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.4f), (Object)Float.valueOf(0.4f)));
        timeLabel.preferredWidth.set((Number)Float.valueOf(0.0f));
        timeLabel.position.set((Object)Point.of((double)3.0, (double)3.0));
        BERLabel bERLabel2 = new BERLabel();
        this.headlines[LineComponent.TRAIN_NAME.i()] = bERLabel2;
        BERLabel trainNameLabel = bERLabel2;
        trainNameLabel.text.set((Object)CustomLanguage.translate(keyTrain).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.ITALIC));
        trainNameLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.2f), (Object)Float.valueOf(0.4f)));
        trainNameLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.4f), (Object)Float.valueOf(0.4f)));
        trainNameLabel.preferredWidth.set((Number)Float.valueOf(0.0f));
        trainNameLabel.position.set((Object)Point.of((double)3.0, (double)3.0));
        BERLabel bERLabel3 = new BERLabel();
        this.headlines[LineComponent.PLATFORM.i()] = bERLabel3;
        BERLabel platformLabel = bERLabel3;
        platformLabel.text.set((Object)CustomLanguage.translate(keyPlatform).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.ITALIC));
        platformLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.2f), (Object)Float.valueOf(0.4f)));
        platformLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.4f), (Object)Float.valueOf(0.4f)));
        platformLabel.preferredWidth.set((Number)Float.valueOf(0.0f));
        platformLabel.position.set((Object)Point.of((double)3.0, (double)3.0));
        BERLabel bERLabel4 = new BERLabel();
        this.headlines[LineComponent.DESTINATION.i()] = bERLabel4;
        BERLabel destinationLabel = bERLabel4;
        destinationLabel.text.set((Object)CustomLanguage.translate(keyDestination).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.ITALIC));
        destinationLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.2f), (Object)Float.valueOf(0.4f)));
        destinationLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.4f), (Object)Float.valueOf(0.4f)));
        destinationLabel.preferredWidth.set((Number)Float.valueOf(0.0f));
        destinationLabel.position.set((Object)Point.of((double)3.0, (double)3.0));
        BERLabel bERLabel5 = new BERLabel();
        this.headlines[LineComponent.STOPOVERS.i()] = bERLabel5;
        BERLabel stopoversLabel = bERLabel5;
        stopoversLabel.text.set((Object)CustomLanguage.translate(keyVia).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.ITALIC));
        stopoversLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.2f), (Object)Float.valueOf(0.4f)));
        stopoversLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.4f), (Object)Float.valueOf(0.4f)));
        stopoversLabel.preferredWidth.set((Number)Float.valueOf(0.0f));
        stopoversLabel.position.set((Object)Point.of((double)3.0, (double)3.0));
        BERLabel bERLabel6 = new BERLabel();
        this.headlines[LineComponent.INFO.i()] = bERLabel6;
        BERLabel infoLabel = bERLabel6;
        infoLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.2f), (Object)Float.valueOf(0.4f)));
        infoLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.4f), (Object)Float.valueOf(0.4f)));
        infoLabel.preferredWidth.set((Number)Float.valueOf(0.0f));
        infoLabel.position.set((Object)Point.of((double)3.0, (double)3.0));
        infoLabel.fullBackground.set((Object)true);
        infoLabel.backgroundPadding.set((Object)new PaddingF(0.5f));
    }

    @Override
    public void render(BERGraphics<AdvancedDisplayBlockEntity> graphics, float pPartialTicks, AdvancedDisplayRenderInstance parent, int light, boolean backSide) {
        RenderUtils.fillColor(graphics, (Vector3f)new Vector3f(2.0f, 6.9f, 0.0f), (float)(((AdvancedDisplayBlockEntity)graphics.blockEntity()).getXSizeScaled() * 16 - 4), (float)0.25f, (DLColor)((DepartureBoardDisplayTableSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).getFontColor(), (Direction)((Direction)((AdvancedDisplayBlockEntity)graphics.blockEntity()).m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)));
        if (((AdvancedDisplayBlockEntity)graphics.blockEntity()).getXSizeScaled() < 4) {
            this.tooSmallLabel.render(graphics);
            return;
        }
        for (int k = 0; k < this.headlines.length; ++k) {
            DLUtils.doIfNotNull((Object)this.headlines[k], y -> y.render((DLGraphics)graphics));
        }
        for (int i = 0; i < this.lines.length && i < this.maxLines; ++i) {
            graphics.poseStack().m_85836_();
            if (i % 2 == 1) {
                RenderUtils.fillColor(graphics, (Vector3f)new Vector3f(2.0f, 7.4f + (float)i * 5.4f, 0.0f), (float)(((AdvancedDisplayBlockEntity)graphics.blockEntity()).getXSizeScaled() * 16 - 4), (float)5.4f, (DLColor)((DepartureBoardDisplayTableSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).getFontColor().withAlpha(40), (Direction)((Direction)((AdvancedDisplayBlockEntity)graphics.blockEntity()).m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)), (int)(((AdvancedDisplayBlockEntity)graphics.blockEntity()).isGlowing() ? 0xF000F0 : light), (boolean)false);
                graphics.poseStack().m_252880_(0.0f, 0.0f, 0.05f);
            }
            for (int k = 0; k < this.lines[i].length; ++k) {
                DLUtils.doIfNotNull((Object)this.lines[i][k], x -> x.render((DLGraphics)graphics));
            }
            graphics.poseStack().m_85849_();
        }
        if (this.showInfoLine) {
            this.statusLabel.render(graphics);
        }
    }

    private Optional<Component> getStatusInfo(AdvancedDisplayBlockEntity blockEntity, StationDisplayData data, boolean singleTrain) {
        if (!(data.getTrainData().hasStatusInfo() && data.getStationData().isDepartureDelayed() || data.getStationData().isStationChanged() || data.isNextSectionExcluded())) {
            return Optional.empty();
        }
        ArrayList<Object> content = new ArrayList<Object>();
        if (data.getTrainData().isCancelled()) {
            content.add(CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.cancelled"));
        }
        if (data.isNextSectionExcluded()) {
            content.add(this.textTrainTerminates);
        }
        if (data.getStationData().isDepartureDelayed()) {
            String delay = ((DepartureBoardDisplayTableSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA ? ModUtils.timeRemainingString(data.getStationData().getDepartureTimeDeviation()) : String.valueOf((long)DLTime.fromTicks((double)data.getStationData().getDepartureTimeDeviation(), (ITimeSystem)new ConfiguredTimeSystem()).toGameMinutes());
            MutableComponent delayComponent = CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.delayed", delay);
            if (((DepartureBoardDisplayTableSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ABS) {
                delayComponent.m_130946_(" ").m_7220_((Component)CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.delay_abs_suffix"));
            }
            content.add(delayComponent);
        }
        if (data.getStationData().isStationChanged()) {
            if (!data.getStationData().getScheduledStation().tagId().equals(data.getStationData().getRealTimeStation().tagId())) {
                content.add(CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.platform_and_station_changed", data.getStationData().getRealTimeStation().tagName(), data.getStationData().getRealTimeStation().info().platform()));
            } else {
                content.add(CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.platform_changed", data.getStationData().getRealTimeStation().info().platform()));
            }
        }
        for (TrainStatus.CompiledTrainStatus status : data.getTrainData().getStatus()) {
            content.add(status.text());
        }
        if (singleTrain) {
            return Optional.ofNullable(TextUtils.concat(content));
        }
        return Optional.ofNullable(CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.information_about_train", data.getTrainData().getName()).m_130946_(": ").m_7220_((Component)TextUtils.concat((Component)TextUtils.text((String)" - "), content)));
    }

    @Override
    public void update(Level level, BlockPos pos, BlockState state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent, AdvancedDisplayBlockEntity.EUpdateReason reason) {
        List<StationDisplayData> preds = blockEntity.getStops().stream().filter(x -> !(x.isNextSectionExcluded() && !((DepartureBoardDisplayTableSettings)this.getDisplaySettings(blockEntity)).showArrival() || x.getTrainData().isCancelled() && DragonLib.getCurrentWorldTime() >= x.getStationData().getScheduledDepartureTime() + (long)((Integer)ModClientConfig.DISPLAY_LEAD_TIME.get()).intValue())).toList();
        MutableBoolean shouldShowLine = new MutableBoolean(false);
        this.infoLineText = TextUtils.concat((Component)TextUtils.text((String)"  +++  "), (Component[])((Component[])preds.stream().limit(this.maxLines).filter(x -> x.getTrainData().hasStatusInfo() && x.getStationData().isDepartureDelayed() || x.getStationData().isStationChanged()).flatMap(x -> {
            shouldShowLine.setTrue();
            return this.getStatusInfo(blockEntity, (StationDisplayData)x, false).stream();
        }).toArray(Component[]::new)));
        this.showInfoLine = shouldShowLine.isTrue();
        if (!this.showInfoLine) {
            this.infoLineText = TextUtils.empty();
        }
        int defaultMaxLines = blockEntity.getYSizeScaled() * 3 - 2;
        this.maxLines = defaultMaxLines - (this.showInfoLine ? 1 : 0);
        int maxIndices = Math.max(0, Math.min(this.maxLines, preds.size()));
        if (reason == AdvancedDisplayBlockEntity.EUpdateReason.LAYOUT_CHANGED || this.lines == null || this.lines.length != maxIndices) {
            this.updateLayout(blockEntity, preds, maxIndices);
        }
        for (int i = 0; i < this.lines.length && i < preds.size(); ++i) {
            StationDisplayData stop = preds.get(i);
            this.updateContent(blockEntity, stop, i, false);
        }
        this.statusLabel.text.set((Object)this.infoLineText);
        this.statusLabel.position.set((Object)Point.of((double)3.0, (double)((float)(blockEntity.getYSizeScaled() * 16) - 12.0f * ((Float)this.statusLabel.verticalMaxScale.get()).floatValue() - 2.0f)));
        this.statusLabel.preferredWidth.set((Number)Float.valueOf(blockEntity.getXSizeScaled() * 16 - 6));
        this.statusLabel.color.set((Object)DLColor.pickBasedOnBrightness((DLColor)((DepartureBoardDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor(), (DLColor)LIGHT_FONT_COLOR, (DLColor)DARK_FONT_COLOR, (float)0.5f));
        this.statusLabel.clippingArea.set((Object)Rectangle.withSize((double)2.0, (double)2.0, (double)(blockEntity.getXSizeScaled() * 16 - 4), (double)(blockEntity.getYSizeScaled() * 16 - 4)));
        this.statusLabel.glowing.set((Object)blockEntity.isGlowing());
        DLUtils.doIfNotNull((Object)this.lines, x -> {
            for (int i = 0; i < ((BERLabel[][])x).length; ++i) {
                BERLabel[] line = x[i];
                if (line == null) continue;
                for (int k = 0; k < line.length; ++k) {
                    DLUtils.doIfNotNull((Object)line[k], l -> {
                        l.clippingArea.set((Object)Rectangle.withSize((double)2.0, (double)2.0, (double)(blockEntity.getXSizeScaled() * 16 - 4), (double)(blockEntity.getYSizeScaled() * 16 - 4)));
                        l.glowing.set((Object)blockEntity.isGlowing());
                    });
                }
            }
        });
        for (int k = 0; k < this.headlines.length; ++k) {
            DLUtils.doIfNotNull((Object)this.headlines[k], l -> {
                l.clippingArea.set((Object)Rectangle.withSize((double)2.0, (double)2.0, (double)(blockEntity.getXSizeScaled() * 16 - 4), (double)(blockEntity.getYSizeScaled() * 16 - 4)));
                l.glowing.set((Object)blockEntity.isGlowing());
            });
        }
    }

    private void updateLayout(AdvancedDisplayBlockEntity blockEntity, List<StationDisplayData> preds, int maxIndices) {
        DepartureBoardDisplayTableSettings settings = (DepartureBoardDisplayTableSettings)this.getDisplaySettings(blockEntity);
        if (blockEntity.getXSizeScaled() < 4) {
            this.tooSmallLabel.clippingArea.set((Object)Rectangle.withSize((double)2.0, (double)2.0, (double)(blockEntity.getXSizeScaled() * 16 - 4), (double)(blockEntity.getYSizeScaled() * 16 - 4)));
            this.tooSmallLabel.glowing.set((Object)blockEntity.isGlowing());
            this.tooSmallLabel.color.set((Object)settings.getFontColor());
            this.tooSmallLabel.preferredWidth.set((Number)Float.valueOf((float)((Rectangle)this.tooSmallLabel.clippingArea.get()).width()));
            return;
        }
        boolean hasStopovers = blockEntity.getXSizeScaled() - 4 >= 4;
        boolean hasInfo = blockEntity.getXSizeScaled() - 4 >= 7;
        BERLabel hTimeLabel = this.headlines[LineComponent.TIME.i()];
        hTimeLabel.x.set((Number)Float.valueOf(3.0f));
        hTimeLabel.preferredWidth.set((Number)Float.valueOf(12.0f + (!this.isSmall(blockEntity) ? 12.0f : 0.0f) + 2.0f));
        hTimeLabel.color.set((Object)settings.getFontColor());
        BERLabel hTrainLabel = this.headlines[LineComponent.TRAIN_NAME.i()];
        hTrainLabel.x.set((Number)Float.valueOf(((Float)hTimeLabel.x.get()).floatValue() + ((Float)hTimeLabel.preferredWidth.get()).floatValue() + 2.0f));
        hTrainLabel.preferredWidth.set((Number)Float.valueOf(settings.getTrainNameWidth()));
        hTrainLabel.color.set((Object)settings.getFontColor());
        BERLabel hPlatformLabel = this.headlines[LineComponent.PLATFORM.i()];
        float hPlatformLabelWidth = settings.getPlatformWidth();
        hPlatformLabel.x.set((Number)Float.valueOf((float)(blockEntity.getXSizeScaled() * 16 - 3) - hPlatformLabelWidth));
        hPlatformLabel.horizontalAlign.set((Object)ETextAlignment.RIGHT);
        hPlatformLabel.preferredWidth.set((Number)Float.valueOf(hPlatformLabelWidth));
        hPlatformLabel.color.set((Object)settings.getFontColor());
        float remainingSpace = (float)(blockEntity.getXSizeScaled() * 16 - 3) - ((Float)hTrainLabel.x.get()).floatValue() - ((Float)hTrainLabel.preferredWidth.get()).floatValue() - (float)settings.getPlatformWidth() - 2.0f;
        float infoSpace = hasInfo ? remainingSpace * settings.getInfoWidthPercentage() - 2.0f : 0.0f;
        float stopoversSpace = hasStopovers ? remainingSpace * settings.getStopoversWidthPercentage() - 2.0f : 0.0f;
        float destinationSpace = remainingSpace - infoSpace - stopoversSpace - 6.0f;
        BERLabel hStopoversLabel = this.headlines[LineComponent.STOPOVERS.i()];
        hStopoversLabel.x.set((Number)Float.valueOf(hasStopovers ? ((Float)hTrainLabel.x.get()).floatValue() + ((Float)hTrainLabel.preferredWidth.get()).floatValue() + 2.0f : 0.0f));
        hStopoversLabel.preferredWidth.set((Number)Float.valueOf(stopoversSpace));
        hStopoversLabel.color.set((Object)settings.getFontColor());
        BERLabel hDestinationLabel = this.headlines[LineComponent.DESTINATION.i()];
        hDestinationLabel.x.set((Number)Float.valueOf(hasStopovers ? ((Float)hStopoversLabel.x.get()).floatValue() + ((Float)hStopoversLabel.preferredWidth.get()).floatValue() + 2.0f : ((Float)hTrainLabel.x.get()).floatValue() + ((Float)hTrainLabel.preferredWidth.get()).floatValue() + 2.0f));
        hDestinationLabel.preferredWidth.set((Number)Float.valueOf(destinationSpace));
        hDestinationLabel.color.set((Object)settings.getFontColor());
        BERLabel hInfoLabel = this.headlines[LineComponent.INFO.i()];
        hInfoLabel.x.set((Number)Float.valueOf(hasInfo ? ((Float)hDestinationLabel.x.get()).floatValue() + ((Float)hDestinationLabel.preferredWidth.get()).floatValue() + 2.0f : 3.0f));
        hInfoLabel.preferredWidth.set((Number)Float.valueOf(infoSpace));
        hInfoLabel.color.set((Object)settings.getFontColor());
        hInfoLabel.fullBackground.set((Object)true);
        this.lines = new BERLabel[maxIndices][];
        for (int i = 0; i < this.lines.length; ++i) {
            StationDisplayData stop = preds.get(i);
            this.lines[i] = this.createLine(blockEntity, stop, i, hasStopovers, hasInfo);
            this.updateContent(blockEntity, stop, i, true);
        }
        this.statusLabel.backgroundColor.set((Object)settings.getFontColor());
        this.statusLabel.color.set((Object)DLColor.pickBasedOnBrightness((DLColor)settings.getFontColor(), (DLColor)LIGHT_FONT_COLOR, (DLColor)DARK_FONT_COLOR, (float)0.5f));
    }

    private void updateContent(AdvancedDisplayBlockEntity blockEntity, StationDisplayData stop, int index, boolean layoutUpdate) {
        boolean hasInfo;
        DepartureBoardDisplayTableSettings settings = (DepartureBoardDisplayTableSettings)this.getDisplaySettings(blockEntity);
        boolean isLast = settings.showArrival() && stop.shouldShowArrivalOfTrain() || stop.isNextSectionExcluded();
        boolean showInfoLine = stop.getStationData().isDepartureDelayed() && stop.getTrainData().hasStatusInfo() || stop.getStationData().isStationChanged() || stop.isNextSectionExcluded();
        BERLabel[] components = this.lines[index];
        BERLabel timeLabel = components[LineComponent.TIME.i()];
        timeLabel.text.set((Object)TextUtils.text((String)ModUtils.formatTime(stop.getScheduledTime(), settings.getTimeDisplay() == ETimeDisplay.ETA)));
        BERLabel realTimeLabel = components[LineComponent.REAL_TIME.i()];
        realTimeLabel.text.set((Object)(this.isSmall(blockEntity) ? TextUtils.text((String)ModUtils.formatTime(stop.getScheduledTime(), settings.getTimeDisplay() == ETimeDisplay.ETA)) : TextUtils.text((String)(stop.getTrainData().isCancelled() ? " \u274c " : (stop.getStationData().isDepartureDelayed() ? ModUtils.formatTime(stop.getRealTime(), settings.getTimeDisplay() == ETimeDisplay.ETA) : "")))));
        realTimeLabel.color.set((Object)(this.isSmall(blockEntity) ? settings.getFontColor() : DLColor.pickBasedOnBrightness((DLColor)settings.getFontColor(), (DLColor)LIGHT_FONT_COLOR, (DLColor)DARK_FONT_COLOR, (float)0.5f)));
        BERLabel trainLabel = components[LineComponent.TRAIN_NAME.i()];
        trainLabel.text.set((Object)TextUtils.text((String)stop.getTrainData().getName()));
        if (settings.showLineColor() && stop.getTrainData().hasColor()) {
            trainLabel.backgroundColor.set((Object)stop.getTrainData().getColor());
            trainLabel.color.set((Object)DLColor.pickBasedOnBrightness((DLColor)stop.getTrainData().getColor(), (DLColor)LIGHT_FONT_COLOR, (DLColor)DARK_FONT_COLOR, (float)0.5f));
        } else {
            trainLabel.backgroundColor.set((Object)DLColor.TRANSPARENT);
            trainLabel.color.set((Object)settings.getFontColor());
        }
        BERLabel destinationLabel = components[LineComponent.DESTINATION.i()];
        destinationLabel.text.set((Object)(isLast ? CustomLanguage.translate("gui.createrailwaysnavigator.schedule_board.train_from", stop.getFirstStopName()) : TextUtils.text((String)stop.getStationData().getDestination())));
        BERLabel stopoversLabel = components[LineComponent.STOPOVERS.i()];
        BERLabel infoLabel = components[LineComponent.INFO.i()];
        boolean hasTransfers = stopoversLabel != null;
        boolean bl = hasInfo = infoLabel != null;
        if (hasTransfers) {
            stopoversLabel.text.set((Object)(isLast ? TextUtils.empty() : TextUtils.concat((Component)TextUtils.text((String)" \u25cf "), stop.getStopovers().stream().map(a -> TextUtils.text((String)a)).toList())));
        }
        if (hasInfo) {
            if (showInfoLine) {
                infoLabel.text.set((Object)this.getStatusInfo(blockEntity, stop, true).orElse((Component)TextUtils.empty()));
                infoLabel.color.set((Object)DLColor.pickBasedOnBrightness((DLColor)settings.getFontColor(), (DLColor)LIGHT_FONT_COLOR, (DLColor)DARK_FONT_COLOR, (float)0.5f));
            } else {
                infoLabel.text.set((Object)TextUtils.empty());
            }
        }
        BERLabel platformLabel = components[LineComponent.PLATFORM.i()];
        platformLabel.text.set((Object)TextUtils.text((String)stop.getStationData().getRealTimeStation().info().platform()));
        platformLabel.position.set((Object)Point.of((double)((Float)this.headlines[LineComponent.PLATFORM.i()].x.get()).floatValue(), (double)(8.4f + (float)index * 5.4f)));
        platformLabel.preferredWidth.set((Number)((Float)this.headlines[LineComponent.PLATFORM.i()].preferredWidth.get()));
        if (stop.getStationData().isStationChanged()) {
            platformLabel.backgroundColor.set((Object)((DepartureBoardDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor());
            platformLabel.color.set((Object)DARK_FONT_COLOR);
        } else {
            platformLabel.backgroundColor.set((Object)DLColor.TRANSPARENT);
            platformLabel.color.set((Object)((DepartureBoardDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor());
        }
        if (layoutUpdate) {
            timeLabel.position.set((Object)Point.of((double)((Float)this.headlines[LineComponent.TIME.i()].x.get()).floatValue(), (double)(8.4f + (float)index * 5.4f)));
            realTimeLabel.position.set((Object)Point.of((double)(((Float)timeLabel.x.get()).floatValue() + ((Float)timeLabel.preferredWidth.get()).floatValue() + 2.0f), (double)(8.4f + (float)index * 5.4f)));
            trainLabel.position.set((Object)Point.of((double)((Float)this.headlines[LineComponent.TRAIN_NAME.i()].x.get()).floatValue(), (double)(8.4f + (float)index * 5.4f)));
            trainLabel.preferredSize.set((Object)((Size)this.headlines[LineComponent.TRAIN_NAME.i()].preferredSize.get()));
            destinationLabel.position.set((Object)Point.of((double)((Float)this.headlines[LineComponent.DESTINATION.i()].x.get()).floatValue(), (double)(8.4f + (float)index * 5.4f)));
            destinationLabel.preferredSize.set((Object)((Size)this.headlines[LineComponent.DESTINATION.i()].preferredSize.get()));
            if (hasTransfers) {
                stopoversLabel.position.set((Object)Point.of((double)((Float)this.headlines[LineComponent.STOPOVERS.i()].x.get()).floatValue(), (double)(8.4f + (float)index * 5.4f)));
                stopoversLabel.preferredSize.set((Object)((Size)this.headlines[LineComponent.STOPOVERS.i()].preferredSize.get()));
            }
            if (hasInfo) {
                infoLabel.position.set((Object)Point.of((double)((Float)this.headlines[LineComponent.INFO.i()].x.get()).floatValue(), (double)(8.4f + (float)index * 5.4f)));
                infoLabel.preferredWidth.set((Number)((Float)this.headlines[LineComponent.INFO.i()].preferredWidth.get()));
                NumberProperty numberProperty = infoLabel.preferredHeight;
                Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
                numberProperty.set((Number)Float.valueOf(9.0f * ((Float)infoLabel.verticalMaxScale.get()).floatValue()));
            }
        }
    }

    private BERLabel[] createLine(AdvancedDisplayBlockEntity blockEntity, StationDisplayData stop, int index, boolean withStopovers, boolean withInfo) {
        BERLabel[] components = new BERLabel[LineComponent.values().length];
        boolean isSmall = this.isSmall(blockEntity);
        BERLabel bERLabel = new BERLabel();
        components[LineComponent.TIME.i()] = bERLabel;
        BERLabel timeLabel = bERLabel;
        timeLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.4f), (Object)Float.valueOf(0.4f)));
        timeLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.2f), (Object)Float.valueOf(0.4f)));
        timeLabel.preferredWidth.set((Number)Float.valueOf(isSmall ? -2.0f : 12.0f));
        timeLabel.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
        timeLabel.horizontalScrollingSpeed.set((Number)Float.valueOf(12.0f));
        timeLabel.color.set((Object)((DepartureBoardDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor());
        BERLabel bERLabel2 = new BERLabel();
        components[LineComponent.REAL_TIME.i()] = bERLabel2;
        BERLabel realTimeLabel = bERLabel2;
        realTimeLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.4f), (Object)Float.valueOf(0.4f)));
        realTimeLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.2f), (Object)Float.valueOf(0.4f)));
        realTimeLabel.preferredWidth.set((Number)Float.valueOf(12.0f));
        realTimeLabel.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
        realTimeLabel.horizontalScrollingSpeed.set((Number)Float.valueOf(12.0f));
        realTimeLabel.color.set((Object)((DepartureBoardDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor());
        realTimeLabel.backgroundPadding.set((Object)new PaddingF(0.5f));
        if (!isSmall) {
            realTimeLabel.backgroundColor.set((Object)((DepartureBoardDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor());
            realTimeLabel.color.set((Object)DARK_FONT_COLOR);
        }
        BERLabel bERLabel3 = new BERLabel();
        components[LineComponent.TRAIN_NAME.i()] = bERLabel3;
        BERLabel trainNameLabel = bERLabel3;
        trainNameLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.4f), (Object)Float.valueOf(0.4f)));
        trainNameLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.2f), (Object)Float.valueOf(0.4f)));
        trainNameLabel.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
        trainNameLabel.horizontalScrollingSpeed.set((Number)Float.valueOf(12.0f));
        trainNameLabel.color.set((Object)((DepartureBoardDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor());
        trainNameLabel.backgroundPadding.set((Object)new PaddingF(0.5f));
        BERLabel bERLabel4 = new BERLabel();
        components[LineComponent.PLATFORM.i()] = bERLabel4;
        BERLabel platformLabel = bERLabel4;
        platformLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.4f), (Object)Float.valueOf(0.4f)));
        platformLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.2f), (Object)Float.valueOf(0.4f)));
        platformLabel.horizontalAlign.set((Object)ETextAlignment.RIGHT);
        platformLabel.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
        platformLabel.horizontalScrollingSpeed.set((Number)Float.valueOf(12.0f));
        platformLabel.color.set((Object)((DepartureBoardDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor());
        BERLabel bERLabel5 = new BERLabel();
        components[LineComponent.DESTINATION.i()] = bERLabel5;
        BERLabel destinationLabel = bERLabel5;
        destinationLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.4f), (Object)Float.valueOf(0.4f)));
        destinationLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.2f), (Object)Float.valueOf(0.4f)));
        destinationLabel.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
        destinationLabel.horizontalScrollingSpeed.set((Number)Float.valueOf(12.0f));
        destinationLabel.color.set((Object)((DepartureBoardDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor());
        if (withStopovers) {
            BERLabel bERLabel6 = new BERLabel();
            components[LineComponent.STOPOVERS.i()] = bERLabel6;
            BERLabel stopoversLabel = bERLabel6;
            stopoversLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.3f), (Object)Float.valueOf(0.3f)));
            stopoversLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.2f), (Object)Float.valueOf(0.3f)));
            stopoversLabel.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
            stopoversLabel.horizontalScrollingSpeed.set((Number)Float.valueOf(12.0f));
            stopoversLabel.color.set((Object)((DepartureBoardDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor());
        }
        if (withInfo) {
            BERLabel bERLabel7 = new BERLabel();
            components[LineComponent.INFO.i()] = bERLabel7;
            BERLabel infoLabel = bERLabel7;
            infoLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.4f), (Object)Float.valueOf(0.4f)));
            infoLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.2f), (Object)Float.valueOf(0.4f)));
            infoLabel.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
            infoLabel.horizontalScrollingSpeed.set((Number)Float.valueOf(12.0f));
            infoLabel.color.set((Object)DARK_FONT_COLOR);
            infoLabel.backgroundColor.set((Object)((DepartureBoardDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor());
            infoLabel.fullBackground.set((Object)true);
            infoLabel.backgroundPadding.set((Object)new PaddingF(0.5f, 0.5f, 0.0f, 0.5f));
            NumberProperty numberProperty = infoLabel.preferredHeight;
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            numberProperty.set((Number)Float.valueOf(9.0f * ((Float)infoLabel.verticalMaxScale.get()).floatValue()));
        }
        return components;
    }

    private boolean isSmall(AdvancedDisplayBlockEntity blockEntity) {
        return blockEntity.getXSizeScaled() <= 4;
    }

    private static enum LineComponent {
        TIME(0),
        REAL_TIME(1),
        TRAIN_NAME(2),
        DESTINATION(3),
        PLATFORM(4),
        STOPOVERS(5),
        INFO(6);

        int index;

        private LineComponent(int index) {
            this.index = index;
        }

        public int i() {
            return this.index;
        }
    }
}

