/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.ber.variants;

import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.block.display.properties.PassengerInformationDetailedSettings;
import de.mrjulsen.crn.block.properties.ETimeDisplay;
import de.mrjulsen.crn.client.CRNGui;
import de.mrjulsen.crn.client.ber.AdvancedDisplayRenderInstance;
import de.mrjulsen.crn.client.ber.variants.AbstractAdvancedDisplayRenderer;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.lang.CustomLanguage;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.TrainExitSide;
import de.mrjulsen.crn.data.train.portable.NextConnectionsDisplayData;
import de.mrjulsen.crn.data.train.portable.TrainDisplayData;
import de.mrjulsen.crn.data.train.portable.TrainStopDisplayData;
import de.mrjulsen.crn.network.packets.pain.GetNextConnectionsDisplayDataPacketData;
import de.mrjulsen.crn.registry.ModNetworkManager;
import de.mrjulsen.crn.registry.data.NextConnectionsRequestData;
import de.mrjulsen.crn.util.ESpeedUnit;
import de.mrjulsen.crn.util.ModUtils;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.ber.BERGraphics;
import de.mrjulsen.mcdragonlib.client.ber.BERLabel;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.PaddingF;
import de.mrjulsen.mcdragonlib.client.util.DLGraphics;
import de.mrjulsen.mcdragonlib.client.util.RenderUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.network.NetworkDirection;
import de.mrjulsen.mcdragonlib.network.NetworkPacketData;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.Pair;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Point;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3f;

public class BERPassengerInfoInformative
implements AbstractAdvancedDisplayRenderer<PassengerInformationDetailedSettings> {
    private final MutableComponent textTrainTerminates = CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.train_terminates");
    private static final ResourceLocation CARRIAGE_ICON = new ResourceLocation("create:textures/gui/assemble.png");
    private static final ResourceLocation ICONS = new ResourceLocation("createrailwaysnavigator", "textures/gui/icons.png");
    private static final String keyDate = "gui.createrailwaysnavigator.route_overview.date";
    private static final String keyNextStop = "gui.createrailwaysnavigator.route_overview.next_stop";
    private static final String keyNextConnections = "gui.createrailwaysnavigator.route_overview.next_connections";
    private static final int MAX_LINES = 4;
    private NextConnectionsDisplayData nextConnections = null;
    private boolean nextStopAnnounced = false;
    private TrainExitSide exitSide = TrainExitSide.UNKNOWN;
    private final List<BERLabel> staticLabels;
    private final BERLabel timeLabel = new BERLabel();
    private final BERLabel carriageLabel = new BERLabel();
    private final BERLabel trainLineLabel = new BERLabel();
    private final BERLabel speedLabel = new BERLabel();
    private final BERLabel dateLabel = new BERLabel();
    private final BERLabel carriageInfoLabel = new BERLabel();
    private final BERLabel nextConnectionsTitleLabel = new BERLabel();
    private final BERLabel pageIndicatorLabel = new BERLabel();
    private BERLabel[][] scheduleLines;
    private BERLabel[][] nextConnectionsLines = new BERLabel[3][];
    private float listDestinationLabelX = 0.0f;

    public BERPassengerInfoInformative() {
        this.timeLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.25f), (Object)Float.valueOf(0.25f)));
        this.timeLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.25f), (Object)Float.valueOf(0.25f)));
        this.carriageLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.25f), (Object)Float.valueOf(0.25f)));
        this.carriageLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.25f), (Object)Float.valueOf(0.25f)));
        this.trainLineLabel.position.set((Object)Point.of((double)3.0, (double)2.5));
        this.trainLineLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.15f), (Object)Float.valueOf(0.25f)));
        this.trainLineLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.25f), (Object)Float.valueOf(0.25f)));
        this.trainLineLabel.backgroundPadding.set((Object)new PaddingF(0.5f));
        this.speedLabel.position.set((Object)Point.of((double)3.0, (double)6.0));
        this.speedLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.2f), (Object)Float.valueOf(0.25f)));
        this.speedLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.3f), (Object)Float.valueOf(0.3f)));
        this.speedLabel.horizontalAlign.set((Object)ETextAlignment.CENTER);
        this.dateLabel.position.set((Object)Point.of((double)3.0, (double)9.0));
        this.dateLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.15f), (Object)Float.valueOf(0.2f)));
        this.dateLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.2f), (Object)Float.valueOf(0.2f)));
        this.dateLabel.horizontalAlign.set((Object)ETextAlignment.CENTER);
        this.carriageInfoLabel.position.set((Object)Point.of((double)4.5, (double)11.0));
        this.carriageInfoLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.15f), (Object)Float.valueOf(0.2f)));
        this.carriageInfoLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.2f), (Object)Float.valueOf(0.2f)));
        this.carriageInfoLabel.horizontalAlign.set((Object)ETextAlignment.CENTER);
        this.nextConnectionsTitleLabel.text.set((Object)CustomLanguage.translate(keyNextConnections).m_130940_(ChatFormatting.BOLD));
        this.nextConnectionsTitleLabel.position.set((Object)Point.of((double)3.0, (double)5.5));
        this.nextConnectionsTitleLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.15f), (Object)Float.valueOf(0.15f)));
        this.nextConnectionsTitleLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.15f), (Object)Float.valueOf(0.15f)));
        this.pageIndicatorLabel.position.set((Object)Point.of((double)3.0, (double)12.5));
        this.pageIndicatorLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.15f), (Object)Float.valueOf(0.15f)));
        this.pageIndicatorLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.15f), (Object)Float.valueOf(0.15f)));
        this.pageIndicatorLabel.horizontalAlign.set((Object)ETextAlignment.CENTER);
        this.staticLabels = List.of(this.timeLabel, this.carriageLabel, this.trainLineLabel, this.speedLabel, this.dateLabel, this.carriageInfoLabel, this.nextConnectionsTitleLabel, this.pageIndicatorLabel);
    }

    private boolean shouldRenderNextConnections() {
        return this.nextConnections != null && !this.nextConnections.getConnections().isEmpty() && this.nextStopAnnounced;
    }

    private String generatePageIndexString(int current, int max) {
        int i;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < current; ++i) {
            sb.append(" \u25a1");
        }
        sb.append(" \u25a0");
        for (i = current + 1; i < max; ++i) {
            sb.append(" \u25a1");
        }
        return sb.toString();
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent) {
        this.timeLabel.text.set((Object)(blockEntity.getXSizeScaled() > 1 && !this.nextStopAnnounced ? TextUtils.text((String)ModUtils.formatTime(DragonLib.getCurrentWorldTime(), false)).m_130940_(ChatFormatting.BOLD) : TextUtils.empty()));
        this.timeLabel.horizontalAlign.set((Object)ETextAlignment.RIGHT);
        this.timeLabel.color.set((Object)((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor());
    }

    public void renderHeader(BERGraphics<AdvancedDisplayBlockEntity> graphics, float partialTick, AdvancedDisplayRenderInstance parent, int light, boolean backSide) {
        float uv255 = 0.00390625f;
        TrainExitSide side = this.exitSide;
        if (backSide) {
            side = side.getOpposite();
        }
        graphics.poseStack().m_85836_();
        if (side == TrainExitSide.LEFT) {
            graphics.poseStack().m_252880_(4.0f, 0.0f, 0.0f);
        }
        if (((AdvancedDisplayBlockEntity)graphics.blockEntity()).getXSizeScaled() > 1 && !this.nextStopAnnounced) {
            this.timeLabel.render(graphics);
            RenderUtils.renderTexture((ResourceLocation)ICONS, graphics, (Vector3f)new Vector3f(((Float)this.timeLabel.x.get()).floatValue() - 2.5f, 2.5f, 0.0f), (float)2.0f, (float)2.0f, (float)0.88671875f, (float)0.07421875f, (float)0.0390625f, (float)0.0390625f, (Direction)((Direction)((AdvancedDisplayBlockEntity)graphics.blockEntity()).m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)), (DLColor)((PassengerInformationDetailedSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).getFontColor(), (boolean)false);
        }
        if (((AdvancedDisplayBlockEntity)graphics.blockEntity()).getTrainData() == null || ((AdvancedDisplayBlockEntity)graphics.blockEntity()).getTrainData().getState().isOutOfService()) {
            graphics.poseStack().m_85849_();
            return;
        }
        this.trainLineLabel.render(graphics);
        if (((AdvancedDisplayBlockEntity)graphics.blockEntity()).getXSizeScaled() > 2 && !this.nextStopAnnounced) {
            this.carriageLabel.render(graphics);
            RenderUtils.renderTexture((ResourceLocation)CARRIAGE_ICON, graphics, (Vector3f)new Vector3f(((Float)this.carriageLabel.x.get()).floatValue() - 3.5f, 2.5f, 0.0f), (float)3.0f, (float)2.0f, (float)0.0859375f, (float)0.90234375f, (float)0.05078125f, (float)0.01953125f, (Direction)((Direction)((AdvancedDisplayBlockEntity)graphics.blockEntity()).m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)), (DLColor)((PassengerInformationDetailedSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).getFontColor(), (boolean)false);
        }
        graphics.poseStack().m_85849_();
        if (this.nextStopAnnounced || ((AdvancedDisplayBlockEntity)graphics.blockEntity()).getTrainData().isWaitingAtStation()) {
            switch (side) {
                case RIGHT: {
                    RenderUtils.renderTexture((ResourceLocation)((ResourceLocation)ModGuiIcons.ICON.getTexture().get()), graphics, (Vector3f)new Vector3f((float)(((AdvancedDisplayBlockEntity)graphics.blockEntity()).getXSizeScaled() * 16 - 3 - 3), 2.05f, 0.0f), (float)3.0f, (float)3.0f, (float)(0.00390625f * (float)ModGuiIcons.ARROW_RIGHT.getU()), (float)(0.00390625f * (float)ModGuiIcons.ARROW_RIGHT.getV()), (float)0.0625f, (float)0.0625f, (Direction)((Direction)((AdvancedDisplayBlockEntity)graphics.blockEntity()).m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)), (DLColor)((PassengerInformationDetailedSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).getFontColor(), (boolean)false);
                    break;
                }
                case LEFT: {
                    RenderUtils.renderTexture((ResourceLocation)((ResourceLocation)ModGuiIcons.ICON.getTexture().get()), graphics, (Vector3f)new Vector3f(3.0f, 2.05f, 0.0f), (float)3.0f, (float)3.0f, (float)(0.00390625f * (float)ModGuiIcons.ARROW_LEFT.getU()), (float)(0.00390625f * (float)ModGuiIcons.ARROW_LEFT.getV()), (float)0.0625f, (float)0.0625f, (Direction)((Direction)((AdvancedDisplayBlockEntity)graphics.blockEntity()).m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)), (DLColor)((PassengerInformationDetailedSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).getFontColor(), (boolean)false);
                    break;
                }
            }
        }
    }

    @Override
    public void render(BERGraphics<AdvancedDisplayBlockEntity> graphics, float partialTick, AdvancedDisplayRenderInstance parent, int light, boolean backSide) {
        float uv255 = 0.00390625f;
        this.renderHeader(graphics, partialTick, parent, light, backSide);
        RenderUtils.fillColor(graphics, (Vector3f)new Vector3f(2.5f, 5.0f, 0.01f), (float)(((AdvancedDisplayBlockEntity)graphics.blockEntity()).getXSizeScaled() * 16 - 5), (float)0.25f, (DLColor)((PassengerInformationDetailedSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).getFontColor(), (Direction)((Direction)((AdvancedDisplayBlockEntity)graphics.blockEntity()).m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)));
        if (((AdvancedDisplayBlockEntity)graphics.blockEntity()).getTrainData() == null || ((AdvancedDisplayBlockEntity)graphics.blockEntity()).getTrainData().getState().isOutOfService()) {
            return;
        }
        if (this.shouldRenderNextConnections()) {
            DLUtils.doIfNotNull((Object)this.nextConnectionsLines, x -> {
                for (int i = 0; i < ((BERLabel[][])x).length; ++i) {
                    DLUtils.doIfNotNull((Object)x[i], a -> {
                        for (int j = 0; j < ((BERLabel[])a).length; ++j) {
                            DLUtils.doIfNotNull((Object)a[j], b -> b.render((DLGraphics)graphics));
                        }
                    });
                }
            });
            this.nextConnectionsTitleLabel.render(graphics);
            this.pageIndicatorLabel.render(graphics);
        } else if (((PassengerInformationDetailedSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).showStats() && DragonLib.getCurrentWorldTime() % 500L < 200L && !((AdvancedDisplayBlockEntity)graphics.blockEntity()).getTrainData().isWaitingAtStation()) {
            this.speedLabel.render(graphics, light);
            this.dateLabel.render(graphics, light);
            this.carriageInfoLabel.render(graphics, light);
            RenderUtils.renderTexture((ResourceLocation)CARRIAGE_ICON, graphics, (Vector3f)new Vector3f((float)(((AdvancedDisplayBlockEntity)graphics.blockEntity()).getXSizeScaled() * 16) / 2.0f - this.carriageInfoLabel.getRenderedWidth() / 2.0f - 1.5f, ((Float)this.carriageInfoLabel.y.get()).floatValue(), 0.0f), (float)2.25f, (float)1.5f, (float)0.0859375f, (float)0.90234375f, (float)0.05078125f, (float)0.01953125f, (Direction)((Direction)((AdvancedDisplayBlockEntity)graphics.blockEntity()).m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)), (DLColor)((PassengerInformationDetailedSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).getFontColor(), (boolean)false);
        } else {
            DLUtils.doIfNotNull((Object)this.scheduleLines, x -> {
                for (int i = 0; i < ((BERLabel[][])x).length; ++i) {
                    int idx = i;
                    DLUtils.doIfNotNull((Object)x[i], a -> {
                        for (int j = 0; j < ((BERLabel[])a).length; ++j) {
                            DLUtils.doIfNotNull((Object)a[j], b -> b.render((DLGraphics)graphics));
                        }
                        float uv32 = 1.0f / (float)CRNGui.GUI.width();
                        if (idx == 0 && this.scheduleLines.length > 1) {
                            RenderUtils.renderTexture((ResourceLocation)((ResourceLocation)CRNGui.GUI.getTexture().get()), (DLGraphics)graphics, (Vector3f)new Vector3f(this.listDestinationLabelX - 2.0f, ((Float)a[LineComponent.SCHEDULED_TIME.i()].y.get()).floatValue() - 1.0f, 0.0f), (float)1.0f, (float)2.0f, (float)(uv32 * 21.0f), (float)(uv32 * 30.0f), (float)(uv32 * 7.0f), (float)(uv32 * 14.0f), (Direction)((Direction)((AdvancedDisplayBlockEntity)graphics.blockEntity()).m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)), (DLColor)((PassengerInformationDetailedSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).getFontColor(), (boolean)false);
                        } else if (idx >= 3) {
                            RenderUtils.renderTexture((ResourceLocation)((ResourceLocation)CRNGui.GUI.getTexture().get()), (DLGraphics)graphics, (Vector3f)new Vector3f(this.listDestinationLabelX - 2.0f, ((Float)a[LineComponent.SCHEDULED_TIME.i()].y.get()).floatValue() - 1.0f, 0.0f), (float)1.0f, (float)2.0f, (float)(uv32 * 35.0f), (float)(uv32 * 30.0f), (float)(uv32 * 7.0f), (float)(uv32 * 14.0f), (Direction)((Direction)((AdvancedDisplayBlockEntity)graphics.blockEntity()).m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)), (DLColor)((PassengerInformationDetailedSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).getFontColor(), (boolean)false);
                        } else {
                            RenderUtils.renderTexture((ResourceLocation)((ResourceLocation)CRNGui.GUI.getTexture().get()), (DLGraphics)graphics, (Vector3f)new Vector3f(this.listDestinationLabelX - 2.0f, ((Float)a[LineComponent.SCHEDULED_TIME.i()].y.get()).floatValue() - 1.0f, 0.0f), (float)1.0f, (float)2.0f, (float)(uv32 * 28.0f), (float)(uv32 * 30.0f), (float)(uv32 * 7.0f), (float)(uv32 * 14.0f), (Direction)((Direction)((AdvancedDisplayBlockEntity)graphics.blockEntity()).m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)), (DLColor)((PassengerInformationDetailedSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).getFontColor(), (boolean)false);
                        }
                    });
                }
            });
        }
    }

    @Override
    public void update(Level level, BlockPos pos, BlockState state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent, AdvancedDisplayBlockEntity.EUpdateReason reason) {
        boolean oos = blockEntity.getTrainData() == null || blockEntity.getTrainData().getState().isOutOfService();
        TrainDisplayData data = blockEntity.getTrainData();
        boolean wasNextStopAnnounced = this.nextStopAnnounced;
        boolean bl = this.nextStopAnnounced = !data.isWaitingAtStation() && data.getNextStop().isPresent() && data.getNextStop().get().getRealTimeArrivalTime() - DragonLib.getCurrentWorldTime() < (long)((Integer)ModClientConfig.NEXT_STOP_ANNOUNCEMENT.get()).intValue();
        TrainExitSide trainExitSide = !this.nextStopAnnounced && !data.isWaitingAtStation() || !((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).showExit() ? TrainExitSide.UNKNOWN : (this.exitSide = data.isWaitingAtStation() ? this.exitSide : (TrainExitSide)((Object)blockEntity.relativeExitDirection.get()));
        if (oos) {
            this.nextStopAnnounced = false;
            this.exitSide = TrainExitSide.UNKNOWN;
        }
        this.timeLabel.text.set((Object)(blockEntity.getXSizeScaled() > 1 && !this.nextStopAnnounced ? TextUtils.text((String)ModUtils.formatTime(DragonLib.getCurrentWorldTime(), false)).m_130940_(ChatFormatting.BOLD) : TextUtils.empty()));
        float timeLabelW = this.timeLabel.getRenderedWidth();
        this.timeLabel.position.set((Object)Point.of((double)((float)(blockEntity.getXSizeScaled() * 16 - 3) - timeLabelW - (float)(this.exitSide != TrainExitSide.UNKNOWN ? 4 : 0)), (double)2.5));
        this.timeLabel.preferredWidth.set((Number)Float.valueOf(timeLabelW));
        this.timeLabel.color.set((Object)((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor());
        if (oos) {
            return;
        }
        if (((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).showConnections() && blockEntity.getXSizeScaled() > 1 && this.nextStopAnnounced && !wasNextStopAnnounced && data.getNextStop().isPresent()) {
            ModNetworkManager.GET_NEXT_CONNECTIONS_DISPLAY_DATA.send((NetworkDirection)NetworkDirection.toServer(), (NetworkPacketData)new GetNextConnectionsDisplayDataPacketData.Request(new NextConnectionsRequestData(data.getNextStop().get().getRealTimeStation().stationName(), data.getTrainData().getId())), response -> {
                this.nextConnections = response.getData();
                this.updateLayout(blockEntity, data);
                this.updateContent(blockEntity, data);
            }, () -> {});
        }
        if (reason == AdvancedDisplayBlockEntity.EUpdateReason.LAYOUT_CHANGED || !this.nextStopAnnounced) {
            this.updateLayout(blockEntity, data);
            this.nextConnections = null;
        }
        this.updateContent(blockEntity, data);
        for (BERLabel label : this.staticLabels) {
            label.clippingArea.set((Object)Rectangle.withSize((double)2.0, (double)2.0, (double)(blockEntity.getXSizeScaled() * 16 - 4), (double)(blockEntity.getYSizeScaled() * 16 - 4)));
            label.glowing.set((Object)blockEntity.isGlowing());
        }
        DLUtils.doIfNotNull((Object)this.scheduleLines, x -> {
            for (int i = 0; i < ((BERLabel[][])x).length; ++i) {
                DLUtils.doIfNotNull((Object)x[i], y -> {
                    for (int j = 0; j < ((BERLabel[])y).length; ++j) {
                        DLUtils.doIfNotNull((Object)y[j], l -> {
                            l.clippingArea.set((Object)Rectangle.withSize((double)2.0, (double)2.0, (double)(blockEntity.getXSizeScaled() * 16 - 4), (double)(blockEntity.getYSizeScaled() * 16 - 4)));
                            l.glowing.set((Object)blockEntity.isGlowing());
                        });
                    }
                });
            }
        });
        DLUtils.doIfNotNull((Object)this.nextConnectionsLines, x -> {
            for (int i = 0; i < ((BERLabel[][])x).length; ++i) {
                DLUtils.doIfNotNull((Object)x[i], y -> {
                    for (int j = 0; j < ((BERLabel[])y).length; ++j) {
                        DLUtils.doIfNotNull((Object)y[j], l -> {
                            l.clippingArea.set((Object)Rectangle.withSize((double)2.0, (double)2.0, (double)(blockEntity.getXSizeScaled() * 16 - 4), (double)(blockEntity.getYSizeScaled() * 16 - 4)));
                            l.glowing.set((Object)blockEntity.isGlowing());
                        });
                    }
                });
            }
        });
    }

    private int getCarriageIndex(AdvancedDisplayBlockEntity blockEntity) {
        PassengerInformationDetailedSettings settings = (PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity);
        return (settings.shouldOverwriteCarriageIndex() ? 0 : blockEntity.getCarriageData().index() + 1) + settings.getCarriageIndex();
    }

    private void updateContent(AdvancedDisplayBlockEntity blockEntity, TrainDisplayData displayData) {
        PassengerInformationDetailedSettings settings = (PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity);
        int carriageIndex = this.getCarriageIndex(blockEntity);
        this.carriageLabel.text.set((Object)(blockEntity.getXSizeScaled() > 1 && !this.nextStopAnnounced ? TextUtils.text((String)String.format("%02d", carriageIndex)).m_130940_(ChatFormatting.BOLD) : TextUtils.empty()));
        float carriageLabelW = this.carriageLabel.getRenderedWidth();
        this.carriageLabel.position.set((Object)Point.of((double)(((Float)this.timeLabel.x.get()).floatValue() - 4.0f - carriageLabelW), (double)2.5));
        this.carriageLabel.preferredWidth.set((Number)Float.valueOf(carriageLabelW));
        this.carriageLabel.color.set((Object)((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor());
        boolean atTerminus = blockEntity.getTrainData().getState() == TrainDisplayData.State.AT_TERMINUS;
        MutableComponent labelText = TextUtils.empty();
        labelText = atTerminus ? this.textTrainTerminates : (this.nextStopAnnounced ? CustomLanguage.translate(keyNextStop, displayData.getNextStop().get().getRealTimeStation().tagName()) : TextUtils.text((String)((String)(settings.getTrainTextComponents().showTrainName() ? displayData.getTrainData().getName() + " " : "") + (settings.getTrainTextComponents().showDestination() ? displayData.getNextStop().get().getDestination() : ""))).m_130940_(ChatFormatting.BOLD));
        this.trainLineLabel.text.set((Object)labelText);
        this.trainLineLabel.preferredWidth.set((Number)Float.valueOf(this.nextStopAnnounced ? (float)(blockEntity.getXSizeScaled() * 16 - 6 - (this.exitSide != TrainExitSide.UNKNOWN ? 4 : 0)) : (blockEntity.getXSizeScaled() > 2 ? ((Float)this.carriageLabel.x.get()).floatValue() - 9.0f : ((Float)this.timeLabel.x.get()).floatValue() - 7.0f)));
        this.trainLineLabel.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
        this.trainLineLabel.horizontalScrollingSpeed.set((Number)Float.valueOf(12.0f));
        if (settings.showLineColor() && blockEntity.getTrainData().getTrainData().hasColor() && !this.nextStopAnnounced && !atTerminus) {
            this.trainLineLabel.backgroundColor.set((Object)blockEntity.getTrainData().getTrainData().getColor());
            this.trainLineLabel.color.set((Object)DLColor.pickBasedOnBrightness((DLColor)blockEntity.getTrainData().getTrainData().getColor(), (DLColor)LIGHT_FONT_COLOR, (DLColor)DARK_FONT_COLOR, (float)0.5f));
        } else {
            this.trainLineLabel.backgroundColor.set((Object)DLColor.TRANSPARENT);
            this.trainLineLabel.color.set((Object)settings.getFontColor());
        }
        this.speedLabel.text.set((Object)ModUtils.calcSpeedString(displayData.getSpeed(), (ESpeedUnit)((Object)ModClientConfig.SPEED_UNIT.get())).m_130940_(ChatFormatting.BOLD));
        this.speedLabel.preferredWidth.set((Number)Float.valueOf((float)((Rectangle)this.speedLabel.clippingArea.get()).width()));
        this.speedLabel.color.set((Object)((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor());
        this.dateLabel.text.set((Object)CustomLanguage.translate(keyDate, blockEntity.m_58904_().m_46468_() / 24000L, ModUtils.formatTime(DragonLib.getCurrentWorldTime(), ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA)));
        this.dateLabel.preferredWidth.set((Number)Float.valueOf((float)((Rectangle)this.dateLabel.clippingArea.get()).width()));
        this.dateLabel.color.set((Object)((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor());
        this.carriageInfoLabel.text.set((Object)TextUtils.text((String)String.format("%02d", carriageIndex)));
        this.carriageInfoLabel.preferredWidth.set((Number)Float.valueOf((float)((Rectangle)this.carriageInfoLabel.clippingArea.get()).width()));
        this.carriageInfoLabel.color.set((Object)((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor());
        if (this.shouldRenderNextConnections() && !this.nextConnections.getConnections().isEmpty()) {
            int pages = (int)Math.ceil((float)this.nextConnections.getConnections().size() / 3.0f);
            int page = (int)(DragonLib.getCurrentWorldTime() % (long)(100 * pages) / 100L);
            this.pageIndicatorLabel.text.set((Object)TextUtils.text((String)this.generatePageIndexString(page, pages)));
            this.pageIndicatorLabel.preferredWidth.set((Number)Float.valueOf((float)((Rectangle)this.pageIndicatorLabel.clippingArea.get()).width()));
            this.pageIndicatorLabel.color.set((Object)((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor());
            this.nextConnectionsTitleLabel.preferredWidth.set((Number)Float.valueOf((float)((Rectangle)this.nextConnectionsTitleLabel.clippingArea.get()).width()));
            this.nextConnectionsTitleLabel.color.set((Object)((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor());
            DLUtils.doIfNotNull((Object)this.nextConnectionsLines, x -> {
                for (int i = 0; i < 3; ++i) {
                    int k = i;
                    int connectionIdx = i + page * 3;
                    DLUtils.doIfNotNull((Object)this.nextConnectionsLines[i], a -> {
                        BERLabel scheduledTimeLabel = a[LineComponent.SCHEDULED_TIME.i()];
                        BERLabel realTimeLabel = a[LineComponent.REAL_TIME.i()];
                        BERLabel trainNameLabel = a[LineComponent.TRAIN_NAME.i()];
                        BERLabel destinationLabel = a[LineComponent.DESTINATION.i()];
                        BERLabel platformLabel = a[LineComponent.PLATFORM.i()];
                        if (connectionIdx >= this.nextConnections.getConnections().size()) {
                            scheduledTimeLabel.text.set((Object)TextUtils.empty());
                            if (realTimeLabel != null) {
                                realTimeLabel.text.set((Object)TextUtils.empty());
                            }
                            trainNameLabel.text.set((Object)TextUtils.empty());
                            destinationLabel.text.set((Object)TextUtils.empty());
                            platformLabel.text.set((Object)TextUtils.empty());
                            return;
                        }
                        TrainStopDisplayData stop = this.nextConnections.getConnections().get(connectionIdx);
                        platformLabel.text.set((Object)TextUtils.text((String)stop.getRealTimeStation().info().platform()));
                        float platformLabelW = platformLabel.getRenderedWidth();
                        platformLabel.position.set((Object)Point.of((double)((float)(blockEntity.getXSizeScaled() * 16 - 3) - platformLabelW), (double)(7.5f + (float)k * 1.7f)));
                        platformLabel.preferredWidth.set((Number)Float.valueOf(platformLabelW));
                        if (realTimeLabel != null) {
                            scheduledTimeLabel.text.set((Object)TextUtils.text((String)ModUtils.formatTime(stop.getScheduledDepartureTime(), ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA)));
                            scheduledTimeLabel.position.set((Object)Point.of((double)3.0, (double)(7.5f + (float)k * 1.7f)));
                            scheduledTimeLabel.color.set((Object)((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor());
                            realTimeLabel.text.set((Object)TextUtils.text((String)ModUtils.formatTime(stop.getRealTimeDepartureTime(), ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA)));
                            realTimeLabel.position.set((Object)Point.of((double)(((Float)scheduledTimeLabel.x.get()).floatValue() + scheduledTimeLabel.getRenderedWidth() + 1.0f), (double)(7.5f + (float)k * 1.7f)));
                            realTimeLabel.color.set((Object)(stop.isDepartureDelayed() ? Constants.COLOR_DELAYED : Constants.COLOR_ON_TIME));
                        } else {
                            scheduledTimeLabel.text.set((Object)TextUtils.text((String)ModUtils.formatTime(stop.getRealTimeDepartureTime(), ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA)));
                            scheduledTimeLabel.position.set((Object)Point.of((double)3.0, (double)(7.5f + (float)k * 1.7f)));
                            scheduledTimeLabel.color.set((Object)(stop.isDepartureDelayed() ? Constants.COLOR_DELAYED : Constants.COLOR_ON_TIME));
                        }
                        float pX = ((Float)scheduledTimeLabel.x.get()).floatValue() + scheduledTimeLabel.getRenderedWidth() + 1.0f + (realTimeLabel == null ? 0.0f : realTimeLabel.getRenderedWidth() + 1.0f);
                        trainNameLabel.text.set((Object)TextUtils.text((String)stop.getTrainName()));
                        trainNameLabel.position.set((Object)Point.of((double)pX, (double)(7.5f + (float)k * 1.7f)));
                        trainNameLabel.preferredWidth.set((Number)Float.valueOf(6.0f));
                        trainNameLabel.color.set((Object)((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor());
                        destinationLabel.text.set((Object)TextUtils.text((String)stop.getDestination()));
                        destinationLabel.position.set((Object)Point.of((double)(pX + 7.0f), (double)(7.5f + (float)k * 1.7f)));
                        destinationLabel.preferredWidth.set((Number)Float.valueOf(((Float)platformLabel.x.get()).floatValue() - 1.0f - pX - 7.0f));
                        destinationLabel.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
                        destinationLabel.color.set((Object)((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor());
                    });
                }
            });
        } else {
            DLUtils.doIfNotNull((Object)this.scheduleLines, x -> {
                int k;
                int j;
                int i;
                int totalStationsCount = displayData.getStopsFromCurrentStation().size();
                int linesCount = Math.min(this.scheduleLines.length, totalStationsCount);
                this.listDestinationLabelX = 0.0f;
                for (i = 0; i < linesCount; ++i) {
                    j = i;
                    k = i >= linesCount - 1 ? totalStationsCount - 1 : i;
                    DLUtils.doIfNotNull((Object)this.scheduleLines[i], a -> {
                        TrainStopDisplayData stop = displayData.getStopsFromCurrentStation().get(k);
                        boolean showDeparture = displayData.isWaitingAtStation() && displayData.getCurrentScheduleIndex() == stop.getStationEntryIndex();
                        BERLabel scheduledTimeLabel = a[LineComponent.SCHEDULED_TIME.i()];
                        BERLabel realTimeLabel = a[LineComponent.REAL_TIME.i()];
                        if (realTimeLabel != null) {
                            scheduledTimeLabel.text.set((Object)TextUtils.text((String)ModUtils.formatTime(showDeparture ? stop.getScheduledDepartureTime() : stop.getScheduledArrivalTime(), ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA)));
                            scheduledTimeLabel.color.set((Object)((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor());
                            realTimeLabel.text.set((Object)TextUtils.text((String)ModUtils.formatTime(showDeparture ? stop.getRealTimeDepartureTime() : stop.getRealTimeArrivalTime(), ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA)));
                            realTimeLabel.position.set((Object)Point.of((double)(((Float)scheduledTimeLabel.x.get()).floatValue() + scheduledTimeLabel.getRenderedWidth() + 1.0f), (double)(6 + j * 2)));
                            realTimeLabel.color.set((Object)(stop.isArrivalDelayed() ? Constants.COLOR_DELAYED : Constants.COLOR_ON_TIME));
                        } else {
                            scheduledTimeLabel.text.set((Object)TextUtils.text((String)ModUtils.formatTime(stop.getRealTimeArrivalTime(), ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA)));
                            scheduledTimeLabel.color.set((Object)(stop.isArrivalDelayed() ? Constants.COLOR_DELAYED : Constants.COLOR_ON_TIME));
                        }
                        this.listDestinationLabelX = Math.max(this.listDestinationLabelX, ((Float)scheduledTimeLabel.x.get()).floatValue() + scheduledTimeLabel.getRenderedWidth() + 3.0f + (realTimeLabel == null ? 0.0f : realTimeLabel.getRenderedWidth() + 1.0f));
                    });
                }
                for (i = 0; i < linesCount; ++i) {
                    j = i;
                    k = i >= linesCount - 1 ? totalStationsCount - 1 : i;
                    DLUtils.doIfNotNull((Object)this.scheduleLines[i], a -> {
                        TrainStopDisplayData stop = displayData.getStopsFromCurrentStation().get(k);
                        BERLabel destinationLabel = a[LineComponent.DESTINATION.i()];
                        destinationLabel.text.set((Object)TextUtils.text((String)stop.getRealTimeStation().tagName()).m_130940_(j >= linesCount - 1 ? ChatFormatting.BOLD : ChatFormatting.RESET));
                        destinationLabel.position.set((Object)Point.of((double)this.listDestinationLabelX, (double)(6 + j * 2)));
                        destinationLabel.preferredWidth.set((Number)Float.valueOf((float)(blockEntity.getXSizeScaled() * 16 - 3) - this.listDestinationLabelX));
                        destinationLabel.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
                        destinationLabel.horizontalScrollingSpeed.set((Number)Float.valueOf(12.0f));
                        destinationLabel.color.set((Object)((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor());
                    });
                }
            });
        }
    }

    private BERLabel[] createStationLine(AdvancedDisplayBlockEntity blockEntity, int index) {
        BERLabel timeLabel = new BERLabel();
        timeLabel.position.set((Object)Point.of((double)3.0, (double)(6 + index * 2)));
        timeLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.1f), (Object)Float.valueOf(0.15f)));
        timeLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.15f), (Object)Float.valueOf(0.15f)));
        timeLabel.preferredWidth.set((Number)Float.valueOf(6.0f));
        BERLabel realTimeLabel = null;
        if (blockEntity.getXSizeScaled() > 1) {
            realTimeLabel = new BERLabel();
            realTimeLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.1f), (Object)Float.valueOf(0.15f)));
            realTimeLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.15f), (Object)Float.valueOf(0.15f)));
            realTimeLabel.preferredWidth.set((Number)Float.valueOf(6.0f));
        }
        BERLabel destinationLabel = new BERLabel();
        destinationLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.08f), (Object)Float.valueOf(0.15f)));
        destinationLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.15f), (Object)Float.valueOf(0.15f)));
        return new BERLabel[]{timeLabel, realTimeLabel, null, destinationLabel};
    }

    private BERLabel[] createNextConnectionsLine(AdvancedDisplayBlockEntity blockEntity, int index) {
        BERLabel timeLabel = new BERLabel();
        timeLabel.position.set((Object)Point.of((double)3.0, (double)(7 + index * 2)));
        timeLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.1f), (Object)Float.valueOf(0.15f)));
        timeLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.15f), (Object)Float.valueOf(0.15f)));
        timeLabel.preferredWidth.set((Number)Float.valueOf(6.0f));
        BERLabel realTimeLabel = null;
        if (blockEntity.getXSizeScaled() > 2) {
            realTimeLabel = new BERLabel();
            realTimeLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.1f), (Object)Float.valueOf(0.15f)));
            realTimeLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.15f), (Object)Float.valueOf(0.15f)));
            realTimeLabel.preferredWidth.set((Number)Float.valueOf(6.0f));
        }
        BERLabel trainNameLabel = new BERLabel();
        trainNameLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.08f), (Object)Float.valueOf(0.15f)));
        trainNameLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.15f), (Object)Float.valueOf(0.15f)));
        BERLabel destinationLabel = new BERLabel();
        destinationLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.08f), (Object)Float.valueOf(0.15f)));
        destinationLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.15f), (Object)Float.valueOf(0.15f)));
        BERLabel platformLabel = new BERLabel();
        platformLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.08f), (Object)Float.valueOf(0.15f)));
        platformLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.15f), (Object)Float.valueOf(0.15f)));
        return new BERLabel[]{timeLabel, realTimeLabel, trainNameLabel, destinationLabel, platformLabel};
    }

    private void updateLayout(AdvancedDisplayBlockEntity blockEntity, TrainDisplayData data) {
        if (this.shouldRenderNextConnections()) {
            for (int i = 0; i < 3; ++i) {
                this.nextConnectionsLines[i] = this.createNextConnectionsLine(blockEntity, i);
            }
            return;
        }
        int totalStationsCount = data.getStopsFromCurrentStation().size();
        int linesCount = Math.min(4, totalStationsCount);
        this.scheduleLines = new BERLabel[linesCount][];
        for (int i = 0; i < linesCount; ++i) {
            this.scheduleLines[i] = this.createStationLine(blockEntity, i);
        }
    }

    private static enum LineComponent {
        SCHEDULED_TIME(0),
        REAL_TIME(1),
        TRAIN_NAME(2),
        DESTINATION(3),
        PLATFORM(4);

        int i;

        private LineComponent(int i) {
            this.i = i;
        }

        public int i() {
            return this.i;
        }
    }
}

