/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.ber.variants;

import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.block.display.properties.PassengerInformationScrollingTextSettings;
import de.mrjulsen.crn.client.ber.AdvancedDisplayRenderInstance;
import de.mrjulsen.crn.client.ber.variants.AbstractAdvancedDisplayRenderer;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.lang.CustomLanguage;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.TrainExitSide;
import de.mrjulsen.crn.data.train.portable.TrainDisplayData;
import de.mrjulsen.crn.util.ESpeedUnit;
import de.mrjulsen.crn.util.ETimeFormat;
import de.mrjulsen.crn.util.ModUtils;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.ber.BERGraphics;
import de.mrjulsen.mcdragonlib.client.ber.BERLabel;
import de.mrjulsen.mcdragonlib.client.util.RenderUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.Pair;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Point;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.mcdragonlib.util.time.ConfiguredTimeSystem;
import de.mrjulsen.mcdragonlib.util.time.DLTime;
import de.mrjulsen.mcdragonlib.util.time.ITimeSystem;
import de.mrjulsen.mcdragonlib.util.time.TimeContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3f;

public class BERPassengerInfoSimple
implements AbstractAdvancedDisplayRenderer<PassengerInformationScrollingTextSettings> {
    private static final ResourceLocation ICONS = new ResourceLocation("createrailwaysnavigator", "textures/gui/icons.png");
    private final MutableComponent textTrainTerminatesHere = CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.this_train_terminates_there").m_130946_(" ").m_7220_((Component)CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.passengers_leave_train"));
    private final MutableComponent textTrainTerminated = CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.train_terminates");
    private static final String keyNextStop = "gui.createrailwaysnavigator.route_overview.next_stop";
    private static final String keyDate = "gui.createrailwaysnavigator.route_overview.date";
    private static final int TICKS_PER_SLIDE = 100;
    private TrainExitSide exitSide = TrainExitSide.UNKNOWN;
    private final BERLabel label = new BERLabel();

    public BERPassengerInfoSimple() {
        this.label.position.set((Object)Point.of((double)3.0, (double)5.5));
        this.label.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.75f), (Object)Float.valueOf(0.75f)));
        this.label.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.75f), (Object)Float.valueOf(0.75f)));
        this.label.horizontalAlign.set((Object)ETextAlignment.CENTER);
        this.label.horizontalScrollingSpeed.set((Number)Float.valueOf(12.0f));
    }

    @Override
    public void render(BERGraphics<AdvancedDisplayBlockEntity> graphics, float partialTick, AdvancedDisplayRenderInstance parent, int light, boolean backSide) {
        if (((AdvancedDisplayBlockEntity)graphics.blockEntity()).getTrainData() == null || ((AdvancedDisplayBlockEntity)graphics.blockEntity()).getTrainData().getState().isOutOfService()) {
            return;
        }
        float uv = 0.00390625f;
        TrainExitSide side = this.exitSide;
        if (backSide) {
            side = side.getOpposite();
        }
        switch (side) {
            case RIGHT: {
                RenderUtils.renderTexture((ResourceLocation)ICONS, graphics, (Vector3f)new Vector3f((float)(((AdvancedDisplayBlockEntity)graphics.blockEntity()).getXSizeScaled() * 16 - 3 - 8), 4.0f, 0.0f), (float)8.0f, (float)8.0f, (float)(uv * (float)ModGuiIcons.ARROW_RIGHT.getU()), (float)(uv * (float)ModGuiIcons.ARROW_RIGHT.getV()), (float)(uv * 16.0f), (float)(uv * 16.0f), (Direction)((Direction)((AdvancedDisplayBlockEntity)graphics.blockEntity()).m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_(), (DLColor)((PassengerInformationScrollingTextSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).getFontColor(), (boolean)false);
                break;
            }
            case LEFT: {
                RenderUtils.renderTexture((ResourceLocation)ICONS, graphics, (Vector3f)new Vector3f(3.0f, 4.0f, 0.0f), (float)8.0f, (float)8.0f, (float)(uv * (float)ModGuiIcons.ARROW_LEFT.getU()), (float)(uv * (float)ModGuiIcons.ARROW_LEFT.getV()), (float)(uv * 16.0f), (float)(uv * 16.0f), (Direction)((Direction)((AdvancedDisplayBlockEntity)graphics.blockEntity()).m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_(), (DLColor)((PassengerInformationScrollingTextSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).getFontColor(), (boolean)false);
                break;
            }
        }
        graphics.poseStack().m_85836_();
        switch (side) {
            case LEFT: {
                graphics.poseStack().m_252880_(10.0f, 0.0f, 0.0f);
                break;
            }
        }
        this.label.render(graphics, light);
        graphics.poseStack().m_85849_();
    }

    @Override
    public void update(Level level, BlockPos pos, BlockState state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent, AdvancedDisplayBlockEntity.EUpdateReason data) {
        if (blockEntity.getTrainData() == null || blockEntity.getTrainData().getState().isOutOfService()) {
            return;
        }
        this.label.clippingArea.set((Object)Rectangle.withSize((double)3.0, (double)3.0, (double)(blockEntity.getXSizeScaled() * 16 - 6), (double)(blockEntity.getYSizeScaled() * 16 - 6)));
        PassengerInformationScrollingTextSettings settings = (PassengerInformationScrollingTextSettings)this.getDisplaySettings(blockEntity);
        TrainExitSide trainExitSide = settings.showExit() ? (blockEntity.getTrainData().isWaitingAtStation() ? this.exitSide : (TrainExitSide)((Object)blockEntity.relativeExitDirection.get())) : (this.exitSide = TrainExitSide.UNKNOWN);
        if (blockEntity.getTrainData().getState() == TrainDisplayData.State.AT_TERMINUS) {
            this.label.text.set((Object)this.textTrainTerminated);
        } else if (!blockEntity.getTrainData().getNextStop().isPresent()) {
            this.label.text.set((Object)(settings.getTrainTextComponents().showTrainName() ? TextUtils.text((String)blockEntity.getTrainData().getTrainData().getName()) : TextUtils.empty()));
        } else if (blockEntity.getTrainData().isWaitingAtStation()) {
            this.label.text.set((Object)TextUtils.text((String)blockEntity.getTrainData().getNextStop().get().getRealTimeStation().tagName()));
        } else if (blockEntity.getTrainData().getNextStop().get().getRealTimeArrivalTime() - DragonLib.getCurrentWorldTime() < (long)((Integer)ModClientConfig.NEXT_STOP_ANNOUNCEMENT.get()).intValue()) {
            MutableComponent txt = CustomLanguage.translate(keyNextStop, blockEntity.getTrainData().getNextStop().get().getRealTimeStation().tagName());
            if (blockEntity.getTrainData().getState().isTerminating(((PassengerInformationScrollingTextSettings)this.getDisplaySettings(blockEntity)).showDoNotBoardText())) {
                txt = TextUtils.concatSimple((Component[])new Component[]{txt, this.textTrainTerminatesHere});
            }
            this.label.text.set((Object)txt);
        } else {
            int slides = 3;
            int slide = (int)(DragonLib.getCurrentWorldTime() % 300L) / 100;
            if (slide == 1 && !settings.showTimeAndDate()) {
                ++slide;
            }
            if (slide == 2 && !settings.showStats()) {
                ++slide;
            }
            switch (slide %= 3) {
                case 0: {
                    this.label.text.set((Object)TextUtils.text((String)((String)(settings.getTrainTextComponents().showTrainName() ? blockEntity.getTrainData().getTrainData().getName() + " " : "") + (settings.getTrainTextComponents().showDestination() && blockEntity.getTrainData().getCurrentStop().isPresent() ? blockEntity.getTrainData().getCurrentStop().get().getDestination() : ""))));
                    break;
                }
                case 1: {
                    this.label.text.set((Object)CustomLanguage.translate(keyDate, blockEntity.m_58904_().m_46468_() / 24000L, DLTime.fromLevelTime((Level)level, (ITimeSystem)new ConfiguredTimeSystem()).format(((ETimeFormat)((Object)ModClientConfig.TIME_FORMAT.get())).getFormat(), TimeContext.INGAME)));
                    break;
                }
                case 2: {
                    this.label.text.set((Object)ModUtils.calcSpeedString(blockEntity.getTrainData().getSpeed(), (ESpeedUnit)((Object)ModClientConfig.SPEED_UNIT.get())));
                }
            }
            this.exitSide = TrainExitSide.UNKNOWN;
        }
        this.label.preferredWidth.set((Number)Float.valueOf((float)blockEntity.getXSizeScaled() * 16.0f - 6.0f - (float)(this.exitSide == TrainExitSide.UNKNOWN ? 0 : 10)));
        this.label.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
        this.label.color.set((Object)((PassengerInformationScrollingTextSettings)this.getDisplaySettings(blockEntity)).getFontColor());
    }
}

