/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.ber.variants;

import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.block.display.properties.PlatformDisplayTableSettings;
import de.mrjulsen.crn.block.properties.ETimeDisplay;
import de.mrjulsen.crn.client.ber.AdvancedDisplayRenderInstance;
import de.mrjulsen.crn.client.ber.variants.AbstractAdvancedDisplayRenderer;
import de.mrjulsen.crn.client.lang.CustomLanguage;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.train.TrainStatus;
import de.mrjulsen.crn.data.train.portable.StationDisplayData;
import de.mrjulsen.crn.util.ModUtils;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.ber.BERGraphics;
import de.mrjulsen.mcdragonlib.client.ber.BERLabel;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.PaddingF;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.Pair;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Point;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.mcdragonlib.util.properties.NumberProperty;
import de.mrjulsen.mcdragonlib.util.time.ConfiguredTimeSystem;
import de.mrjulsen.mcdragonlib.util.time.DLTime;
import de.mrjulsen.mcdragonlib.util.time.ITimeSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class BERPlatformDetailed
implements AbstractAdvancedDisplayRenderer<PlatformDisplayTableSettings> {
    private final MutableComponent textTrainTerminatesHere = CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.train_terminates");
    private static final String keyTime = "gui.createrailwaysnavigator.time";
    private static final float LINE_HEIGHT = 5.4f;
    private boolean showInfoLine = false;
    private MutableComponent infoLineText = TextUtils.empty();
    private int maxLines = 0;
    private final BERLabel timeLabel = new BERLabel();
    private final BERLabel statusLabel = new BERLabel();
    private BERLabel[][] lines = new BERLabel[0][];

    public BERPlatformDetailed() {
        this.timeLabel.text.set((Object)TextUtils.empty());
        this.timeLabel.horizontalAlign.set((Object)ETextAlignment.CENTER);
        this.timeLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.4f), (Object)Float.valueOf(0.4f)));
        this.timeLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.4f), (Object)Float.valueOf(0.4f)));
        this.statusLabel.text.set((Object)TextUtils.empty());
        this.statusLabel.horizontalAlign.set((Object)ETextAlignment.CENTER);
        this.statusLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.4f), (Object)Float.valueOf(0.4f)));
        this.statusLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.4f), (Object)Float.valueOf(0.4f)));
        this.statusLabel.backgroundColor.set((Object)DLColor.WHITE);
        this.statusLabel.color.set((Object)DARK_FONT_COLOR);
        this.statusLabel.fullBackground.set((Object)true);
        this.statusLabel.horizontalScrollingSpeed.set((Number)Float.valueOf(12.0f));
        this.statusLabel.backgroundPadding.set((Object)new PaddingF(0.5f));
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent) {
        this.timeLabel.text.set((Object)(blockEntity.getXSize() > 1 ? CustomLanguage.translate(keyTime, ModUtils.formatTime(DragonLib.getCurrentWorldTime(), false)) : TextUtils.text((String)ModUtils.formatTime(DragonLib.getCurrentWorldTime(), false))));
        this.timeLabel.clippingArea.set((Object)Rectangle.withSize((double)2.0, (double)2.0, (double)(blockEntity.getXSizeScaled() * 16 - 4), (double)(blockEntity.getYSizeScaled() * 16 - 4)));
        this.timeLabel.glowing.set((Object)blockEntity.isGlowing());
        this.statusLabel.clippingArea.set((Object)Rectangle.withSize((double)2.0, (double)2.0, (double)(blockEntity.getXSizeScaled() * 16 - 4), (double)(blockEntity.getYSizeScaled() * 16 - 4)));
        this.statusLabel.glowing.set((Object)blockEntity.isGlowing());
        BERLabel[][] bERLabelArray = this.lines;
        int n = bERLabelArray.length;
        for (int i = 0; i < n; ++i) {
            BERLabel[] lbls;
            for (BERLabel lbl : lbls = bERLabelArray[i]) {
                lbl.glowing.set((Object)blockEntity.isGlowing());
                lbl.clippingArea.set((Object)Rectangle.withSize((double)2.0, (double)2.0, (double)(blockEntity.getXSizeScaled() * 16 - 4), (double)(blockEntity.getYSizeScaled() * 16 - 4)));
            }
        }
    }

    @Override
    public void render(BERGraphics<AdvancedDisplayBlockEntity> graphics, float pPartialTicks, AdvancedDisplayRenderInstance parent, int light, boolean backSide) {
        for (int i = 0; i < this.lines.length && i < this.maxLines; ++i) {
            for (int k = 0; k < this.lines[i].length; ++k) {
                if (((PlatformDisplayTableSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).showTimeAndDate() && i >= this.maxLines - 1 && DragonLib.getCurrentWorldTime() % 200L > 100L) {
                    this.timeLabel.render(graphics);
                    continue;
                }
                this.lines[i][k].render(graphics);
            }
        }
        if (((PlatformDisplayTableSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).showTimeAndDate() && this.lines.length < this.maxLines) {
            this.timeLabel.render(graphics);
        }
        if (this.showInfoLine) {
            this.statusLabel.render(graphics);
        }
    }

    @Override
    public void update(Level level, BlockPos pos, BlockState state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent, AdvancedDisplayBlockEntity.EUpdateReason reason) {
        ArrayList<StationDisplayData> preds = new ArrayList<StationDisplayData>();
        for (int i = 0; i < blockEntity.getStops().size(); ++i) {
            StationDisplayData data = blockEntity.getStops().get(i);
            if (i != 0 && (data.getStationData().getRealTimeArrivalTime() >= DragonLib.getCurrentWorldTime() + (long)((Integer)ModClientConfig.DISPLAY_LEAD_TIME.get()).intValue() || data.getTrainData().isCancelled() && DragonLib.getCurrentWorldTime() >= data.getStationData().getScheduledDepartureTime() + (long)((Integer)ModClientConfig.DISPLAY_LEAD_TIME.get()).intValue())) continue;
            preds.add(data);
        }
        this.showInfoLine = !preds.isEmpty() && (((StationDisplayData)preds.get(0)).getStationData().isDepartureDelayed() && ((StationDisplayData)preds.get(0)).getTrainData().hasStatusInfo() || ((StationDisplayData)preds.get(0)).getStationData().isStationChanged() || ((StationDisplayData)preds.get(0)).isNextSectionExcluded());
        this.infoLineText = this.showInfoLine ? TextUtils.concat((Component)TextUtils.text((String)"  +++  "), (Component[])((Component[])preds.stream().limit(this.maxLines).filter(x -> x.getTrainData().hasStatusInfo() && x.getStationData().isDepartureDelayed() || x.getStationData().isStationChanged() || x.isNextSectionExcluded()).map(x -> {
            ArrayList<Object> content = new ArrayList<Object>();
            if (x.getTrainData().isCancelled()) {
                return CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.cancelled");
            }
            if (x.isNextSectionExcluded()) {
                content.add(this.textTrainTerminatesHere);
            }
            if (x.getStationData().isDepartureDelayed()) {
                String delay = ((PlatformDisplayTableSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA ? ModUtils.timeRemainingString(x.getStationData().getDepartureTimeDeviation()) : String.valueOf((long)DLTime.fromTicks((double)x.getStationData().getDepartureTimeDeviation(), (ITimeSystem)new ConfiguredTimeSystem()).toGameMinutes());
                MutableComponent delayComponent = CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.delayed", delay);
                if (((PlatformDisplayTableSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ABS) {
                    delayComponent.m_130946_(" ").m_7220_((Component)CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.delay_abs_suffix"));
                }
                content.add(delayComponent);
            }
            if (x.getStationData().isStationChanged()) {
                if (!x.getStationData().getScheduledStation().tagId().equals(x.getStationData().getRealTimeStation().tagId())) {
                    content.add(CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.platform_and_station_changed", x.getStationData().getRealTimeStation().tagName(), x.getStationData().getRealTimeStation().info().platform()));
                } else {
                    content.add(CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.platform_changed", x.getStationData().getRealTimeStation().info().platform()));
                }
            }
            for (TrainStatus.CompiledTrainStatus status : x.getTrainData().getStatus()) {
                content.add(status.text());
            }
            return CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.information_about_train", x.getTrainData().getName()).m_7220_((Component)TextUtils.text((String)": ")).m_7220_((Component)TextUtils.concat((Component)TextUtils.text((String)" - "), content));
        }).toArray(Component[]::new))) : TextUtils.empty();
        int defaultMaxLines = blockEntity.getYSizeScaled() * 3 - 1;
        this.maxLines = defaultMaxLines - (this.showInfoLine ? 1 : 0);
        int maxIndices = Math.max(0, Math.min(this.maxLines, preds.size()));
        if (reason == AdvancedDisplayBlockEntity.EUpdateReason.LAYOUT_CHANGED || this.lines == null || this.lines.length != maxIndices) {
            this.updateLayout(blockEntity, preds, maxIndices);
        }
        for (int i = 0; i < this.lines.length; ++i) {
            StationDisplayData stop = (StationDisplayData)preds.get(i);
            this.updateContent(blockEntity, stop, i);
        }
        this.statusLabel.text.set((Object)this.infoLineText);
        this.statusLabel.position.set((Object)Point.of((double)3.0, (double)((float)(blockEntity.getYSizeScaled() * 16) - 12.0f * ((Float)this.statusLabel.verticalMaxScale.get()).floatValue() - 2.0f)));
        this.statusLabel.preferredWidth.set((Number)Float.valueOf((float)((Rectangle)this.statusLabel.clippingArea.get()).width() - 2.0f));
        NumberProperty numberProperty = this.statusLabel.preferredHeight;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        numberProperty.set((Number)Float.valueOf(9.0f * ((Float)this.statusLabel.verticalMaxScale.get()).floatValue()));
        this.statusLabel.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
        this.timeLabel.position.set((Object)Point.of((double)3.0, (double)(3.0f + (float)(Math.min(this.lines.length, this.maxLines) - (this.lines.length < this.maxLines ? 0 : 1)) * 5.4f)));
    }

    private void updateLayout(AdvancedDisplayBlockEntity blockEntity, List<StationDisplayData> preds, int maxIndices) {
        this.lines = new BERLabel[maxIndices][];
        for (int i = 0; i < this.lines.length; ++i) {
            StationDisplayData stop = preds.get(i);
            this.lines[i] = this.createLine(blockEntity, stop, i);
            this.updateContent(blockEntity, stop, i);
        }
        this.statusLabel.backgroundColor.set((Object)((PlatformDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor());
        this.statusLabel.color.set((Object)DLColor.pickBasedOnBrightness((DLColor)((PlatformDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor(), (DLColor)LIGHT_FONT_COLOR, (DLColor)DARK_FONT_COLOR, (float)0.5f));
        this.timeLabel.preferredWidth.set((Number)Float.valueOf((float)((Rectangle)this.timeLabel.clippingArea.get()).width()));
        this.timeLabel.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
        this.timeLabel.color.set((Object)((PlatformDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor());
    }

    private void updateContent(AdvancedDisplayBlockEntity blockEntity, StationDisplayData stop, int index) {
        PlatformDisplayTableSettings settings = (PlatformDisplayTableSettings)this.getDisplaySettings(blockEntity);
        boolean isLast = settings.showArrival() && stop.shouldShowArrivalOfTrain() || stop.isNextSectionExcluded();
        BERLabel[] components = this.lines[index];
        BERLabel timeComponent = components[LineComponent.TIME.i()];
        timeComponent.text.set((Object)TextUtils.text((String)ModUtils.formatTime(stop.getScheduledTime(), ((PlatformDisplayTableSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA)));
        BERLabel realTimeComponent = components[LineComponent.REAL_TIME.i()];
        realTimeComponent.text.set((Object)TextUtils.text((String)(stop.getTrainData().isCancelled() ? " \u274c " : (stop.getStationData().isDepartureDelayed() ? ModUtils.formatTime(stop.getRealTime(), ((PlatformDisplayTableSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA) : ""))));
        realTimeComponent.color.set((Object)DLColor.pickBasedOnBrightness((DLColor)((PlatformDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor(), (DLColor)LIGHT_FONT_COLOR, (DLColor)DARK_FONT_COLOR, (float)0.5f));
        BERLabel trainNameComponent = components[LineComponent.TRAIN_NAME.i()];
        trainNameComponent.text.set((Object)TextUtils.text((String)stop.getTrainData().getName()));
        if (settings.showLineColor() && stop.getTrainData().hasColor()) {
            trainNameComponent.backgroundColor.set((Object)stop.getTrainData().getColor());
            trainNameComponent.color.set((Object)DLColor.pickBasedOnBrightness((DLColor)stop.getTrainData().getColor(), (DLColor)LIGHT_FONT_COLOR, (DLColor)DARK_FONT_COLOR, (float)0.5f));
        } else {
            trainNameComponent.backgroundColor.set((Object)DLColor.TRANSPARENT);
            trainNameComponent.color.set((Object)settings.getFontColor());
        }
        BERLabel platformComponent = components[LineComponent.PLATFORM.i()];
        platformComponent.text.set((Object)TextUtils.text((String)stop.getStationData().getRealTimeStation().info().platform()));
        BERLabel destinationComponent = components[LineComponent.DESTINATION.i()];
        destinationComponent.text.set((Object)(isLast ? CustomLanguage.translate("gui.createrailwaysnavigator.schedule_board.train_from", stop.getFirstStopName()) : TextUtils.text((String)stop.getStationData().getDestination())));
        int x = 3;
        timeComponent.position.set((Object)Point.of((double)x, (double)(3.0f + (float)index * 5.4f)));
        x = (int)((float)x + (timeComponent.getRenderedWidth() + 2.0f));
        realTimeComponent.position.set((Object)Point.of((double)x, (double)(3.0f + (float)index * 5.4f)));
        x = (int)((float)x + (realTimeComponent.getRenderedWidth() + 2.0f + (float)(((Component)realTimeComponent.text.get()).getString().isEmpty() ? 0 : 2)));
        trainNameComponent.position.set((Object)Point.of((double)x, (double)(3.0f + (float)index * 5.4f)));
        float trainNameWidth = Math.min(settings.isAutoTrainNameWidth() ? trainNameComponent.getRenderedWidth() : (float)settings.getTrainNameWidth(), (float)(blockEntity.getXSizeScaled() * 16 - 3) - ((Float)trainNameComponent.x.get()).floatValue());
        trainNameComponent.preferredWidth.set((Number)Float.valueOf(trainNameWidth));
        trainNameComponent.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
        x = (int)((float)x + (trainNameWidth + 2.0f));
        float platformWidth = settings.isAutoPlatformWidth() ? platformComponent.getRenderedWidth() : (float)settings.getPlatformWidth();
        platformComponent.position.set((Object)Point.of((double)((float)(blockEntity.getXSizeScaled() * 16 - 3) - platformWidth), (double)(3.0f + (float)index * 5.4f)));
        platformComponent.preferredWidth.set((Number)Float.valueOf(platformWidth));
        platformComponent.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
        if (stop.getStationData().isStationChanged()) {
            platformComponent.backgroundColor.set((Object)((PlatformDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor());
            platformComponent.color.set((Object)DARK_FONT_COLOR);
        } else {
            platformComponent.backgroundColor.set((Object)DLColor.TRANSPARENT);
            platformComponent.color.set((Object)((PlatformDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor());
        }
        destinationComponent.position.set((Object)Point.of((double)x, (double)(3.0f + (float)index * 5.4f)));
        destinationComponent.preferredWidth.set((Number)Float.valueOf((float)(blockEntity.getXSizeScaled() * 16 - 3 - x) - platformWidth - 3.0f));
        destinationComponent.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
    }

    private BERLabel[] createLine(AdvancedDisplayBlockEntity blockEntity, StationDisplayData stop, int index) {
        BERLabel[] components = new BERLabel[LineComponent.values().length];
        BERLabel bERLabel = new BERLabel();
        components[LineComponent.TIME.i()] = bERLabel;
        BERLabel timeComponent = bERLabel;
        timeComponent.clippingArea.set((Object)Rectangle.withSize((double)2.0, (double)2.0, (double)(blockEntity.getXSizeScaled() * 16 - 4), (double)(blockEntity.getYSizeScaled() * 16 - 4)));
        timeComponent.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.4f), (Object)Float.valueOf(0.4f)));
        timeComponent.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.2f), (Object)Float.valueOf(0.4f)));
        timeComponent.preferredWidth.set((Number)Float.valueOf(12.0f));
        timeComponent.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
        timeComponent.color.set((Object)((PlatformDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor());
        BERLabel bERLabel2 = new BERLabel();
        components[LineComponent.REAL_TIME.i()] = bERLabel2;
        BERLabel realTimeComponent = bERLabel2;
        realTimeComponent.clippingArea.set((Object)Rectangle.withSize((double)2.0, (double)2.0, (double)(blockEntity.getXSizeScaled() * 16 - 4), (double)(blockEntity.getYSizeScaled() * 16 - 4)));
        realTimeComponent.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.4f), (Object)Float.valueOf(0.4f)));
        realTimeComponent.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.2f), (Object)Float.valueOf(0.4f)));
        realTimeComponent.preferredWidth.set((Number)Float.valueOf(12.0f));
        realTimeComponent.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
        realTimeComponent.backgroundColor.set((Object)((PlatformDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor());
        realTimeComponent.color.set((Object)DARK_FONT_COLOR);
        realTimeComponent.backgroundPadding.set((Object)new PaddingF(0.5f));
        BERLabel bERLabel3 = new BERLabel();
        components[LineComponent.TRAIN_NAME.i()] = bERLabel3;
        BERLabel trainNameComponent = bERLabel3;
        trainNameComponent.clippingArea.set((Object)Rectangle.withSize((double)2.0, (double)2.0, (double)(blockEntity.getXSizeScaled() * 16 - 4), (double)(blockEntity.getYSizeScaled() * 16 - 4)));
        trainNameComponent.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.4f), (Object)Float.valueOf(0.4f)));
        trainNameComponent.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.2f), (Object)Float.valueOf(0.4f)));
        trainNameComponent.horizontalScrollingSpeed.set((Number)Float.valueOf(12.0f));
        trainNameComponent.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
        trainNameComponent.color.set((Object)((PlatformDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor());
        trainNameComponent.backgroundPadding.set((Object)new PaddingF(0.5f));
        BERLabel bERLabel4 = new BERLabel();
        components[LineComponent.PLATFORM.i()] = bERLabel4;
        BERLabel platformComponent = bERLabel4;
        platformComponent.clippingArea.set((Object)Rectangle.withSize((double)2.0, (double)2.0, (double)(blockEntity.getXSizeScaled() * 16 - 4), (double)(blockEntity.getYSizeScaled() * 16 - 4)));
        platformComponent.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.4f), (Object)Float.valueOf(0.4f)));
        platformComponent.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.2f), (Object)Float.valueOf(0.4f)));
        platformComponent.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
        platformComponent.horizontalAlign.set((Object)ETextAlignment.RIGHT);
        platformComponent.color.set((Object)((PlatformDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor());
        platformComponent.backgroundPadding.set((Object)new PaddingF(0.5f));
        BERLabel bERLabel5 = new BERLabel();
        components[LineComponent.DESTINATION.i()] = bERLabel5;
        BERLabel destinationComponent = bERLabel5;
        destinationComponent.clippingArea.set((Object)Rectangle.withSize((double)2.0, (double)2.0, (double)(blockEntity.getXSizeScaled() * 16 - 4), (double)(blockEntity.getYSizeScaled() * 16 - 4)));
        destinationComponent.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.4f), (Object)Float.valueOf(0.4f)));
        destinationComponent.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.2f), (Object)Float.valueOf(0.4f)));
        destinationComponent.horizontalScrollingSpeed.set((Number)Float.valueOf(12.0f));
        destinationComponent.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
        destinationComponent.color.set((Object)((PlatformDisplayTableSettings)this.getDisplaySettings(blockEntity)).getFontColor());
        return components;
    }

    private static enum LineComponent {
        TIME(0),
        REAL_TIME(1),
        TRAIN_NAME(2),
        DESTINATION(3),
        PLATFORM(4);

        int index;

        private LineComponent(int index) {
            this.index = index;
        }

        public int i() {
            return this.index;
        }
    }
}

