/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.ber.variants;

import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.block.display.properties.PlatformDisplayFocusSettings;
import de.mrjulsen.crn.block.properties.ETimeDisplay;
import de.mrjulsen.crn.client.ber.AdvancedDisplayRenderInstance;
import de.mrjulsen.crn.client.ber.variants.AbstractAdvancedDisplayRenderer;
import de.mrjulsen.crn.client.lang.CustomLanguage;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.train.TrainStatus;
import de.mrjulsen.crn.data.train.portable.StationDisplayData;
import de.mrjulsen.crn.data.train.portable.TrainStopDisplayData;
import de.mrjulsen.crn.util.ModUtils;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.ber.BERGraphics;
import de.mrjulsen.mcdragonlib.client.ber.BERLabel;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.PaddingF;
import de.mrjulsen.mcdragonlib.client.util.DLGraphics;
import de.mrjulsen.mcdragonlib.client.util.RenderUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.Pair;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Point;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.mcdragonlib.util.properties.NumberProperty;
import de.mrjulsen.mcdragonlib.util.time.ConfiguredTimeSystem;
import de.mrjulsen.mcdragonlib.util.time.DLTime;
import de.mrjulsen.mcdragonlib.util.time.ITimeSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3f;

public class BERPlatformInformative
implements AbstractAdvancedDisplayRenderer<PlatformDisplayFocusSettings> {
    private static final String keyFollowingTrains = "gui.createrailwaysnavigator.following_trains";
    private final MutableComponent textTrainTerminatesHere = CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.train_terminates");
    private static final float LINE_HEIGHT = 5.4f;
    private int maxLines = 0;
    private boolean showInfoLine = false;
    private Component infoLineText = TextUtils.empty();
    private BERLabel statusLabel;
    private BERLabel[] focusArea;
    private BERLabel[][] lines;
    private final BERLabel platformLabel = new BERLabel();
    private final BERLabel followingTrainsLabel = new BERLabel();

    public BERPlatformInformative() {
        this.platformLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.8f), (Object)Float.valueOf(0.8f)));
        this.platformLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.4f), (Object)Float.valueOf(0.6f)));
        this.followingTrainsLabel.text.set((Object)CustomLanguage.translate(keyFollowingTrains));
        this.followingTrainsLabel.position.set((Object)Point.of((double)3.0, (double)16.0));
        this.followingTrainsLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.2f), (Object)Float.valueOf(0.2f)));
        this.followingTrainsLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.2f), (Object)Float.valueOf(0.2f)));
    }

    private boolean isExtendedDisplay(AdvancedDisplayBlockEntity blockEntity) {
        return blockEntity.getYSize() > 1;
    }

    @Override
    public void render(BERGraphics<AdvancedDisplayBlockEntity> graphics, float pPartialTicks, AdvancedDisplayRenderInstance parent, int light, boolean backSide) {
        if (this.isExtendedDisplay((AdvancedDisplayBlockEntity)graphics.blockEntity())) {
            RenderUtils.fillColor(graphics, (Vector3f)new Vector3f(2.5f, 15.5f, 0.0f), (float)(((AdvancedDisplayBlockEntity)graphics.blockEntity()).getXSizeScaled() * 16 - 5), (float)0.25f, (DLColor)((PlatformDisplayFocusSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).getFontColor(), (Direction)((Direction)((AdvancedDisplayBlockEntity)graphics.blockEntity()).m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)), (int)(((AdvancedDisplayBlockEntity)graphics.blockEntity()).isGlowing() ? 0xF000F0 : light), (boolean)false);
            this.followingTrainsLabel.render(graphics);
        }
        DLUtils.doIfNotNull((Object)this.focusArea, a -> {
            for (int i = 0; i < ((BERLabel[])a).length; ++i) {
                BERLabel label = a[i];
                if (label == null) continue;
                graphics.poseStack().m_85836_();
                if (backSide) {
                    float maxWidth = ((AdvancedDisplayBlockEntity)graphics.blockEntity()).getXSizeScaled() * 16;
                    if (i == LineComponent.TIME.i()) {
                        graphics.poseStack().m_252880_(-((Float)label.x.get()).floatValue() + maxWidth - 3.0f - label.getRenderedWidth(), 0.0f, 0.0f);
                    } else if (i == LineComponent.REAL_TIME.i()) {
                        graphics.poseStack().m_252880_(-((Float)label.x.get()).floatValue() + maxWidth - 3.0f - label.getRenderedWidth(), 0.0f, 0.0f);
                    } else if (i == LineComponent.TRAIN_NAME.i()) {
                        graphics.poseStack().m_252880_(-((Float)label.x.get()).floatValue() + maxWidth - 3.0f - label.getRenderedWidth(), 0.0f, 0.0f);
                    } else if (i == LineComponent.DESTINATION.i()) {
                        graphics.poseStack().m_252880_(-((Float)label.x.get()).floatValue() + 5.0f + ((Float)this.platformLabel.preferredWidth.get()).floatValue(), 0.0f, 0.0f);
                    } else if (i == LineComponent.STOPOVERS.i()) {
                        graphics.poseStack().m_252880_(-((Float)label.x.get()).floatValue() + 5.0f + ((Float)this.platformLabel.preferredWidth.get()).floatValue(), 0.0f, 0.0f);
                    } else if (i == LineComponent.PLATFORM.i()) {
                        graphics.poseStack().m_252880_(-((Float)label.x.get()).floatValue() + 3.0f, 0.0f, 0.0f);
                    }
                }
                label.render((DLGraphics)graphics);
                graphics.poseStack().m_85849_();
            }
        });
        DLUtils.doIfNotNull((Object)this.lines, x -> {
            for (BERLabel[] line : x) {
                if (line == null) continue;
                for (BERLabel label : line) {
                    if (label == null) continue;
                    label.render((DLGraphics)graphics, light);
                }
            }
        });
        graphics.poseStack().m_85836_();
        if (this.statusLabel != null && !((Component)this.statusLabel.text.get()).getString().isBlank()) {
            graphics.poseStack().m_85836_();
            if (backSide) {
                graphics.poseStack().m_252880_(-((Float)this.statusLabel.x.get()).floatValue() + 5.0f + ((Float)this.platformLabel.preferredWidth.get()).floatValue(), 0.0f, 0.0f);
            }
            DLUtils.doIfNotNull((Object)this.statusLabel, x -> x.render((DLGraphics)graphics, light));
            graphics.poseStack().m_85849_();
        }
        if (backSide && this.platformLabel != null) {
            graphics.poseStack().m_252880_((float)(-((AdvancedDisplayBlockEntity)graphics.blockEntity()).getXSizeScaled() * 16 + 6) + this.platformLabel.getRenderedWidth(), 0.0f, 0.0f);
        }
        this.platformLabel.render(graphics, light);
        graphics.poseStack().m_85849_();
    }

    @Override
    public void update(Level level, BlockPos pos, BlockState state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent, AdvancedDisplayBlockEntity.EUpdateReason reason) {
        List<StationDisplayData> preds = blockEntity.getStops().stream().filter(x -> !x.getTrainData().isCancelled() || DragonLib.getCurrentWorldTime() < x.getStationData().getScheduledDepartureTime() + (long)((Integer)ModClientConfig.DISPLAY_LEAD_TIME.get()).intValue()).toList();
        if (preds.isEmpty()) {
            this.lines = null;
            this.focusArea = null;
            this.statusLabel = null;
            this.platformLabel.text.set((Object)TextUtils.text((String)(blockEntity.isPlatformFixed() && blockEntity.getStationInfo() != null ? blockEntity.getStationInfo().platform() : "")).m_130940_(ChatFormatting.BOLD));
            float platformWidth = ((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).isAutoPlatformWidthNextStop() ? this.platformLabel.getRenderedWidth() : (float)((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getPlatformWidthNextStop();
            this.platformLabel.position.set((Object)Point.of((double)((float)(blockEntity.getXSizeScaled() * 16 - 3) - platformWidth), (double)3.0));
            this.platformLabel.horizontalAlign.set((Object)ETextAlignment.RIGHT);
            this.platformLabel.preferredWidth.set((Number)Float.valueOf(platformWidth));
            this.platformLabel.color.set((Object)((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor());
            return;
        }
        if (reason == AdvancedDisplayBlockEntity.EUpdateReason.LAYOUT_CHANGED || this.lines == null || this.focusArea == null) {
            this.updateLayout(blockEntity, preds);
        }
        boolean bl = this.showInfoLine = preds.get(0).getStationData().isDepartureDelayed() && preds.get(0).getTrainData().hasStatusInfo() || preds.get(0).getStationData().isStationChanged() || preds.get(0).isNextSectionExcluded();
        if (this.showInfoLine) {
            ArrayList<Object> content = new ArrayList<Object>();
            if (preds.get(0).getTrainData().isCancelled()) {
                content.add(CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.cancelled"));
            } else {
                String delay;
                TrainStopDisplayData displayData = preds.get(0).getStationData();
                String string = delay = ((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA ? ModUtils.timeRemainingString(displayData.getDepartureTimeDeviation()) : String.valueOf((long)DLTime.fromTicks((double)displayData.getDepartureTimeDeviation(), (ITimeSystem)new ConfiguredTimeSystem()).toGameMinutes());
                if (preds.get(0).isNextSectionExcluded()) {
                    content.add(this.textTrainTerminatesHere);
                }
                if (displayData.isDepartureDelayed()) {
                    MutableComponent delayComponent = CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.delayed", delay);
                    if (((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ABS) {
                        delayComponent.m_130946_(" ").m_7220_((Component)CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.delay_abs_suffix"));
                    }
                    content.add(delayComponent);
                }
                if (displayData.isStationChanged() && !blockEntity.isAllowedOnDisplay(displayData.getRealTimeStation())) {
                    if (!displayData.getScheduledStation().tagId().equals(displayData.getRealTimeStation().tagId())) {
                        content.add(CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.platform_and_station_changed", displayData.getRealTimeStation().tagName(), displayData.getRealTimeStation().info().platform()));
                    } else {
                        content.add(CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.platform_changed", displayData.getRealTimeStation().info().platform()));
                    }
                }
                for (TrainStatus.CompiledTrainStatus status : preds.get(0).getTrainData().getStatus()) {
                    content.add(status.text());
                }
            }
            this.infoLineText = TextUtils.concat((Component)TextUtils.text((String)"  +++  "), content);
        } else {
            this.infoLineText = TextUtils.empty();
        }
        this.updateFocusContent(blockEntity, preds.get(0));
        for (int i = 1; i < this.lines.length && i < preds.size(); ++i) {
            StationDisplayData stop = preds.get(i);
            this.updateTableContent(blockEntity, stop, i);
        }
    }

    private void updateLayout(AdvancedDisplayBlockEntity blockEntity, List<StationDisplayData> preds) {
        this.focusArea = new BERLabel[7];
        this.lines = new BERLabel[0][];
        this.platformLabel.clippingArea.set((Object)Rectangle.withSize((double)2.0, (double)2.0, (double)(blockEntity.getXSizeScaled() * 16 - 4), (double)(blockEntity.getYSizeScaled() * 16 - 4)));
        this.platformLabel.glowing.set((Object)blockEntity.isGlowing());
        this.followingTrainsLabel.clippingArea.set((Object)Rectangle.withSize((double)2.0, (double)2.0, (double)(blockEntity.getXSizeScaled() * 16 - 4), (double)(blockEntity.getYSizeScaled() * 16 - 4)));
        this.followingTrainsLabel.glowing.set((Object)blockEntity.isGlowing());
        this.followingTrainsLabel.color.set((Object)((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor());
        this.platformLabel.color.set((Object)((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor());
        BERLabel bERLabel = new BERLabel();
        this.focusArea[LineComponent.TIME.i()] = bERLabel;
        BERLabel timeLabel = bERLabel;
        timeLabel.position.set((Object)Point.of((double)3.0, (double)3.0));
        timeLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.4f), (Object)Float.valueOf(0.4f)));
        timeLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.2f), (Object)Float.valueOf(0.4f)));
        timeLabel.color.set((Object)((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor());
        BERLabel bERLabel2 = new BERLabel();
        this.focusArea[LineComponent.REAL_TIME.i()] = bERLabel2;
        BERLabel realTimeLabel = bERLabel2;
        realTimeLabel.position.set((Object)Point.of((double)3.0, (double)7.0));
        realTimeLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.4f), (Object)Float.valueOf(0.4f)));
        realTimeLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.2f), (Object)Float.valueOf(0.4f)));
        realTimeLabel.backgroundColor.set((Object)((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor());
        realTimeLabel.backgroundPadding.set((Object)new PaddingF(0.5f));
        realTimeLabel.color.set((Object)DARK_FONT_COLOR);
        BERLabel bERLabel3 = new BERLabel();
        this.focusArea[LineComponent.TRAIN_NAME.i()] = bERLabel3;
        BERLabel trainNameLabel = bERLabel3;
        trainNameLabel.position.set((Object)Point.of((double)3.0, (double)7.0));
        trainNameLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.3f), (Object)Float.valueOf(0.3f)));
        trainNameLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.15f), (Object)Float.valueOf(0.3f)));
        trainNameLabel.preferredWidth.set((Number)Float.valueOf(12.0f));
        trainNameLabel.horizontalScrollMode.set((Object)BERLabel.EScrollMode.FLEX_FIT);
        trainNameLabel.backgroundPadding.set((Object)new PaddingF(0.5f));
        trainNameLabel.color.set((Object)((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor());
        BERLabel bERLabel4 = new BERLabel();
        this.focusArea[LineComponent.DESTINATION.i()] = bERLabel4;
        BERLabel destinationLabel = bERLabel4;
        destinationLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.6f), (Object)Float.valueOf(0.6f)));
        destinationLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.4f), (Object)Float.valueOf(0.6f)));
        destinationLabel.horizontalScrollingSpeed.set((Number)Float.valueOf(12.0f));
        destinationLabel.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
        destinationLabel.color.set((Object)((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor());
        BERLabel bERLabel5 = new BERLabel();
        this.focusArea[LineComponent.STOPOVERS.i()] = bERLabel5;
        BERLabel stopoversLabel = bERLabel5;
        stopoversLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.2f), (Object)Float.valueOf(0.2f)));
        stopoversLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.1f), (Object)Float.valueOf(0.2f)));
        stopoversLabel.horizontalScrollingSpeed.set((Number)Float.valueOf(12.0f));
        stopoversLabel.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
        stopoversLabel.color.set((Object)((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor());
        this.statusLabel = new BERLabel();
        this.statusLabel.text.set((Object)this.infoLineText);
        this.statusLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.3f), (Object)Float.valueOf(0.3f)));
        this.statusLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.3f), (Object)Float.valueOf(0.3f)));
        NumberProperty numberProperty = this.statusLabel.preferredHeight;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        numberProperty.set((Number)Float.valueOf(9.0f * ((Float)this.statusLabel.verticalMaxScale.get()).floatValue()));
        this.statusLabel.horizontalScrollingSpeed.set((Number)Float.valueOf(12.0f));
        this.statusLabel.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
        this.statusLabel.backgroundColor.set((Object)((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor());
        this.statusLabel.backgroundPadding.set((Object)new PaddingF(0.5f));
        this.statusLabel.fullBackground.set((Object)true);
        this.statusLabel.color.set((Object)DARK_FONT_COLOR);
        if (this.isExtendedDisplay(blockEntity)) {
            this.maxLines = (blockEntity.getYSizeScaled() - 1) * 3;
            int maxIndices = Math.min(this.maxLines, preds.size());
            this.lines = new BERLabel[Math.max(maxIndices, 0)][];
            for (int i = 1; i < this.lines.length; ++i) {
                StationDisplayData stop = preds.get(i);
                this.lines[i] = this.createTableLine(blockEntity, stop, i);
            }
        }
        DLUtils.doIfNotNull((Object)this.statusLabel, l -> {
            l.clippingArea.set((Object)Rectangle.withSize((double)2.0, (double)2.0, (double)(blockEntity.getXSizeScaled() * 16 - 4), (double)(blockEntity.getYSizeScaled() * 16 - 4)));
            l.glowing.set((Object)blockEntity.isGlowing());
        });
        DLUtils.doIfNotNull((Object)this.focusArea, x -> {
            for (int i = 0; i < ((BERLabel[])x).length; ++i) {
                DLUtils.doIfNotNull((Object)x[i], l -> {
                    l.clippingArea.set((Object)Rectangle.withSize((double)2.0, (double)2.0, (double)(blockEntity.getXSizeScaled() * 16 - 4), (double)(blockEntity.getYSizeScaled() * 16 - 4)));
                    l.glowing.set((Object)blockEntity.isGlowing());
                });
            }
        });
        DLUtils.doIfNotNull((Object)this.lines, x -> {
            for (int i = 0; i < ((BERLabel[][])x).length; ++i) {
                DLUtils.doIfNotNull((Object)x[i], y -> {
                    for (int j = 0; j < ((BERLabel[])y).length; ++j) {
                        DLUtils.doIfNotNull((Object)y[j], l -> {
                            l.clippingArea.set((Object)Rectangle.withSize((double)2.0, (double)2.0, (double)(blockEntity.getXSizeScaled() * 16 - 4), (double)(blockEntity.getYSizeScaled() * 16 - 4)));
                            l.glowing.set((Object)blockEntity.isGlowing());
                        });
                    }
                });
            }
        });
    }

    private BERLabel[] createTableLine(AdvancedDisplayBlockEntity blockEntity, StationDisplayData stop, int index) {
        BERLabel[] components = new BERLabel[5];
        BERLabel bERLabel = new BERLabel();
        components[LineComponent.TIME.i()] = bERLabel;
        BERLabel timeLabel = bERLabel;
        timeLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.4f), (Object)Float.valueOf(0.4f)));
        timeLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.2f), (Object)Float.valueOf(0.4f)));
        timeLabel.horizontalScrollingSpeed.set((Number)Float.valueOf(12.0f));
        timeLabel.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
        timeLabel.preferredWidth.set((Number)Float.valueOf(12.0f));
        timeLabel.color.set((Object)((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor());
        BERLabel bERLabel2 = new BERLabel();
        components[LineComponent.REAL_TIME.i()] = bERLabel2;
        BERLabel realTimeLabel = bERLabel2;
        realTimeLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.4f), (Object)Float.valueOf(0.4f)));
        realTimeLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.2f), (Object)Float.valueOf(0.4f)));
        realTimeLabel.horizontalScrollingSpeed.set((Number)Float.valueOf(12.0f));
        realTimeLabel.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
        realTimeLabel.preferredWidth.set((Number)Float.valueOf(12.0f));
        realTimeLabel.backgroundColor.set((Object)((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor());
        realTimeLabel.backgroundPadding.set((Object)new PaddingF(0.5f));
        realTimeLabel.color.set((Object)DARK_FONT_COLOR);
        BERLabel bERLabel3 = new BERLabel();
        components[LineComponent.TRAIN_NAME.i()] = bERLabel3;
        BERLabel trainNameLabel = bERLabel3;
        trainNameLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.4f), (Object)Float.valueOf(0.4f)));
        trainNameLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.2f), (Object)Float.valueOf(0.4f)));
        trainNameLabel.horizontalScrollingSpeed.set((Number)Float.valueOf(12.0f));
        trainNameLabel.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
        trainNameLabel.color.set((Object)((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor());
        trainNameLabel.backgroundPadding.set((Object)new PaddingF(0.5f));
        BERLabel bERLabel4 = new BERLabel();
        components[LineComponent.PLATFORM.i()] = bERLabel4;
        BERLabel platformLabel = bERLabel4;
        platformLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.4f), (Object)Float.valueOf(0.4f)));
        platformLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.2f), (Object)Float.valueOf(0.4f)));
        platformLabel.color.set((Object)((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor());
        platformLabel.backgroundPadding.set((Object)new PaddingF(0.5f));
        BERLabel bERLabel5 = new BERLabel();
        components[LineComponent.DESTINATION.i()] = bERLabel5;
        BERLabel destinationLabel = bERLabel5;
        destinationLabel.verticalScale.set((Object)Pair.of((Object)Float.valueOf(0.4f), (Object)Float.valueOf(0.4f)));
        destinationLabel.horizontalScale.set((Object)Pair.of((Object)Float.valueOf(0.2f), (Object)Float.valueOf(0.4f)));
        destinationLabel.horizontalScrollingSpeed.set((Number)Float.valueOf(12.0f));
        destinationLabel.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
        destinationLabel.color.set((Object)((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor());
        return components;
    }

    private void updateFocusContent(AdvancedDisplayBlockEntity blockEntity, StationDisplayData stop) {
        PlatformDisplayFocusSettings settings = (PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity);
        boolean isLast = settings.showArrival() && stop.shouldShowArrivalOfTrain() || stop.isNextSectionExcluded();
        this.followingTrainsLabel.color.set((Object)((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor());
        BERLabel timeLabel = this.focusArea[LineComponent.TIME.i()];
        timeLabel.text.set((Object)TextUtils.text((String)ModUtils.formatTime(stop.getScheduledTime(), ((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA)));
        BERLabel realTimeLabel = this.focusArea[LineComponent.REAL_TIME.i()];
        realTimeLabel.text.set((Object)TextUtils.text((String)(stop.isDelayed() ? ModUtils.formatTime(stop.getRealTime(), ((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA) : "")));
        realTimeLabel.color.set((Object)DLColor.pickBasedOnBrightness((DLColor)((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor(), (DLColor)LIGHT_FONT_COLOR, (DLColor)DARK_FONT_COLOR, (float)0.5f));
        byte trainNameWidth = settings.getTrainNameWidthNextStop();
        BERLabel trainNameLabel = this.focusArea[LineComponent.TRAIN_NAME.i()];
        trainNameLabel.text.set((Object)TextUtils.text((String)stop.getTrainData().getName()));
        trainNameLabel.position.set((Object)Point.of((double)3.0, (double)(7.0f + (stop.isDelayed() ? 4.5f : 0.0f))));
        trainNameLabel.preferredWidth.set((Number)Float.valueOf(settings.isAutoTrainNameWidthNextStop() ? (float)((Rectangle)trainNameLabel.clippingArea.get()).width() : (float)trainNameWidth));
        trainNameLabel.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
        if (settings.showLineColor() && stop.getTrainData().hasColor()) {
            trainNameLabel.backgroundColor.set((Object)stop.getTrainData().getColor());
            trainNameLabel.color.set((Object)DLColor.pickBasedOnBrightness((DLColor)stop.getTrainData().getColor(), (DLColor)LIGHT_FONT_COLOR, (DLColor)DARK_FONT_COLOR, (float)0.5f));
        } else {
            trainNameLabel.backgroundColor.set((Object)DLColor.TRANSPARENT);
            trainNameLabel.color.set((Object)((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor());
        }
        this.platformLabel.text.set((Object)TextUtils.text((String)(blockEntity.isPlatformFixed() ? blockEntity.getStationInfo().platform() : stop.getStationData().getRealTimeStation().info().platform())).m_130940_(ChatFormatting.BOLD));
        float x = 5.0f + Math.max(trainNameLabel.getRenderedWidth(), Math.max(timeLabel.getRenderedWidth(), realTimeLabel.getRenderedWidth()));
        float platformWidth = ((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).isAutoPlatformWidthNextStop() ? this.platformLabel.getRenderedWidth() : (float)((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getPlatformWidthNextStop();
        this.platformLabel.position.set((Object)Point.of((double)((float)(blockEntity.getXSizeScaled() * 16 - 3) - platformWidth), (double)3.0));
        this.platformLabel.preferredWidth.set((Number)Float.valueOf(platformWidth));
        this.platformLabel.horizontalAlign.set((Object)ETextAlignment.RIGHT);
        this.platformLabel.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
        float w = (float)(blockEntity.getXSizeScaled() * 16 - 5) - this.platformLabel.getRenderedWidth() - x;
        BERLabel destinationLabel = this.focusArea[LineComponent.DESTINATION.i()];
        destinationLabel.text.set((Object)(isLast ? CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.arrival") : TextUtils.text((String)stop.getStationData().getDestination())));
        destinationLabel.position.set((Object)Point.of((double)x, (double)9.0));
        destinationLabel.preferredWidth.set((Number)Float.valueOf(w));
        destinationLabel.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
        BERLabel stopoversLabel = this.focusArea[LineComponent.STOPOVERS.i()];
        stopoversLabel.text.set((Object)(isLast ? CustomLanguage.translate("gui.createrailwaysnavigator.schedule_board.train_from", stop.getFirstStopName()) : TextUtils.concat((Component)TextUtils.text((String)" \u25cf "), stop.getStopovers().stream().map(a -> TextUtils.text((String)a)).toList())));
        stopoversLabel.position.set((Object)Point.of((double)x, (double)6.5));
        stopoversLabel.preferredWidth.set((Number)Float.valueOf(w));
        stopoversLabel.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
        this.statusLabel.text.set((Object)this.infoLineText);
        this.statusLabel.position.set((Object)Point.of((double)x, (double)2.5));
        this.statusLabel.preferredWidth.set((Number)Float.valueOf(w));
        this.statusLabel.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
        this.statusLabel.color.set((Object)DLColor.pickBasedOnBrightness((DLColor)((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor(), (DLColor)LIGHT_FONT_COLOR, (DLColor)DARK_FONT_COLOR, (float)0.5f));
    }

    private void updateTableContent(AdvancedDisplayBlockEntity blockEntity, StationDisplayData stop, int index) {
        PlatformDisplayFocusSettings settings = (PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity);
        boolean isLast = settings.showArrival() && stop.shouldShowArrivalOfTrain() || stop.isNextSectionExcluded();
        BERLabel[] components = this.lines[index];
        BERLabel timeLabel = components[LineComponent.TIME.i()];
        timeLabel.text.set((Object)TextUtils.text((String)ModUtils.formatTime(stop.getScheduledTime(), ((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA)));
        BERLabel realTimeLabel = components[LineComponent.REAL_TIME.i()];
        realTimeLabel.text.set((Object)TextUtils.text((String)(stop.getTrainData().isCancelled() ? " \u274c " : (stop.getStationData().isDepartureDelayed() ? ModUtils.formatTime(isLast ? stop.getStationData().getRealTimeArrivalTime() : stop.getStationData().getRealTimeDepartureTime(), ((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA) : ""))));
        realTimeLabel.color.set((Object)DLColor.pickBasedOnBrightness((DLColor)((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor(), (DLColor)LIGHT_FONT_COLOR, (DLColor)DARK_FONT_COLOR, (float)0.5f));
        BERLabel trainNameLabel = components[LineComponent.TRAIN_NAME.i()];
        trainNameLabel.text.set((Object)TextUtils.text((String)stop.getTrainData().getName()));
        if (settings.showLineColor() && stop.getTrainData().hasColor()) {
            trainNameLabel.backgroundColor.set((Object)stop.getTrainData().getColor());
            trainNameLabel.color.set((Object)DLColor.pickBasedOnBrightness((DLColor)stop.getTrainData().getColor(), (DLColor)LIGHT_FONT_COLOR, (DLColor)DARK_FONT_COLOR, (float)0.5f));
        } else {
            trainNameLabel.backgroundColor.set((Object)DLColor.TRANSPARENT);
            trainNameLabel.color.set((Object)((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor());
        }
        BERLabel platformLabel = components[LineComponent.PLATFORM.i()];
        platformLabel.text.set((Object)(blockEntity.isPlatformFixed() ? TextUtils.empty() : TextUtils.text((String)stop.getStationData().getRealTimeStation().info().platform())));
        BERLabel destinationLabel = components[LineComponent.DESTINATION.i()];
        destinationLabel.text.set((Object)(isLast ? CustomLanguage.translate("gui.createrailwaysnavigator.schedule_board.train_from", stop.getFirstStopName()) : TextUtils.text((String)stop.getStationData().getDestination())));
        int x = 3;
        timeLabel.position.set((Object)Point.of((double)x, (double)(14.0f + (float)index * 5.4f)));
        x = (int)((float)x + (timeLabel.getRenderedWidth() + 2.0f));
        realTimeLabel.position.set((Object)Point.of((double)x, (double)(14.0f + (float)index * 5.4f)));
        x = (int)((float)x + (realTimeLabel.getRenderedWidth() + 2.0f + (float)(!((Component)realTimeLabel.text.get()).getString().isEmpty() ? 2 : 0)));
        float trainNameWidth = settings.isAutoTrainNameWidth() ? trainNameLabel.getRenderedWidth() : (float)settings.getTrainNameWidth();
        trainNameLabel.position.set((Object)Point.of((double)x, (double)(14.0f + (float)index * 5.4f)));
        trainNameLabel.preferredWidth.set((Number)Float.valueOf(trainNameWidth));
        trainNameLabel.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
        x = (int)((float)x + (trainNameWidth + 2.0f));
        float platformWidth = settings.isAutoPlatformWidth() ? platformLabel.getRenderedWidth() : (float)settings.getPlatformWidth();
        platformLabel.position.set((Object)Point.of((double)((float)(blockEntity.getXSizeScaled() * 16 - 3) - platformWidth), (double)(14.0f + (float)index * 5.4f)));
        platformLabel.horizontalAlign.set((Object)ETextAlignment.RIGHT);
        platformLabel.preferredWidth.set((Number)Float.valueOf(platformWidth));
        platformLabel.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
        platformLabel.backgroundPadding.set((Object)new PaddingF(0.5f));
        if (stop.getStationData().isStationChanged()) {
            platformLabel.backgroundColor.set((Object)((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor());
            platformLabel.color.set((Object)DARK_FONT_COLOR);
        } else {
            platformLabel.backgroundColor.set((Object)DLColor.TRANSPARENT);
            platformLabel.color.set((Object)((PlatformDisplayFocusSettings)this.getDisplaySettings(blockEntity)).getFontColor());
        }
        destinationLabel.position.set((Object)Point.of((double)x, (double)(14.0f + (float)index * 5.4f)));
        destinationLabel.preferredWidth.set((Number)Float.valueOf((float)(blockEntity.getXSizeScaled() * 16 - 3 - x) - platformWidth - 3.0f));
        destinationLabel.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
    }

    private static enum LineComponent {
        TIME(0),
        REAL_TIME(1),
        TRAIN_NAME(2),
        DESTINATION(3),
        PLATFORM(4),
        STOPOVERS(5);

        int index;

        private LineComponent(int index) {
            this.index = index;
        }

        public int i() {
            return this.index;
        }
    }
}

