/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.ber.variants;

import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.block.display.properties.SimpleStaticTextDisplaySettings;
import de.mrjulsen.crn.client.ber.AdvancedDisplayRenderInstance;
import de.mrjulsen.crn.client.ber.variants.AbstractAdvancedDisplayRenderer;
import de.mrjulsen.crn.util.VariableManager;
import de.mrjulsen.mcdragonlib.client.ber.BERGraphics;
import de.mrjulsen.mcdragonlib.client.ber.BERLabel;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Point;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class BERStaticText
implements AbstractAdvancedDisplayRenderer<SimpleStaticTextDisplaySettings> {
    private final BERLabel label = new BERLabel();

    public BERStaticText() {
        this.label.position.set((Object)Point.of((double)3.0, (double)5.2f));
        this.label.horizontalScrollingSpeed.set((Number)Float.valueOf(12.0f));
        this.label.horizontalMinScale.set((Number)Float.valueOf(0.5f));
        this.label.horizontalMaxScale.set((Number)Float.valueOf(0.75f));
        this.label.verticalMinScale.set((Number)Float.valueOf(0.75f));
        this.label.verticalMaxScale.set((Number)Float.valueOf(0.75f));
        this.label.horizontalScrollMode.set((Object)BERLabel.EScrollMode.WHEN_NEEDED);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent) {
        MutableComponent text = this.getText(((SimpleStaticTextDisplaySettings)this.getDisplaySettings(blockEntity)).getStaticText());
        this.label.text.set((Object)text);
    }

    @Override
    public void render(BERGraphics<AdvancedDisplayBlockEntity> graphics, float pPartialTicks, AdvancedDisplayRenderInstance parent, int light, boolean backSide) {
        this.label.render(graphics, light);
    }

    private MutableComponent getText(String input) {
        String staticText = VariableManager.replacePlaceholders(input);
        MutableComponent text = TextUtils.empty();
        if (staticText != null) {
            try {
                text = Component.Serializer.m_130701_((String)staticText);
            }
            catch (Exception e) {
                text = TextUtils.text((String)staticText);
            }
        }
        if (text == null) {
            text = TextUtils.empty();
        }
        return text;
    }

    @Override
    public void update(Level level, BlockPos pos, BlockState state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent, AdvancedDisplayBlockEntity.EUpdateReason reason) {
        if (!blockEntity.isController()) {
            return;
        }
        this.label.clippingArea.set((Object)Rectangle.withSize((double)3.0, (double)3.0, (double)(blockEntity.getXSizeScaled() * 16 - 6), (double)(blockEntity.getYSizeScaled() * 16 - 6)));
        this.label.color.set((Object)((SimpleStaticTextDisplaySettings)this.getDisplaySettings(blockEntity)).getFontColor());
        this.label.preferredWidth.set((Number)Float.valueOf((float)(blockEntity.getXSizeScaled() * 16 - 3) - ((Float)this.label.x.get()).floatValue()));
        this.label.horizontalAlign.set((Object)ETextAlignment.CENTER);
    }
}

