/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import de.mrjulsen.crn.client.CRNGui;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.DLTexture;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.util.DLColor;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class CreateDynamicWidgets {
    private static final int BORDER_HEIGHT = 2;
    private static final int TEXTBOX_HEIGHT = 18;
    private static final DLColor COLOR_BORDER = DLColor.fromInt((int)-13027015);
    private static final DLColor COLOR_3D_SHADOW = DLColor.fromInt((int)-13158601);
    private static final DLColor COLOR_3D_HIGHLIGHT = DLColor.fromInt((int)-7631989);
    private static final DLColor COLOR_3D_NEUTRAL = DLColor.fromInt((int)-9145228);
    private static final DLColor COLOR_TEXTBOX_3D_SHADOW = DLColor.fromInt((int)-13158601);
    private static final DLColor COLOR_TEXTBOX_3D_LIGHT = DLColor.fromInt((int)-1);
    private static final DLColor COLOR_TEXTBOX_3D_NEUTRAL = DLColor.fromInt((int)-9145228);
    private static final DLColor COLOR_TEXTBOX_COLOR_BG = DLColor.fromInt((int)-6052957);
    private static final DLColor COLOR_TEXTBOX_COLOR_ACCENT = DLColor.fromInt((int)-7631989);

    public static void renderWidgetInner(DLGuiGraphics graphics, int x, int y, int w, int h, DLColor color) {
        GuiUtils.fill((DLGuiGraphics)graphics, (int)x, (int)y, (int)w, (int)h, (DLColor)color);
        GuiUtils.fill((DLGuiGraphics)graphics, (int)x, (int)y, (int)1, (int)h, (DLColor)ColorShade.LIGHT.getColor());
        GuiUtils.fill((DLGuiGraphics)graphics, (int)(x + 1), (int)y, (int)1, (int)h, (DLColor)COLOR_BORDER);
        GuiUtils.fill((DLGuiGraphics)graphics, (int)(x + w - 1), (int)y, (int)1, (int)h, (DLColor)ColorShade.LIGHT.getColor());
        GuiUtils.fill((DLGuiGraphics)graphics, (int)(x + w - 2), (int)y, (int)1, (int)h, (DLColor)COLOR_BORDER);
    }

    public static void renderWidgetInner(DLGuiGraphics graphics, int x, int y, int w, int h, ColorShade color) {
        CreateDynamicWidgets.renderWidgetInner(graphics, x, y, w, h, color.getColor());
    }

    public static void renderWidgetTopBorder(DLGuiGraphics graphics, int x, int y, int w) {
        GuiUtils.fill((DLGuiGraphics)graphics, (int)(x + 1), (int)y, (int)(w - 2), (int)1, (DLColor)ColorShade.LIGHT.getColor());
        GuiUtils.fill((DLGuiGraphics)graphics, (int)x, (int)(y + 1), (int)w, (int)1, (DLColor)ColorShade.LIGHT.getColor());
        GuiUtils.fill((DLGuiGraphics)graphics, (int)(x + 1), (int)(y + 1), (int)(w - 2), (int)1, (DLColor)COLOR_BORDER);
    }

    public static void renderWidgetBottomBorder(DLGuiGraphics graphics, int x, int y, int w) {
        GuiUtils.fill((DLGuiGraphics)graphics, (int)x, (int)y, (int)w, (int)1, (DLColor)ColorShade.LIGHT.getColor());
        GuiUtils.fill((DLGuiGraphics)graphics, (int)(x + 1), (int)(y + 1), (int)(w - 2), (int)1, (DLColor)ColorShade.LIGHT.getColor());
        GuiUtils.fill((DLGuiGraphics)graphics, (int)(x + 1), (int)y, (int)(w - 2), (int)1, (DLColor)COLOR_BORDER);
    }

    public static void renderSingleShadeWidget(DLGuiGraphics DLGuiGraphics2, int x, int y, int w, int h, DLColor color) {
        CreateDynamicWidgets.renderWidgetInner(DLGuiGraphics2, x, y + 2, w, h - 4, color);
        CreateDynamicWidgets.renderWidgetTopBorder(DLGuiGraphics2, x, y, w);
        CreateDynamicWidgets.renderWidgetBottomBorder(DLGuiGraphics2, x, y + h - 2, w);
    }

    public static void renderSingleShadeWidget(DLGuiGraphics graphics, int x, int y, int w, int h, ColorShade color) {
        CreateDynamicWidgets.renderSingleShadeWidget(graphics, x, y, w, h, color.getColor());
    }

    public static void renderDuoShadeWidget(DLGuiGraphics graphics, int x, int y, int w, int h1, DLColor color1, int h2, DLColor color2) {
        CreateDynamicWidgets.renderWidgetInner(graphics, x, y + 2, w, h1 - 2, color1);
        CreateDynamicWidgets.renderWidgetInner(graphics, x, y + h1, w, h2 - 2, color2);
        CreateDynamicWidgets.renderWidgetTopBorder(graphics, x, y, w);
        CreateDynamicWidgets.renderWidgetBottomBorder(graphics, x, y + h1 + h2 - 2, w);
    }

    public static void renderDuoShadeWidget(DLGuiGraphics graphics, int x, int y, int w, int h1, ColorShade color1, int h2, ColorShade color2) {
        CreateDynamicWidgets.renderDuoShadeWidget(graphics, x, y, w, h1, color1.getColor(), h2, color2.getColor());
    }

    public static void renderGrabber(DLGuiGraphics graphics, int x, int y) {
        for (int i = 0; i < 2; ++i) {
            for (int k = 0; k < 4; ++k) {
                GuiUtils.fill((DLGuiGraphics)graphics, (int)(x + 1 + i * 4), (int)(y + 1 + k * 4), (int)2, (int)2, (DLColor)COLOR_3D_SHADOW);
                GuiUtils.fill((DLGuiGraphics)graphics, (int)(x + 1 + i * 4), (int)(y + 1 + k * 4), (int)1, (int)1, (DLColor)COLOR_3D_HIGHLIGHT);
            }
        }
    }

    public static void renderTextSlotOverlay(DLGuiGraphics graphics, int x, int y, int w, int h) {
        GuiUtils.fill((DLGuiGraphics)graphics, (int)x, (int)y, (int)w, (int)1, (DLColor)COLOR_3D_SHADOW);
        GuiUtils.fill((DLGuiGraphics)graphics, (int)x, (int)(y + h - 1), (int)w, (int)1, (DLColor)COLOR_3D_HIGHLIGHT);
        GuiUtils.fill((DLGuiGraphics)graphics, (int)x, (int)(y + h - 1), (int)1, (int)1, (DLColor)COLOR_3D_NEUTRAL);
        GuiUtils.fill((DLGuiGraphics)graphics, (int)(x + w - 1), (int)(y + h - 1), (int)1, (int)1, (DLColor)COLOR_3D_NEUTRAL);
        GuiUtils.fill((DLGuiGraphics)graphics, (int)(x + 1), (int)(y + 2), (int)1, (int)1, (DLColor)COLOR_3D_SHADOW);
        GuiUtils.fill((DLGuiGraphics)graphics, (int)(x + w - 2), (int)(y + 2), (int)1, (int)1, (DLColor)COLOR_3D_NEUTRAL);
        GuiUtils.fill((DLGuiGraphics)graphics, (int)(x + 1), (int)(y + h - 3), (int)1, (int)1, (DLColor)COLOR_3D_NEUTRAL);
        GuiUtils.fill((DLGuiGraphics)graphics, (int)(x + w - 2), (int)(y + h - 3), (int)1, (int)1, (DLColor)COLOR_3D_HIGHLIGHT);
    }

    public static void renderTextBox(DLGuiGraphics graphics, int x, int y, int w) {
        int h = 18;
        GuiUtils.fill((DLGuiGraphics)graphics, (int)x, (int)y, (int)w, (int)h, (DLColor)COLOR_TEXTBOX_COLOR_ACCENT);
        GuiUtils.fill((DLGuiGraphics)graphics, (int)x, (int)(y + 2), (int)w, (int)2, (DLColor)COLOR_TEXTBOX_COLOR_BG);
        GuiUtils.fill((DLGuiGraphics)graphics, (int)x, (int)(y + h - 4), (int)w, (int)2, (DLColor)COLOR_TEXTBOX_COLOR_BG);
        GuiUtils.fill((DLGuiGraphics)graphics, (int)x, (int)y, (int)w, (int)1, (DLColor)COLOR_TEXTBOX_3D_SHADOW);
        GuiUtils.fill((DLGuiGraphics)graphics, (int)x, (int)(y + h - 1), (int)w, (int)1, (DLColor)COLOR_TEXTBOX_3D_LIGHT);
        GuiUtils.fill((DLGuiGraphics)graphics, (int)x, (int)y, (int)1, (int)h, (DLColor)COLOR_TEXTBOX_3D_SHADOW);
        GuiUtils.fill((DLGuiGraphics)graphics, (int)(x + w - 1), (int)y, (int)1, (int)h, (DLColor)COLOR_TEXTBOX_3D_LIGHT);
        GuiUtils.fill((DLGuiGraphics)graphics, (int)(x + w - 1), (int)y, (int)1, (int)1, (DLColor)COLOR_TEXTBOX_3D_NEUTRAL);
        GuiUtils.fill((DLGuiGraphics)graphics, (int)x, (int)(y + h - 1), (int)1, (int)1, (DLColor)COLOR_TEXTBOX_3D_NEUTRAL);
    }

    public static void renderHorizontalSeparator(DLGuiGraphics graphics, int x, int y, int w) {
        GuiUtils.fill((DLGuiGraphics)graphics, (int)(x + 1), (int)y, (int)(w - 1), (int)1, (DLColor)ColorShade.LIGHT.getColor());
        GuiUtils.fill((DLGuiGraphics)graphics, (int)x, (int)(y + 1), (int)(w - 1), (int)1, (DLColor)COLOR_BORDER);
    }

    public static void renderContainerBackground(DLGuiGraphics graphics, int x, int y, int w, int h, ContainerColor color) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)color.res);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f = 2.0f;
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferbuilder.m_5483_((double)x, (double)y + (double)h, 0.0).m_7421_(0.0f, (float)h / f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        bufferbuilder.m_5483_((double)x + (double)w, (double)y + (double)h, 0.0).m_7421_((float)w / f, (float)h / f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        bufferbuilder.m_5483_((double)x + (double)w, (double)y, 0.0).m_7421_((float)w / f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        bufferbuilder.m_5483_((double)x, (double)y, 0.0).m_7421_(0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        tesselator.m_85914_();
    }

    protected static void renderNineSliced(DLGuiGraphics graphics, int x, int y, int w, int h, int u, int v, int textureWidth, int textureHeight, int cornerSliceSize, ResourceLocation location, boolean renderCenter) {
        GuiUtils.drawTexture((ResourceLocation)location, (DLGuiGraphics)graphics, (int)x, (int)y, (int)cornerSliceSize, (int)cornerSliceSize, (int)u, (int)v, (int)cornerSliceSize, (int)cornerSliceSize, (GuiUtils.TextureFillMode)GuiUtils.TextureFillMode.STRETCH, (int)textureWidth, (int)textureHeight);
        GuiUtils.drawTexture((ResourceLocation)location, (DLGuiGraphics)graphics, (int)(x + w - cornerSliceSize), (int)y, (int)cornerSliceSize, (int)cornerSliceSize, (int)(u + 1 + cornerSliceSize), (int)v, (int)cornerSliceSize, (int)cornerSliceSize, (GuiUtils.TextureFillMode)GuiUtils.TextureFillMode.STRETCH, (int)textureWidth, (int)textureHeight);
        GuiUtils.drawTexture((ResourceLocation)location, (DLGuiGraphics)graphics, (int)x, (int)(y + h - cornerSliceSize), (int)cornerSliceSize, (int)cornerSliceSize, (int)u, (int)(v + 1 + cornerSliceSize), (int)cornerSliceSize, (int)cornerSliceSize, (GuiUtils.TextureFillMode)GuiUtils.TextureFillMode.STRETCH, (int)textureWidth, (int)textureHeight);
        GuiUtils.drawTexture((ResourceLocation)location, (DLGuiGraphics)graphics, (int)(x + w - cornerSliceSize), (int)(y + h - cornerSliceSize), (int)cornerSliceSize, (int)cornerSliceSize, (int)(u + 1 + cornerSliceSize), (int)(v + 1 + cornerSliceSize), (int)cornerSliceSize, (int)cornerSliceSize, (GuiUtils.TextureFillMode)GuiUtils.TextureFillMode.STRETCH, (int)textureWidth, (int)textureHeight);
        GuiUtils.drawTexture((ResourceLocation)location, (DLGuiGraphics)graphics, (int)(x + cornerSliceSize), (int)y, (int)(w - cornerSliceSize * 2), (int)cornerSliceSize, (int)(u + cornerSliceSize), (int)v, (int)1, (int)cornerSliceSize, (GuiUtils.TextureFillMode)GuiUtils.TextureFillMode.STRETCH, (int)textureWidth, (int)textureHeight);
        GuiUtils.drawTexture((ResourceLocation)location, (DLGuiGraphics)graphics, (int)(x + cornerSliceSize), (int)(y + h - cornerSliceSize), (int)(w - cornerSliceSize * 2), (int)cornerSliceSize, (int)(u + cornerSliceSize), (int)(v + 1 + cornerSliceSize), (int)1, (int)cornerSliceSize, (GuiUtils.TextureFillMode)GuiUtils.TextureFillMode.STRETCH, (int)textureWidth, (int)textureHeight);
        GuiUtils.drawTexture((ResourceLocation)location, (DLGuiGraphics)graphics, (int)x, (int)(y + cornerSliceSize), (int)cornerSliceSize, (int)(h - cornerSliceSize * 2), (int)u, (int)(v + cornerSliceSize), (int)cornerSliceSize, (int)1, (GuiUtils.TextureFillMode)GuiUtils.TextureFillMode.STRETCH, (int)textureWidth, (int)textureHeight);
        GuiUtils.drawTexture((ResourceLocation)location, (DLGuiGraphics)graphics, (int)(x + w - cornerSliceSize), (int)(y + cornerSliceSize), (int)cornerSliceSize, (int)(h - cornerSliceSize * 2), (int)(u + 1 + cornerSliceSize), (int)(v + cornerSliceSize), (int)cornerSliceSize, (int)1, (GuiUtils.TextureFillMode)GuiUtils.TextureFillMode.STRETCH, (int)textureWidth, (int)textureHeight);
        if (renderCenter) {
            GuiUtils.drawTexture((ResourceLocation)location, (DLGuiGraphics)graphics, (int)(x + cornerSliceSize), (int)(y + cornerSliceSize), (int)(w - cornerSliceSize * 2), (int)(h - cornerSliceSize * 2), (int)(u + cornerSliceSize), (int)(v + cornerSliceSize), (int)1, (int)1, (GuiUtils.TextureFillMode)GuiUtils.TextureFillMode.STRETCH, (int)textureWidth, (int)textureHeight);
        }
    }

    public static void renderContainer(DLGuiGraphics graphics, int x, int y, int w, int h, ContainerColor color) {
        switch (color.ordinal()) {
            case 3: {
                CRNGui.GUI_SPRITES.getSprite("content_gold").render(graphics, x, y, w, h);
                break;
            }
            case 1: {
                CRNGui.GUI_SPRITES.getSprite("content_purple").render(graphics, x, y, w, h);
                break;
            }
            case 2: {
                CRNGui.GUI_SPRITES.getSprite("content_blue").render(graphics, x, y, w, h);
                break;
            }
            default: {
                CRNGui.GUI_SPRITES.getSprite("content_gray").render(graphics, x, y, w, h);
            }
        }
    }

    public static void renderTitleBar(DLGuiGraphics graphics, int x, int y, int w, int h, BarColor color) {
        switch (color.ordinal()) {
            case 2: {
                CRNGui.GUI_SPRITES.getSprite("header_gold").render(graphics, x, y, w, h);
                break;
            }
            case 1: {
                CRNGui.GUI_SPRITES.getSprite("header_purple").render(graphics, x, y, w, h);
                break;
            }
            default: {
                CRNGui.GUI_SPRITES.getSprite("header_gray").render(graphics, x, y, w, h);
            }
        }
    }

    public static void renderWindow(DLGuiGraphics graphics, int x, int y, int w, int h, ContainerColor color, BarColor bar, int headerSize, int footerSize, boolean renderContent) {
        CreateDynamicWidgets.renderWindow(graphics, x, y, w, h, color, bar, bar, headerSize, footerSize, renderContent);
    }

    public static void renderWindow(DLGuiGraphics graphics, int x, int y, int w, int h, ContainerColor color, BarColor header, BarColor footer, int headerSize, int footerSize, boolean renderContent) {
        CreateDynamicWidgets.renderTitleBar(graphics, x, y, w, headerSize, header);
        CreateDynamicWidgets.renderTitleBar(graphics, x, y + h - footerSize, w, footerSize, footer);
        if (renderContent) {
            CreateDynamicWidgets.renderContainer(graphics, x + 1, y + headerSize - 1, w - 2, h - headerSize - footerSize + 2, color);
        }
    }

    public static void renderShadow(DLGuiGraphics graphics, int x, int y, int w, int h) {
        CreateDynamicWidgets.renderNineSliced(graphics, x - 5, y - 5, w + 10, h + 10, 0, 0, 11, 11, 5, new ResourceLocation("createrailwaysnavigator", "textures/gui/shadow.png"), true);
    }

    public static void renderTextHighlighted(DLGuiGraphics graphics, int x, int y, Font font, Component text, DLColor color) {
        int width = font.m_92852_((FormattedText)text) + 6;
        Objects.requireNonNull(font);
        int height = 9 + 6;
        GuiUtils.fill((DLGuiGraphics)graphics, (int)x, (int)(y + 1), (int)width, (int)(height - 3), (DLColor)color);
        GuiUtils.fill((DLGuiGraphics)graphics, (int)(x + 1), (int)y, (int)(width - 2), (int)1, (DLColor)color);
        GuiUtils.fill((DLGuiGraphics)graphics, (int)(x + 1), (int)(y + height - 2), (int)(width - 2), (int)1, (DLColor)color);
        GuiUtils.drawString((DLGuiGraphics)graphics, (Font)font, (int)(x + 3), (int)(y + 3), (FormattedText)text, (DLColor)DLColor.pickBasedOnBrightness((DLColor)color, (DLColor)DLColor.WHITE, (DLColor)DLColor.BLACK, (float)0.5f), (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
    }

    public static void renderIconSlot(DLGuiGraphics graphics, int x, int y, int w, int h) {
        CreateDynamicWidgets.renderNineSliced(graphics, x, y, w, h, 0, 7, CRNGui.GUI.width(), CRNGui.GUI.height(), 1, (ResourceLocation)CRNGui.GUI.getTexture().get(), true);
    }

    public static void renderTextBoxArrow(DLGuiGraphics graphics, int x, int y) {
        GuiUtils.drawTexture((DLTexture)CRNGui.GUI, (DLGuiGraphics)graphics, (int)(x - 3), (int)(y + 5), (int)4, (int)8, (int)60, (int)54, (int)4, (int)8, (GuiUtils.TextureFillMode)GuiUtils.TextureFillMode.STRETCH);
    }

    public static void renderVerticalSeparator(DLGuiGraphics graphics, int x, int y, int h, BarColor color) {
        GuiUtils.drawTexture((DLTexture)CRNGui.GUI, (DLGuiGraphics)graphics, (int)x, (int)y, (int)1, (int)h, (int)(color.u + 5), (int)(color.v + 3), (int)1, (int)1, (GuiUtils.TextureFillMode)GuiUtils.TextureFillMode.STRETCH);
        GuiUtils.drawTexture((DLTexture)CRNGui.GUI, (DLGuiGraphics)graphics, (int)(x + 1), (int)y, (int)1, (int)h, (int)(color.u + 1), (int)(color.v + 3), (int)1, (int)1, (GuiUtils.TextureFillMode)GuiUtils.TextureFillMode.STRETCH);
    }

    public static enum ColorShade {
        LIGHT(DLColor.fromInt((int)-9474193)),
        DARK(DLColor.fromInt((int)-11053225));

        private final DLColor color;

        private ColorShade(DLColor color) {
            this.color = color;
        }

        public DLColor getColor() {
            return this.color;
        }
    }

    public static enum ContainerColor {
        GRAY(new ResourceLocation("createrailwaysnavigator", "textures/gui/container_gray.png")),
        PURPLE(new ResourceLocation("createrailwaysnavigator", "textures/gui/container_purple.png")),
        BLUE(new ResourceLocation("createrailwaysnavigator", "textures/gui/container_blue.png")),
        GOLD(new ResourceLocation("createrailwaysnavigator", "textures/gui/container_gold.png"));

        private final ResourceLocation res;

        private ContainerColor(ResourceLocation res) {
            this.res = res;
        }
    }

    public static enum BarColor {
        GRAY(7, 0),
        PURPLE(14, 0),
        GOLD(0, 0);

        private final int u;
        private final int v;

        private BarColor(int u, int v) {
            this.u = u;
            this.v = v;
        }
    }

    public static enum FooterSize {
        DEFAULT(15),
        SMALL(30),
        EXTENDED(36);

        private final int size;

        private FooterSize(int size) {
            this.size = size;
        }

        public int size() {
            return this.size;
        }
    }
}

