/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.overlay;

import com.mojang.blaze3d.platform.InputConstants;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.overlay.OverlayPosition;
import de.mrjulsen.crn.client.gui.overlay.SlidingTextComponent;
import de.mrjulsen.crn.client.gui.overlay.pages.AbstractRouteDetailsPage;
import de.mrjulsen.crn.client.gui.overlay.pages.ConnectionMissedPage;
import de.mrjulsen.crn.client.gui.overlay.pages.JourneyCompletedPage;
import de.mrjulsen.crn.client.gui.overlay.pages.NextConnectionsPage;
import de.mrjulsen.crn.client.gui.overlay.pages.RouteOverviewPage;
import de.mrjulsen.crn.client.gui.overlay.pages.TrainCancelledInfo;
import de.mrjulsen.crn.client.gui.overlay.pages.TransferPage;
import de.mrjulsen.crn.client.gui.overlay.pages.WelcomePage;
import de.mrjulsen.crn.client.gui.widgets.skins.CRNFlatButtonRenderer;
import de.mrjulsen.crn.client.gui.windows.RouteDetailsWindow;
import de.mrjulsen.crn.client.gui.windows.RouteOverlaySettingsWindow;
import de.mrjulsen.crn.client.input.ModKeys;
import de.mrjulsen.crn.client.lang.CustomLanguage;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.crn.data.navigation.TransferConnection;
import de.mrjulsen.crn.util.ETimeFormat;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindow;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindowManager;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLPanel;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLTooltip;
import de.mrjulsen.mcdragonlib.client.gui.widgets.layout.BorderLayout;
import de.mrjulsen.mcdragonlib.client.gui.widgets.layout.TableLayout;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.mcdragonlib.util.time.ConfiguredTimeSystem;
import de.mrjulsen.mcdragonlib.util.time.DLTime;
import de.mrjulsen.mcdragonlib.util.time.ITimeSystem;
import de.mrjulsen.mcdragonlib.util.time.TimeContext;
import java.util.List;
import java.util.Objects;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.Level;

public class RouteDetailsOverlay
extends DLWindow {
    private static final Component title = TextUtils.translate((String)"gui.createrailwaysnavigator.route_overview.title");
    private static final int GUI_WIDTH = 226;
    private static final int GUI_HEIGHT = 118;
    private static final int SCROLL_AREA_HEIGHT = 25;
    private static final int SLIDING_TEXT_AREA_WIDTH = 220;
    private float slidingTextOffset = 0.0f;
    private int slidingTextWidth = 0;
    private LerpedFloat xPos;
    private LerpedFloat yPos;
    private static final String keyTrainDetails = "gui.createrailwaysnavigator.route_overview.train_details";
    private static final String keyTransfer = "gui.createrailwaysnavigator.route_overview.transfer";
    private static final String keyTransferWithPlatform = "gui.createrailwaysnavigator.route_overview.transfer_with_platform";
    private static final String keyAfterJourney = "gui.createrailwaysnavigator.route_overview.after_journey";
    private static final String keyOptionsText = "gui.createrailwaysnavigator.route_overview.options";
    private static final String keyKeybindOptions = "key.createrailwaysnavigator.route_overlay_options";
    private static final String keyJourneyBegins = "gui.createrailwaysnavigator.route_overview.journey_begins";
    private static final String keyJourneyBeginsWithPlatform = "gui.createrailwaysnavigator.route_overview.journey_begins_with_platform";
    private static final String keyNextStop = "gui.createrailwaysnavigator.route_overview.next_stop";
    private static final String keyConnectionMissedInfo = "gui.createrailwaysnavigator.route_overview.connection_missed_info";
    private static final String keyTrainCancelledInfo = "gui.createrailwaysnavigator.route_overview.train_cancelled_info";
    private final Font font;
    private final ClientRoute route;
    private boolean journeyCompleted;
    private final DLPanel contentPanel;
    private final SlidingTextComponent slidingTextComponent;
    private AbstractRouteDetailsPage currentPage;

    public RouteDetailsOverlay(DLWindowManager manager, Level level, ClientRoute route, int width, int height) {
        super(manager);
        this.font = Minecraft.m_91087_().f_91062_;
        this.journeyCompleted = false;
        this.route = route;
        route.addListener();
        this.scale.set((Number)((Double)ModClientConfig.OVERLAY_SCALE.get()));
        this.setSize(226.0, 118.0);
        this.windowSpawnPosition.set((Object)DLWindow.WindowPosition.CENTER);
        this.xPos = LerpedFloat.linear().startWithValue(manager.getScreenWidth() / 2.0 - (Double)this.scale.get() * (double)(this.width() / 2));
        this.yPos = LerpedFloat.linear().startWithValue(manager.getScreenHeight() / 2.0 - (Double)this.scale.get() * (double)(this.height() / 2));
        int dy = CreateDynamicWidgets.FooterSize.DEFAULT.size() + 25;
        this.contentPanel = (DLPanel)this.addComponent((DLGuiComponent)new DLPanel(3, dy, this.width() - 6, this.height() - dy - CreateDynamicWidgets.FooterSize.DEFAULT.size() - 1));
        this.contentPanel.layout.set((Object)new BorderLayout(0, 0));
        this.slidingTextComponent = (SlidingTextComponent)this.addComponent(new SlidingTextComponent(3, CreateDynamicWidgets.FooterSize.DEFAULT.size() + 1, this.width() - 6));
        int optionsPanelSize = 11;
        DLPanel optionsPanel = (DLPanel)this.addComponent((DLGuiComponent)new DLPanel(3, this.height() - 2 - 11, this.width() - 6, 11));
        TableLayout layout = new TableLayout();
        layout.addColumn("void", 1.0, TableLayout.ColumnSizeMode.PERCENTAGE);
        layout.addColumn("settings", 1.0, TableLayout.ColumnSizeMode.AUTO);
        layout.addColumn("popout", 1.0, TableLayout.ColumnSizeMode.AUTO);
        layout.addColumn("close", 1.0, TableLayout.ColumnSizeMode.AUTO);
        optionsPanel.layout.set((Object)layout);
        DLButton closeBtn = (DLButton)optionsPanel.addComponent((DLGuiComponent)new DLButton(0, 0, 16, 11));
        closeBtn.layoutContraint.set((Object)"close");
        closeBtn.icon.set((Object)ModGuiIcons.X_SMALL.getAsSprite(16, 16));
        closeBtn.text.set((Object)TextUtils.empty());
        closeBtn.textColor.set((Object)DragonLib.VANILLA_UI_FONT_COLOR);
        closeBtn.componentRenderer.set((Object)CRNFlatButtonRenderer.INSTANCE);
        closeBtn.tooltip.set((Object)new DLTooltip(List.of(TextUtils.TEXT_CLOSE), this.width()));
        closeBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            this.getWindowManager().closeWindow((DLWindow)this);
            return false;
        });
        DLButton settingsBtn = (DLButton)optionsPanel.addComponent((DLGuiComponent)new DLButton(0, 0, 16, 11));
        settingsBtn.layoutContraint.set((Object)"settings");
        settingsBtn.icon.set((Object)ModGuiIcons.SETTINGS_SMALL.getAsSprite(16, 16));
        settingsBtn.text.set((Object)TextUtils.empty());
        settingsBtn.textColor.set((Object)DragonLib.VANILLA_UI_FONT_COLOR);
        settingsBtn.componentRenderer.set((Object)CRNFlatButtonRenderer.INSTANCE);
        settingsBtn.tooltip.set((Object)new DLTooltip(List.of(TextUtils.text((String)"Settings")), this.width()));
        settingsBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            DLWindow.openWindow(mgr -> new RouteOverlaySettingsWindow(mgr, this));
            return false;
        });
        DLButton popoutBtn = (DLButton)optionsPanel.addComponent((DLGuiComponent)new DLButton(0, 0, 16, 11));
        popoutBtn.layoutContraint.set((Object)"popout");
        popoutBtn.icon.set((Object)ModGuiIcons.POP_OUT.getAsSprite(16, 16));
        popoutBtn.text.set((Object)TextUtils.empty());
        popoutBtn.textColor.set((Object)DragonLib.VANILLA_UI_FONT_COLOR);
        popoutBtn.componentRenderer.set((Object)CRNFlatButtonRenderer.INSTANCE);
        popoutBtn.tooltip.set((Object)new DLTooltip(List.of(TextUtils.text((String)"Show route details")), this.width()));
        popoutBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            DLWindow.openWindow(mgr -> new RouteDetailsWindow(mgr, route));
            return false;
        });
        this.addEventListener(DLGuiStandardEvents.ComponentPosAndSizeChanged.class, (s, e) -> {
            this.contentPanel.setPosition(3.0, (double)dy);
            this.contentPanel.setSize((double)(this.width() - 6), (double)(this.height() - dy - CreateDynamicWidgets.FooterSize.DEFAULT.size() - 1));
            optionsPanel.setPosition(3.0, (double)(this.height() - 2 - 11));
            optionsPanel.setSize((double)(this.width() - 6), 11.0);
            return false;
        });
        this.setPage(new WelcomePage(this.route));
        String terminus = route.getStart().getDisplayTitle();
        StationTag.StationInfo info = route.getStart().getRealTimeStationTag().info();
        String departureTimeText = DLTime.fromTicks((double)route.getStart().getScheduledDepartureTime(), (ITimeSystem)new ConfiguredTimeSystem()).format(((ETimeFormat)((Object)ModClientConfig.TIME_FORMAT.get())).getFormat(), TimeContext.INGAME);
        this.setSlidingText((Component)(info.platform().isEmpty() ? CustomLanguage.translate(keyJourneyBegins, route.getStart().getTrainDisplayName(), terminus, departureTimeText) : CustomLanguage.translate(keyJourneyBeginsWithPlatform, route.getStart().getTrainDisplayName(), terminus, departureTimeText, info.platform())));
        if (route.isClosed()) {
            return;
        }
        route.listen("departure_from_any_stop", (Object)this, x -> {
            this.setPage(new RouteOverviewPage(this.route));
            String terminus = x.part().getNextStop().getTerminusText();
            this.setSlidingText((Component)CustomLanguage.translate(keyTrainDetails, x.part().getNextStop().getTrainDisplayName(), terminus == null || terminus.isEmpty() ? x.part().getNextStop().getScheduleTitle() : terminus));
        });
        route.listen("first_stop_station_changed", (Object)this, x -> this.setSlidingText((Component)(x.trainStop().getRealTimeStationTag().info().platform().isEmpty() ? CustomLanguage.translate(keyJourneyBegins) : CustomLanguage.translate(keyJourneyBeginsWithPlatform, x.trainStop().getRealTimeStationTag().info().platform()))));
        route.listen("arrival_at_any_stop", (Object)this, x -> this.setSlidingText((Component)TextUtils.text((String)x.trainStop().getRealTimeStationTag().tagName())));
        route.listen("any_stop_announced", (Object)this, x -> {
            NextConnectionsPage page = new NextConnectionsPage(this.route, null);
            if (page.hasConnections()) {
                this.setPage(page);
            }
        });
        route.listen("announce_stopover", (Object)this, x -> this.setSlidingText((Component)CustomLanguage.translate(keyNextStop, x.trainStop().getRealTimeStationTag().tagName())));
        route.listen("announce_last_stop", (Object)this, x -> this.setSlidingText((Component)CustomLanguage.translate(keyNextStop, x.trainStop().getRealTimeStationTag().tagName())));
        route.listen("announce_transfer_arrival_station", (Object)this, x -> {
            if (x.connection().isConnectionMissed()) {
                this.connectionMissed();
                return;
            }
            this.setSlidingText((Component)CustomLanguage.translate(keyNextStop, x.trainStop().getRealTimeStationTag().tagName()).m_130946_("   ***   ").m_7220_(this.getTransferSlidingText(x.connection())));
            this.setPage(new TransferPage(this.route, x.connection()));
        });
        route.listen("part_changed", (Object)this, x -> {
            if (x.connection().isConnectionMissed()) {
                this.connectionMissed();
            }
        });
        route.listen("departure_from_transfer_arrival_station", (Object)this, x -> {
            this.setSlidingText((Component)TextUtils.text((String)x.connection().getArrivalStation().getRealTimeStationTag().tagName()).m_130946_("   ***   ").m_7220_(this.getTransferSlidingText(x.connection())));
            this.setPage(new TransferPage(this.route, x.connection()));
        });
        route.listen("arrival_at_last_stop", (Object)this, x -> {
            this.setSlidingText((Component)CustomLanguage.translate(keyAfterJourney, x.trainStop().getRealTimeStationTag().tagName()));
            this.setPage(new JourneyCompletedPage(this.route, () -> this.setPage(new NextConnectionsPage(route, () -> {}))));
            route.close();
        });
        route.listen("departure_from_last_stop", (Object)this, x -> {
            if (this.journeyCompleted) {
                return;
            }
            this.setSlidingText((Component)CustomLanguage.translate(keyAfterJourney, x.trainStop().getRealTimeStationTag().tagName()));
            this.setPage(new JourneyCompletedPage(this.route, () -> this.setPage(new NextConnectionsPage(route, () -> {}))));
            route.close();
        });
        route.listen("any_transfer_missed", (Object)this, x -> this.connectionMissed());
        route.listen("train_cancelled", (Object)this, x -> this.trainCancelled(x.part().getLastStop().getTrainDisplayName()));
    }

    private Component getTransferSlidingText(TransferConnection connection) {
        StationTag.StationInfo info = connection.getDepartureStation().getRealTimeStationTag().info();
        String terminus = connection.getDepartureStation().getDisplayTitle();
        return info == null || info.platform().isBlank() ? CustomLanguage.translate(keyTransfer, connection.getDepartureStation().getTrainDisplayName(), terminus) : CustomLanguage.translate(keyTransferWithPlatform, connection.getDepartureStation().getTrainDisplayName(), terminus, info.platform());
    }

    private void connectionMissed() {
        this.setSlidingText((Component)CustomLanguage.translate(keyConnectionMissedInfo));
        this.setPage(new ConnectionMissedPage(this.route));
        this.route.close();
    }

    private void trainCancelled(String trainName) {
        this.setSlidingText((Component)CustomLanguage.translate(keyTrainCancelledInfo, trainName));
        this.setPage(new TrainCancelledInfo(this.route, trainName));
        this.route.close();
    }

    public void setPage(AbstractRouteDetailsPage page) {
        this.contentPanel.clearComponents();
        page.layoutContraint.set((Object)BorderLayout.BorderPosition.CENTER);
        this.contentPanel.addComponent((DLGuiComponent)page);
        this.currentPage = page;
    }

    public void close() {
        this.route.close();
        this.journeyCompleted = true;
    }

    public void tick() {
        if (Screen.m_96637_() && ModKeys.KEY_OVERLAY_SETTINGS.m_90857_()) {
            DLWindow.openWindow(mgr -> new RouteOverlaySettingsWindow(mgr, this));
        }
        this.xPos.tickChaser();
        this.yPos.tickChaser();
    }

    protected void tickSlidingText(float delta) {
        if ((float)this.slidingTextWidth > 165.0f) {
            this.slidingTextOffset -= delta;
            if (this.slidingTextOffset < (float)(-(this.slidingTextWidth / 2))) {
                this.slidingTextOffset = 220 + this.slidingTextWidth / 2 + 20;
            }
        }
    }

    private void setSlidingText(Component component) {
        this.slidingTextComponent.text.set((Object)component);
        this.slidingTextWidth = this.font.m_92852_((FormattedText)component);
        this.slidingTextOffset = (float)this.slidingTextWidth > 165.0f ? (float)(220 + this.slidingTextWidth / 2 + 20) : 82.0f;
    }

    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        OverlayPosition pos = (OverlayPosition)((Object)ModClientConfig.ROUTE_OVERLAY_POSITION.get());
        int x = pos == OverlayPosition.TOP_LEFT || pos == OverlayPosition.BOTTOM_LEFT ? 8 : (int)(this.getWindowManager().getScreenWidth() - (double)this.width() * (Double)this.scale.get() - 10.0);
        int y = pos == OverlayPosition.TOP_LEFT || pos == OverlayPosition.TOP_RIGHT ? 8 : (int)(this.getWindowManager().getScreenHeight() - (double)this.height() * (Double)this.scale.get() - 10.0);
        this.xPos.chase((double)x, (double)0.2f, LerpedFloat.Chaser.EXP);
        this.yPos.chase((double)y, (double)0.2f, LerpedFloat.Chaser.EXP);
        this.setPosition(this.xPos.getValue(Minecraft.m_91087_().m_91296_()), this.yPos.getValue(Minecraft.m_91087_().m_91296_()));
        CreateDynamicWidgets.renderWindow(graphics, 0, 0, this.width(), this.height(), this.currentPage.isImportant() ? CreateDynamicWidgets.ContainerColor.GOLD : CreateDynamicWidgets.ContainerColor.BLUE, this.currentPage.isImportant() ? CreateDynamicWidgets.BarColor.GOLD : CreateDynamicWidgets.BarColor.GRAY, CreateDynamicWidgets.FooterSize.DEFAULT.size(), CreateDynamicWidgets.FooterSize.DEFAULT.size(), false);
        CreateDynamicWidgets.renderContainer(graphics, 1, CreateDynamicWidgets.FooterSize.DEFAULT.size() - 1, this.width() - 2, 25, CreateDynamicWidgets.ContainerColor.GRAY);
        int dy = CreateDynamicWidgets.FooterSize.DEFAULT.size() + 25 - 2;
        CreateDynamicWidgets.renderContainer(graphics, 1, dy, this.width() - 2, this.height() - dy - CreateDynamicWidgets.FooterSize.DEFAULT.size() + 1, this.currentPage.isImportant() ? CreateDynamicWidgets.ContainerColor.GOLD : CreateDynamicWidgets.ContainerColor.BLUE);
        GuiUtils.drawString((DLGuiGraphics)graphics, (Font)this.font, (int)6, (int)4, (FormattedText)title, (DLColor)DragonLib.VANILLA_UI_FONT_COLOR, (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
        MutableComponent timeText = TextUtils.text((String)DLTime.fromLevelTime((Level)Minecraft.m_91087_().f_91073_, (ITimeSystem)new ConfiguredTimeSystem()).format(((ETimeFormat)((Object)ModClientConfig.TIME_FORMAT.get())).getFormat(), TimeContext.INGAME));
        GuiUtils.drawString((DLGuiGraphics)graphics, (Font)this.font, (int)(this.width() - 6), (int)4, (FormattedText)timeText, (DLColor)DragonLib.VANILLA_UI_FONT_COLOR, (ETextAlignment)ETextAlignment.RIGHT, (boolean)false);
        Font font = graphics.defaultFont();
        int n = this.height() - 2;
        Objects.requireNonNull(graphics.defaultFont());
        GuiUtils.drawString((DLGuiGraphics)graphics, (Font)font, (int)6, (int)(n - 9), (FormattedText)TextUtils.truncateWithEllipsis((Font)graphics.defaultFont(), (Component)TextUtils.translate((String)keyOptionsText, (Object[])new Object[]{TextUtils.translate((String)InputConstants.m_84827_((int)(Minecraft.f_91002_ ? 343 : 341), (int)0).m_84874_()).m_130946_(" + ").m_7220_((Component)TextUtils.keybind((String)keyKeybindOptions)).m_130940_(ChatFormatting.BOLD)}), (int)(this.width() - 50)), (DLColor)DragonLib.VANILLA_UI_FONT_COLOR, (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
    }

    public ClientRoute getRoute() {
        return this.route;
    }
}

