/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.overlay.pages;

import de.mrjulsen.crn.client.gui.overlay.pages.AbstractRouteDetailsPage;
import de.mrjulsen.crn.client.lang.CustomLanguage;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.crn.data.train.ClientTrainStop;
import de.mrjulsen.crn.data.train.TrainStop;
import de.mrjulsen.crn.network.packets.pain.GetDeparturesAtPacketData;
import de.mrjulsen.crn.registry.ModNetworkManager;
import de.mrjulsen.crn.util.ETimeFormat;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.network.NetworkDirection;
import de.mrjulsen.mcdragonlib.network.NetworkPacketData;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.mcdragonlib.util.time.ConfiguredTimeSystem;
import de.mrjulsen.mcdragonlib.util.time.DLTime;
import de.mrjulsen.mcdragonlib.util.time.ITimeSystem;
import de.mrjulsen.mcdragonlib.util.time.TimeContext;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class NextConnectionsPage
extends AbstractRouteDetailsPage {
    private final List<TrainStop> nextConnections = new ArrayList<TrainStop>();
    private static final String keyNextConnections = "gui.createrailwaysnavigator.route_overview.next_connections";
    private static final int CONNECTION_ENTRIES_PER_PAGE = 3;
    private static final int TIME_PER_CONNECTIONS_SUBPAGE = 200;
    private int connectionsSubPageTime = 0;
    private int connectionsSubPageIndex = 0;
    private int connectionsSubPagesCount = 0;
    private final Runnable afterFirstCycle;
    private int cycles;

    public NextConnectionsPage(ClientRoute route, Runnable afterFirstCycle) {
        super(route);
        this.afterFirstCycle = afterFirstCycle;
        ModNetworkManager.GET_DEPARTURES_AT.send((NetworkDirection)NetworkDirection.toServer(), (NetworkPacketData)new GetDeparturesAtPacketData.Request(route.getCurrentPart().getNextStop().getRealTimeStationTag().tagId(), route.getCurrentPart().getNextStop().getTrainId(), true), response -> {
            List<ClientTrainStop> stops = response.getData();
            if (stops.isEmpty()) {
                afterFirstCycle.run();
                return;
            }
            this.nextConnections.addAll(stops);
            this.connectionsSubPagesCount = this.nextConnections.size() / 3 + (this.nextConnections.size() % 3 == 0 ? 0 : 1);
        }, () -> {});
    }

    @Override
    public boolean isImportant() {
        return false;
    }

    public boolean hasConnections() {
        return !this.nextConnections.isEmpty();
    }

    public void tick() {
        super.tick();
        if (this.nextConnections.isEmpty()) {
            return;
        }
        ++this.connectionsSubPageTime;
        if ((this.connectionsSubPageTime %= 200) == 0) {
            ++this.connectionsSubPageIndex;
            if ((this.connectionsSubPageIndex %= this.connectionsSubPagesCount) == 0) {
                ++this.cycles;
                if (this.cycles == 1) {
                    DLUtils.doIfNotNull((Object)this.afterFirstCycle, x -> x.run());
                }
            }
        }
    }

    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        GuiUtils.drawString((DLGuiGraphics)graphics, (Font)this.font, (int)5, (int)4, (FormattedText)CustomLanguage.translate(keyNextConnections).m_130940_(ChatFormatting.BOLD), (DLColor)DLColor.WHITE, (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
        int y = 16;
        int spacing = 5;
        int timeWidth = 30;
        int trainNameWidth = 40;
        for (int i = this.connectionsSubPageIndex * 3; i < (this.connectionsSubPageIndex + 1) * 3 && i < this.nextConnections.size(); ++i) {
            TrainStop stop = this.nextConnections.get(i);
            String terminus = stop.getDisplayTitle();
            MutableComponent departureTimeText = TextUtils.text((String)DLTime.fromTicks((double)stop.getScheduledDepartureTime(), (ITimeSystem)new ConfiguredTimeSystem()).format(((ETimeFormat)((Object)ModClientConfig.TIME_FORMAT.get())).getFormat(), TimeContext.INGAME));
            GuiUtils.drawString((DLGuiGraphics)graphics, (Font)this.font, (int)5, (int)y, (FormattedText)departureTimeText, (DLColor)DLColor.fromInt((int)-2368549), (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
            GuiUtils.drawString((DLGuiGraphics)graphics, (Font)this.font, (int)40, (int)y, (FormattedText)TextUtils.truncateWithEllipsis((Font)this.font, (Component)TextUtils.text((String)stop.getTrainName()), (int)40), (DLColor)DLColor.fromInt((int)-2368549), (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
            GuiUtils.drawString((DLGuiGraphics)graphics, (Font)this.font, (int)(this.width() - 5), (int)y, (String)stop.getRealTimeStationTag().info().platform(), (DLColor)DLColor.fromInt((int)-2368549), (ETextAlignment)ETextAlignment.RIGHT, (boolean)false);
            int terminusWidth = this.width() - 10 + 30 + 40 + 15 - this.font.m_92895_(stop.getRealTimeStationTag().info().platform());
            GuiUtils.drawString((DLGuiGraphics)graphics, (Font)this.font, (int)85, (int)y, (FormattedText)TextUtils.truncateWithEllipsis((Font)this.font, (Component)TextUtils.text((String)terminus), (int)terminusWidth), (DLColor)DLColor.fromInt((int)-2368549), (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
            y += 12;
        }
        y = 52;
        int dotSize = 4;
        int center = this.width() / 2 - 2;
        int startX = center - 8 * (this.connectionsSubPagesCount - 1);
        for (int i = 0; i < this.connectionsSubPagesCount; ++i) {
            if (this.connectionsSubPageIndex == i) {
                GuiUtils.drawBox((DLGuiGraphics)graphics, (Rectangle)Rectangle.withSize((double)(startX + 8 * i - 1), (double)(y - 1), (double)6.0, (double)6.0), (DLColor)DLColor.fromInt((int)-5592406), (DLColor)DLColor.fromInt((int)-1));
                continue;
            }
            GuiUtils.drawBox((DLGuiGraphics)graphics, (Rectangle)Rectangle.withSize((double)(startX + 8 * i), (double)y, (double)4.0, (double)4.0), (DLColor)DLColor.fromInt((int)-7829368), (DLColor)DLColor.fromInt((int)-2368549));
        }
    }
}

