/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.overlay.pages;

import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.overlay.pages.AbstractRouteDetailsPage;
import de.mrjulsen.crn.client.gui.overlay.pages.RouteOverviewPage;
import de.mrjulsen.crn.client.lang.CustomLanguage;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.crn.data.train.ClientTrainStop;
import de.mrjulsen.crn.util.ETimeFormat;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.mcdragonlib.util.time.ConfiguredTimeSystem;
import de.mrjulsen.mcdragonlib.util.time.DLTime;
import de.mrjulsen.mcdragonlib.util.time.ITimeSystem;
import de.mrjulsen.mcdragonlib.util.time.TimeContext;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class WelcomePage
extends AbstractRouteDetailsPage {
    private static final String keyDepartureIn = "gui.createrailwaysnavigator.route_details.departure";
    private static final String keyTimeNow = "gui.createrailwaysnavigator.time.now";
    private static final String keyTransferCount = "gui.createrailwaysnavigator.navigator.route_entry.transfer";

    public WelcomePage(ClientRoute route) {
        super(route);
    }

    @Override
    public boolean isImportant() {
        return true;
    }

    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        int y = 16;
        RouteOverviewPage.renderStation(graphics, -4, this.width(), this.font, this.route.getStart(), RouteOverviewPage.RoutePathIcons.START, true, false);
        GuiUtils.fill((DLGuiGraphics)graphics, (int)0, (int)y, (int)this.width(), (int)1, (DLColor)DLColor.fromInt((int)-2368549));
        ModGuiIcons.TIME.render(graphics, 5, y + 3);
        long departureTicks = this.route.getCurrentPart().departureIn();
        MutableComponent time = TextUtils.text((String)DLTime.fromTicks((double)departureTicks, (ITimeSystem)new ConfiguredTimeSystem()).format(Constants.DEFAULT_VERBOSE_GAME_DURATION_FORMAT, TimeContext.INGAME));
        Objects.requireNonNull(this.font);
        GuiUtils.drawString((DLGuiGraphics)graphics, (Font)this.font, (int)26, (int)(y + 3 + 8 - 9 / 2), (FormattedText)CustomLanguage.translate(keyDepartureIn).m_130946_(" ").m_7220_((Component)(departureTicks > 0L ? time : CustomLanguage.translate(keyTimeNow))).m_130940_(ChatFormatting.BOLD), (DLColor)DLColor.WHITE, (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
        y += 21;
        int detailsLineHeight = 12;
        ClientTrainStop endStation = this.route.getLastClientPart().getLastClientStop();
        MutableComponent platformText = TextUtils.text((String)endStation.getRealTimeStationTag().info().platform());
        int platformTextWidth = this.font.m_92852_((FormattedText)platformText);
        int maxStationNameWidth = this.width() - platformTextWidth - 10 - 5;
        String timeText = DLTime.fromTicks((double)endStation.getRoundedRealTimeArrivalTime(), (ITimeSystem)new ConfiguredTimeSystem()).format(((ETimeFormat)((Object)ModClientConfig.TIME_FORMAT.get())).getFormat(), TimeContext.INGAME);
        MutableComponent stationText = TextUtils.text((String)timeText).m_7220_((Component)TextUtils.text((String)(" " + endStation.getRealTimeStationTag().tagName())));
        if (this.font.m_92852_((FormattedText)stationText) > maxStationNameWidth) {
            stationText = TextUtils.text((String)this.font.m_92854_((FormattedText)stationText, maxStationNameWidth).getString()).m_7220_((Component)TextUtils.text((String)"...")).m_130948_(stationText.m_7383_());
        }
        Objects.requireNonNull(this.font);
        ModGuiIcons.TARGET.render(graphics, 5, y + 9 / 2 - 8);
        GuiUtils.drawString((DLGuiGraphics)graphics, (Font)this.font, (int)26, (int)y, (FormattedText)stationText, (DLColor)DLColor.fromInt((int)-2368549), (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
        GuiUtils.drawString((DLGuiGraphics)graphics, (Font)this.font, (int)(this.width() - 5), (int)y, (FormattedText)platformText, (DLColor)(endStation.isStationInfoChanged() ? Constants.COLOR_DELAYED : DLColor.fromInt((int)-2368549)), (ETextAlignment)ETextAlignment.RIGHT, (boolean)false);
        Objects.requireNonNull(this.font);
        ModGuiIcons.INFO.render(graphics, 5, y + 12 + 9 / 2 - 8);
        GuiUtils.drawString((DLGuiGraphics)graphics, (Font)this.font, (int)26, (int)(y + 12), (FormattedText)TextUtils.text((String)String.format("%s %s | %s", this.route.getTransferCount(), CustomLanguage.translate(keyTransferCount).getString(), DLTime.fromTicks((double)this.route.travelTime(), (ITimeSystem)new ConfiguredTimeSystem()).format(Constants.DEFAULT_VERBOSE_GAME_DURATION_FORMAT, TimeContext.INGAME))), (DLColor)DLColor.fromInt((int)-2368549), (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
    }
}

