/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets;

import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.client.gui.widgets.RouteViewer;
import de.mrjulsen.crn.client.gui.widgets.skins.CRNFlatButtonRenderer;
import de.mrjulsen.crn.data.storage.RecentSearchQueries;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLContextMenu;
import de.mrjulsen.mcdragonlib.client.gui.widgets.render.IStateRenderer;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.CursorType;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.DLSprite;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class RecentSearchQueryButton
extends DLButton {
    private final Component text;
    private final Component subText;

    public RecentSearchQueryButton(RouteViewer viewer, int x, int y, int width, RecentSearchQueries.RecentSearchQuery query) {
        super(x, y, width, 12);
        this.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            viewer.search(query.getStartStation(), query.getDestinationStation(), () -> {});
            return false;
        });
        this.cursor.set((Object)CursorType.HAND);
        this.subText = TextUtils.truncateWithEllipsis((Font)Minecraft.m_91087_().f_91062_, (Component)TextUtils.text((String)DragonLib.DATE_FORMAT.format(query.getCreationTime())).m_130940_(ChatFormatting.GRAY), (int)((int)((float)(width - 6) / 0.75f)));
        this.text = TextUtils.truncateWithEllipsis((Font)Minecraft.m_91087_().f_91062_, (Component)TextUtils.text((String)String.format("%s \u2192 %s", query.getStartStation(), query.getDestinationStation())), (int)((int)((float)(width - 6 - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.subText) - 5) / 0.75f)));
        this.componentRenderer.set((Object)CRNFlatButtonRenderer.INSTANCE);
        DLContextMenu contextMenu = new DLContextMenu((pX, pY) -> {
            ArrayList<DLContextMenu.ItemEntry> entries = new ArrayList<DLContextMenu.ItemEntry>();
            entries.add(new DLContextMenu.ItemEntry(Constants.TEXT_SEARCH, DLSprite.empty(), true, () -> viewer.search(query.getStartStation(), query.getDestinationStation(), () -> {}), null));
            entries.add(DLContextMenu.ItemEntry.SEPARATOR);
            entries.add(new DLContextMenu.ItemEntry(Constants.TEXT_REMOVE, DLSprite.empty(), true, () -> DLUtils.doIfNotNull((Object)viewer.getUserSettings(), a -> {
                a.recentSearchQueries.getValue().remove(query);
                a.clientSave(() -> {});
            }), null));
            return entries;
        });
        this.addEventListener(DLGuiStandardEvents.RightClickEvent.class, (src, event) -> {
            contextMenu.open(this.getWindowManager(), (int)this.getWindowManager().mouseXOnScreen(), (int)this.getWindowManager().mouseYOnScreen());
            return false;
        });
    }

    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        if (!((Boolean)this.enabled.get()).booleanValue()) {
            ((IStateRenderer)this.componentRenderer.get()).renderSprite(graphics, 0, 0, this.width(), this.height(), (DLGuiComponent)this, (Enum)DLButton.ButtonState.DISABLED);
        } else if (this.isMouseDown() && (this.getWindowManager() == null || this.getWindowManager().getMouseDownButton() == 0)) {
            ((IStateRenderer)this.componentRenderer.get()).renderSprite(graphics, 0, 0, this.width(), this.height(), (DLGuiComponent)this, (Enum)DLButton.ButtonState.DOWN_SELECTED);
        } else if (this.isSelected()) {
            ((IStateRenderer)this.componentRenderer.get()).renderSprite(graphics, 0, 0, this.width(), this.height(), (DLGuiComponent)this, (Enum)DLButton.ButtonState.SELECTED);
        } else {
            ((IStateRenderer)this.componentRenderer.get()).renderSprite(graphics, 0, 0, this.width(), this.height(), (DLGuiComponent)this, (Enum)DLButton.ButtonState.NORMAL);
        }
        graphics.poseStack().m_85836_();
        graphics.poseStack().m_252880_(3.0f, 3.0f, 0.0f);
        graphics.poseStack().m_85841_(0.75f, 0.75f, 0.75f);
        GuiUtils.drawString((DLGuiGraphics)graphics, (Font)graphics.defaultFont(), (int)0, (int)0, (FormattedText)this.text, (DLColor)DragonLib.VANILLA_BUTTON_ACTIVE_FONT_COLOR, (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
        graphics.poseStack().m_85849_();
        graphics.poseStack().m_85836_();
        graphics.poseStack().m_252880_((float)(this.width() - 3), 3.0f, 0.0f);
        graphics.poseStack().m_85841_(0.75f, 0.75f, 0.75f);
        GuiUtils.drawString((DLGuiGraphics)graphics, (Font)graphics.defaultFont(), (int)0, (int)0, (FormattedText)this.subText, (DLColor)DragonLib.VANILLA_BUTTON_ACTIVE_FONT_COLOR, (ETextAlignment)ETextAlignment.RIGHT, (boolean)false);
        graphics.poseStack().m_85849_();
    }
}

