/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.foundation.gui.AllIcons;
import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.client.gui.Animator;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.widgets.RecentSearchQueryButton;
import de.mrjulsen.crn.client.gui.widgets.RouteWidget;
import de.mrjulsen.crn.client.gui.widgets.skins.ModernScrollbarComponentRenderer;
import de.mrjulsen.crn.data.UserSettings;
import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.crn.data.storage.RecentSearchQueries;
import de.mrjulsen.crn.network.packets.pain.NavigatePacketData;
import de.mrjulsen.crn.registry.ModNetworkManager;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLContextMenu;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLPanel;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLScrollBar;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.EAlign;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.DLSprite;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.network.NetworkDirection;
import de.mrjulsen.mcdragonlib.network.NetworkPacketData;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.mcdragonlib.util.properties.BooleanProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class RouteViewer
extends DLGuiComponent {
    private final MutableComponent searchingText = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.searching");
    private final MutableComponent noConnectionsText = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.no_connections");
    private final MutableComponent notSearchedText = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.not_searched");
    private final MutableComponent txtRecentSearchQueries = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.recently_searched").m_130940_(ChatFormatting.BOLD);
    public final BooleanProperty displayRecentSearchQueries = new BooleanProperty(false);
    private final List<ClientRoute> routes = new ArrayList<ClientRoute>();
    private final DLPanel contentPanel;
    private final DLScrollBar scrollbar;
    private UserSettings settings;
    private final Animator animator = (Animator)this.addComponent(new Animator());
    private int angle = 0;
    private double animPercentage = 0.0;
    private double renderOffsetX = 0.0;
    private boolean animationStarted = false;
    private boolean hasSearched = false;
    private boolean isLoading = false;
    private int contentHeight = 0;

    public RouteViewer(int x, int y, int w, int h) {
        super(x, y, w, h);
        this.contentPanel = (DLPanel)this.addComponent((DLGuiComponent)new DLPanel(0, 0, this.width(), this.height()));
        this.contentPanel.anchor.set2((Enum[])EAlign.values());
        this.contentPanel.inputConsumptionPolicy.set(type -> false);
        this.scrollbar = (DLScrollBar)this.addComponent((DLGuiComponent)new DLScrollBar(this.width() - 5, 0, 5, this.height(), DLScrollBar.Orientation.VERTICAL));
        this.scrollbar.componentRenderer.set((Object)ModernScrollbarComponentRenderer.INSTANCE);
        this.scrollbar.anchor.set2((Enum[])new EAlign[]{EAlign.TOP, EAlign.BOTTOM, EAlign.RIGHT});
        this.scrollbar.scrollerSize.set((Number)0);
        this.scrollbar.screenSize.set((Number)this.height());
        this.scrollbar.scrollSteps.set((Number)10);
        this.scrollbar.max.set((Number)0);
        this.scrollbar.inputConsumptionPolicy.set(type -> true);
        this.scrollbar.addEventListener(DLScrollBar.ValueChangedEvent.class, (s, e) -> {
            this.contentPanel.setScrollOffsetY(e.value());
            return false;
        });
        this.addEventListener(DLGuiStandardEvents.ScrollEvent.class, (arg_0, arg_1) -> ((DLScrollBar)this.scrollbar).invokeEvent(arg_0, arg_1));
        DLContextMenu recetlySearchedMenu = new DLContextMenu((pX, pY) -> {
            ArrayList<DLContextMenu.ItemEntry> entries = new ArrayList<DLContextMenu.ItemEntry>();
            entries.add(new DLContextMenu.ItemEntry((Component)TextUtils.text((String)"Clear"), DLSprite.empty(), true, () -> {}, null));
            return entries;
        });
        DLContextMenu routesViewMenu = new DLContextMenu((pX, pY) -> {
            ArrayList<DLContextMenu.ItemEntry> entries = new ArrayList<DLContextMenu.ItemEntry>();
            entries.add(new DLContextMenu.ItemEntry((Component)TextUtils.text((String)"Clear"), DLSprite.empty(), true, () -> {}, null));
            entries.add(DLContextMenu.ItemEntry.SEPARATOR);
            entries.add(new DLContextMenu.ItemEntry((Component)TextUtils.text((String)"Refresh"), DLSprite.empty(), true, () -> {}, null));
            return entries;
        });
        this.addEventListener(DLGuiStandardEvents.RightClickEvent.class, (src, event) -> {
            if (this.hasSearched) {
                routesViewMenu.open(this.getWindowManager(), (int)this.getWindowManager().mouseXOnScreen(), (int)this.getWindowManager().mouseYOnScreen());
            } else {
                recetlySearchedMenu.open(this.getWindowManager(), (int)this.getWindowManager().mouseXOnScreen(), (int)this.getWindowManager().mouseYOnScreen());
            }
            return false;
        });
    }

    public void search(String start, String end, Runnable andThen) {
        this.isLoading = true;
        this.settings.recentSearchQueries.getValue().add(new RecentSearchQueries.RecentSearchQuery(start, end));
        this.contentPanel.clearComponents();
        this.animPercentage = 0.0;
        this.renderOffsetX = -50.0;
        this.settings.clientSave(() -> {
            this.animator.start(10, (poseStack, current, total, percentage) -> {
                this.animPercentage = Math.pow(1.0 - percentage, 4.0);
                this.renderOffsetX = -(50.0 * this.animPercentage);
            }, null, () -> {
                this.renderOffsetX = 0.0;
                ModNetworkManager.NAVIGATE.send((NetworkDirection)NetworkDirection.toServer(), (NetworkPacketData)new NavigatePacketData.Request(start, end, Minecraft.m_91087_().f_91074_.m_20148_()), response -> {
                    this.routes.clear();
                    this.routes.addAll(response.getData());
                    this.animator.start(10, (poseStack, current, total, percentage) -> {
                        this.animPercentage = Math.pow(percentage, 4.0);
                        this.renderOffsetX = 50.0 * this.animPercentage;
                    }, null, () -> {
                        this.animationStarted = false;
                        this.animPercentage = 0.0;
                        this.renderOffsetX = 0.0;
                        this.loadList();
                        andThen.run();
                        this.hasSearched = true;
                        this.isLoading = false;
                    });
                }, andThen::run);
            });
            this.animationStarted = true;
        });
    }

    public void updateSettings(UserSettings settings) {
        if (this.isLoading) {
            return;
        }
        this.settings = settings;
        this.loadList();
    }

    private void loadList() {
        this.contentPanel.clearComponents();
        this.contentHeight = 0;
        if (((Boolean)this.displayRecentSearchQueries.get()).booleanValue() && !this.hasSearched && !this.isLoading && this.routes.isEmpty() && this.settings != null) {
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            this.contentHeight = 20 + 9;
            for (RecentSearchQueries.RecentSearchQuery query : this.settings.recentSearchQueries.getValue().getAll()) {
                RecentSearchQueryButton btn = (RecentSearchQueryButton)this.contentPanel.addComponent((DLGuiComponent)new RecentSearchQueryButton(this, 10, this.contentHeight, this.width() - 20, query));
                this.contentHeight += btn.height();
            }
            this.contentHeight += 10;
        } else if (!this.routes.isEmpty()) {
            this.contentHeight = 5;
            for (ClientRoute route : this.routes) {
                RouteWidget w = (RouteWidget)this.contentPanel.addComponent((DLGuiComponent)new RouteWidget(10, this.contentHeight, route));
                this.contentHeight += w.height() + 3;
            }
            this.contentHeight += 3;
        }
        this.scrollbar.max.set((Number)this.contentHeight);
    }

    public UserSettings getUserSettings() {
        return this.settings;
    }

    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        graphics.poseStack().m_85836_();
        graphics.poseStack().m_85837_(this.renderOffsetX, 0.0, 0.0);
        float frameTime = Minecraft.m_91087_().m_91296_();
        this.angle = (int)((float)this.angle + 6.0f * frameTime);
        if (this.angle > 360) {
            this.angle = 0;
        }
        double offsetX = Math.sin(Math.toRadians(this.angle)) * 5.0;
        double offsetY = Math.cos(Math.toRadians(this.angle)) * 5.0;
        if (!this.isLoading) {
            if (this.hasSearched && this.routes.isEmpty()) {
                Font font = graphics.defaultFont();
                int n = this.width() / 2;
                int n2 = this.height() / 2 + 15;
                Objects.requireNonNull(graphics.defaultFont());
                GuiUtils.drawString((DLGuiGraphics)graphics, (Font)font, (int)n, (int)(n2 - 9 - 10), (FormattedText)this.noConnectionsText, (DLColor)DLColor.WHITE, (ETextAlignment)ETextAlignment.CENTER, (boolean)false);
                GuiGraphics guiGraphics = graphics.graphics();
                int n3 = this.width() / 2 - 8;
                int n4 = this.height() / 2 - 15;
                Objects.requireNonNull(graphics.defaultFont());
                AllIcons.I_ACTIVE.render(guiGraphics, n3, n4 - 9 - 10);
            } else if (this.settings != null && ((Boolean)this.displayRecentSearchQueries.get()).booleanValue() && !this.hasSearched && !this.settings.recentSearchQueries.getValue().isEmpty()) {
                GuiUtils.drawString((DLGuiGraphics)graphics, (Font)graphics.defaultFont(), (int)10, (int)10, (FormattedText)this.txtRecentSearchQueries, (DLColor)DLColor.WHITE, (ETextAlignment)ETextAlignment.LEFT, (boolean)true);
                if (this.settings == null) {
                    Font font = graphics.defaultFont();
                    int n = this.width() / 2;
                    int n5 = this.height() / 2 + 15;
                    Objects.requireNonNull(graphics.defaultFont());
                    GuiUtils.drawString((DLGuiGraphics)graphics, (Font)font, (int)n, (int)(n5 - 9), (FormattedText)Constants.TEXT_LOADING, (DLColor)DLColor.WHITE, (ETextAlignment)ETextAlignment.CENTER, (boolean)false);
                    GuiGraphics guiGraphics = graphics.graphics();
                    int n6 = (int)((double)(this.width() / 2 - 8) + offsetX);
                    int n7 = this.height() / 2 - 15;
                    Objects.requireNonNull(graphics.defaultFont());
                    AllIcons.I_MTD_SCAN.render(guiGraphics, n6, (int)((double)(n7 - 9) + offsetY));
                }
            } else if (!this.hasSearched) {
                Font font = graphics.defaultFont();
                int n = this.width() / 2;
                int n8 = this.height() / 2 + 15;
                Objects.requireNonNull(graphics.defaultFont());
                GuiUtils.drawString((DLGuiGraphics)graphics, (Font)font, (int)n, (int)(n8 - 9), (FormattedText)this.notSearchedText, (DLColor)DLColor.WHITE, (ETextAlignment)ETextAlignment.CENTER, (boolean)false);
                int n9 = this.width() / 2 - 8;
                int n10 = this.height() / 2 - 15;
                Objects.requireNonNull(graphics.defaultFont());
                ModGuiIcons.INFO.render(graphics, n9, n10 - 9);
            }
        } else if (this.animationStarted) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GuiUtils.setTint((DLColor)DLColor.of((float)(this.animator.isRunning() ? (float)(1.0 - this.animPercentage) : 1.0f), (float)1.0f, (float)1.0f, (float)1.0f));
            int n = this.width() / 2 - graphics.defaultFont().m_92852_((FormattedText)this.searchingText) / 2 - 10;
            int n11 = this.height() / 2 - 25;
            Objects.requireNonNull(graphics.defaultFont());
            CreateDynamicWidgets.renderShadow(graphics, n, n11 - 9, graphics.defaultFont().m_92852_((FormattedText)this.searchingText) + 20, 55);
            Font font = graphics.defaultFont();
            int n12 = this.width() / 2;
            int n13 = this.height() / 2 + 15;
            Objects.requireNonNull(graphics.defaultFont());
            GuiUtils.drawString((DLGuiGraphics)graphics, (Font)font, (int)n12, (int)(n13 - 9), (FormattedText)this.searchingText, (DLColor)DLColor.of((float)((float)(1.0 - this.animPercentage)), (float)1.0f, (float)1.0f, (float)1.0f), (ETextAlignment)ETextAlignment.CENTER, (boolean)false);
            GuiGraphics guiGraphics = graphics.graphics();
            int n14 = (int)((double)(this.width() / 2 - 8) + offsetX);
            int n15 = this.height() / 2 - 15;
            Objects.requireNonNull(graphics.defaultFont());
            AllIcons.I_MTD_SCAN.render(guiGraphics, n14, (int)((double)(n15 - 9) + offsetY));
        }
        if (!this.isLoading && this.scrollbar.canScroll() && (Double)this.scrollbar.value.get() > 0.0) {
            GuiUtils.fillGradient((DLGuiGraphics)graphics, (int)0, (int)0, (int)this.width(), (int)10, (DLColor)DLColor.fromInt((int)0x77000000), (DLColor)DLColor.TRANSPARENT, (EAlign)EAlign.TOP);
        }
        if (!this.isLoading && this.scrollbar.canScroll() && (Double)this.scrollbar.value.get() < (double)((Integer)this.scrollbar.max.get()).intValue()) {
            GuiUtils.fillGradient((DLGuiGraphics)graphics, (int)0, (int)(this.height() - 10), (int)this.width(), (int)10, (DLColor)DLColor.fromInt((int)0x77000000), (DLColor)DLColor.TRANSPARENT, (EAlign)EAlign.BOTTOM);
        }
        graphics.poseStack().m_85849_();
    }
}

