/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.content.trains.station.NoShadowFontWrapper;
import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.windows.RouteDetailsWindow;
import de.mrjulsen.crn.client.lang.CustomLanguage;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.crn.data.navigation.RoutePart;
import de.mrjulsen.crn.util.ETimeFormat;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.CursorType;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.mcdragonlib.util.time.ConfiguredTimeSystem;
import de.mrjulsen.mcdragonlib.util.time.DLTime;
import de.mrjulsen.mcdragonlib.util.time.ITimeSystem;
import de.mrjulsen.mcdragonlib.util.time.TimeContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class RouteWidget
extends DLButton {
    public static final int WIDTH = 214;
    public static final int HEIGHT = 54;
    private static final int DISPLAY_WIDTH = 204;
    private final ClientRoute route;
    private final MutableComponent transferText = CustomLanguage.translate("gui.createrailwaysnavigator.navigator.route_entry.transfer");
    private final MutableComponent connectionInPast = CustomLanguage.translate("gui.createrailwaysnavigator.navigator.route_entry.connection_in_past");
    private final MutableComponent trainCanceled = CustomLanguage.translate("gui.createrailwaysnavigator.route_overview.stop_cancelled");
    private final MutableComponent textShowDetails = TextUtils.translate((String)"gui.createrailwaysnavigator.route_widget.show_details");
    private final MutableComponent textSave = TextUtils.translate((String)"gui.createrailwaysnavigator.route_widget.save");
    private final MutableComponent textShare = TextUtils.translate((String)"gui.createrailwaysnavigator.route_widget.share");
    private final MutableComponent textRemove = TextUtils.translate((String)"gui.createrailwaysnavigator.route_widget.remove");

    public RouteWidget(int x, int y, ClientRoute route) {
        super(x, y, 214, 54);
        this.cursor.set((Object)CursorType.HAND);
        this.route = route;
        this.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            this.getWindowManager().createModal(mgr -> new RouteDetailsWindow(mgr, route));
            return false;
        });
    }

    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        DLColor color;
        int i;
        int precision = (Integer)ModClientConfig.REALTIME_PRECISION_THRESHOLD.get();
        CreateDynamicWidgets.renderSingleShadeWidget(graphics, 0, 0, 214, 54, CreateDynamicWidgets.ColorShade.DARK.getColor());
        CreateDynamicWidgets.renderHorizontalSeparator(graphics, 6, 22, 202);
        if (this.isSelected()) {
            GuiUtils.fill((DLGuiGraphics)graphics, (int)0, (int)0, (int)this.width(), (int)this.height(), (DLColor)DLColor.fromInt((int)0x22FFFFFF));
        }
        Minecraft minecraft = Minecraft.m_91087_();
        ImmutableList<RoutePart> parts = this.route.getParts();
        NoShadowFontWrapper shadowlessFont = new NoShadowFontWrapper(minecraft.f_91062_);
        String timeStart = DLTime.fromTicks((double)this.route.getStart().getScheduledDepartureTime(), (ITimeSystem)new ConfiguredTimeSystem()).format(((ETimeFormat)((Object)ModClientConfig.TIME_FORMAT.get())).getFormat(), TimeContext.INGAME);
        String timeEnd = DLTime.fromTicks((double)this.route.getEnd().getScheduledArrivalTime(), (ITimeSystem)new ConfiguredTimeSystem()).format(((ETimeFormat)((Object)ModClientConfig.TIME_FORMAT.get())).getFormat(), TimeContext.INGAME);
        String dash = " - ";
        MutableComponent summary = TextUtils.text((String)String.format("%s%s%s | %s %s | %s", timeStart, dash, timeEnd, this.route.getTransferCount(), this.transferText.getString(), DLTime.fromTicks((double)((int)this.route.travelTime()), (ITimeSystem)new ConfiguredTimeSystem()).format(Constants.DEFAULT_VERBOSE_GAME_DURATION_FORMAT, TimeContext.INGAME)));
        float scale = 0.75f;
        float localScale = shadowlessFont.m_92852_((FormattedText)summary) > 202 ? 0.75f : 1.0f;
        graphics.poseStack().m_85836_();
        graphics.poseStack().m_85841_(localScale, 1.0f, 1.0f);
        GuiUtils.drawString((DLGuiGraphics)graphics, (Font)minecraft.f_91062_, (int)((int)(6.0f / localScale)), (int)5, (FormattedText)summary, (DLColor)DLColor.WHITE, (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
        graphics.poseStack().m_85849_();
        int routePartWidth = 204 / parts.size();
        String endStationName = this.route.getEnd().getRealTimeStationTag().tagName();
        int textW = shadowlessFont.m_92895_(endStationName);
        for (i = 0; i < parts.size(); ++i) {
            color = ((RoutePart)parts.get(i)).getFirstStop().getTrainDisplayColor();
            GuiUtils.fill((DLGuiGraphics)graphics, (int)(6 + i * routePartWidth + 1), (int)27, (int)(routePartWidth - 4), (int)1, (DLColor)color);
            GuiUtils.fill((DLGuiGraphics)graphics, (int)(5 + i * routePartWidth + 1), (int)28, (int)(routePartWidth - 2), (int)9, (DLColor)color);
            GuiUtils.fill((DLGuiGraphics)graphics, (int)(6 + i * routePartWidth + 1), (int)37, (int)(routePartWidth - 4), (int)1, (DLColor)color);
        }
        graphics.poseStack().m_85836_();
        graphics.poseStack().m_85841_(0.75f, 0.75f, 0.75f);
        for (i = 0; i < parts.size(); ++i) {
            color = ((RoutePart)parts.get(i)).getFirstStop().getTrainDisplayColor();
            DLColor fontColor = DLColor.pickBasedOnBrightness((DLColor)color, (DLColor)DLColor.WHITE, (DLColor)DLColor.BLACK, (float)0.5f);
            Component trainName = TextUtils.truncateWithEllipsis((Font)graphics.defaultFont(), (Component)TextUtils.text((String)((RoutePart)parts.get(i)).getFirstStop().getTrainDisplayName()), (int)((int)((float)(routePartWidth - 10) / 0.75f)));
            GuiUtils.drawString((DLGuiGraphics)graphics, (Font)graphics.defaultFont(), (int)((int)((float)(5 + i * routePartWidth + routePartWidth / 2) / 0.75f)), (int)40, (FormattedText)trainName, (DLColor)fontColor, (ETextAlignment)ETextAlignment.CENTER, (boolean)false);
        }
        GuiUtils.drawString((DLGuiGraphics)graphics, (Font)graphics.defaultFont(), (int)8, (int)57, (FormattedText)TextUtils.text((String)this.route.getStart().getRealTimeStationTag().tagName()), (DLColor)DLColor.fromInt((int)-2368549), (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
        GuiUtils.drawString((DLGuiGraphics)graphics, (Font)graphics.defaultFont(), (int)(277 - textW), (int)57, (FormattedText)TextUtils.text((String)endStationName), (DLColor)DLColor.fromInt((int)-2368549), (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
        if (this.route.getStart().shouldRenderRealTime()) {
            GuiUtils.drawString((DLGuiGraphics)graphics, (Font)graphics.defaultFont(), (int)((int)((6.0f + (float)graphics.defaultFont().m_92895_(timeStart) * localScale / 2.0f) / 0.75f) - graphics.defaultFont().m_92895_(timeStart) / 2), (int)20, (FormattedText)TextUtils.text((String)DLTime.fromTicks((double)(this.route.getStart().getScheduledDepartureTime() + this.route.getStart().getDepartureTimeDeviation() / (long)precision * (long)precision), (ITimeSystem)new ConfiguredTimeSystem()).format(((ETimeFormat)((Object)ModClientConfig.TIME_FORMAT.get())).getFormat(), TimeContext.INGAME)), (DLColor)(this.route.getStart().isDepartureDelayed() ? Constants.COLOR_DELAYED : Constants.COLOR_ON_TIME), (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
        }
        if (this.route.getEnd().shouldRenderRealTime()) {
            GuiUtils.drawString((DLGuiGraphics)graphics, (Font)graphics.defaultFont(), (int)((int)((6.0f + (float)graphics.defaultFont().m_92895_(timeEnd) * localScale * 1.5f + (float)graphics.defaultFont().m_92895_(dash) * localScale) / 0.75f) - graphics.defaultFont().m_92895_(timeEnd) / 2), (int)20, (FormattedText)TextUtils.text((String)DLTime.fromTicks((double)(this.route.getEnd().getScheduledArrivalTime() + this.route.getEnd().getArrivalTimeDeviation() / (long)precision * (long)precision), (ITimeSystem)new ConfiguredTimeSystem()).format(((ETimeFormat)((Object)ModClientConfig.TIME_FORMAT.get())).getFormat(), TimeContext.INGAME)), (DLColor)(this.route.getEnd().isArrivalDelayed() ? Constants.COLOR_DELAYED : Constants.COLOR_ON_TIME), (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
        }
        if (this.route.isAnyCancelled()) {
            GuiUtils.drawString((DLGuiGraphics)graphics, (Font)shadowlessFont, (int)278, (int)20, (FormattedText)this.trainCanceled, (DLColor)Constants.COLOR_DELAYED, (ETextAlignment)ETextAlignment.RIGHT, (boolean)false);
        } else if (this.route.getStart().isDeparted()) {
            GuiUtils.drawString((DLGuiGraphics)graphics, (Font)shadowlessFont, (int)278, (int)20, (FormattedText)this.connectionInPast, (DLColor)Constants.COLOR_DELAYED, (ETextAlignment)ETextAlignment.RIGHT, (boolean)false);
        }
        graphics.poseStack().m_85849_();
    }
}

