/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets;

import de.mrjulsen.crn.client.gui.widgets.SavedRouteWidget;
import de.mrjulsen.crn.client.gui.widgets.skins.ModernScrollbarComponentRenderer;
import de.mrjulsen.crn.data.ISavableNavigatorData;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLPanel;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLScrollBar;
import de.mrjulsen.mcdragonlib.client.gui.widgets.layout.FlowLayout;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.Padding;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.EAlign;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.mcdragonlib.util.time.ConfiguredTimeSystem;
import de.mrjulsen.mcdragonlib.util.time.DLTime;
import de.mrjulsen.mcdragonlib.util.time.ITimeSystem;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.Level;

public class SavedRoutesViewer
extends DLGuiComponent {
    private final DLPanel contentPanel;
    private final DLScrollBar scrollbar;
    private List<? extends ISavableNavigatorData> data = List.of();

    public SavedRoutesViewer(int x, int y, int w, int h) {
        super(x, y, w, h);
        this.contentPanel = (DLPanel)this.addComponent((DLGuiComponent)new DLPanel(0, 0, this.width(), this.height()));
        this.contentPanel.anchor.set2((Enum[])EAlign.values());
        this.contentPanel.inputConsumptionPolicy.set(type -> false);
        FlowLayout layout = new FlowLayout();
        layout.fillCrossAxis.set((Object)true);
        layout.flowDirection.set((Object)FlowLayout.Direction.VERTICAL);
        layout.padding.set((Object)new Padding(10, 10, 10, 10));
        layout.wrap.set((Object)false);
        layout.verticalGap.set((Number)3);
        this.contentPanel.layout.set((Object)layout);
        this.scrollbar = (DLScrollBar)this.addComponent((DLGuiComponent)new DLScrollBar(this.width() - 5, 0, 5, this.height(), DLScrollBar.Orientation.VERTICAL));
        this.scrollbar.componentRenderer.set((Object)ModernScrollbarComponentRenderer.INSTANCE);
        this.scrollbar.anchor.set2((Enum[])new EAlign[]{EAlign.TOP, EAlign.BOTTOM, EAlign.RIGHT});
        this.scrollbar.scrollerSize.set((Number)0);
        this.scrollbar.screenSize.set((Number)this.contentPanel.height());
        this.scrollbar.scrollSteps.set((Number)15);
        this.scrollbar.max.set((Number)0);
        this.scrollbar.inputConsumptionPolicy.set(type -> true);
        this.scrollbar.addEventListener(DLScrollBar.ValueChangedEvent.class, (s, e) -> {
            this.contentPanel.setScrollOffsetY(e.value());
            return false;
        });
        this.addEventListener(DLGuiStandardEvents.ScrollEvent.class, (arg_0, arg_1) -> ((DLScrollBar)this.scrollbar).invokeEvent(arg_0, arg_1));
        this.contentPanel.addEventListener(DLGuiStandardEvents.ComponentLayoutUpdatedEvent.class, (s, e) -> {
            this.scrollbar.max.set((Number)e.layoutResult().contentHeight());
            this.scrollbar.screenSize.set((Number)this.contentPanel.height());
            return false;
        });
    }

    public void refresh() {
        this.displaySavedRoutes(this.data);
    }

    public void displaySavedRoutes(List<? extends ISavableNavigatorData> data) {
        this.contentPanel.clearComponents();
        this.data = data;
        Collections.sort(data, Comparator.comparing(x -> ((ISavableNavigatorData)x).customGroup() == null ? null : (String)((ISavableNavigatorData)x).customGroup().getFirst(), Comparator.nullsLast(Comparator.naturalOrder())).thenComparingLong(x -> ((ISavableNavigatorData)x).dayOrderValue()).thenComparingLong(x -> ((ISavableNavigatorData)x).timeOrderValue()));
        ISavableNavigatorData lastData = null;
        for (int i = 0; i < data.size(); ++i) {
            ISavableNavigatorData d = data.get(i);
            if (lastData != null && lastData.customGroup() != d.customGroup()) {
                this.contentPanel.addComponent((DLGuiComponent)new GroupingHeader((Component)(d.customGroup() == null ? TextUtils.empty() : (MutableComponent)d.customGroup().getSecond()).m_130940_(ChatFormatting.BOLD)));
            }
            if (lastData == null || lastData.dayOrderValue() != d.dayOrderValue()) {
                DLTime worldTime = DLTime.fromLevelTime((Level)Minecraft.m_91087_().f_91073_, (ITimeSystem)new ConfiguredTimeSystem());
                long dayDiff = d.dayOrderValue() - (long)worldTime.toGameDays();
                MutableComponent text = d.timeOrderValue() < (long)worldTime.getTicks() ? TextUtils.translate((String)"gui.createrailwaysnavigator.saved_routes.in_the_past") : (dayDiff == 0L ? TextUtils.translate((String)"gui.createrailwaysnavigator.saved_routes.today") : (dayDiff == 1L ? TextUtils.translate((String)"gui.createrailwaysnavigator.saved_routes.tomorrow") : TextUtils.translate((String)"gui.createrailwaysnavigator.saved_routes.in_days", (Object[])new Object[]{dayDiff})));
                this.contentPanel.addComponent((DLGuiComponent)new GroupingHeader((Component)text));
            }
            lastData = d;
            SavedRouteWidget widget = new SavedRouteWidget(this, 0, 0, d);
            this.contentPanel.addComponent((DLGuiComponent)widget);
        }
    }

    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        if (this.scrollbar.canScroll() && (Double)this.scrollbar.value.get() > 0.0) {
            GuiUtils.fillGradient((DLGuiGraphics)graphics, (int)0, (int)0, (int)this.width(), (int)10, (DLColor)DLColor.fromInt((int)0x77000000), (DLColor)DLColor.TRANSPARENT, (EAlign)EAlign.TOP);
        }
        if (this.scrollbar.canScroll() && (Double)this.scrollbar.value.get() < (double)((Integer)this.scrollbar.max.get()).intValue()) {
            GuiUtils.fillGradient((DLGuiGraphics)graphics, (int)0, (int)(this.height() - 10), (int)this.width(), (int)10, (DLColor)DLColor.fromInt((int)0x77000000), (DLColor)DLColor.TRANSPARENT, (EAlign)EAlign.BOTTOM);
        }
    }

    private static final class GroupingHeader
    extends DLGuiComponent {
        private static final int HEIGHT = 24;
        private final Component text;

        public GroupingHeader(Component text) {
            super(0, 0, 100, 24);
            this.text = text == null ? TextUtils.empty() : text;
        }

        public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
            Font font = graphics.defaultFont();
            int n = this.height() / 2;
            Objects.requireNonNull(graphics.defaultFont());
            GuiUtils.drawString((DLGuiGraphics)graphics, (Font)font, (int)0, (int)(n - 9 / 2), (FormattedText)this.text, (DLColor)DragonLib.VANILLA_BUTTON_ACTIVE_FONT_COLOR, (ETextAlignment)ETextAlignment.LEFT, (boolean)true);
        }
    }
}

