/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets;

import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.widgets.skins.ModernScrollbarComponentRenderer;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.annotations.SupportsEvents;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLItemSelectionBox;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.events.IEvent;
import de.mrjulsen.mcdragonlib.events.IEventDispatcher;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.FormattedText;

@SupportsEvents(value={SelectEvent.class})
public class SelectionListBox<T>
extends DLItemSelectionBox<T> {
    public SelectionListBox(int x, int y, int w, int h) {
        super(x, y, w, h);
        this.scrollBar.componentRenderer.set((Object)ModernScrollbarComponentRenderer.INSTANCE);
        this.scrollBar.setSize(5.0, (double)this.height());
        this.scrollBar.setPosition((double)(this.width() - 5), 0.0);
        this.contentPanel.setPosition(0.0, 0.0);
        this.contentPanel.setSize((double)this.width(), (double)this.height());
    }

    protected DLItemSelectionBox.DLListBoxItem<T> defaultItemBuilder(T item) {
        SelectionBoxItem<T> itm = new SelectionBoxItem<T>(this, item);
        itm.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            this.invokeEvent((IEventDispatcher)this, new SelectEvent(itm));
            return false;
        });
        return itm;
    }

    protected void defaultItemSelection(DLItemSelectionBox.ItemSelectionChangeEvent event) {
        List itemComponents = this.getSelectedComponent();
        DLItemSelectionBox.DLListBoxItem clickedItem = event.item();
        boolean isSelected = (Boolean)clickedItem.selected.get();
        if (!((Boolean)this.multiselect.get()).booleanValue()) {
            for (DLItemSelectionBox.DLListBoxItem itm : itemComponents) {
                if (itm == event.item()) continue;
                itm.selected.set((Object)false);
            }
        }
        event.selected().setValue(!isSelected);
    }

    public void selectIf(Predicate<T> test) {
        LinkedList items = new LinkedList();
        for (Object item : this.items) {
            if (!test.test(item)) continue;
            items.add(item);
        }
        this.selectedItems.set(items);
    }

    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
    }

    public static class SelectionBoxItem<T>
    extends DLItemSelectionBox.DLListBoxItem<T> {
        protected SelectionBoxItem(SelectionListBox<T> collectionComponentRef, T item) {
            super(collectionComponentRef, item, 100, 16);
        }

        public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
            if (((Boolean)this.selected.get()).booleanValue()) {
                ModGuiIcons.CHECKMARK.render(graphics, 1, 0);
            }
            if (this.isSelected()) {
                GuiUtils.fill((DLGuiGraphics)graphics, (int)0, (int)0, (int)this.width(), (int)this.height(), (DLColor)DLColor.fromInt((int)0x44FFFFFF));
            }
            Font font = Minecraft.m_91087_().f_91062_;
            int n = this.height() / 2;
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            GuiUtils.drawString((DLGuiGraphics)graphics, (Font)font, (int)20, (int)(n - 9 / 2), (FormattedText)((FormattedText)((Function)((SelectionListBox)this.collectionComponentRef).textFormat.get()).apply(this.item)), (DLColor)((Boolean)this.selected.get() != false ? DragonLib.VANILLA_BUTTON_HIGHLIGHTED_FONT_COLOR : DragonLib.VANILLA_BUTTON_ACTIVE_FONT_COLOR), (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
        }

        public T getItem() {
            return (T)this.item;
        }
    }

    public record SelectEvent(DLItemSelectionBox.DLListBoxItem<?> item) implements IEvent
    {
    }
}

