/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets;

import com.simibubi.create.foundation.gui.AllIcons;
import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.widgets.StationDeparturesViewer;
import de.mrjulsen.crn.client.gui.windows.TrainJourneyWindow;
import de.mrjulsen.crn.client.lang.CustomLanguage;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.crn.data.train.TrainStop;
import de.mrjulsen.crn.util.ETimeFormat;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.CursorType;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.mcdragonlib.util.time.ConfiguredTimeSystem;
import de.mrjulsen.mcdragonlib.util.time.DLTime;
import de.mrjulsen.mcdragonlib.util.time.ITimeSystem;
import de.mrjulsen.mcdragonlib.util.time.TimeContext;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class StationDeparturesWidget
extends DLButton {
    public static final int HEADER_HEIGHT = 20;
    public static final int DEFAULT_LINE_HEIGHT = 12;
    public static final float DEFAULT_SCALE = 0.75f;
    private final MutableComponent connectionInPast = CustomLanguage.translate("gui.createrailwaysnavigator.navigator.route_entry.connection_in_past");
    private final MutableComponent trainCanceled = CustomLanguage.translate("gui.createrailwaysnavigator.route_overview.stop_cancelled");
    private final ClientRoute route;
    private final boolean arrival;

    public StationDeparturesWidget(StationDeparturesViewer viewer, ClientRoute route, boolean arrival) {
        super(0, 0, 100, 32);
        this.route = route;
        this.arrival = arrival;
        this.cursor.set((Object)CursorType.HAND);
        this.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            this.getWindowManager().createModal(mgr -> new TrainJourneyWindow(mgr, route, route.getStart().getTrainId()));
            return false;
        });
    }

    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        MutableComponent stationText;
        CreateDynamicWidgets.renderSingleShadeWidget(graphics, 0, 0, this.width(), this.height(), CreateDynamicWidgets.ColorShade.DARK.getColor());
        if (this.isSelected()) {
            GuiUtils.fill((DLGuiGraphics)graphics, (int)0, (int)0, (int)this.width(), (int)this.height(), (DLColor)DLColor.fromInt((int)0x22FFFFFF));
        }
        TrainStop currentStop = this.arrival ? this.route.getEnd() : this.route.getStart();
        float scale = 0.75f;
        MutableComponent trainName = TextUtils.text((String)currentStop.getTrainDisplayName()).m_130940_(ChatFormatting.BOLD);
        graphics.poseStack().m_85836_();
        graphics.poseStack().m_85841_(0.75f, 0.75f, 0.75f);
        if (this.arrival) {
            AllIcons.I_CONFIG_OPEN.render(graphics.graphics(), 8, 5);
        } else {
            AllIcons.I_CONFIG_BACK.render(graphics.graphics(), 8, 5);
        }
        if (this.route.isAnyCancelled()) {
            GuiUtils.drawString((DLGuiGraphics)graphics, (Font)graphics.defaultFont(), (int)((int)((float)(this.width() - 5) / 0.75f)), (int)20, (FormattedText)this.trainCanceled, (DLColor)Constants.COLOR_DELAYED, (ETextAlignment)ETextAlignment.RIGHT, (boolean)false);
        } else if (this.route.getStart().isDeparted()) {
            GuiUtils.drawString((DLGuiGraphics)graphics, (Font)graphics.defaultFont(), (int)((int)((float)(this.width() - 5) / 0.75f)), (int)20, (FormattedText)this.connectionInPast, (DLColor)Constants.COLOR_DELAYED, (ETextAlignment)ETextAlignment.RIGHT, (boolean)false);
        }
        CreateDynamicWidgets.renderTextHighlighted(graphics, 30, 6, graphics.defaultFont(), (Component)trainName, currentStop.getTrainDisplayColor());
        graphics.poseStack().m_85849_();
        MutableComponent platformText = TextUtils.text((String)this.route.getStart().getRealTimeStationTag().info().platform());
        int maxStationNameWidth = this.width() - 6 - (int)((float)(45 + graphics.defaultFont().m_92852_((FormattedText)trainName)) * 0.75f);
        MutableComponent mutableComponent = stationText = this.arrival ? TextUtils.translate((String)"gui.createrailwaysnavigator.schedule_board.train_from", (Object[])new Object[]{this.route.getEnd().getRealTimeStationTag().tagName()}) : TextUtils.text((String)this.route.getStart().getDisplayTitle());
        if (graphics.defaultFont().m_92852_((FormattedText)stationText) > maxStationNameWidth) {
            stationText = TextUtils.text((String)graphics.defaultFont().m_92854_((FormattedText)stationText, maxStationNameWidth).getString()).m_7220_((Component)TextUtils.text((String)"...")).m_130948_(stationText.m_7383_());
        }
        GuiUtils.drawString((DLGuiGraphics)graphics, (Font)graphics.defaultFont(), (int)((int)((float)(45 + graphics.defaultFont().m_92852_((FormattedText)trainName)) * 0.75f)), (int)6, (FormattedText)stationText, (DLColor)DLColor.WHITE, (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
        GuiUtils.drawString((DLGuiGraphics)graphics, (Font)graphics.defaultFont(), (int)(this.width() - 6), (int)20, (FormattedText)platformText, (DLColor)DLColor.WHITE, (ETextAlignment)ETextAlignment.RIGHT, (boolean)false);
        GuiUtils.drawString((DLGuiGraphics)graphics, (Font)graphics.defaultFont(), (int)22, (int)20, (String)DLTime.fromTicks((double)(this.arrival ? (double)this.route.getStart().getScheduledArrivalTime() : (double)this.route.getStart().getScheduledDepartureTime()), (ITimeSystem)new ConfiguredTimeSystem()).format(((ETimeFormat)((Object)ModClientConfig.TIME_FORMAT.get())).getFormat(), TimeContext.INGAME), (DLColor)DLColor.WHITE, (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
        GuiUtils.drawString((DLGuiGraphics)graphics, (Font)graphics.defaultFont(), (int)62, (int)20, (String)DLTime.fromTicks((double)(this.arrival ? (double)this.route.getStart().getRealTimeArrivalTime() : (double)this.route.getStart().getRealTimeDepartureTime()), (ITimeSystem)new ConfiguredTimeSystem()).format(((ETimeFormat)((Object)ModClientConfig.TIME_FORMAT.get())).getFormat(), TimeContext.INGAME), (DLColor)((this.arrival ? this.route.getStart().isArrivalDelayed() : this.route.getStart().isDepartureDelayed()) ? Constants.COLOR_DELAYED : Constants.COLOR_ON_TIME), (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
    }

    public void close() {
        this.route.closeAll();
    }
}

