/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets;

import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.widgets.FlatIconButton;
import de.mrjulsen.crn.client.gui.widgets.SearchBox;
import de.mrjulsen.crn.client.gui.widgets.create.CreateTextBox;
import de.mrjulsen.crn.client.gui.widgets.skins.ModernScrollbarComponentRenderer;
import de.mrjulsen.crn.registry.ModNetworkManager;
import de.mrjulsen.crn.util.Owner;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLPanel;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLScrollBar;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.DLAbstractRichTextInputField;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.RichTextComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.EAlign;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.network.NetworkDirection;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class TrustedPlayerListComponent
extends DLGuiComponent {
    private final DLPanel contentPanel;
    private final SearchBox searchBox;
    private final DLScrollBar scrollBar;
    private final Map<String, Owner> playerPool = new HashMap<String, Owner>();
    private final Set<Owner> players = new HashSet<Owner>();

    public TrustedPlayerListComponent(int x, int y, int w, int h, Set<Owner> players) {
        super(x, y, w, h);
        this.players.addAll(players);
        this.contentPanel = (DLPanel)this.addComponent((DLGuiComponent)new DLPanel(0, 18, this.width(), this.height() - 36));
        this.searchBox = (SearchBox)this.addComponent((DLGuiComponent)new SearchBox(0, 0, this.width()));
        this.searchBox.acceptAndCancelKeysEnabled.set((Object)true);
        this.searchBox.placeholderText.set((Object)Constants.TEXT_SEARCH);
        this.searchBox.addEventListener(DLAbstractRichTextInputField.TextAcceptKeyPressedEvent.class, (s, e) -> {
            this.refresh();
            return false;
        });
        FlatIconButton addBtn = (FlatIconButton)this.addComponent((DLGuiComponent)new FlatIconButton(this.width() - 18, this.height() - 18, ModGuiIcons.ADD.getAsSprite(16, 16)));
        addBtn.anchor.set2((Enum[])new EAlign[]{EAlign.TOP, EAlign.RIGHT});
        CreateTextBox inputBox = (CreateTextBox)this.addComponent((DLGuiComponent)new CreateTextBox(0, this.height() - 18, this.width() - 18));
        inputBox.acceptAndCancelKeysEnabled.set((Object)true);
        inputBox.addEventListener(DLAbstractRichTextInputField.TextAcceptKeyPressedEvent.class, (s, e) -> {
            if (this.playerPool.containsKey(((RichTextComponent)inputBox.text.get()).getPlainText())) {
                this.players.add(this.playerPool.get(((RichTextComponent)inputBox.text.get()).getPlainText()));
                ((RichTextComponent)inputBox.text.get()).clear();
                this.refresh();
            }
            return false;
        });
        this.scrollBar = (DLScrollBar)this.addComponent((DLGuiComponent)new DLScrollBar(this.contentPanel.x() + this.contentPanel.width() - 5, this.contentPanel.y(), 5, this.contentPanel.height(), DLScrollBar.Orientation.VERTICAL));
        this.scrollBar.componentRenderer.set((Object)ModernScrollbarComponentRenderer.INSTANCE);
        this.scrollBar.anchor.set2((Enum[])new EAlign[]{EAlign.TOP, EAlign.BOTTOM, EAlign.RIGHT});
        this.scrollBar.scrollerSize.set((Number)0);
        this.scrollBar.screenSize.set((Number)this.contentPanel.height());
        this.scrollBar.scrollSteps.set((Number)10);
        this.scrollBar.max.set((Number)0);
        this.scrollBar.inputConsumptionPolicy.set(type -> true);
        this.scrollBar.addEventListener(DLScrollBar.ValueChangedEvent.class, (s, e) -> {
            this.contentPanel.setScrollOffsetY(e.value());
            return false;
        });
        addBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            if (this.playerPool.containsKey(((RichTextComponent)inputBox.text.get()).getPlainText())) {
                this.players.add(this.playerPool.get(((RichTextComponent)inputBox.text.get()).getPlainText()));
                ((RichTextComponent)inputBox.text.get()).clear();
                this.refresh();
            }
            return false;
        });
        this.reload();
        this.refresh();
    }

    public Set<Owner> getSelectedPlayers() {
        return this.players;
    }

    public int refresh() {
        this.contentPanel.clearComponents();
        int y = 0;
        for (Owner player : this.players) {
            if (!player.name().toLowerCase().contains(((RichTextComponent)this.searchBox.text.get()).getPlainText().toLowerCase())) continue;
            TrustedPlayerListItem item = (TrustedPlayerListItem)this.contentPanel.addComponent((DLGuiComponent)new TrustedPlayerListItem(this, player));
            item.setWidth(this.contentPanel.width());
            y += item.height();
        }
        this.scrollBar.max.set((Number)y);
        return y;
    }

    private void reload() {
        ModNetworkManager.GET_ONLINE_PLAYERS.send((NetworkDirection)NetworkDirection.toServer(), response -> {
            this.playerPool.clear();
            for (Owner o : response.getPlayers()) {
                this.playerPool.put(o.name(), o);
            }
        }, () -> {});
    }

    public static class TrustedPlayerListItem
    extends DLGuiComponent {
        private final Owner item;

        protected TrustedPlayerListItem(TrustedPlayerListComponent list, Owner item) {
            super(0, 0, 100, 20);
            this.item = item;
            FlatIconButton deleteBtn = (FlatIconButton)this.addComponent((DLGuiComponent)new FlatIconButton(this.width() - 18 - 1, 1, ModGuiIcons.DELETE.getAsSprite(16, 16)));
            deleteBtn.anchor.set2((Enum[])new EAlign[]{EAlign.RIGHT});
            deleteBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
                list.players.remove(item);
                list.refresh();
                return false;
            });
        }

        public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
            CreateDynamicWidgets.renderTextSlotOverlay(graphics, 1, 1, this.width() - 18 - 4, this.height() - 2);
            Font font = graphics.defaultFont();
            int n = this.height() / 2;
            Objects.requireNonNull(graphics.defaultFont());
            GuiUtils.drawString((DLGuiGraphics)graphics, (Font)font, (int)6, (int)(n - 9 / 2), (FormattedText)TextUtils.truncateWithEllipsis((Font)graphics.defaultFont(), (Component)TextUtils.text((String)this.item.name()), (int)(this.width() - 18 - 4 - 10)), (DLColor)DragonLib.VANILLA_BUTTON_ACTIVE_FONT_COLOR, (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
        }
    }
}

