/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets.autocomplete;

import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.network.packets.pain.GetAllStationsAsTagsPacketData;
import de.mrjulsen.crn.registry.ModNetworkManager;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindowManager;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLRichTextEditBox;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.RichTextComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.autocomplete.DLAutocompleteWindow;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.autocomplete.IAutocompletionManager;
import de.mrjulsen.mcdragonlib.network.NetworkDirection;
import de.mrjulsen.mcdragonlib.network.NetworkPacketData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;

public class StationTagsAutocomplete
implements IAutocompletionManager<StationTag> {
    private final List<StationTag> tags = new ArrayList<StationTag>();

    public DLAutocompleteWindow<StationTag> createWindow(DLWindowManager windowManager, DLRichTextEditBox textBox) {
        DLAutocompleteWindow window = super.createWindow(windowManager, textBox);
        ModNetworkManager.GET_ALL_STATIONS_AS_STATION_TAGS.send((NetworkDirection)NetworkDirection.toServer(), (NetworkPacketData)new GetAllStationsAsTagsPacketData.Request(true), result -> Minecraft.m_91087_().execute(() -> {
            this.tags.clear();
            this.tags.addAll(result.getTags().stream().sorted((a, b) -> a.getTagName().get().compareToIgnoreCase(b.getTagName().get())).toList());
            this.configureWindow((DLAutocompleteWindow<StationTag>)window, textBox);
        }), () -> {});
        return window;
    }

    public void configureWindow(DLAutocompleteWindow<StationTag> window, DLRichTextEditBox textBox) {
        window.suggestions.set(this.tags);
        window.filter.set(tag -> tag.getTagName().get().toLowerCase().contains(((RichTextComponent)textBox.text.get()).getPlainText().toLowerCase()));
    }

    public void closeWindow(DLAutocompleteWindow<StationTag> window, DLRichTextEditBox textBox) {
        this.tags.clear();
        super.closeWindow(window, textBox);
    }
}

