/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets.modular;

import de.mrjulsen.crn.client.gui.widgets.modular.ModularWidgetContainer;
import de.mrjulsen.crn.client.gui.widgets.modular.ModularWidgetLine;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;

public class ModularWidgetBuilder {
    private final ModularWidgetContainer container;
    private final Map<String, Consumer<ModularWidgetLine>> lineBuilders = new LinkedHashMap<String, Consumer<ModularWidgetLine>>();

    public ModularWidgetBuilder(ModularWidgetContainer container) {
        this.container = container;
    }

    public void addLine(String name, Consumer<ModularWidgetLine> lineBuilder) {
        if (this.lineBuilders.containsKey(name)) {
            return;
        }
        this.lineBuilders.put(name, lineBuilder);
    }

    public void clear() {
        this.lineBuilders.clear();
    }

    public int getCurrentLinesCount() {
        return this.lineBuilders.size();
    }

    public boolean hasLine(String name) {
        return this.lineBuilders.containsKey(name);
    }

    public Consumer<ModularWidgetLine> getLine(String name) {
        return this.lineBuilders.get(name);
    }

    public void addToLine(String name, Consumer<ModularWidgetLine> additional) {
        this.lineBuilders.replace(name, this.lineBuilders.get(name).andThen(additional));
    }

    public void build() {
    }
}

