/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets.options;

import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.client.gui.widgets.SearchBox;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLAbstractDataView;
import de.mrjulsen.mcdragonlib.client.gui.widgets.layout.FlowLayout;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.DLAbstractRichTextInputField;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.RichTextComponent;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.mcdragonlib.util.properties.Property;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;

public class OptionsDataView<T>
extends DLAbstractDataView<T, DLBasicItem<T>> {
    public final Property<Function<OptionsDataView<T>, CreateEntryItem<T>>> createNewItemBuilder = (Property)new Property(null).withAfterPropertyChangedCallback((a, b) -> this.createComponents());
    public final Property<BiPredicate<T, String>> searchFilter = (Property)new Property(null).withAfterPropertyChangedCallback((a, b) -> this.createComponents());
    private int requiredHeight = 0;
    private SearchBox searchBox;

    public OptionsDataView(int x, int y, int w, int h) {
        super(x, y, w, h);
        FlowLayout layout = new FlowLayout();
        layout.fillCrossAxis.set((Object)true);
        layout.flowDirection.set((Object)FlowLayout.Direction.VERTICAL);
        layout.verticalGap.set((Number)2);
        layout.wrap.set((Object)false);
        this.contentPanel.layout.set((Object)layout);
        this.searchBox = new SearchBox(0, 0, 1);
        this.searchBox.acceptAndCancelKeysEnabled.set((Object)true);
        this.searchBox.addEventListener(DLAbstractRichTextInputField.TextAcceptKeyPressedEvent.class, (s, e) -> {
            this.createComponents();
            return false;
        });
        this.searchBox.placeholderText.set((Object)Constants.TEXT_SEARCH);
    }

    protected DLBasicItem<T> defaultItemBuilder(T item) {
        return new DLBasicItem<T>(this, item);
    }

    protected void createComponents() {
        this.contentPanel.clearComponents();
        if (this.searchFilter.get() != null) {
            this.contentPanel.addComponent((DLGuiComponent)this.searchBox);
        }
        if (this.createNewItemBuilder.get() != null) {
            this.contentPanel.addComponent((DLGuiComponent)((CreateEntryItem)((Object)((Function)this.createNewItemBuilder.get()).apply(this))));
        }
        for (Object item : this.items.get()) {
            if (this.searchFilter.get() != null && this.searchBox != null && !((BiPredicate)this.searchFilter.get()).test(item, ((RichTextComponent)this.searchBox.text.get()).getPlainText())) continue;
            DLBasicItem listItem = (DLBasicItem)((Object)((Function)this.itemBuilder.get()).apply(item));
            this.contentPanel.addComponent((DLGuiComponent)listItem);
        }
    }

    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
    }

    public static class DLBasicItem<T>
    extends DLAbstractDataView.DLDataViewItem<T, OptionsDataView<T>> {
        public DLBasicItem(OptionsDataView<T> collectionComponentRef, T item) {
            super(collectionComponentRef, item);
        }

        protected void refresh() {
            this.contentPanel.clearComponents();
            Map<String, DLGuiComponent> content = this.subComponents.stream().collect(Collectors.toMap(x -> x.name(), x -> x.component()));
            int totalWidth = ((OptionsDataView)this.collectionComponentRef).width();
            int fixedWidthSum = ((OptionsDataView)this.collectionComponentRef).dataSlots.stream().filter(s -> s.mode() == DLAbstractDataView.SizeMode.FIXED).mapToInt(s -> (int)(s.size() + 2.0)).sum();
            int remainingWidth = Math.max(totalWidth - fixedWidthSum, 0);
            double percentTotal = ((OptionsDataView)this.collectionComponentRef).dataSlots.stream().filter(s -> s.mode() == DLAbstractDataView.SizeMode.PERCENTAGE).mapToDouble(s -> s.size() + 2.0).sum();
            HashMap<String, Integer> widths = new HashMap<String, Integer>();
            for (DLAbstractDataView.DataSlot s2 : ((OptionsDataView)this.collectionComponentRef).dataSlots) {
                if (s2.mode() == DLAbstractDataView.SizeMode.FIXED) {
                    widths.put(s2.name(), (int)(s2.size() + 2.0));
                    continue;
                }
                double part = percentTotal == 0.0 ? 0.0 : (s2.size() + 2.0) / percentTotal;
                widths.put(s2.name(), (int)Math.round((double)remainingWidth * part));
            }
            int x2 = 0;
            int maxH = 0;
            for (DLAbstractDataView.DataSlot s3 : ((OptionsDataView)this.collectionComponentRef).dataSlots) {
                int w = (Integer)widths.get(s3.name());
                DLGuiComponent c = content.get(s3.name());
                if (c != null) {
                    int h = c.height();
                    c.setPosition((double)x2, 0.0);
                    c.setSize((double)(w - 2), (double)h);
                    maxH = Math.max(maxH, h);
                    this.contentPanel.addComponent(c);
                }
                x2 += w;
            }
            this.setHeight(maxH);
        }
    }

    public static class CreateEntryItem<T>
    extends DLBasicItem<T> {
        public CreateEntryItem(OptionsDataView<T> collectionComponentRef) {
            super(collectionComponentRef, null);
        }
    }
}

