/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets.options;

import de.mrjulsen.crn.client.gui.widgets.skins.ModernScrollbarComponentRenderer;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLPanel;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLScrollBar;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.EAlign;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import java.util.ArrayList;
import java.util.List;

public class OptionsView
extends DLGuiComponent {
    private final DLPanel contentPanel;
    private final DLScrollBar scrollbar;
    private final List<DLGuiComponent> entries = new ArrayList<DLGuiComponent>();
    private boolean refreshing = false;

    public OptionsView(int x, int y, int w, int h) {
        super(x, y, w, h);
        this.contentPanel = (DLPanel)this.addComponent((DLGuiComponent)new DLPanel(0, 0, this.width(), this.height()));
        this.contentPanel.anchor.set2((Enum[])EAlign.values());
        this.contentPanel.inputConsumptionPolicy.set(type -> false);
        this.scrollbar = (DLScrollBar)this.addComponent((DLGuiComponent)new DLScrollBar(this.width() - 5, 0, 5, this.height(), DLScrollBar.Orientation.VERTICAL));
        this.scrollbar.componentRenderer.set((Object)ModernScrollbarComponentRenderer.INSTANCE);
        this.scrollbar.anchor.set2((Enum[])new EAlign[]{EAlign.TOP, EAlign.BOTTOM, EAlign.RIGHT});
        this.scrollbar.scrollerSize.set((Number)0);
        this.scrollbar.screenSize.set((Number)this.contentPanel.height());
        this.scrollbar.scrollSteps.set((Number)15);
        this.scrollbar.max.set((Number)0);
        this.scrollbar.inputConsumptionPolicy.set(type -> true);
        this.scrollbar.addEventListener(DLScrollBar.ValueChangedEvent.class, (s, e) -> {
            this.contentPanel.setScrollOffsetY(e.value());
            return false;
        });
        this.addEventListener(DLGuiStandardEvents.ScrollEvent.class, (arg_0, arg_1) -> ((DLScrollBar)this.scrollbar).invokeEvent(arg_0, arg_1));
    }

    public <T extends DLGuiComponent> T addEntry(T entry) {
        this.entries.add(entry);
        entry.addEventListener(DLGuiStandardEvents.ComponentPosAndSizeChanged.class, (s, e) -> {
            if (this.refreshing) {
                return false;
            }
            this.refresh();
            return false;
        });
        this.refresh();
        return entry;
    }

    public void clearEntries() {
        this.entries.clear();
    }

    public void refresh() {
        this.refreshing = true;
        this.contentPanel.clearComponents();
        int y = 10;
        for (DLGuiComponent entry : this.entries) {
            entry.setPosition(10.0, (double)y);
            entry.setWidth((double)(this.width() - 20));
            this.contentPanel.addComponent(entry);
            y += entry.height() + 3;
        }
        this.scrollbar.max.set((Number)(y += 7));
        this.scrollbar.screenSize.set((Number)this.contentPanel.height());
        this.refreshing = false;
    }

    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        if (this.scrollbar.canScroll() && (Double)this.scrollbar.value.get() > 0.0) {
            GuiUtils.fillGradient((DLGuiGraphics)graphics, (int)0, (int)0, (int)this.width(), (int)10, (DLColor)DLColor.fromInt((int)0x77000000), (DLColor)DLColor.TRANSPARENT, (EAlign)EAlign.TOP);
        }
        if (this.scrollbar.canScroll() && (Double)this.scrollbar.value.get() < (double)((Integer)this.scrollbar.max.get()).intValue()) {
            GuiUtils.fillGradient((DLGuiGraphics)graphics, (int)0, (int)(this.height() - 10), (int)this.width(), (int)10, (DLColor)DLColor.fromInt((int)0x77000000), (DLColor)DLColor.TRANSPARENT, (EAlign)EAlign.BOTTOM);
        }
    }

    public static interface IOptionsViewEntry {
    }
}

