/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets.routedetails;

import de.mrjulsen.crn.client.gui.widgets.routedetails.RoutePartEntryWidget;
import de.mrjulsen.crn.client.gui.widgets.routedetails.TrainDetailsWidget;
import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.crn.data.navigation.ClientRoutePart;
import de.mrjulsen.crn.data.train.ClientTrainStop;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.layout.FlowLayout;
import de.mrjulsen.mcdragonlib.util.properties.BooleanProperty;
import java.util.List;

public class RoutePartWidget
extends DLGuiComponent {
    private final ClientRoutePart part;
    private final ClientRoute route;
    public final BooleanProperty expanded = (BooleanProperty)new BooleanProperty(false).withAfterPropertyChangedCallback((o, n) -> this.initGui());
    public final BooleanProperty showTrainDetails = (BooleanProperty)new BooleanProperty(true).withAfterPropertyChangedCallback((o, n) -> this.initGui());
    public final BooleanProperty showEntireJourney = (BooleanProperty)new BooleanProperty(false).withAfterPropertyChangedCallback((o, n) -> this.initGui());
    public final BooleanProperty canExpandCollapse = (BooleanProperty)new BooleanProperty(true).withAfterPropertyChangedCallback((o, n) -> this.initGui());

    public RoutePartWidget(int width, ClientRoute route, ClientRoutePart part) {
        super(0, 0, width, 1);
        this.part = part;
        this.route = route;
        FlowLayout layout = new FlowLayout();
        layout.fillCrossAxis.set((Object)true);
        layout.flowDirection.set((Object)FlowLayout.Direction.VERTICAL);
        layout.wrap.set((Object)false);
        this.layout.set((Object)layout);
        this.addEventListener(DLGuiStandardEvents.ComponentLayoutUpdatedEvent.class, (s, e) -> {
            this.setHeight(e.layoutResult().contentHeight());
            return false;
        });
    }

    public void initGui() {
        this.clearComponents();
        boolean valid = this.route.isPartReachable(this.part);
        List<ClientTrainStop> stops = (Boolean)this.showEntireJourney.get() != false ? this.part.getAllJourneyClientStops() : this.part.getAllClientStops();
        this.addComponent((DLGuiComponent)new RoutePartEntryWidget(this.part, this.route, stops.get(0), RoutePartEntryWidget.TrainStopType.START, valid));
        if (((Boolean)this.showTrainDetails.get()).booleanValue()) {
            this.addComponent(new TrainDetailsWidget(this, this.route, this.part, stops.get(0)));
        }
        if (((Boolean)this.expanded.get()).booleanValue()) {
            for (int i = 1; i < stops.size() - 1; ++i) {
                ClientTrainStop stop = stops.get(i);
                this.addComponent((DLGuiComponent)new RoutePartEntryWidget(this.part, this.route, stop, RoutePartEntryWidget.TrainStopType.TRANSIT, valid));
            }
        }
        this.addComponent((DLGuiComponent)new RoutePartEntryWidget(this.part, this.route, stops.get(stops.size() - 1), RoutePartEntryWidget.TrainStopType.END, valid));
    }
}

