/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets.routedetails;

import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.client.gui.widgets.routedetails.RoutePartWidget;
import de.mrjulsen.crn.client.gui.widgets.routedetails.TrainDataWidget;
import de.mrjulsen.crn.client.gui.widgets.routedetails.TrainStatusInfoWidget;
import de.mrjulsen.crn.client.gui.widgets.skins.CRNFlatButtonRenderer;
import de.mrjulsen.crn.client.gui.windows.TrainJourneyWindow;
import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.crn.data.navigation.ClientRoutePart;
import de.mrjulsen.crn.data.train.ClientTrainStop;
import de.mrjulsen.crn.data.train.TrainStatus;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLPanel;
import de.mrjulsen.mcdragonlib.client.gui.widgets.layout.FlowLayout;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.Padding;
import de.mrjulsen.mcdragonlib.client.render.GuiIcons;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.DLTexture;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;

public class TrainDetailsWidget
extends DLGuiComponent {
    protected static final DLTexture GUI = new DLTexture(DLUtils.resourceLocation((String)"createrailwaysnavigator", (String)"textures/gui/widgets.png"), 256, 256);
    protected static final int ENTRY_WIDTH = 225;
    protected static final int V = 92;
    private final RoutePartWidget container;
    private final ClientTrainStop stop;
    private final ClientRoutePart part;
    private final DLPanel statusInfoPanel;

    public TrainDetailsWidget(RoutePartWidget container, ClientRoute route, ClientRoutePart part, ClientTrainStop firstStop) {
        super(0, 0, 225, 20);
        this.stop = firstStop;
        this.part = part;
        this.container = container;
        FlowLayout layout = new FlowLayout();
        layout.fillCrossAxis.set((Object)true);
        layout.flowDirection.set((Object)FlowLayout.Direction.VERTICAL);
        layout.padding.set((Object)new Padding(1, 9, 1, 76));
        layout.verticalGap.set((Number)1);
        layout.wrap.set((Object)false);
        this.layout.set((Object)layout);
        this.addEventListener(DLGuiStandardEvents.ComponentLayoutUpdatedEvent.class, (s, e) -> {
            this.setHeight(e.layoutResult().contentHeight());
            return false;
        });
        this.addComponent(new TrainDataWidget(firstStop, part));
        DLButton showJourneyBtn = (DLButton)this.addComponent((DLGuiComponent)new DLButton(0, 0, 1, 14));
        showJourneyBtn.componentRenderer.set((Object)CRNFlatButtonRenderer.INSTANCE);
        showJourneyBtn.text.set((Object)TextUtils.translate((String)"gui.createrailwaysnavigator.journey_info.title"));
        showJourneyBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            this.getWindowManager().createModal(mgr -> new TrainJourneyWindow(mgr, route, part.getTrainId()));
            return false;
        });
        if (!part.getStopovers().isEmpty()) {
            DLButton showDetailsBtn = (DLButton)this.addComponent((DLGuiComponent)new DLButton(0, 0, 1, 14));
            showDetailsBtn.componentRenderer.set((Object)CRNFlatButtonRenderer.INSTANCE);
            showDetailsBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
                container.expanded.toggle();
                this.updateShowDetailsBtn(showDetailsBtn);
                return false;
            });
            this.updateShowDetailsBtn(showDetailsBtn);
        }
        this.statusInfoPanel = new DLPanel(0, 0, 0, 0);
        FlowLayout statusLayout = new FlowLayout();
        statusLayout.fillCrossAxis.set((Object)true);
        statusLayout.flowDirection.set((Object)FlowLayout.Direction.VERTICAL);
        statusLayout.wrap.set((Object)false);
        this.statusInfoPanel.layout.set((Object)statusLayout);
        this.addComponent((DLGuiComponent)this.statusInfoPanel);
        this.statusInfoPanel.addEventListener(DLGuiStandardEvents.ComponentLayoutUpdatedEvent.class, (s, e) -> {
            this.statusInfoPanel.setHeight((double)e.layoutResult().contentHeight());
            return false;
        });
        part.listen("update2", (Object)this, data -> this.updateStatus());
        this.updateStatus();
    }

    private void updateStatus() {
        this.statusInfoPanel.clearComponents();
        for (TrainStatus.CompiledTrainStatus status : this.part.getStatus()) {
            this.statusInfoPanel.addComponent((DLGuiComponent)new TrainStatusInfoWidget(0, 0, 0, status));
        }
    }

    protected void updateShowDetailsBtn(DLButton showDetailsBtn) {
        showDetailsBtn.text.set((Object)((Boolean)this.container.expanded.get() != false ? Constants.TOOLTIP_COLLAPSE : Constants.TOOLTIP_EXPAND));
        showDetailsBtn.icon.set((Object)((Boolean)this.container.expanded.get() != false ? GuiIcons.ARROW_UP : GuiIcons.ARROW_DOWN).getAsSprite(16, 16));
    }

    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        GuiUtils.drawTexture((DLTexture)GUI, (DLGuiGraphics)graphics, (int)0, (int)0, (int)225, (int)this.height(), (int)0, (int)92, (int)225, (int)1, (GuiUtils.TextureFillMode)GuiUtils.TextureFillMode.STRETCH);
    }
}

