/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.windows;

import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.flyout.FlyoutColorPickerWidget;
import de.mrjulsen.crn.client.gui.flyout.FlyoutConfirmDialog;
import de.mrjulsen.crn.client.gui.flyout.FlyoutTrustedPlayersWidget;
import de.mrjulsen.crn.client.gui.widgets.AbstractFlyoutWidget;
import de.mrjulsen.crn.client.gui.widgets.FlatIconButton;
import de.mrjulsen.crn.client.gui.widgets.autocomplete.StationsAutocomplete;
import de.mrjulsen.crn.client.gui.widgets.autocomplete.TrainAutocomplete;
import de.mrjulsen.crn.client.gui.widgets.create.CreateButton;
import de.mrjulsen.crn.client.gui.widgets.create.CreateTextBox;
import de.mrjulsen.crn.client.gui.widgets.options.OptionEntry;
import de.mrjulsen.crn.client.gui.widgets.options.OptionEntryHeader;
import de.mrjulsen.crn.client.gui.widgets.options.OptionsDataView;
import de.mrjulsen.crn.client.gui.widgets.options.OptionsView;
import de.mrjulsen.crn.client.gui.widgets.options.TextOptionLabel;
import de.mrjulsen.crn.client.gui.windows.AbstractNavigatorScreen;
import de.mrjulsen.crn.client.gui.windows.StationTagSettingsWindow;
import de.mrjulsen.crn.client.gui.windows.TransferOwnershipWindow;
import de.mrjulsen.crn.data.TrainCategory;
import de.mrjulsen.crn.data.TrainLine;
import de.mrjulsen.crn.data.storage.GlobalSettingsClient;
import de.mrjulsen.crn.network.packets.pain.AddStationToBlacklistPacketData;
import de.mrjulsen.crn.network.packets.pain.AddTrainToBlacklistPacketData;
import de.mrjulsen.crn.network.packets.pain.CreateTrainCategoryPacketData;
import de.mrjulsen.crn.network.packets.pain.CreateTrainLinePacketData;
import de.mrjulsen.crn.network.packets.pain.DeleteTrainCategoryPacketData;
import de.mrjulsen.crn.network.packets.pain.DeleteTrainLinePacketData;
import de.mrjulsen.crn.network.packets.pain.RemoveStationFromBlacklistPacketData;
import de.mrjulsen.crn.network.packets.pain.RemoveTrainFromBlacklistPacketData;
import de.mrjulsen.crn.network.packets.pain.TrainCategoryUpdatePermissionsPacketData;
import de.mrjulsen.crn.network.packets.pain.UpdateTrainCategoryColorPacketData;
import de.mrjulsen.crn.network.packets.pain.UpdateTrainCategoryNamePacketData;
import de.mrjulsen.crn.network.packets.pain.UpdateTrainLineColorPacketData;
import de.mrjulsen.crn.network.packets.pain.UpdateTrainLineNamePacketData;
import de.mrjulsen.crn.network.packets.pain.UpdateTrainLinePermissionsPacketData;
import de.mrjulsen.crn.registry.ModNetworkManager;
import de.mrjulsen.crn.util.Lock;
import de.mrjulsen.crn.util.Owner;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindowManager;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLAbstractDataView;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLContextMenu;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLEditableLabel;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLTooltip;
import de.mrjulsen.mcdragonlib.client.gui.widgets.layout.TableLayout;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.DLAbstractRichTextInputField;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.RichTextComponent;
import de.mrjulsen.mcdragonlib.client.util.DLSprite;
import de.mrjulsen.mcdragonlib.events.IEventListener;
import de.mrjulsen.mcdragonlib.network.NetworkDirection;
import de.mrjulsen.mcdragonlib.network.NetworkPacketData;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.createmod.catnip.gui.element.ScreenElement;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class GlobalSettingsWindow
extends AbstractNavigatorScreen {
    private final Component optionTagTitle = TextUtils.translate((String)"gui.createrailwaysnavigator.global_settings.option_alias.title");
    private final Component optionTagDescription = TextUtils.translate((String)"gui.createrailwaysnavigator.global_settings.option_alias.description").m_130940_(ChatFormatting.GRAY);
    private final Component optionBlacklistTitle = TextUtils.translate((String)"gui.createrailwaysnavigator.global_settings.option_blacklist.title");
    private final Component optionBlacklistDescription = TextUtils.translate((String)"gui.createrailwaysnavigator.global_settings.option_blacklist.description").m_130940_(ChatFormatting.GRAY);
    private final Component optionTrainCategoryTitle = TextUtils.translate((String)"gui.createrailwaysnavigator.global_settings.train_category.title");
    private final Component optionTrainCategoryDescription = TextUtils.translate((String)"gui.createrailwaysnavigator.global_settings.train_category.description").m_130940_(ChatFormatting.GRAY);
    private final Component optionTrainBlacklistTitle = TextUtils.translate((String)"gui.createrailwaysnavigator.global_settings.train_blacklist.title");
    private final Component optionTrainBlacklistDescription = TextUtils.translate((String)"gui.createrailwaysnavigator.global_settings.train_blacklist.description").m_130940_(ChatFormatting.GRAY);
    private final Component optionTrainLineTitle = TextUtils.translate((String)"gui.createrailwaysnavigator.global_settings.train_line.title");
    private final Component optionTrainLineDescription = TextUtils.translate((String)"gui.createrailwaysnavigator.global_settings.train_line.description").m_130940_(ChatFormatting.GRAY);
    private final Component textColor = TextUtils.translate((String)"gui.createrailwaysnavigator.global_settings.train_line.color");
    private final OptionsView optionsView;

    public GlobalSettingsWindow(DLWindowManager manager) {
        super(manager, (Component)TextUtils.translate((String)"gui.createrailwaysnavigator.global_settings.title").m_7220_((Component)(GlobalSettingsClient.modificationsAllowed() ? TextUtils.empty() : TextUtils.text((String)" ").m_7220_(Constants.TEXT_READ_ONLY).m_130940_(ChatFormatting.DARK_RED))), CreateDynamicWidgets.ContainerColor.PURPLE, CreateDynamicWidgets.BarColor.GRAY);
        manager.setPauseScreen(false);
        CreateButton helpButton = (CreateButton)this.addComponent((DLGuiComponent)new CreateButton(this.width() - 18 - 8, this.height() - 18 - 6, (ScreenElement)ModGuiIcons.HELP.getAsCreateIcon()));
        helpButton.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            Util.m_137581_().m_137646_("https://github.com/MisterJulsen/Create-Train-Navigator/wiki/Global-Settings");
            return false;
        });
        helpButton.tooltip.set((Object)new DLTooltip(List.of(Constants.TEXT_HELP), 200));
        this.optionsView = (OptionsView)this.addComponent(new OptionsView(3, CreateDynamicWidgets.FooterSize.DEFAULT.size() + 1, 234, 247 - (CreateDynamicWidgets.FooterSize.DEFAULT.size() + 1) - CreateDynamicWidgets.FooterSize.SMALL.size() - 1));
        this.createStationTagOption();
        this.createStationBlacklistOption();
        this.createTrainBlacklistOption();
        this.createTrainCategoryOption();
        this.createTrainLineOption();
    }

    private void reloadBlacklistedTrains(OptionsDataView<String> dataView) {
        ModNetworkManager.GET_ALL_BLACKLISTED_TRAINS.send((NetworkDirection)NetworkDirection.toServer(), response -> dataView.items.setAll(response.getNames().stream().sorted((a, b) -> a.compareToIgnoreCase((String)b)).toList()), () -> {});
    }

    private void reloadBlacklistedStations(OptionsDataView<String> dataView) {
        ModNetworkManager.GET_ALL_BLACKLISTED_STATIONS.send((NetworkDirection)NetworkDirection.toServer(), response -> dataView.items.setAll(response.getNames().stream().sorted((a, b) -> a.compareToIgnoreCase((String)b)).toList()), () -> {});
    }

    private void reloadTrainLines(OptionsDataView<TrainLine> dataView) {
        ModNetworkManager.GET_ALL_TRAIN_LINES.send((NetworkDirection)NetworkDirection.toServer(), response -> dataView.items.setAll(response.getLines().stream().sorted((a, b) -> a.getLineName().compareToIgnoreCase(b.getLineName())).toList()), () -> {});
    }

    private void reloadTrainCategories(OptionsDataView<TrainCategory> dataView) {
        ModNetworkManager.GET_ALL_TRAIN_CATEGORIES.send((NetworkDirection)NetworkDirection.toServer(), response -> dataView.items.setAll(response.getCategories().stream().sorted((a, b) -> a.getCategoryName().compareToIgnoreCase(b.getCategoryName())).toList()), () -> {});
    }

    private void createStationTagOption() {
        OptionEntryHeader header = new OptionEntryHeader(this.optionTagTitle, List.of(this.optionTagDescription));
        header.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            this.getWindowManager().createModal(mgr -> new StationTagSettingsWindow(mgr));
            return false;
        });
        this.optionsView.addEntry(header);
    }

    private OptionEntry<String> createTrainBlacklistOption() {
        OptionEntry<String> trainLinesEntry = this.optionsView.addEntry(new OptionEntry(this.optionTrainBlacklistTitle, List.of(this.optionTrainBlacklistDescription), (IEventListener<DLGuiComponent, DLGuiStandardEvents.MousePressedEvent>)((IEventListener)(s, e) -> {
            OptionEntry c = (OptionEntry)s;
            c.expanded.toggle();
            if (((Boolean)c.expanded.get()).booleanValue()) {
                this.reloadBlacklistedTrains(c.dataView);
            }
            return false;
        })));
        TableLayout layout = new TableLayout();
        layout.addColumn("name", 1.0, TableLayout.ColumnSizeMode.PERCENTAGE);
        layout.addColumn("help", 0.0, TableLayout.ColumnSizeMode.AUTO);
        layout.addColumn("dropdown", 20.0, TableLayout.ColumnSizeMode.FIXED);
        trainLinesEntry.getHeader().layout.set((Object)layout);
        trainLinesEntry.dataView.createNewItemBuilder.set(!GlobalSettingsClient.modificationsAllowed() ? null : view -> {
            OptionsDataView.CreateEntryItem item = new OptionsDataView.CreateEntryItem(view);
            CreateTextBox nameBox = new CreateTextBox(0, 0, 0);
            FlatIconButton addBtn = new FlatIconButton(0, 0, ModGuiIcons.ADD.getAsSprite(16, 16));
            Runnable addAction = () -> {
                if (((RichTextComponent)nameBox.text.get()).getPlainText().isBlank()) {
                    return;
                }
                ModNetworkManager.ADD_TRAIN_TO_BLACKLIST.send((NetworkDirection)NetworkDirection.toServer(), (NetworkPacketData)new AddTrainToBlacklistPacketData.Request(((RichTextComponent)nameBox.text.get()).getPlainText()), response -> this.reloadBlacklistedTrains((OptionsDataView<String>)((Object)view)), () -> {});
                ((RichTextComponent)nameBox.text.get()).clear();
            };
            nameBox.acceptAndCancelKeysEnabled.set((Object)true);
            nameBox.autocompleteManager.set((Object)new TrainAutocomplete());
            nameBox.addEventListener(DLAbstractRichTextInputField.TextAcceptKeyPressedEvent.class, (s, e) -> {
                addAction.run();
                return false;
            });
            addBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
                addAction.run();
                return false;
            });
            addBtn.tooltip.set((Object)new DLTooltip(List.of(Constants.TEXT_ADD), 200));
            item.subComponents.add((Object)new DLAbstractDataView.DataSlotComponent("name", (DLGuiComponent)nameBox));
            item.subComponents.add((Object)new DLAbstractDataView.DataSlotComponent("action", (DLGuiComponent)addBtn));
            return item;
        });
        trainLinesEntry.dataView.searchFilter.set((item, searchTerm) -> item.toLowerCase().contains(searchTerm.toLowerCase()));
        trainLinesEntry.dataView.itemBuilder.set(in -> {
            OptionsDataView.DLBasicItem<String> item = new OptionsDataView.DLBasicItem<String>(trainLinesEntry.dataView, (String)in);
            TextOptionLabel nameLabel = new TextOptionLabel();
            nameLabel.text.set(in);
            if (GlobalSettingsClient.modificationsAllowed()) {
                FlatIconButton deleteBtn = new FlatIconButton(0, 0, ModGuiIcons.DELETE.getAsSprite(16, 16));
                deleteBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
                    this.getWindowManager().createModal(mgr -> new FlyoutConfirmDialog(mgr, (DLGuiComponent)deleteBtn, AbstractFlyoutWidget.FlyoutPointer.RIGHT, CreateDynamicWidgets.ColorShade.DARK, () -> ModNetworkManager.REMOVE_TRAIN_FROM_BLACKLIST.send((NetworkDirection)NetworkDirection.toServer(), (NetworkPacketData)new RemoveTrainFromBlacklistPacketData.Request((String)in), response -> this.reloadBlacklistedTrains(trainLinesEntry.dataView), () -> {})));
                    return false;
                });
                deleteBtn.tooltip.set((Object)new DLTooltip(List.of(Constants.TEXT_DELETE), 200));
                item.subComponents.add((Object)new DLAbstractDataView.DataSlotComponent("action", (DLGuiComponent)deleteBtn));
            }
            item.subComponents.add((Object)new DLAbstractDataView.DataSlotComponent("name", (DLGuiComponent)nameLabel));
            return item;
        });
        trainLinesEntry.dataView.dataSlots.add((Object)new DLAbstractDataView.DataSlot("name", (Component)TextUtils.text((String)"Name"), 100.0, DLAbstractDataView.SizeMode.PERCENTAGE));
        trainLinesEntry.dataView.dataSlots.add((Object)new DLAbstractDataView.DataSlot("action", (Component)TextUtils.text((String)"Action"), 18.0, DLAbstractDataView.SizeMode.FIXED));
        FlatIconButton btnHelp = new FlatIconButton(0, 0, ModGuiIcons.HELP.getAsSprite(16, 16));
        btnHelp.tooltip.set((Object)new DLTooltip(List.of(Constants.TEXT_HELP), 200));
        btnHelp.layoutContraint.set((Object)"help");
        btnHelp.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            Util.m_137581_().m_137646_("https://github.com/MisterJulsen/Create-Train-Navigator/wiki/Train-Blacklist");
            return false;
        });
        trainLinesEntry.getHeader().addComponent((DLGuiComponent)btnHelp);
        return trainLinesEntry;
    }

    private OptionEntry<String> createStationBlacklistOption() {
        OptionEntry<String> trainLinesEntry = this.optionsView.addEntry(new OptionEntry(this.optionBlacklistTitle, List.of(this.optionBlacklistDescription), (IEventListener<DLGuiComponent, DLGuiStandardEvents.MousePressedEvent>)((IEventListener)(s, e) -> {
            OptionEntry c = (OptionEntry)s;
            c.expanded.toggle();
            if (((Boolean)c.expanded.get()).booleanValue()) {
                this.reloadBlacklistedStations(c.dataView);
            }
            return false;
        })));
        TableLayout layout = new TableLayout();
        layout.addColumn("name", 1.0, TableLayout.ColumnSizeMode.PERCENTAGE);
        layout.addColumn("help", 0.0, TableLayout.ColumnSizeMode.AUTO);
        layout.addColumn("dropdown", 20.0, TableLayout.ColumnSizeMode.FIXED);
        trainLinesEntry.getHeader().layout.set((Object)layout);
        trainLinesEntry.dataView.createNewItemBuilder.set(!GlobalSettingsClient.modificationsAllowed() ? null : view -> {
            OptionsDataView.CreateEntryItem item = new OptionsDataView.CreateEntryItem(view);
            CreateTextBox nameBox = new CreateTextBox(0, 0, 0);
            FlatIconButton addBtn = new FlatIconButton(0, 0, ModGuiIcons.ADD.getAsSprite(16, 16));
            Runnable addAction = () -> {
                if (((RichTextComponent)nameBox.text.get()).getPlainText().isBlank()) {
                    return;
                }
                ModNetworkManager.ADD_STATION_TO_BLACKLIST.send((NetworkDirection)NetworkDirection.toServer(), (NetworkPacketData)new AddStationToBlacklistPacketData.Request(((RichTextComponent)nameBox.text.get()).getPlainText()), response -> this.reloadBlacklistedStations((OptionsDataView<String>)((Object)view)), () -> {});
                ((RichTextComponent)nameBox.text.get()).clear();
            };
            nameBox.acceptAndCancelKeysEnabled.set((Object)true);
            nameBox.autocompleteManager.set((Object)new StationsAutocomplete());
            nameBox.addEventListener(DLAbstractRichTextInputField.TextAcceptKeyPressedEvent.class, (s, e) -> {
                addAction.run();
                return false;
            });
            addBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
                addAction.run();
                return false;
            });
            addBtn.tooltip.set((Object)new DLTooltip(List.of(Constants.TEXT_ADD), 200));
            item.subComponents.add((Object)new DLAbstractDataView.DataSlotComponent("name", (DLGuiComponent)nameBox));
            item.subComponents.add((Object)new DLAbstractDataView.DataSlotComponent("action", (DLGuiComponent)addBtn));
            return item;
        });
        trainLinesEntry.dataView.searchFilter.set((item, searchTerm) -> item.toLowerCase().contains(searchTerm.toLowerCase()));
        trainLinesEntry.dataView.itemBuilder.set(in -> {
            OptionsDataView.DLBasicItem<String> item = new OptionsDataView.DLBasicItem<String>(trainLinesEntry.dataView, (String)in);
            TextOptionLabel nameLabel = new TextOptionLabel();
            nameLabel.text.set(in);
            FlatIconButton deleteBtn = new FlatIconButton(0, 0, ModGuiIcons.DELETE.getAsSprite(16, 16));
            deleteBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
                this.getWindowManager().createModal(mgr -> new FlyoutConfirmDialog(mgr, (DLGuiComponent)deleteBtn, AbstractFlyoutWidget.FlyoutPointer.RIGHT, CreateDynamicWidgets.ColorShade.DARK, () -> ModNetworkManager.REMOVE_STATION_FROM_BLACKLIST.send((NetworkDirection)NetworkDirection.toServer(), (NetworkPacketData)new RemoveStationFromBlacklistPacketData.Request((String)in), response -> this.reloadBlacklistedStations(trainLinesEntry.dataView), () -> {})));
                return false;
            });
            deleteBtn.tooltip.set((Object)new DLTooltip(List.of(Constants.TEXT_DELETE), 200));
            item.subComponents.add((Object)new DLAbstractDataView.DataSlotComponent("name", (DLGuiComponent)nameLabel));
            item.subComponents.add((Object)new DLAbstractDataView.DataSlotComponent("action", (DLGuiComponent)deleteBtn));
            return item;
        });
        trainLinesEntry.dataView.dataSlots.add((Object)new DLAbstractDataView.DataSlot("name", (Component)TextUtils.text((String)"Name"), 100.0, DLAbstractDataView.SizeMode.PERCENTAGE));
        trainLinesEntry.dataView.dataSlots.add((Object)new DLAbstractDataView.DataSlot("action", (Component)TextUtils.text((String)"Action"), 18.0, DLAbstractDataView.SizeMode.FIXED));
        FlatIconButton btnHelp = new FlatIconButton(0, 0, ModGuiIcons.HELP.getAsSprite(16, 16));
        btnHelp.tooltip.set((Object)new DLTooltip(List.of(Constants.TEXT_HELP), 200));
        btnHelp.layoutContraint.set((Object)"help");
        btnHelp.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            Util.m_137581_().m_137646_("https://github.com/MisterJulsen/Create-Train-Navigator/wiki/Station-Blacklist");
            return false;
        });
        trainLinesEntry.getHeader().addComponent((DLGuiComponent)btnHelp);
        return trainLinesEntry;
    }

    private OptionEntry<TrainLine> createTrainLineOption() {
        OptionEntry<TrainLine> trainLinesEntry = this.optionsView.addEntry(new OptionEntry(this.optionTrainLineTitle, List.of(this.optionTrainLineDescription), (IEventListener<DLGuiComponent, DLGuiStandardEvents.MousePressedEvent>)((IEventListener)(s, e) -> {
            OptionEntry c = (OptionEntry)s;
            c.expanded.toggle();
            if (((Boolean)c.expanded.get()).booleanValue()) {
                this.reloadTrainLines(c.dataView);
            }
            return false;
        })));
        TableLayout layout = new TableLayout();
        layout.addColumn("name", 1.0, TableLayout.ColumnSizeMode.PERCENTAGE);
        layout.addColumn("help", 0.0, TableLayout.ColumnSizeMode.AUTO);
        layout.addColumn("dropdown", 20.0, TableLayout.ColumnSizeMode.FIXED);
        trainLinesEntry.getHeader().layout.set((Object)layout);
        trainLinesEntry.dataView.createNewItemBuilder.set(!GlobalSettingsClient.modificationsAllowed() ? null : view -> {
            OptionsDataView.CreateEntryItem item = new OptionsDataView.CreateEntryItem(view);
            CreateTextBox nameBox = new CreateTextBox(0, 0, 0);
            FlatIconButton addBtn = new FlatIconButton(0, 0, ModGuiIcons.ADD.getAsSprite(16, 16));
            Runnable addAction = () -> {
                if (((RichTextComponent)nameBox.text.get()).getPlainText().isBlank()) {
                    return;
                }
                ModNetworkManager.CREATE_TRAIN_LINE.send((NetworkDirection)NetworkDirection.toServer(), (NetworkPacketData)new CreateTrainLinePacketData.Request(((RichTextComponent)nameBox.text.get()).getPlainText()), response -> this.reloadTrainLines((OptionsDataView<TrainLine>)((Object)view)), () -> {});
                ((RichTextComponent)nameBox.text.get()).clear();
            };
            nameBox.acceptAndCancelKeysEnabled.set((Object)true);
            nameBox.addEventListener(DLAbstractRichTextInputField.TextAcceptKeyPressedEvent.class, (s, e) -> {
                addAction.run();
                return false;
            });
            addBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
                addAction.run();
                return false;
            });
            addBtn.tooltip.set((Object)new DLTooltip(List.of(Constants.TEXT_ADD), 200));
            item.subComponents.add((Object)new DLAbstractDataView.DataSlotComponent("name", (DLGuiComponent)nameBox));
            item.subComponents.add((Object)new DLAbstractDataView.DataSlotComponent("action", (DLGuiComponent)addBtn));
            return item;
        });
        trainLinesEntry.dataView.searchFilter.set((item, searchTerm) -> item.getLineName().toLowerCase().contains(searchTerm.toLowerCase()));
        trainLinesEntry.dataView.itemBuilder.set(in -> {
            boolean allowed = in.getOwner().isAllowed() && GlobalSettingsClient.modificationsAllowed();
            OptionsDataView.DLBasicItem<TrainLine> item = new OptionsDataView.DLBasicItem<TrainLine>(trainLinesEntry.dataView, (TrainLine)in);
            TextOptionLabel nameLabel = new TextOptionLabel();
            nameLabel.addEventListener(DLEditableLabel.TextEditedEvent.class, (s, e) -> {
                if (((String)nameLabel.text.get()).isBlank()) {
                    return false;
                }
                ModNetworkManager.UPDATE_TRAIN_LINE_NAME.send((NetworkDirection)NetworkDirection.toServer(), (NetworkPacketData)new UpdateTrainLineNamePacketData.Request(in.getId(), (String)nameLabel.text.get()), response -> this.reloadTrainLines(trainLinesEntry.dataView), () -> {});
                return false;
            });
            nameLabel.text.set((Object)in.getLineName());
            nameLabel.editable.set((Object)allowed);
            FlatIconButton btnPermissions = new FlatIconButton(0, 0, in.getOwner().get().getIcon());
            DLContextMenu permissionsMenu = new DLContextMenu((pX, pY) -> {
                ArrayList<DLContextMenu.ItemEntry> entries = new ArrayList<DLContextMenu.ItemEntry>();
                entries.add(new DLContextMenu.ItemEntry((Component)TextUtils.translate((String)"gui.createrailwaysnavigator.lock.trusted_players"), DLSprite.empty(), true, () -> this.getWindowManager().createModal(mgr -> new FlyoutTrustedPlayersWidget(mgr, (DLGuiComponent)btnPermissions, AbstractFlyoutWidget.FlyoutPointer.RIGHT, CreateDynamicWidgets.ColorShade.DARK, in.getOwner().getTrusted(), players -> GlobalSettingsClient.updateTrainLinePermissions(new UpdateTrainLinePermissionsPacketData.Request(in.getId(), null, null, (Set<Owner>)players), a -> this.reloadTrainLines(trainLinesEntry.dataView)))), null));
                entries.add(DLContextMenu.ItemEntry.SEPARATOR);
                entries.add(new DLContextMenu.ItemEntry((Component)TextUtils.translate((String)"gui.createrailwaysnavigator.lock.transfer_ownership"), DLSprite.empty(), true, () -> this.getWindowManager().createModal(mgr -> new TransferOwnershipWindow(mgr, in.getOwner().getOwner().orElse(null), newOwner -> GlobalSettingsClient.updateTrainLinePermissions(new UpdateTrainLinePermissionsPacketData.Request(in.getId(), (Owner)newOwner, null, null), $ -> GlobalSettingsClient.getTrainLines(res -> this.reloadTrainLines(trainLinesEntry.dataView))))), null));
                return entries;
            });
            btnPermissions.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
                if (!in.getOwner().isAllowed()) {
                    return false;
                }
                GlobalSettingsClient.updateTrainLinePermissions(new UpdateTrainLinePermissionsPacketData.Request(in.getId(), null, (Lock.LockState)in.getOwner().get().next(), null), a -> a.ifPresent(x -> {
                    in.getOwner().set(x.getOwner().get());
                    in.getOwner().updateTrusted(x.getOwner().getTrusted());
                    btnPermissions.sprite.set((Object)x.getOwner().get().getIcon());
                    btnPermissions.tooltip.set((Object)new DLTooltip(in.getOwner().asText(new Owner((Player)Minecraft.m_91087_().f_91074_)), 200));
                }));
                return false;
            });
            btnPermissions.addEventListener(DLGuiStandardEvents.RightClickEvent.class, (src, event) -> {
                if (!in.getOwner().isAdmin()) {
                    return false;
                }
                permissionsMenu.open(this.getWindowManager(), (int)this.getWindowManager().mouseXOnScreen(), (int)this.getWindowManager().mouseYOnScreen());
                return false;
            });
            btnPermissions.tooltip.set((Object)new DLTooltip(in.getOwner().asText(new Owner((Player)Minecraft.m_91087_().f_91074_)), 200));
            FlatIconButton colorBtn = new FlatIconButton(0, 0, ModGuiIcons.COLOR_PALETTE.getAsSprite(16, 16));
            colorBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
                this.getWindowManager().createModal(mgr -> new FlyoutColorPickerWidget(mgr, (DLGuiComponent)colorBtn, AbstractFlyoutWidget.FlyoutPointer.RIGHT, CreateDynamicWidgets.ColorShade.DARK, DLColor.TRANSPARENT, Constants.DEFAULT_TRAIN_TYPE_COLORS, 8, true, true, col -> ModNetworkManager.UPDATE_TRAIN_LINE_COLOR.send((NetworkDirection)NetworkDirection.toServer(), (NetworkPacketData)new UpdateTrainLineColorPacketData(in.getId(), (DLColor)col), response -> this.reloadTrainLines(trainLinesEntry.dataView), () -> {})));
                return false;
            });
            colorBtn.tooltip.set((Object)new DLTooltip(List.of(this.textColor), 200));
            colorBtn.backgroundTint.set((Object)in.getColor());
            FlatIconButton deleteBtn = new FlatIconButton(0, 0, ModGuiIcons.DELETE.getAsSprite(16, 16));
            deleteBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
                this.getWindowManager().createModal(mgr -> new FlyoutConfirmDialog(mgr, (DLGuiComponent)deleteBtn, AbstractFlyoutWidget.FlyoutPointer.RIGHT, CreateDynamicWidgets.ColorShade.DARK, () -> ModNetworkManager.DELETE_TRAIN_LINE.send((NetworkDirection)NetworkDirection.toServer(), (NetworkPacketData)new DeleteTrainLinePacketData(in.getId()), response -> this.reloadTrainLines(trainLinesEntry.dataView), () -> {})));
                return false;
            });
            deleteBtn.tooltip.set((Object)new DLTooltip(List.of(Constants.TEXT_DELETE), 200));
            item.subComponents.add((Object)new DLAbstractDataView.DataSlotComponent("name", (DLGuiComponent)nameLabel));
            item.subComponents.add((Object)new DLAbstractDataView.DataSlotComponent("permissions", (DLGuiComponent)btnPermissions));
            if (allowed) {
                item.subComponents.add((Object)new DLAbstractDataView.DataSlotComponent("color", (DLGuiComponent)colorBtn));
                item.subComponents.add((Object)new DLAbstractDataView.DataSlotComponent("action", (DLGuiComponent)deleteBtn));
            }
            return item;
        });
        trainLinesEntry.dataView.dataSlots.add((Object)new DLAbstractDataView.DataSlot("name", (Component)TextUtils.text((String)"Name"), 100.0, DLAbstractDataView.SizeMode.PERCENTAGE));
        trainLinesEntry.dataView.dataSlots.add((Object)new DLAbstractDataView.DataSlot("permissions", (Component)TextUtils.text((String)"Permission"), 18.0, DLAbstractDataView.SizeMode.FIXED));
        trainLinesEntry.dataView.dataSlots.add((Object)new DLAbstractDataView.DataSlot("color", (Component)TextUtils.text((String)"Color"), 18.0, DLAbstractDataView.SizeMode.FIXED));
        trainLinesEntry.dataView.dataSlots.add((Object)new DLAbstractDataView.DataSlot("action", (Component)TextUtils.text((String)"Action"), 18.0, DLAbstractDataView.SizeMode.FIXED));
        FlatIconButton btnHelp = new FlatIconButton(0, 0, ModGuiIcons.HELP.getAsSprite(16, 16));
        btnHelp.tooltip.set((Object)new DLTooltip(List.of(Constants.TEXT_HELP), 200));
        btnHelp.layoutContraint.set((Object)"help");
        btnHelp.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            Util.m_137581_().m_137646_("https://github.com/MisterJulsen/Create-Train-Navigator/wiki/Train-Lines");
            return false;
        });
        trainLinesEntry.getHeader().addComponent((DLGuiComponent)btnHelp);
        return trainLinesEntry;
    }

    private OptionEntry<TrainCategory> createTrainCategoryOption() {
        OptionEntry<TrainCategory> trainLinesEntry = this.optionsView.addEntry(new OptionEntry(this.optionTrainCategoryTitle, List.of(this.optionTrainCategoryDescription), (IEventListener<DLGuiComponent, DLGuiStandardEvents.MousePressedEvent>)((IEventListener)(s, e) -> {
            OptionEntry c = (OptionEntry)s;
            c.expanded.toggle();
            if (((Boolean)c.expanded.get()).booleanValue()) {
                this.reloadTrainCategories(c.dataView);
            }
            return false;
        })));
        TableLayout layout = new TableLayout();
        layout.addColumn("name", 1.0, TableLayout.ColumnSizeMode.PERCENTAGE);
        layout.addColumn("help", 0.0, TableLayout.ColumnSizeMode.AUTO);
        layout.addColumn("dropdown", 20.0, TableLayout.ColumnSizeMode.FIXED);
        trainLinesEntry.getHeader().layout.set((Object)layout);
        trainLinesEntry.dataView.createNewItemBuilder.set(!GlobalSettingsClient.modificationsAllowed() ? null : view -> {
            OptionsDataView.CreateEntryItem item = new OptionsDataView.CreateEntryItem(view);
            CreateTextBox nameBox = new CreateTextBox(0, 0, 0);
            FlatIconButton addBtn = new FlatIconButton(0, 0, ModGuiIcons.ADD.getAsSprite(16, 16));
            Runnable addAction = () -> {
                if (((RichTextComponent)nameBox.text.get()).getPlainText().isBlank()) {
                    return;
                }
                ModNetworkManager.CREATE_TRAIN_CATEGORY.send((NetworkDirection)NetworkDirection.toServer(), (NetworkPacketData)new CreateTrainCategoryPacketData.Request(((RichTextComponent)nameBox.text.get()).getPlainText()), response -> this.reloadTrainCategories((OptionsDataView<TrainCategory>)((Object)view)), () -> {});
                ((RichTextComponent)nameBox.text.get()).clear();
            };
            nameBox.acceptAndCancelKeysEnabled.set((Object)true);
            nameBox.addEventListener(DLAbstractRichTextInputField.TextAcceptKeyPressedEvent.class, (s, e) -> {
                addAction.run();
                return false;
            });
            addBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
                addAction.run();
                return false;
            });
            addBtn.tooltip.set((Object)new DLTooltip(List.of(Constants.TEXT_ADD), 200));
            item.subComponents.add((Object)new DLAbstractDataView.DataSlotComponent("name", (DLGuiComponent)nameBox));
            item.subComponents.add((Object)new DLAbstractDataView.DataSlotComponent("action", (DLGuiComponent)addBtn));
            return item;
        });
        trainLinesEntry.dataView.searchFilter.set((item, searchTerm) -> item.getCategoryName().toLowerCase().contains(searchTerm.toLowerCase()));
        trainLinesEntry.dataView.itemBuilder.set(in -> {
            boolean allowed = in.getOwner().isAllowed() && GlobalSettingsClient.modificationsAllowed();
            OptionsDataView.DLBasicItem<TrainCategory> item = new OptionsDataView.DLBasicItem<TrainCategory>(trainLinesEntry.dataView, (TrainCategory)in);
            TextOptionLabel nameLabel = new TextOptionLabel();
            nameLabel.addEventListener(DLEditableLabel.TextEditedEvent.class, (s, e) -> {
                if (((String)nameLabel.text.get()).isBlank()) {
                    return false;
                }
                ModNetworkManager.UPDATE_TRAIN_CATEGORY_NAME.send((NetworkDirection)NetworkDirection.toServer(), (NetworkPacketData)new UpdateTrainCategoryNamePacketData.Request(in.getId(), (String)nameLabel.text.get()), response -> this.reloadTrainCategories(trainLinesEntry.dataView), () -> {});
                return false;
            });
            nameLabel.text.set((Object)in.getCategoryName());
            nameLabel.editable.set((Object)allowed);
            FlatIconButton btnPermissions = new FlatIconButton(0, 0, in.getOwner().get().getIcon());
            DLContextMenu permissionsMenu = new DLContextMenu((pX, pY) -> {
                ArrayList<DLContextMenu.ItemEntry> entries = new ArrayList<DLContextMenu.ItemEntry>();
                entries.add(new DLContextMenu.ItemEntry((Component)TextUtils.translate((String)"gui.createrailwaysnavigator.lock.trusted_players"), DLSprite.empty(), true, () -> this.getWindowManager().createModal(mgr -> new FlyoutTrustedPlayersWidget(mgr, (DLGuiComponent)btnPermissions, AbstractFlyoutWidget.FlyoutPointer.RIGHT, CreateDynamicWidgets.ColorShade.DARK, in.getOwner().getTrusted(), players -> GlobalSettingsClient.updateTrainCategoryPermissions(new TrainCategoryUpdatePermissionsPacketData.Request(in.getId(), null, null, (Set<Owner>)players), a -> this.reloadTrainCategories(trainLinesEntry.dataView)))), null));
                entries.add(DLContextMenu.ItemEntry.SEPARATOR);
                entries.add(new DLContextMenu.ItemEntry((Component)TextUtils.translate((String)"gui.createrailwaysnavigator.lock.transfer_ownership"), DLSprite.empty(), true, () -> this.getWindowManager().createModal(mgr -> new TransferOwnershipWindow(mgr, in.getOwner().getOwner().orElse(null), newOwner -> GlobalSettingsClient.updateTrainCategoryPermissions(new TrainCategoryUpdatePermissionsPacketData.Request(in.getId(), (Owner)newOwner, null, null), $ -> GlobalSettingsClient.getTrainCategories(res -> this.reloadTrainCategories(trainLinesEntry.dataView))))), null));
                return entries;
            });
            btnPermissions.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
                if (!in.getOwner().isAllowed()) {
                    return false;
                }
                GlobalSettingsClient.updateTrainCategoryPermissions(new TrainCategoryUpdatePermissionsPacketData.Request(in.getId(), null, (Lock.LockState)in.getOwner().get().next(), null), a -> a.ifPresent(x -> {
                    in.getOwner().set(x.getOwner().get());
                    in.getOwner().updateTrusted(x.getOwner().getTrusted());
                    btnPermissions.sprite.set((Object)x.getOwner().get().getIcon());
                    btnPermissions.tooltip.set((Object)new DLTooltip(in.getOwner().asText(new Owner((Player)Minecraft.m_91087_().f_91074_)), 200));
                }));
                return false;
            });
            btnPermissions.addEventListener(DLGuiStandardEvents.RightClickEvent.class, (src, event) -> {
                if (!in.getOwner().isAdmin()) {
                    return false;
                }
                permissionsMenu.open(this.getWindowManager(), (int)this.getWindowManager().mouseXOnScreen(), (int)this.getWindowManager().mouseYOnScreen());
                return false;
            });
            btnPermissions.tooltip.set((Object)new DLTooltip(in.getOwner().asText(new Owner((Player)Minecraft.m_91087_().f_91074_)), 200));
            FlatIconButton colorBtn = new FlatIconButton(0, 0, ModGuiIcons.COLOR_PALETTE.getAsSprite(16, 16));
            colorBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
                this.getWindowManager().createModal(mgr -> new FlyoutColorPickerWidget(mgr, (DLGuiComponent)colorBtn, AbstractFlyoutWidget.FlyoutPointer.RIGHT, CreateDynamicWidgets.ColorShade.DARK, DLColor.TRANSPARENT, Constants.DEFAULT_TRAIN_TYPE_COLORS, 8, true, true, col -> ModNetworkManager.UPDATE_TRAIN_CATEGORY_COLOR.send((NetworkDirection)NetworkDirection.toServer(), (NetworkPacketData)new UpdateTrainCategoryColorPacketData(in.getId(), (DLColor)col), response -> this.reloadTrainCategories(trainLinesEntry.dataView), () -> {})));
                return false;
            });
            colorBtn.tooltip.set((Object)new DLTooltip(List.of(this.textColor), 200));
            colorBtn.backgroundTint.set((Object)in.getColor());
            FlatIconButton deleteBtn = new FlatIconButton(0, 0, ModGuiIcons.DELETE.getAsSprite(16, 16));
            deleteBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
                this.getWindowManager().createModal(mgr -> new FlyoutConfirmDialog(mgr, (DLGuiComponent)deleteBtn, AbstractFlyoutWidget.FlyoutPointer.RIGHT, CreateDynamicWidgets.ColorShade.DARK, () -> ModNetworkManager.DELETE_TRAIN_CATEGORY.send((NetworkDirection)NetworkDirection.toServer(), (NetworkPacketData)new DeleteTrainCategoryPacketData(in.getId()), response -> this.reloadTrainCategories(trainLinesEntry.dataView), () -> {})));
                return false;
            });
            deleteBtn.tooltip.set((Object)new DLTooltip(List.of(Constants.TEXT_DELETE), 200));
            item.subComponents.add((Object)new DLAbstractDataView.DataSlotComponent("name", (DLGuiComponent)nameLabel));
            item.subComponents.add((Object)new DLAbstractDataView.DataSlotComponent("permissions", (DLGuiComponent)btnPermissions));
            if (allowed) {
                item.subComponents.add((Object)new DLAbstractDataView.DataSlotComponent("color", (DLGuiComponent)colorBtn));
                item.subComponents.add((Object)new DLAbstractDataView.DataSlotComponent("action", (DLGuiComponent)deleteBtn));
            }
            return item;
        });
        trainLinesEntry.dataView.dataSlots.add((Object)new DLAbstractDataView.DataSlot("name", (Component)TextUtils.text((String)"Name"), 100.0, DLAbstractDataView.SizeMode.PERCENTAGE));
        trainLinesEntry.dataView.dataSlots.add((Object)new DLAbstractDataView.DataSlot("permissions", (Component)TextUtils.text((String)"Permission"), 18.0, DLAbstractDataView.SizeMode.FIXED));
        trainLinesEntry.dataView.dataSlots.add((Object)new DLAbstractDataView.DataSlot("color", (Component)TextUtils.text((String)"Color"), 18.0, DLAbstractDataView.SizeMode.FIXED));
        trainLinesEntry.dataView.dataSlots.add((Object)new DLAbstractDataView.DataSlot("action", (Component)TextUtils.text((String)"Action"), 18.0, DLAbstractDataView.SizeMode.FIXED));
        FlatIconButton btnHelp = new FlatIconButton(0, 0, ModGuiIcons.HELP.getAsSprite(16, 16));
        btnHelp.tooltip.set((Object)new DLTooltip(List.of(Constants.TEXT_HELP), 200));
        btnHelp.layoutContraint.set((Object)"help");
        btnHelp.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            Util.m_137581_().m_137646_("https://github.com/MisterJulsen/Create-Train-Navigator/wiki/Train-Categories");
            return false;
        });
        trainLinesEntry.getHeader().addComponent((DLGuiComponent)btnHelp);
        return trainLinesEntry;
    }
}

