/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.windows;

import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.widgets.routedetails.RouteDetailsViewer;
import de.mrjulsen.crn.client.gui.windows.AbstractNavigatorScreen;
import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.crn.data.navigation.ClientRoutePart;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindowManager;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.mcdragonlib.util.time.ConfiguredTimeSystem;
import de.mrjulsen.mcdragonlib.util.time.DLTime;
import de.mrjulsen.mcdragonlib.util.time.ITimeSystem;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.level.Level;

public class TrainJourneyWindow
extends AbstractNavigatorScreen {
    private final ClientRoute route;
    private final ClientRoutePart part;
    private final RouteDetailsViewer viewer;

    public TrainJourneyWindow(DLWindowManager manager, ClientRoute route, UUID trainId) {
        super(manager, (Component)TextUtils.translate((String)"gui.createrailwaysnavigator.journey_info.title"), CreateDynamicWidgets.ContainerColor.GRAY, CreateDynamicWidgets.BarColor.GOLD);
        this.route = route;
        this.part = route.getClientParts().stream().filter(x -> x.getTrainId().equals(trainId)).findFirst().orElse(route.getFirstClientPart());
        int dy = CreateDynamicWidgets.FooterSize.DEFAULT.size() + 32;
        this.viewer = (RouteDetailsViewer)this.addComponent(new RouteDetailsViewer(3, dy, 234, 247 - dy - CreateDynamicWidgets.FooterSize.SMALL.size() - 1));
        this.viewer.showTrainDetails.set((Object)false);
        this.viewer.canExpandCollapse.set((Object)false);
        this.viewer.expanded.set((Object)true);
        this.viewer.showEntireJourney.set((Object)true);
        this.viewer.displayPart(route, x -> x == this.part);
    }

    @Override
    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        super.renderMainLayer(graphics, mouseX, mouseY, renderBounds);
        int y = CreateDynamicWidgets.FooterSize.DEFAULT.size() - 1;
        CreateDynamicWidgets.renderContainer(graphics, 1, y, 238, 32, CreateDynamicWidgets.ContainerColor.BLUE);
        GuiUtils.drawString((DLGuiGraphics)graphics, (Font)graphics.defaultFont(), (int)8, (int)(y + 7), (FormattedText)TextUtils.translate((String)"gui.createrailwaysnavigator.journey_info.date", (Object[])new Object[]{(long)DLTime.fromLevelTime((Level)Minecraft.m_91087_().f_91073_, (ITimeSystem)new ConfiguredTimeSystem()).toGameDays()}), (DLColor)DragonLib.VANILLA_BUTTON_ACTIVE_FONT_COLOR, (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
        GuiUtils.drawString((DLGuiGraphics)graphics, (Font)graphics.defaultFont(), (int)8, (int)(y + 18), (FormattedText)TextUtils.translate((String)"gui.createrailwaysnavigator.journey_info.train", (Object[])new Object[]{this.part.getFirstStop().getTrainDisplayName(), this.part.getFirstStop().getTrainId().toString().split("-")[0], this.part.getFirstStop().getDisplayTitle()}), (DLColor)DragonLib.VANILLA_BUTTON_ACTIVE_FONT_COLOR, (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
        CreateDynamicWidgets.renderContainer(graphics, 1, y += 31, 238, 247 - y - CreateDynamicWidgets.FooterSize.SMALL.size() + 1, CreateDynamicWidgets.ContainerColor.GOLD);
    }
}

