/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.windows;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.trains.schedule.condition.TimedWaitCondition;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.utility.CreateLang;
import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.client.CRNGui;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.widgets.IconSlotWidget;
import de.mrjulsen.crn.client.gui.widgets.ModularWidgetContainer;
import de.mrjulsen.crn.client.gui.widgets.create.CreateButton;
import de.mrjulsen.crn.client.gui.widgets.create.CreateItemPicker;
import de.mrjulsen.crn.client.gui.widgets.create.CreateScrollNumberInput;
import de.mrjulsen.crn.data.ETimeSource;
import de.mrjulsen.crn.data.train.DepartureHistory;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindow;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindowManager;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLCycleButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLNumberPicker;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLPanel;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLTooltip;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.DLTexture;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.mcdragonlib.util.time.DLTime;
import de.mrjulsen.mcdragonlib.util.time.ITimeSystem;
import de.mrjulsen.mcdragonlib.util.time.VanillaTimeSystem;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.gui.element.ScreenElement;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class TrainSeparationSettingsWindow
extends DLWindow {
    private static final MutableComponent title = TextUtils.translate((String)"createrailwaysnavigator.schedule.condition.train_separation.settings");
    private static final ItemStack DISPLAY_ITEM = new ItemStack((ItemLike)AllItems.SCHEDULE.get());
    private static final int GUI_WIDTH = 212;
    private static final CreateDynamicWidgets.FooterSize headerSize = CreateDynamicWidgets.FooterSize.DEFAULT;
    private static final CreateDynamicWidgets.FooterSize footerSize = CreateDynamicWidgets.FooterSize.SMALL;
    private ModularWidgetContainer commonSettingsContainer;
    private final CompoundTag nbt;
    private DLTime currentTime = Constants.NULL_TIME;
    private DepartureHistory.ETrainFilter filter = DepartureHistory.ETrainFilter.ANY;
    private ETimeSource timeSource = ETimeSource.REAL_LIFE;

    public TrainSeparationSettingsWindow(DLWindowManager manager, CompoundTag nbt) {
        super(manager);
        this.setWidth(212.0);
        this.windowSpawnPosition.set((Object)DLWindow.WindowPosition.PARENT_CENTER);
        this.nbt = nbt;
        this.currentTime = DLTime.fromTicks((double)(nbt.m_128441_("Ticks") ? (double)nbt.m_128451_("Ticks") : (double)(nbt.m_128451_("Value") * TimedWaitCondition.TimeUnit.values()[nbt.m_128451_((String)"TimeUnit")].ticksPer)), (ITimeSystem)VanillaTimeSystem.INSTANCE);
        this.filter = DepartureHistory.ETrainFilter.getByIndex(nbt.m_128445_("TrainFilter"));
        this.timeSource = ETimeSource.getByIndex(nbt.m_128445_("TimeSource"));
        CreateButton backButton = (CreateButton)this.addComponent((DLGuiComponent)new CreateButton(this.width() - 7 - 18, this.height() - 6 - 18, (ScreenElement)AllIcons.I_CONFIRM));
        backButton.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            this.getWindowManager().closeWindow((DLWindow)this);
            return false;
        });
        CreateButton helpButton = (CreateButton)this.addComponent((DLGuiComponent)new CreateButton(this.width() - 17 - 36, this.height() - 6 - 18, (ScreenElement)ModGuiIcons.HELP.getAsCreateIcon()));
        helpButton.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            Util.m_137581_().m_137646_("https://github.com/MisterJulsen/Create-Train-Navigator/wiki/Train-Separation");
            return false;
        });
        helpButton.tooltip.set((Object)new DLTooltip(List.of(Constants.TEXT_HELP), 200));
        this.commonSettingsContainer = (ModularWidgetContainer)this.addComponent(new ModularWidgetContainer(3, headerSize.size() + 1, this.width() - 6, 100));
        int minHeight = headerSize.size() + footerSize.size() + 2;
        this.initGui();
        this.setHeight(minHeight);
        this.commonSettingsContainer.addEventListener(ModularWidgetContainer.ContentLayoutUpdatedEvent.class, (s, e) -> {
            this.commonSettingsContainer.setHeight(e.layoutResult().contentHeight());
            this.setHeight(minHeight + e.layoutResult().contentHeight());
            backButton.setPosition(this.width() - 7 - 18, this.height() - 6 - 18);
            helpButton.setPosition(this.width() - 17 - 36, this.height() - 6 - 18);
            this.setY(this.getWindowManager().getScreenHeight() / 2.0 - (double)(this.height() / 2));
            return false;
        });
    }

    private void initGui() {
        this.commonSettingsContainer.clearLines();
        DLPanel lineTimes = this.commonSettingsContainer.addLine("times");
        IconSlotWidget timesIcon = (IconSlotWidget)lineTimes.addComponent((DLGuiComponent)new IconSlotWidget(0, 0));
        timesIcon.icon.set((Object)ModGuiIcons.TIME.getAsSprite(16, 16));
        switch (this.timeSource) {
            case IN_GAME: {
                DLTime.TimeSnapshot snapshot = this.currentTime.decomposeGameTime();
                CreateScrollNumberInput daysBox = (CreateScrollNumberInput)lineTimes.addComponent((DLGuiComponent)new CreateScrollNumberInput(0, 0, 22));
                daysBox.title.set((Object)CreateLang.translateDirect((String)"generic.unit.days", (Object[])new Object[0]));
                daysBox.shiftStep.set((Number)5.0);
                daysBox.min.set((Number)0.0);
                daysBox.max.set((Number)49.0);
                daysBox.value.set((Number)snapshot.days());
                daysBox.addEventListener(DLNumberPicker.ValueChangedEvent.class, (s, e) -> {
                    DLTime.TimeSnapshot ts = this.currentTime.decomposeGameTime();
                    this.currentTime = DLTime.fromIngame((long)((long)e.value()), (int)ts.hours(), (int)ts.minutes(), (int)ts.seconds(), (ITimeSystem)VanillaTimeSystem.INSTANCE);
                    return false;
                });
                CreateScrollNumberInput hoursBox = (CreateScrollNumberInput)lineTimes.addComponent((DLGuiComponent)new CreateScrollNumberInput(0, 0, 22));
                hoursBox.title.set((Object)CreateLang.translateDirect((String)"generic.unit.hours", (Object[])new Object[0]));
                hoursBox.shiftStep.set((Number)8.0);
                hoursBox.min.set((Number)0.0);
                hoursBox.max.set((Number)23.0);
                hoursBox.value.set((Number)snapshot.hours());
                hoursBox.addEventListener(DLNumberPicker.ValueChangedEvent.class, (s, e) -> {
                    DLTime.TimeSnapshot ts = this.currentTime.decomposeGameTime();
                    this.currentTime = DLTime.fromIngame((long)ts.days(), (int)((int)e.value()), (int)ts.minutes(), (int)ts.seconds(), (ITimeSystem)VanillaTimeSystem.INSTANCE);
                    return false;
                });
                CreateScrollNumberInput minutesBox = (CreateScrollNumberInput)lineTimes.addComponent((DLGuiComponent)new CreateScrollNumberInput(0, 0, 22));
                minutesBox.title.set((Object)CreateLang.translateDirect((String)"generic.unit.minutes", (Object[])new Object[0]));
                minutesBox.shiftStep.set((Number)5.0);
                minutesBox.min.set((Number)0.0);
                minutesBox.max.set((Number)59.0);
                minutesBox.value.set((Number)snapshot.minutes());
                minutesBox.addEventListener(DLNumberPicker.ValueChangedEvent.class, (s, e) -> {
                    DLTime.TimeSnapshot ts = this.currentTime.decomposeGameTime();
                    this.currentTime = DLTime.fromIngame((long)ts.days(), (int)ts.hours(), (int)((int)e.value()), (int)0, (ITimeSystem)VanillaTimeSystem.INSTANCE);
                    return false;
                });
                break;
            }
            default: {
                DLTime.TimeSnapshot snapshot = this.currentTime.decomposeRealTime();
                CreateScrollNumberInput minutesBox = (CreateScrollNumberInput)lineTimes.addComponent((DLGuiComponent)new CreateScrollNumberInput(0, 0, 22));
                minutesBox.title.set((Object)CreateLang.translateDirect((String)"generic.unit.minutes", (Object[])new Object[0]));
                minutesBox.shiftStep.set((Number)10.0);
                minutesBox.min.set((Number)0.0);
                minutesBox.max.set((Number)999.0);
                minutesBox.value.set((Number)((long)snapshot.minutes() + ((long)snapshot.hours() + snapshot.days() * 24L) * 60L));
                minutesBox.addEventListener(DLNumberPicker.ValueChangedEvent.class, (s, e) -> {
                    DLTime.TimeSnapshot ts = this.currentTime.decomposeRealTime();
                    this.currentTime = DLTime.fromReal((long)ts.days(), (int)ts.hours(), (int)((int)e.value()), (int)ts.seconds(), (int)ts.millis(), (ITimeSystem)VanillaTimeSystem.INSTANCE);
                    return false;
                });
                CreateScrollNumberInput secondsBox = (CreateScrollNumberInput)lineTimes.addComponent((DLGuiComponent)new CreateScrollNumberInput(0, 0, 22));
                secondsBox.title.set((Object)CreateLang.translateDirect((String)"generic.unit.seconds", (Object[])new Object[0]));
                secondsBox.shiftStep.set((Number)10.0);
                secondsBox.min.set((Number)0.0);
                secondsBox.max.set((Number)59.0);
                secondsBox.value.set((Number)snapshot.seconds());
                secondsBox.addEventListener(DLNumberPicker.ValueChangedEvent.class, (s, e) -> {
                    DLTime.TimeSnapshot ts = this.currentTime.decomposeRealTime();
                    this.currentTime = DLTime.fromReal((long)ts.days(), (int)ts.hours(), (int)ts.minutes(), (int)((int)e.value()), (int)ts.millis(), (ITimeSystem)VanillaTimeSystem.INSTANCE);
                    return false;
                });
                CreateScrollNumberInput ticksBox = (CreateScrollNumberInput)lineTimes.addComponent((DLGuiComponent)new CreateScrollNumberInput(0, 0, 22));
                ticksBox.title.set((Object)CreateLang.translateDirect((String)"generic.unit.ticks", (Object[])new Object[0]));
                ticksBox.shiftStep.set((Number)5.0);
                ticksBox.min.set((Number)0.0);
                ticksBox.max.set((Number)19.0);
                ticksBox.value.set((Number)snapshot.millis());
                ticksBox.addEventListener(DLNumberPicker.ValueChangedEvent.class, (s, e) -> false);
            }
        }
        CreateItemPicker timeSourcePicker = (CreateItemPicker)lineTimes.addComponent(new CreateItemPicker(0, 0, 80));
        timeSourcePicker.title.set((Object)ETimeSource.IN_GAME.getEnumTranslation());
        timeSourcePicker.hint.set((Object)ETimeSource.IN_GAME.getEnumDescriptionTranslation());
        timeSourcePicker.formatter.set(item -> item == null ? TextUtils.empty() : item.getValueTranslation());
        timeSourcePicker.items.addAll((Object[])ETimeSource.values());
        timeSourcePicker.selectedItem.set(Optional.ofNullable(this.timeSource));
        timeSourcePicker.addEventListener(DLCycleButton.SelectedItemChanged.class, (s, e) -> {
            ((Optional)timeSourcePicker.selectedItem.get()).ifPresent(i -> {
                this.timeSource = i;
            });
            this.initGui();
            return false;
        });
        DLPanel lineFilter = this.commonSettingsContainer.addLine("filter");
        IconSlotWidget filterIcon = (IconSlotWidget)lineFilter.addComponent((DLGuiComponent)new IconSlotWidget(0, 0));
        filterIcon.icon.set((Object)ModGuiIcons.TRAIN.getAsSprite(16, 16));
        CreateItemPicker filterType = (CreateItemPicker)lineFilter.addComponent(new CreateItemPicker(0, 0, 120));
        filterType.renderArrow.set((Object)true);
        filterType.title.set((Object)DepartureHistory.ETrainFilter.ANY.getEnumTranslation());
        filterType.hint.set((Object)DepartureHistory.ETrainFilter.ANY.getEnumDescriptionTranslation());
        filterType.formatter.set(item -> item == null ? TextUtils.empty() : item.getValueTranslation());
        filterType.items.addAll((Object[])DepartureHistory.ETrainFilter.values());
        filterType.selectedItem.set(Optional.ofNullable(this.filter));
        filterType.addEventListener(DLCycleButton.SelectedItemChanged.class, (s, e) -> {
            ((Optional)filterType.selectedItem.get()).ifPresent(i -> {
                this.filter = i;
            });
            return false;
        });
    }

    public void close() {
        this.nbt.m_128405_("Ticks", (int)this.currentTime.getTicks());
        this.nbt.m_128344_("TimeSource", this.timeSource.getIndex());
        this.nbt.m_128344_("TrainFilter", this.filter.getIndex());
    }

    public Rectangle getRenderBounds() {
        return Rectangle.INFINITE;
    }

    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        CreateDynamicWidgets.renderWindow(graphics, 0, 0, this.width(), this.height(), CreateDynamicWidgets.ContainerColor.PURPLE, CreateDynamicWidgets.BarColor.GOLD, CreateDynamicWidgets.BarColor.GRAY, headerSize.size(), footerSize.size(), true);
        CreateDynamicWidgets.renderVerticalSeparator(graphics, this.width() - 31, this.height() - footerSize.size() + 2, footerSize.size() - 4, CreateDynamicWidgets.BarColor.GRAY);
        GuiUtils.drawString((DLGuiGraphics)graphics, (Font)graphics.defaultFont(), (int)6, (int)4, (FormattedText)title, (DLColor)DragonLib.VANILLA_UI_FONT_COLOR, (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
        GuiUtils.drawTexture((DLTexture)CRNGui.GUI, (DLGuiGraphics)graphics, (int)(this.width() - 3), (int)(this.height() - 24), (int)11, (int)18, (int)0, (int)12);
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of((ItemStack)DISPLAY_ITEM).at((float)(this.width() + 11), (float)(this.height() - 48), -200.0f)).scale(4.0).render(graphics.graphics());
    }
}

