/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.windows;

import com.simibubi.create.foundation.gui.AllIcons;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.flyout.FlyoutConfirmDialog;
import de.mrjulsen.crn.client.gui.widgets.AbstractFlyoutWidget;
import de.mrjulsen.crn.client.gui.widgets.IconSlotWidget;
import de.mrjulsen.crn.client.gui.widgets.create.CreateButton;
import de.mrjulsen.crn.client.gui.widgets.create.CreateItemPicker;
import de.mrjulsen.crn.registry.ModNetworkManager;
import de.mrjulsen.crn.util.Owner;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindow;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindowManager;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.network.NetworkDirection;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.MathUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.createmod.catnip.gui.element.ScreenElement;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.network.chat.FormattedText;

public class TransferOwnershipWindow
extends DLWindow {
    private static final int GUI_WIDTH = 250;
    private static final int GUI_HEIGHT = 120;
    private static final CreateDynamicWidgets.FooterSize headerSize = CreateDynamicWidgets.FooterSize.DEFAULT;
    private static final CreateDynamicWidgets.FooterSize footerSize = CreateDynamicWidgets.FooterSize.SMALL;
    private final Owner current;
    private final List<Owner> playerList = new ArrayList<Owner>();
    private final MultiLineLabel messageLabel;
    private final IconSlotWidget iconWidget;
    private final CreateItemPicker<Owner> selectionBox;

    public TransferOwnershipWindow(DLWindowManager manager, Owner selected, Consumer<Owner> okAction) {
        super(manager);
        this.setSize(250.0, 120.0);
        this.movable.set((Object)true);
        this.windowSpawnPosition.set((Object)DLWindow.WindowPosition.PARENT_CENTER);
        this.current = selected;
        Rectangle workingArea = Rectangle.withSize((double)1.0, (double)headerSize.size(), (double)(this.width() - 2), (double)(this.height() - headerSize.size() - footerSize.size()));
        this.iconWidget = (IconSlotWidget)this.addComponent(new IconSlotWidget((int)workingArea.x() + 16, (int)workingArea.y() + 8));
        this.iconWidget.icon.set((Object)ModGuiIcons.USER.getAsSprite(16, 16));
        this.selectionBox = (CreateItemPicker)this.addComponent((DLGuiComponent)new CreateItemPicker(this.iconWidget.x() + this.iconWidget.width() + 6, this.iconWidget.y(), this.width() - (this.iconWidget.x() + this.iconWidget.width()) + this.x() - 16 - 6));
        this.selectionBox.enabled.set((Object)false);
        this.selectionBox.renderArrow.set((Object)true);
        this.selectionBox.filter.set((i, s) -> i.name().toLowerCase().contains(s.toLowerCase()));
        this.selectionBox.formatter.set(i -> i == null ? TextUtils.empty() : TextUtils.text((String)i.name()));
        CreateButton okBtn = (CreateButton)this.addComponent((DLGuiComponent)new CreateButton(this.width() - 17 - 36, this.height() - 6 - 18, (ScreenElement)AllIcons.I_CONFIRM));
        okBtn.enabled.set((Object)false);
        okBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            this.getWindowManager().createModal(mgr -> new FlyoutConfirmDialog(mgr, (DLGuiComponent)okBtn, AbstractFlyoutWidget.FlyoutPointer.RIGHT, CreateDynamicWidgets.ColorShade.DARK, () -> {
                DLUtils.doIfNotNull((Object)okAction, x -> x.accept(this.playerList.get((Integer)this.selectionBox.selectedIndex.get())));
                this.getAssignedModal().ifPresent(m -> this.getWindowManager().closeModal(m));
            }));
            return false;
        });
        CreateButton cancelBtn = (CreateButton)this.addComponent((DLGuiComponent)new CreateButton(this.width() - 7 - 18, this.height() - 6 - 18, (ScreenElement)AllIcons.I_MTD_CLOSE));
        cancelBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            this.getAssignedModal().ifPresent(m -> this.getWindowManager().closeModal(m));
            return false;
        });
        this.messageLabel = MultiLineLabel.m_94341_((Font)Minecraft.m_91087_().f_91062_, (FormattedText)TextUtils.translate((String)"gui.createrailwaysnavigator.lock.transfer_ownership.warning").m_130940_(ChatFormatting.GOLD), (int)((int)((float)this.selectionBox.width() / 0.75f)));
        ModNetworkManager.GET_ONLINE_PLAYERS.send((NetworkDirection)NetworkDirection.toServer(), response -> {
            this.playerList.add(new Owner());
            this.playerList.addAll(response.getPlayers().stream().collect(Collectors.toSet()));
            this.selectionBox.items.set(this.playerList);
            this.selectionBox.selectedIndex.set((Number)MathUtils.clamp((int)(this.current == null ? 0 : this.playerList.indexOf(this.current)), (int)0, (int)(this.playerList.size() - 1)));
            okBtn.enabled.set((Object)true);
            this.selectionBox.enabled.set((Object)true);
        }, () -> {});
    }

    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        Rectangle workingArea = Rectangle.withSize((double)1.0, (double)headerSize.size(), (double)(this.width() - 2), (double)(this.height() - headerSize.size() - footerSize.size()));
        CreateDynamicWidgets.renderWindow(graphics, 0, 0, this.width(), this.height(), CreateDynamicWidgets.ContainerColor.PURPLE, CreateDynamicWidgets.BarColor.GOLD, CreateDynamicWidgets.BarColor.GRAY, headerSize.size(), footerSize.size(), false);
        CreateDynamicWidgets.renderVerticalSeparator(graphics, this.width() - 31, this.height() - footerSize.size() + 2, footerSize.size() - 4, CreateDynamicWidgets.BarColor.GRAY);
        CreateDynamicWidgets.renderContainer(graphics, (int)workingArea.x(), (int)workingArea.y() - 1, (int)workingArea.width(), (int)workingArea.height() + 2, CreateDynamicWidgets.ContainerColor.PURPLE);
        GuiUtils.drawString((DLGuiGraphics)graphics, (Font)graphics.defaultFont(), (int)6, (int)4, (FormattedText)TextUtils.translate((String)"gui.createrailwaysnavigator.lock.transfer_ownership"), (DLColor)DragonLib.VANILLA_UI_FONT_COLOR, (ETextAlignment)ETextAlignment.LEFT, (boolean)false);
        ModGuiIcons.WARN.render(graphics, this.iconWidget.x(), this.iconWidget.y() + this.iconWidget.height() + 8);
        if (this.selectionBox != null) {
            graphics.poseStack().m_85836_();
            graphics.poseStack().m_252880_((float)this.selectionBox.x(), (float)(this.selectionBox.y() + this.selectionBox.height() + 8), 0.0f);
            graphics.poseStack().m_85841_(0.75f, 0.75f, 0.75f);
            DLUtils.doIfNotNull((Object)this.messageLabel, x -> {
                GuiGraphics guiGraphics = graphics.graphics();
                Objects.requireNonNull(graphics.defaultFont());
                x.m_6508_(guiGraphics, 0, 0, 9, -1);
            });
            graphics.poseStack().m_85849_();
        }
    }
}

