/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.cmd;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.mrjulsen.crn.data.train.DepartureHistory;
import de.mrjulsen.crn.data.train.TrainListener;
import de.mrjulsen.crn.network.packets.pain.ShowTrainDebugScreenPacketData;
import de.mrjulsen.crn.registry.ModNetworkManager;
import de.mrjulsen.mcdragonlib.network.NetworkDirection;
import de.mrjulsen.mcdragonlib.network.NetworkPacketData;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class DebugCommand {
    private static final String CMD_NAME = "createrailwaysnavigator";
    private static final String SUB_DEBUG = "debug";
    private static final String SUB_DISCORD = "discord";
    private static final String SUB_GITHUB = "github";
    private static final String SUB_RESET = "resetTrainPredictions";
    private static final String SUB_HARD_RESET = "hardResetTrainPredictions";
    private static final String SUB_TRAIN_DEBUG_OVERLAY = "trainDebugOverlay";
    private static final String SUB_TRAIN_OVERVIEW = "trainOverview";
    private static final String SUB_CLEAR_DEPARTURE_HISTORY = "clearDepartureHistory";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, Commands.CommandSelection selection) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)CMD_NAME).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)SUB_DEBUG).requires(x -> x.m_6761_(3))).then(Commands.m_82127_((String)SUB_HARD_RESET).executes(x -> DebugCommand.hardReset((CommandSourceStack)x.getSource())))).then(Commands.m_82127_((String)SUB_RESET).executes(x -> DebugCommand.reset((CommandSourceStack)x.getSource())))).then(Commands.m_82127_((String)SUB_TRAIN_DEBUG_OVERLAY).executes(x -> DebugCommand.showTrainObservationOverlay((CommandSourceStack)x.getSource())))).then(Commands.m_82127_((String)SUB_TRAIN_OVERVIEW).executes(x -> DebugCommand.showTrainDebugScreen((CommandSourceStack)x.getSource())))).then(Commands.m_82127_((String)SUB_CLEAR_DEPARTURE_HISTORY).executes(x -> DebugCommand.clearDepartureHistory((CommandSourceStack)x.getSource()))))).then(Commands.m_82127_((String)SUB_DISCORD).executes(x -> DebugCommand.discord((CommandSourceStack)x.getSource())))).then(Commands.m_82127_((String)SUB_GITHUB).executes(x -> DebugCommand.github((CommandSourceStack)x.getSource())));
        dispatcher.register(builder);
    }

    private static int discord(CommandSourceStack cmd) throws CommandSyntaxException {
        cmd.m_288197_(() -> TextUtils.text((String)"Redirecting to the discord server..."), false);
        Util.m_137581_().m_137646_("https://discord.gg/hH7YxTrPpk");
        return 1;
    }

    private static int github(CommandSourceStack cmd) throws CommandSyntaxException {
        cmd.m_288197_(() -> TextUtils.text((String)"Redirecting to the github repository..."), false);
        Util.m_137581_().m_137646_("https://github.com/MisterJulsen/Create-Train-Navigator");
        return 1;
    }

    private static int hardReset(CommandSourceStack cmd) throws CommandSyntaxException {
        cmd.m_288197_(() -> TextUtils.text((String)"All train predictions have been deleted."), false);
        TrainListener.resetTrainData();
        return 1;
    }

    private static int reset(CommandSourceStack cmd) throws CommandSyntaxException {
        cmd.m_288197_(() -> TextUtils.text((String)"All train predictions have been reset."), false);
        TrainListener.getAllTrainData().forEach(x -> x.softResetPredictions());
        return 1;
    }

    private static int showTrainObservationOverlay(CommandSourceStack cmd) throws CommandSyntaxException {
        if (Platform.getEnvironment() == Env.CLIENT) {
            cmd.m_288197_(() -> TextUtils.text((String)"Visibility of the train debug overlay has been toggled."), false);
            return 1;
        }
        cmd.m_81352_((Component)TextUtils.text((String)"Cannot open the train debug overlay in multiplayer."));
        return 0;
    }

    private static int showTrainDebugScreen(CommandSourceStack cmd) throws CommandSyntaxException {
        cmd.m_288197_(() -> TextUtils.empty(), false);
        ModNetworkManager.SHOW_TRAIN_DEBUG_SCREEN.send((NetworkDirection)NetworkDirection.toPlayer((ServerPlayer)cmd.m_81375_()), (NetworkPacketData)new ShowTrainDebugScreenPacketData());
        return 1;
    }

    private static int clearDepartureHistory(CommandSourceStack cmd) throws CommandSyntaxException {
        cmd.m_288197_(() -> TextUtils.text((String)"The departure history has been deleted."), false);
        DepartureHistory.clear();
        return 1;
    }
}

