/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data;

import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.crn.network.packets.pain.GetUserSettingsPacketData;
import de.mrjulsen.crn.registry.ModNetworkManager;
import de.mrjulsen.mcdragonlib.network.NetworkDirection;
import de.mrjulsen.mcdragonlib.network.NetworkPacketData;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.Holder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;

public final class SavedRoutesManager {
    private static final LinkedHashSet<ClientRoute> savedRoutes = new LinkedHashSet();
    private static Holder.MutableHolder<Boolean> isSynchronizing = new Holder.MutableHolder((Object)false);

    public static void saveRoute(ClientRoute route) {
        route.addListener();
        savedRoutes.add(route);
    }

    public static void removeRoute(ClientRoute route) {
        route.close();
        savedRoutes.remove(route);
    }

    public static void removeAllRoutes() {
        savedRoutes.forEach(x -> x.closeAll());
        savedRoutes.clear();
    }

    public static boolean isSaved(ClientRoute route) {
        return savedRoutes.contains(route);
    }

    public static List<ClientRoute> getAllSavedRoutes() {
        return new ArrayList<ClientRoute>(savedRoutes);
    }

    public static void push(boolean clear, Runnable andThen) {
        isSynchronizing.set((Object)true);
        ModNetworkManager.GET_USER_SETTINGS.send((NetworkDirection)NetworkDirection.toServer(), (NetworkPacketData)new GetUserSettingsPacketData.Request(Minecraft.m_91087_().f_91074_.m_20148_()), response -> response.getData().ifPresent(settings -> {
            Set<Object> currentValue = clear ? new HashSet() : settings.savedRoutes.getValue();
            currentValue.addAll(savedRoutes.stream().map(x -> x.toNbt()).toList());
            settings.savedRoutes.setValue(currentValue);
            settings.clientSave(() -> {
                isSynchronizing.set((Object)false);
                DLUtils.doIfNotNull((Object)andThen, Runnable::run);
            });
        }), () -> {});
    }

    public static void pull(boolean clear, Runnable andThen) {
        isSynchronizing.set((Object)true);
        ModNetworkManager.GET_USER_SETTINGS.send((NetworkDirection)NetworkDirection.toServer(), (NetworkPacketData)new GetUserSettingsPacketData.Request(Minecraft.m_91087_().f_91074_.m_20148_()), response -> response.getData().ifPresent(settings -> {
            Set currentValue = settings.savedRoutes.getValue().stream().map(x -> ClientRoute.fromNbt(x, true)).collect(Collectors.toSet());
            if (clear) {
                savedRoutes.clear();
            }
            savedRoutes.addAll(currentValue);
            isSynchronizing.set((Object)false);
            DLUtils.doIfNotNull((Object)andThen, Runnable::run);
        }), () -> {});
    }

    public static boolean isSynchronizing() {
        return (Boolean)isSynchronizing.get();
    }
}

