/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data;

import de.mrjulsen.crn.util.Lock;
import de.mrjulsen.crn.util.Owner;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.util.DLColor;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;

public class TrainLine {
    public static final int MAX_NAME_LENGTH = 32;
    private static final String NBT_ID = "Id";
    private static final String NBT_NAME = "Name";
    private static final String NBT_COLOR = "Color";
    private static final String NBT_LAST_EDITOR = "LastEditor";
    private static final String NBT_LAST_EDITED_TIME = "LastEditedTimestamp";
    private static final String NBT_OWNER = "Owner";
    private final UUID id;
    private String name;
    private DLColor lineColor = DLColor.TRANSPARENT;
    protected final Lock owner;
    protected Owner lastEditor;
    protected long lastEditedTime = 0L;

    public TrainLine(UUID id, String name, Player player) {
        this(id, name, new Owner(player));
    }

    public TrainLine(UUID id, String name, Owner owner) {
        this(id, name, new Lock(owner));
    }

    protected TrainLine(UUID id, String name, Lock owner) {
        this.id = id;
        this.name = name;
        this.owner = owner;
        owner.getOwner().ifPresent(this::updateLastEdited);
    }

    public static UUID genMD5Uuid(String name) {
        byte[] nameBytes = name.getBytes(StandardCharsets.UTF_8);
        return UUID.nameUUIDFromBytes(nameBytes);
    }

    public String getLineName() {
        return this.name;
    }

    public UUID getId() {
        return this.id;
    }

    public DLColor getColor() {
        return this.lineColor;
    }

    public void setColor(DLColor color) {
        this.lineColor = color;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Lock getOwner() {
        return this.owner;
    }

    public Optional<Owner> getLastEditor() {
        return Optional.ofNullable(this.lastEditor);
    }

    private void updateLastEdited(Owner editor) {
        this.lastEditor = editor;
        this.lastEditedTime = new Date().getTime();
    }

    public void updateLastEdited(Player player) {
        this.updateLastEdited(new Owner(player));
    }

    public Date getLastEditedTime() {
        return new Date(this.lastEditedTime);
    }

    public String getLastEditedTimeFormatted() {
        return DragonLib.DATE_FORMAT.format(this.getLastEditedTime());
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TrainLine) {
            TrainLine o = (TrainLine)obj;
            return this.name.equals(o.getLineName());
        }
        return false;
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128362_(NBT_ID, this.id);
        this.getLastEditor().ifPresent(x -> nbt.m_128365_(NBT_LAST_EDITOR, (Tag)x.toNbt()));
        nbt.m_128356_(NBT_LAST_EDITED_TIME, this.lastEditedTime);
        nbt.m_128365_(NBT_OWNER, (Tag)this.owner.toNbt());
        nbt.m_128359_(NBT_NAME, this.getLineName());
        nbt.m_128405_(NBT_COLOR, this.getColor().getAsARGB());
        return nbt;
    }

    public static TrainLine fromNbt(CompoundTag nbt) {
        String name = nbt.m_128461_(NBT_NAME);
        UUID id = nbt.m_128441_(NBT_ID) ? nbt.m_128342_(NBT_ID) : TrainLine.genMD5Uuid(name);
        Owner lastEditor = nbt.m_128441_(NBT_LAST_EDITOR) && nbt.m_128435_(NBT_LAST_EDITOR) == 10 ? Owner.fromNbt(nbt.m_128469_(NBT_LAST_EDITOR)) : null;
        long lastEditedTime = nbt.m_128454_(NBT_LAST_EDITED_TIME);
        Lock owner = nbt.m_128441_(NBT_OWNER) && nbt.m_128435_(NBT_OWNER) == 10 ? Lock.fromNbt(nbt.m_128469_(NBT_OWNER)) : new Lock(new Owner((UUID)null));
        TrainLine line = new TrainLine(id, name, owner);
        line.setColor(DLColor.fromInt((int)nbt.m_128451_(NBT_COLOR)));
        line.lastEditor = lastEditor;
        line.lastEditedTime = lastEditedTime;
        return line;
    }
}

