/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.navigation;

import de.mrjulsen.crn.data.navigation.ClientRoutePart;
import de.mrjulsen.crn.network.packets.pain.UpdateRealtimePacketData;
import de.mrjulsen.crn.registry.ModNetworkManager;
import de.mrjulsen.mcdragonlib.network.NetworkDirection;
import de.mrjulsen.mcdragonlib.network.NetworkPacketData;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.Pair;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public final class ClientTrainListener {
    private static final ConcurrentHashMap<UUID, ConcurrentHashMap<UUID, Pair<UUID, Consumer<ClientRoutePart.TrainRealTimeData>>>> callbacks = new ConcurrentHashMap();

    public static int debug_registeredListenersCount() {
        return callbacks.values().stream().mapToInt(x -> x.size()).sum();
    }

    public static UUID register(UUID sessionId, UUID trainId, Consumer<ClientRoutePart.TrainRealTimeData> callback) {
        Map trainCallbacks = callbacks.computeIfAbsent(trainId, x -> new ConcurrentHashMap());
        UUID id = null;
        while (trainCallbacks.containsKey(id = UUID.randomUUID())) {
        }
        trainCallbacks.put(id, Pair.of((Object)sessionId, callback));
        return id;
    }

    public static void unregister(UUID trainId, UUID callbackId) {
        if (callbacks.containsKey(trainId)) {
            Map trainCallbacks = callbacks.get(trainId);
            if (trainCallbacks.containsKey(callbackId)) {
                trainCallbacks.remove(callbackId);
            }
            if (trainCallbacks.isEmpty()) {
                callbacks.remove(trainId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tick(Runnable andThen) {
        ConcurrentHashMap<UUID, ConcurrentHashMap<UUID, Pair<UUID, Consumer<ClientRoutePart.TrainRealTimeData>>>> concurrentHashMap = callbacks;
        synchronized (concurrentHashMap) {
            Iterator<Map.Entry<UUID, ConcurrentHashMap<UUID, Pair<UUID, Consumer<ClientRoutePart.TrainRealTimeData>>>>> iterator = callbacks.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<UUID, ConcurrentHashMap<UUID, Pair<UUID, Consumer<ClientRoutePart.TrainRealTimeData>>>> entry = iterator.next();
                if (entry.getValue().isEmpty()) {
                    iterator.remove();
                    continue;
                }
                Map listeners = entry.getValue();
                ModNetworkManager.UPDATE_REALTIME.send((NetworkDirection)NetworkDirection.toServer(), (NetworkPacketData)new UpdateRealtimePacketData.Request(entry.getKey()), response -> {
                    response.getData().ifPresent(res -> listeners.values().forEach(a -> ((Consumer)a.getSecond()).accept(res)));
                    DLUtils.doIfNotNull((Object)andThen, a -> a.run());
                }, () -> {});
            }
        }
    }

    public static void clear() {
        callbacks.clear();
    }
}

