/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.navigation;

import com.google.common.collect.ImmutableList;
import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.ISavableNavigatorData;
import de.mrjulsen.crn.data.navigation.RoutePart;
import de.mrjulsen.crn.data.navigation.TransferConnection;
import de.mrjulsen.crn.data.train.TrainStop;
import de.mrjulsen.crn.util.ETimeFormat;
import de.mrjulsen.mcdragonlib.util.Cache;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.time.ConfiguredTimeSystem;
import de.mrjulsen.mcdragonlib.util.time.DLTime;
import de.mrjulsen.mcdragonlib.util.time.ITimeSystem;
import de.mrjulsen.mcdragonlib.util.time.TimeContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;

public class Route
implements ISavableNavigatorData {
    protected static final String NBT_PARTS = "Parts";
    protected final List<RoutePart> parts;
    protected final List<TransferConnection> connections;
    protected final Cache<Boolean> isCancelled = new Cache(() -> this.getParts().stream().anyMatch(x -> x.isCancelled()));

    public Route(List<RoutePart> parts, boolean realTimeTracker) {
        this.parts = parts;
        this.connections = TransferConnection.getConnections(parts);
    }

    public static Route empty(boolean realTimeTracker) {
        return new Route(List.of(), realTimeTracker);
    }

    public List<TransferConnection> getConnections() {
        return this.connections;
    }

    public Optional<TransferConnection> getConnectionWith(TrainStop stop) {
        for (TransferConnection connection : this.getConnections()) {
            if (connection.getArrivalStation() != stop && connection.getDepartureStation() != stop) continue;
            return Optional.ofNullable(connection);
        }
        return Optional.empty();
    }

    public RoutePart getFirstPart() {
        return this.parts.get(0);
    }

    public RoutePart getLastPart() {
        return this.parts.get(this.parts.size() - 1);
    }

    public TrainStop getStart() {
        return this.getFirstPart().getFirstStop();
    }

    public TrainStop getEnd() {
        return this.getLastPart().getLastStop();
    }

    public ImmutableList<RoutePart> getParts() {
        return ImmutableList.copyOf(this.parts);
    }

    public int getTransferCount() {
        return this.parts.size() - 1;
    }

    public long departureIn() {
        return this.getFirstPart().departureIn();
    }

    public long arrivalAtDestinationIn() {
        return this.getLastPart().timeUntilEnd();
    }

    public long travelTime() {
        return this.arrivalAtDestinationIn() - this.departureIn();
    }

    public boolean isAnyCancelled() {
        return (Boolean)this.isCancelled.get();
    }

    public boolean isPartReachable(RoutePart part) {
        int idx = this.parts.indexOf(part);
        if (idx <= 0) {
            return true;
        }
        for (int i = 0; i < this.connections.size(); ++i) {
            if (!this.connections.get(i).isConnectionMissed()) continue;
            return i >= idx;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ROUTE[" + this.getStart().getRealTimeStationTag().tagName() + " -> " + this.getEnd().getRealTimeStationTag().tagName() + "]");
        return builder.toString();
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        ListTag list = new ListTag();
        for (RoutePart part : this.parts) {
            list.add((Object)part.toNbt());
        }
        nbt.m_128365_(NBT_PARTS, (Tag)list);
        return nbt;
    }

    public static Route fromNbt(CompoundTag nbt, boolean realTimeTracker) {
        return new Route(nbt.m_128437_(NBT_PARTS, 10).stream().map(x -> RoutePart.fromNbt((CompoundTag)x)).toList(), realTimeTracker);
    }

    @Override
    public List<ISavableNavigatorData.SavableNavigatorDataLine> getOverviewData() {
        ArrayList<ISavableNavigatorData.SavableNavigatorDataLine> lines = new ArrayList<ISavableNavigatorData.SavableNavigatorDataLine>();
        lines.add(new ISavableNavigatorData.SavableNavigatorDataLine((Component)TextUtils.text((String)(DLTime.fromTicks((double)this.getStart().getScheduledDepartureTime(), (ITimeSystem)new ConfiguredTimeSystem()).format(((ETimeFormat)((Object)ModClientConfig.TIME_FORMAT.get())).getFormat(), TimeContext.INGAME) + "   " + this.getStart().getRealTimeStationTag().tagName())), ModGuiIcons.ROUTE_START.getAsSprite(16, 16)));
        lines.add(new ISavableNavigatorData.SavableNavigatorDataLine((Component)TextUtils.text((String)(DLTime.fromTicks((double)this.getEnd().getScheduledArrivalTime(), (ITimeSystem)new ConfiguredTimeSystem()).format(((ETimeFormat)((Object)ModClientConfig.TIME_FORMAT.get())).getFormat(), TimeContext.INGAME) + "   " + this.getEnd().getRealTimeStationTag().tagName())), ModGuiIcons.ROUTE_END.getAsSprite(16, 16)));
        lines.add(new ISavableNavigatorData.SavableNavigatorDataLine((Component)TextUtils.translate((String)"gui.createrailwaysnavigator.route_overview.date", (Object[])new Object[]{(long)DLTime.fromTicks((double)this.getStart().getScheduledDepartureTime(), (ITimeSystem)new ConfiguredTimeSystem()).toGameDays(), DLTime.fromTicks((double)this.getStart().getScheduledDepartureTime(), (ITimeSystem)new ConfiguredTimeSystem()).format(((ETimeFormat)((Object)ModClientConfig.TIME_FORMAT.get())).getFormat(), TimeContext.INGAME)}).m_130946_(" | ").m_130946_(DLTime.fromTicks((double)this.departureIn(), (ITimeSystem)new ConfiguredTimeSystem()).format(Constants.DEFAULT_VERBOSE_GAME_DURATION_FORMAT, TimeContext.INGAME)), ModGuiIcons.CALENDAR.getAsSprite(16, 16)));
        lines.add(new ISavableNavigatorData.SavableNavigatorDataLine((Component)TextUtils.translate((String)"gui.createrailwaysnavigator.route_overview.transfers", (Object[])new Object[]{this.getTransferCount()}).m_7220_((Component)TextUtils.text((String)(" | " + DLTime.fromTicks((double)this.travelTime(), (ITimeSystem)new ConfiguredTimeSystem()).format(Constants.DEFAULT_VERBOSE_GAME_DURATION_FORMAT, TimeContext.INGAME)))), ModGuiIcons.INFO.getAsSprite(16, 16)));
        if (this.isAnyCancelled()) {
            lines.add(new ISavableNavigatorData.SavableNavigatorDataLine((Component)TextUtils.translate((String)"gui.createrailwaysnavigator.route_overview.cancelled").m_130940_(ChatFormatting.RED), ModGuiIcons.IMPORTANT.getAsSprite(16, 16)));
        }
        return lines;
    }

    @Override
    public ISavableNavigatorData.SavableNavigatorDataLine getTitle() {
        return new ISavableNavigatorData.SavableNavigatorDataLine((Component)TextUtils.translate((String)"gui.createrailwaysnavigator.saved_routes.saved_route"), ModGuiIcons.BOOKMARK.getAsSprite(16, 16));
    }

    @Override
    public long timeOrderValue() {
        return this.getStart().getScheduledDepartureTime();
    }
}

