/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.navigation;

import com.simibubi.create.content.trains.entity.Train;
import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.train.TrainData;
import de.mrjulsen.crn.data.train.TrainListener;
import de.mrjulsen.crn.data.train.TrainPrediction;
import de.mrjulsen.crn.data.train.TrainStop;
import de.mrjulsen.mcdragonlib.config.ECachingPriority;
import de.mrjulsen.mcdragonlib.util.Cache;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;

public class TrainSchedule {
    private final UUID sessionId;
    private final Train train;
    private final List<TrainStop> stops;
    private final Cache<List<TrainStop>> stopsChronologically = new Cache(() -> this.getAllStops().stream().sorted((a, b) -> Long.compare(a.getScheduledArrivalTime(), b.getScheduledArrivalTime())).toList());
    private final Cache<List<TrainStop>> stopsChronologicallyDeparture = new Cache(() -> this.getAllStops().stream().sorted((a, b) -> Long.compare(a.getScheduledDepartureTime(), b.getScheduledDepartureTime())).toList(), ECachingPriority.LOW);
    private boolean simulated;
    private long simulationTime;

    private TrainSchedule(UUID sessionId, Train train, List<TrainStop> stops) {
        this.sessionId = sessionId;
        this.train = train;
        this.stops = stops;
    }

    public TrainSchedule(UUID sessionId, Train train) {
        this(TrainListener.getTrainData(train.id).map(TrainData::getSessionId).orElse(new UUID(0L, 0L)), train, TrainListener.getTrainData(train.id).map(a -> a.getPredictions().stream().map(x -> new TrainStop((TrainPrediction)x)).toList()).orElse(List.of()));
    }

    public static TrainSchedule empty() {
        return new TrainSchedule(new UUID(0L, 0L), null, List.of());
    }

    public static TrainSchedule ofSectionForIndex(UUID sessionId, Train train, int stationSectionIndex, int targetStationIndex, long simulationTime) {
        return new TrainSchedule(sessionId, train, TrainListener.getTrainData(train.id).map(x -> x.getSectionForIndex(stationSectionIndex).getAllStops(simulationTime, targetStationIndex)).orElse(List.of()));
    }

    public List<TrainStop> getAllStops() {
        return this.stops;
    }

    public List<TrainStop> getAllStopsChronologically() {
        return (List)this.stopsChronologically.get();
    }

    public List<TrainStop> getAllStopsChronologicallyDeparture() {
        return (List)this.stopsChronologicallyDeparture.get();
    }

    public UUID getSessionId() {
        return this.sessionId;
    }

    public Train getTrain() {
        return this.train;
    }

    public boolean stopsAt(StationTag tag) {
        for (TrainStop stop : this.stops) {
            if (!stop.getTag().equals(tag)) continue;
            return true;
        }
        return false;
    }

    public TrainSchedule simulate(long ticks) {
        this.simulated = true;
        this.simulationTime += ticks;
        return new TrainSchedule(this.sessionId, this.train, this.stops.stream().map(x -> x.copy()).peek(x -> x.simulateTicks(ticks)).toList());
    }

    public boolean isSimulated() {
        return this.simulated;
    }

    public long getSimulationTime() {
        return this.simulationTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEqual(TrainSchedule other) {
        if (other == null) {
            return false;
        }
        List<TrainStop> allStops = this.getAllStops();
        List<TrainStop> otherAllStops = other.getAllStops();
        List<TrainStop> list = allStops;
        synchronized (list) {
            List<TrainStop> list2 = otherAllStops;
            synchronized (list2) {
                if (allStops.size() != otherAllStops.size()) {
                    return false;
                }
                HashSet otherTags = new HashSet(otherAllStops.size());
                otherAllStops.forEach(x -> otherTags.add(x.getTag().getTagName().get()));
                for (TrainStop stop : allStops) {
                    if (otherTags.contains(stop.getTag().getTagName().get())) continue;
                    return false;
                }
                return true;
            }
        }
    }
}

