/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.mixin;

import com.simibubi.create.content.trains.entity.Navigation;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.graph.DiscoveredPath;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.graph.TrackNode;
import com.simibubi.create.content.trains.schedule.ScheduleEntry;
import com.simibubi.create.content.trains.signal.SignalBoundary;
import com.simibubi.create.content.trains.signal.SignalEdgeGroup;
import com.simibubi.create.content.trains.station.GlobalStation;
import de.mrjulsen.crn.data.schedule.INavigationExtension;
import de.mrjulsen.crn.data.schedule.condition.IDelayedWaitCondition;
import de.mrjulsen.crn.data.schedule.instruction.PrioritizedDestinationInstruction;
import de.mrjulsen.crn.util.IFrontierEntry;
import de.mrjulsen.crn.util.PenaltyResult;
import de.mrjulsen.mcdragonlib.util.Pair;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.createmod.catnip.data.Couple;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Coerce;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Navigation.class})
public abstract class NavigationMixin
implements INavigationExtension {
    public Queue<Pair<IDelayedWaitCondition, IDelayedWaitCondition.DelayedWaitConditionContext>> delayedWaitConditions = new ConcurrentLinkedQueue<Pair<IDelayedWaitCondition, IDelayedWaitCondition.DelayedWaitConditionContext>>();
    public PenaltyResult currentReasons;
    public boolean forward;
    public Map<Boolean, PenaltyResult> finalReasonByDirection;
    @Shadow(remap=false)
    public List<Couple<TrackNode>> currentPath;
    @Shadow(remap=false)
    public Train train;
    private boolean shouldCheckPenalties = false;
    private boolean isForwardSelected = false;

    @Override
    public void addDelayedWaitCondition(Pair<IDelayedWaitCondition, IDelayedWaitCondition.DelayedWaitConditionContext> pair) {
        this.delayedWaitConditions.add(pair);
    }

    @Override
    public boolean isDelayedWaitConditionPending() {
        return !this.delayedWaitConditions.isEmpty();
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/entity/Train;leaveStation()V", shift=At.Shift.BEFORE)}, remap=false, cancellable=true)
    public void onTick(Level level, CallbackInfo ci) {
        if (!this.delayedWaitConditions.isEmpty()) {
            Pair<IDelayedWaitCondition, IDelayedWaitCondition.DelayedWaitConditionContext> p = this.delayedWaitConditions.peek();
            if (!((IDelayedWaitCondition.DelayedWaitConditionContext)p.getSecond()).nbt().m_128441_("Delay")) {
                ((IDelayedWaitCondition.DelayedWaitConditionContext)p.getSecond()).nbt().m_128405_("Delay", 0);
            }
            if (((IDelayedWaitCondition)p.getFirst()).runDelayed((IDelayedWaitCondition.DelayedWaitConditionContext)p.getSecond())) {
                ((IDelayedWaitCondition.DelayedWaitConditionContext)this.delayedWaitConditions.poll().getSecond()).nbt().m_128473_("Delay");
            } else {
                ((IDelayedWaitCondition.DelayedWaitConditionContext)p.getSecond()).nbt().m_128405_("Delay", ((IDelayedWaitCondition.DelayedWaitConditionContext)p.getSecond()).nbt().m_128451_("Delay") + 1);
            }
            ci.cancel();
        }
    }

    @Inject(method={"cancelNavigation"}, at={@At(value="HEAD")}, remap=false)
    public void resetOnCancel(CallbackInfo ci) {
        this.delayedWaitConditions.clear();
    }

    @Override
    public Optional<PenaltyResult> getPenaltiesByDirection() {
        if (this.finalReasonByDirection == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.finalReasonByDirection.get(this.isForwardSelected));
    }

    @Inject(method={"findPathTo"}, remap=false, at={@At(value="HEAD")})
    public void onStartNavigation(@Coerce Object a, double maxCost, CallbackInfoReturnable<?> cir) {
        if (this.train == null || this.train.runtime == null || this.train.runtime.getSchedule() == null) {
            return;
        }
        if (this.train.runtime.currentEntry < 0 || this.train.runtime.currentEntry > this.train.runtime.getSchedule().entries.size() || !(this.shouldCheckPenalties = ((ScheduleEntry)this.train.runtime.getSchedule().entries.get((int)this.train.runtime.currentEntry)).instruction instanceof PrioritizedDestinationInstruction)) {
            return;
        }
        if (this.finalReasonByDirection == null) {
            this.finalReasonByDirection = new IdentityHashMap<Boolean, PenaltyResult>(2);
        } else {
            this.finalReasonByDirection.clear();
        }
        this.finalReasonByDirection.put(true, new PenaltyResult());
        this.finalReasonByDirection.put(false, new PenaltyResult());
        this.currentReasons = null;
    }

    @Inject(method={"findPathTo"}, remap=false, at={@At(value="TAIL")})
    public void onEndNavigation(@Coerce Object a, double maxCost, CallbackInfoReturnable<?> cir) {
        this.shouldCheckPenalties = false;
        this.currentReasons = null;
    }

    @Inject(method={"search(DDZLjava/util/ArrayList;Lcom/simibubi/create/content/trains/entity/Navigation$StationTest;)V"}, remap=false, at={@At(value="HEAD")})
    public void onStartSearch(double maxDistance, double maxCosts, boolean forward, ArrayList<GlobalStation> destinations, Navigation.StationTest stationTest, CallbackInfo ci) {
        if (!this.shouldCheckPenalties) {
            return;
        }
        this.currentReasons = new PenaltyResult();
        this.forward = forward;
    }

    @Redirect(method={"search(DDZLjava/util/ArrayList;Lcom/simibubi/create/content/trains/entity/Navigation$StationTest;)V"}, remap=false, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/entity/Navigation$StationTest;test(DDLjava/util/Map;Lnet/createmod/catnip/data/Pair;Lcom/simibubi/create/content/trains/station/GlobalStation;)Z", remap=false))
    public boolean onTestStation(Navigation.StationTest test, double distance, double cost, Map<TrackEdge, net.createmod.catnip.data.Pair<Boolean, Couple<TrackNode>>> reachedVia, net.createmod.catnip.data.Pair<Couple<TrackNode>, TrackEdge> current, GlobalStation station) {
        boolean b = test.test(distance, cost, reachedVia, current, station);
        if (this.shouldCheckPenalties && b) {
            this.finalReasonByDirection.put(this.forward, new PenaltyResult(this.currentReasons));
        }
        return b;
    }

    @Redirect(method={"search(DDZLjava/util/ArrayList;Lcom/simibubi/create/content/trains/entity/Navigation$StationTest;)V"}, remap=false, at=@At(value="INVOKE", target="Ljava/util/PriorityQueue;add(Ljava/lang/Object;)Z", remap=false))
    public boolean onReadFrontierEntry(PriorityQueue<Object> queue, @Coerce Object obj) {
        IFrontierEntry entry = (IFrontierEntry)obj;
        if (this.shouldCheckPenalties) {
            entry.setPenaltyReasons(new PenaltyResult(this.currentReasons));
        }
        return queue.add(obj);
    }

    @Redirect(method={"search(DDZLjava/util/ArrayList;Lcom/simibubi/create/content/trains/entity/Navigation$StationTest;)V"}, remap=false, at=@At(value="FIELD", target="Lcom/simibubi/create/content/trains/entity/Navigation$FrontierEntry;penalty:I", remap=false, opcode=180))
    public int onCreateFrontierEntry(@Coerce Object obj) {
        IFrontierEntry entry = (IFrontierEntry)obj;
        if (this.shouldCheckPenalties) {
            this.currentReasons = new PenaltyResult(entry.getPenaltyReasons());
        }
        return entry.getPenalty();
    }

    @Redirect(method={"search(DDZLjava/util/ArrayList;Lcom/simibubi/create/content/trains/entity/Navigation$StationTest;)V"}, remap=false, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/signal/SignalBoundary;isForcedRed(Lcom/simibubi/create/content/trains/graph/TrackNode;)Z", remap=false))
    public boolean onForceRed(SignalBoundary signal, TrackNode node) {
        boolean b = signal.isForcedRed(node);
        if (this.shouldCheckPenalties && b) {
            this.currentReasons.add(PenaltyResult.Type.REDSTONE_RED_SIGNAL);
        }
        return b;
    }

    @Redirect(method={"search(DDZLjava/util/ArrayList;Lcom/simibubi/create/content/trains/entity/Navigation$StationTest;)V"}, remap=false, at=@At(value="INVOKE", target="Ljava/util/Map;getOrDefault(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", remap=false), slice=@Slice(from=@At(value="INVOKE", target="Ljava/util/PriorityQueue;<init>()V", remap=false)))
    public Object onGetPenaltyByEdge(Map<TrackEdge, Integer> map, Object edge, Object defaultValue) {
        int val = map.getOrDefault((TrackEdge)edge, (Integer)defaultValue);
        if (this.shouldCheckPenalties && val > 0) {
            PenaltyResult.Type.getTypeByPenalty(PenaltyResult.Category.TRAINS, val).ifPresent(this.currentReasons::add);
        }
        return val;
    }

    @Redirect(method={"search(DDZLjava/util/ArrayList;Lcom/simibubi/create/content/trains/entity/Navigation$StationTest;)V"}, remap=false, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/signal/SignalEdgeGroup;isOccupiedUnless(Lcom/simibubi/create/content/trains/signal/SignalBoundary;)Z", remap=false))
    public boolean onCheckOccupiedRedSignal(SignalEdgeGroup group, SignalBoundary signal) {
        boolean b = group.isOccupiedUnless(signal);
        if (this.shouldCheckPenalties && b) {
            this.currentReasons.add(PenaltyResult.Type.RED_SIGNAL);
        }
        return b;
    }

    @Inject(method={"findPathTo(Ljava/util/ArrayList;D)Lcom/simibubi/create/content/trains/graph/DiscoveredPath;"}, remap=false, at={@At(value="RETURN")}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/createmod/catnip/data/Couple;create(Ljava/lang/Object;Ljava/lang/Object;)Lnet/createmod/catnip/data/Couple;", remap=false))}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void selectDirection(ArrayList<GlobalStation> destinations, double maxCost, CallbackInfoReturnable<DiscoveredPath> cir, TrackGraph graph, Couple<DiscoveredPath> results) {
        if (this.shouldCheckPenalties) {
            Object selected = cir.getReturnValue();
            this.isForwardSelected = results.getFirst() == selected;
        }
    }
}

